# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ServiceDnsConfig',
    'ServiceDnsConfigDnsRecord',
    'ServiceHealthCheckConfig',
    'ServiceHealthCheckCustomConfig',
    'GetServiceDnsConfigResult',
    'GetServiceDnsConfigDnsRecordResult',
    'GetServiceHealthCheckConfigResult',
    'GetServiceHealthCheckCustomConfigResult',
]

@pulumi.output_type
class ServiceDnsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsRecords":
            suggest = "dns_records"
        elif key == "namespaceId":
            suggest = "namespace_id"
        elif key == "routingPolicy":
            suggest = "routing_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDnsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDnsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDnsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_records: Sequence['outputs.ServiceDnsConfigDnsRecord'],
                 namespace_id: builtins.str,
                 routing_policy: Optional[builtins.str] = None):
        """
        :param Sequence['ServiceDnsConfigDnsRecordArgs'] dns_records: An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
        :param builtins.str namespace_id: The ID of the namespace to use for DNS configuration.
        :param builtins.str routing_policy: The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
        """
        pulumi.set(__self__, "dns_records", dns_records)
        pulumi.set(__self__, "namespace_id", namespace_id)
        if routing_policy is not None:
            pulumi.set(__self__, "routing_policy", routing_policy)

    @property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Sequence['outputs.ServiceDnsConfigDnsRecord']:
        """
        An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
        """
        return pulumi.get(self, "dns_records")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> builtins.str:
        """
        The ID of the namespace to use for DNS configuration.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="routingPolicy")
    def routing_policy(self) -> Optional[builtins.str]:
        """
        The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
        """
        return pulumi.get(self, "routing_policy")


@pulumi.output_type
class ServiceDnsConfigDnsRecord(dict):
    def __init__(__self__, *,
                 ttl: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int ttl: The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
        :param builtins.str type: The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
        """
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def ttl(self) -> builtins.int:
        """
        The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceHealthCheckConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "resourcePath":
            suggest = "resource_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHealthCheckConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHealthCheckConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHealthCheckConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[builtins.int] = None,
                 resource_path: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.int failure_threshold: The number of consecutive health checks. Maximum value of 10.
        :param builtins.str resource_path: The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
        :param builtins.str type: The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[builtins.int]:
        """
        The number of consecutive health checks. Maximum value of 10.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[builtins.str]:
        """
        The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
        """
        return pulumi.get(self, "resource_path")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceHealthCheckCustomConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHealthCheckCustomConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHealthCheckCustomConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHealthCheckCustomConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[builtins.int] = None):
        """
        :param builtins.int failure_threshold: The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Value is always set to 1.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)

    @property
    @pulumi.getter(name="failureThreshold")
    @_utilities.deprecated("""failure_threshold is deprecated. The argument is no longer supported by AWS and the value is always set to 1. The attribute will be removed in a future major version.""")
    def failure_threshold(self) -> Optional[builtins.int]:
        """
        The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Value is always set to 1.
        """
        return pulumi.get(self, "failure_threshold")


@pulumi.output_type
class GetServiceDnsConfigResult(dict):
    def __init__(__self__, *,
                 dns_records: Sequence['outputs.GetServiceDnsConfigDnsRecordResult'],
                 namespace_id: builtins.str,
                 routing_policy: builtins.str):
        """
        :param Sequence['GetServiceDnsConfigDnsRecordArgs'] dns_records: An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
        :param builtins.str namespace_id: ID of the namespace that the service belongs to.
        :param builtins.str routing_policy: Routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
        """
        pulumi.set(__self__, "dns_records", dns_records)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "routing_policy", routing_policy)

    @property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Sequence['outputs.GetServiceDnsConfigDnsRecordResult']:
        """
        An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
        """
        return pulumi.get(self, "dns_records")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> builtins.str:
        """
        ID of the namespace that the service belongs to.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="routingPolicy")
    def routing_policy(self) -> builtins.str:
        """
        Routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
        """
        return pulumi.get(self, "routing_policy")


@pulumi.output_type
class GetServiceDnsConfigDnsRecordResult(dict):
    def __init__(__self__, *,
                 ttl: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int ttl: Amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
        :param builtins.str type: The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def ttl(self) -> builtins.int:
        """
        Amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceHealthCheckConfigResult(dict):
    def __init__(__self__, *,
                 failure_threshold: builtins.int,
                 resource_path: builtins.str,
                 type: builtins.str):
        """
        :param builtins.int failure_threshold: The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
        :param builtins.str resource_path: Path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
        :param builtins.str type: The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "resource_path", resource_path)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> builtins.int:
        """
        The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> builtins.str:
        """
        Path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
        """
        return pulumi.get(self, "resource_path")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceHealthCheckCustomConfigResult(dict):
    def __init__(__self__, *,
                 failure_threshold: builtins.int):
        """
        :param builtins.int failure_threshold: The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> builtins.int:
        """
        The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
        """
        return pulumi.get(self, "failure_threshold")


