# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTemplatesResult',
    'AwaitableGetTemplatesResult',
    'get_templates',
    'get_templates_output',
]

@pulumi.output_type
class GetTemplatesResult:
    """
    A collection of values returned by getTemplates.
    """
    def __init__(__self__, aws_region=None, id=None, region=None, templates=None):
        if aws_region and not isinstance(aws_region, str):
            raise TypeError("Expected argument 'aws_region' to be a str")
        pulumi.set(__self__, "aws_region", aws_region)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if templates and not isinstance(templates, list):
            raise TypeError("Expected argument 'templates' to be a list")
        pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use get_region instead.""")
    def region(self) -> Optional[builtins.str]:
        """
        AWS Region to which the template applies.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def templates(self) -> Sequence['outputs.GetTemplatesTemplateResult']:
        """
        A list of quota increase templates for specified region. See `templates`.
        """
        return pulumi.get(self, "templates")


class AwaitableGetTemplatesResult(GetTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplatesResult(
            aws_region=self.aws_region,
            id=self.id,
            region=self.region,
            templates=self.templates)


def get_templates(aws_region: Optional[builtins.str] = None,
                  region: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplatesResult:
    """
    Data source for managing AWS Service Quotas Templates.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicequotas.get_templates(aws_region="us-east-1")
    ```


    :param builtins.str aws_region: AWS Region to which the quota increases apply.
    :param builtins.str region: AWS Region to which the quota increases apply. Use `get_region` instead.
    """
    __args__ = dict()
    __args__['awsRegion'] = aws_region
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:servicequotas/getTemplates:getTemplates', __args__, opts=opts, typ=GetTemplatesResult).value

    return AwaitableGetTemplatesResult(
        aws_region=pulumi.get(__ret__, 'aws_region'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        templates=pulumi.get(__ret__, 'templates'))
def get_templates_output(aws_region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTemplatesResult]:
    """
    Data source for managing AWS Service Quotas Templates.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicequotas.get_templates(aws_region="us-east-1")
    ```


    :param builtins.str aws_region: AWS Region to which the quota increases apply.
    :param builtins.str region: AWS Region to which the quota increases apply. Use `get_region` instead.
    """
    __args__ = dict()
    __args__['awsRegion'] = aws_region
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:servicequotas/getTemplates:getTemplates', __args__, opts=opts, typ=GetTemplatesResult)
    return __ret__.apply(lambda __response__: GetTemplatesResult(
        aws_region=pulumi.get(__response__, 'aws_region'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        templates=pulumi.get(__response__, 'templates')))
