# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConfigurationSetDeliveryOptionsArgs',
    'ConfigurationSetDeliveryOptionsArgsDict',
    'ConfigurationSetTrackingOptionsArgs',
    'ConfigurationSetTrackingOptionsArgsDict',
    'EventDestinationCloudwatchDestinationArgs',
    'EventDestinationCloudwatchDestinationArgsDict',
    'EventDestinationKinesisDestinationArgs',
    'EventDestinationKinesisDestinationArgsDict',
    'EventDestinationSnsDestinationArgs',
    'EventDestinationSnsDestinationArgsDict',
    'ReceiptRuleAddHeaderActionArgs',
    'ReceiptRuleAddHeaderActionArgsDict',
    'ReceiptRuleBounceActionArgs',
    'ReceiptRuleBounceActionArgsDict',
    'ReceiptRuleLambdaActionArgs',
    'ReceiptRuleLambdaActionArgsDict',
    'ReceiptRuleS3ActionArgs',
    'ReceiptRuleS3ActionArgsDict',
    'ReceiptRuleSnsActionArgs',
    'ReceiptRuleSnsActionArgsDict',
    'ReceiptRuleStopActionArgs',
    'ReceiptRuleStopActionArgsDict',
    'ReceiptRuleWorkmailActionArgs',
    'ReceiptRuleWorkmailActionArgsDict',
]

MYPY = False

if not MYPY:
    class ConfigurationSetDeliveryOptionsArgsDict(TypedDict):
        tls_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is `Require`, messages are only delivered if a TLS connection can be established. If the value is `Optional`, messages can be delivered in plain text if a TLS connection can't be established. Valid values: `Require` or `Optional`. Defaults to `Optional`.
        """
elif False:
    ConfigurationSetDeliveryOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationSetDeliveryOptionsArgs:
    def __init__(__self__, *,
                 tls_policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] tls_policy: Whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is `Require`, messages are only delivered if a TLS connection can be established. If the value is `Optional`, messages can be delivered in plain text if a TLS connection can't be established. Valid values: `Require` or `Optional`. Defaults to `Optional`.
        """
        if tls_policy is not None:
            pulumi.set(__self__, "tls_policy", tls_policy)

    @property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is `Require`, messages are only delivered if a TLS connection can be established. If the value is `Optional`, messages can be delivered in plain text if a TLS connection can't be established. Valid values: `Require` or `Optional`. Defaults to `Optional`.
        """
        return pulumi.get(self, "tls_policy")

    @tls_policy.setter
    def tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_policy", value)


if not MYPY:
    class ConfigurationSetTrackingOptionsArgsDict(TypedDict):
        custom_redirect_domain: NotRequired[pulumi.Input[builtins.str]]
        """
        Custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
        """
elif False:
    ConfigurationSetTrackingOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationSetTrackingOptionsArgs:
    def __init__(__self__, *,
                 custom_redirect_domain: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] custom_redirect_domain: Custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
        """
        if custom_redirect_domain is not None:
            pulumi.set(__self__, "custom_redirect_domain", custom_redirect_domain)

    @property
    @pulumi.getter(name="customRedirectDomain")
    def custom_redirect_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
        """
        return pulumi.get(self, "custom_redirect_domain")

    @custom_redirect_domain.setter
    def custom_redirect_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_redirect_domain", value)


if not MYPY:
    class EventDestinationCloudwatchDestinationArgsDict(TypedDict):
        default_value: pulumi.Input[builtins.str]
        """
        The default value for the event
        """
        dimension_name: pulumi.Input[builtins.str]
        """
        The name for the dimension
        """
        value_source: pulumi.Input[builtins.str]
        """
        The source for the value. May be any of `"messageTag"`, `"emailHeader"` or `"linkTag"`.
        """
elif False:
    EventDestinationCloudwatchDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventDestinationCloudwatchDestinationArgs:
    def __init__(__self__, *,
                 default_value: pulumi.Input[builtins.str],
                 dimension_name: pulumi.Input[builtins.str],
                 value_source: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] default_value: The default value for the event
        :param pulumi.Input[builtins.str] dimension_name: The name for the dimension
        :param pulumi.Input[builtins.str] value_source: The source for the value. May be any of `"messageTag"`, `"emailHeader"` or `"linkTag"`.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Input[builtins.str]:
        """
        The default value for the event
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> pulumi.Input[builtins.str]:
        """
        The name for the dimension
        """
        return pulumi.get(self, "dimension_name")

    @dimension_name.setter
    def dimension_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dimension_name", value)

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> pulumi.Input[builtins.str]:
        """
        The source for the value. May be any of `"messageTag"`, `"emailHeader"` or `"linkTag"`.
        """
        return pulumi.get(self, "value_source")

    @value_source.setter
    def value_source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value_source", value)


if not MYPY:
    class EventDestinationKinesisDestinationArgsDict(TypedDict):
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of the role that has permissions to access the Kinesis Stream
        """
        stream_arn: pulumi.Input[builtins.str]
        """
        The ARN of the Kinesis Stream
        """
elif False:
    EventDestinationKinesisDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventDestinationKinesisDestinationArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str],
                 stream_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] role_arn: The ARN of the role that has permissions to access the Kinesis Stream
        :param pulumi.Input[builtins.str] stream_arn: The ARN of the Kinesis Stream
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the role that has permissions to access the Kinesis Stream
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the Kinesis Stream
        """
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_arn", value)


if not MYPY:
    class EventDestinationSnsDestinationArgsDict(TypedDict):
        topic_arn: pulumi.Input[builtins.str]
        """
        The ARN of the SNS topic
        """
elif False:
    EventDestinationSnsDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventDestinationSnsDestinationArgs:
    def __init__(__self__, *,
                 topic_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] topic_arn: The ARN of the SNS topic
        """
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the SNS topic
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "topic_arn", value)


if not MYPY:
    class ReceiptRuleAddHeaderActionArgsDict(TypedDict):
        header_name: pulumi.Input[builtins.str]
        """
        The name of the header to add
        """
        header_value: pulumi.Input[builtins.str]
        """
        The value of the header to add
        """
        position: pulumi.Input[builtins.int]
        """
        The position of the action in the receipt rule
        """
elif False:
    ReceiptRuleAddHeaderActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReceiptRuleAddHeaderActionArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[builtins.str],
                 header_value: pulumi.Input[builtins.str],
                 position: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] header_name: The name of the header to add
        :param pulumi.Input[builtins.str] header_value: The value of the header to add
        :param pulumi.Input[builtins.int] position: The position of the action in the receipt rule
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the header to add
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the header to add
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "header_value", value)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the action in the receipt rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)


if not MYPY:
    class ReceiptRuleBounceActionArgsDict(TypedDict):
        message: pulumi.Input[builtins.str]
        """
        The message to send
        """
        position: pulumi.Input[builtins.int]
        """
        The position of the action in the receipt rule
        """
        sender: pulumi.Input[builtins.str]
        """
        The email address of the sender
        """
        smtp_reply_code: pulumi.Input[builtins.str]
        """
        The RFC 5321 SMTP reply code
        """
        status_code: NotRequired[pulumi.Input[builtins.str]]
        """
        The RFC 3463 SMTP enhanced status code
        """
        topic_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of an SNS topic to notify
        """
elif False:
    ReceiptRuleBounceActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReceiptRuleBounceActionArgs:
    def __init__(__self__, *,
                 message: pulumi.Input[builtins.str],
                 position: pulumi.Input[builtins.int],
                 sender: pulumi.Input[builtins.str],
                 smtp_reply_code: pulumi.Input[builtins.str],
                 status_code: Optional[pulumi.Input[builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] message: The message to send
        :param pulumi.Input[builtins.int] position: The position of the action in the receipt rule
        :param pulumi.Input[builtins.str] sender: The email address of the sender
        :param pulumi.Input[builtins.str] smtp_reply_code: The RFC 5321 SMTP reply code
        :param pulumi.Input[builtins.str] status_code: The RFC 3463 SMTP enhanced status code
        :param pulumi.Input[builtins.str] topic_arn: The ARN of an SNS topic to notify
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "sender", sender)
        pulumi.set(__self__, "smtp_reply_code", smtp_reply_code)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input[builtins.str]:
        """
        The message to send
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the action in the receipt rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def sender(self) -> pulumi.Input[builtins.str]:
        """
        The email address of the sender
        """
        return pulumi.get(self, "sender")

    @sender.setter
    def sender(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sender", value)

    @property
    @pulumi.getter(name="smtpReplyCode")
    def smtp_reply_code(self) -> pulumi.Input[builtins.str]:
        """
        The RFC 5321 SMTP reply code
        """
        return pulumi.get(self, "smtp_reply_code")

    @smtp_reply_code.setter
    def smtp_reply_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "smtp_reply_code", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RFC 3463 SMTP enhanced status code
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an SNS topic to notify
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "topic_arn", value)


if not MYPY:
    class ReceiptRuleLambdaActionArgsDict(TypedDict):
        function_arn: pulumi.Input[builtins.str]
        """
        The ARN of the Lambda function to invoke
        """
        position: pulumi.Input[builtins.int]
        """
        The position of the action in the receipt rule
        """
        invocation_type: NotRequired[pulumi.Input[builtins.str]]
        """
        `Event` or `RequestResponse`
        """
        topic_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of an SNS topic to notify
        """
elif False:
    ReceiptRuleLambdaActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReceiptRuleLambdaActionArgs:
    def __init__(__self__, *,
                 function_arn: pulumi.Input[builtins.str],
                 position: pulumi.Input[builtins.int],
                 invocation_type: Optional[pulumi.Input[builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] function_arn: The ARN of the Lambda function to invoke
        :param pulumi.Input[builtins.int] position: The position of the action in the receipt rule
        :param pulumi.Input[builtins.str] invocation_type: `Event` or `RequestResponse`
        :param pulumi.Input[builtins.str] topic_arn: The ARN of an SNS topic to notify
        """
        pulumi.set(__self__, "function_arn", function_arn)
        pulumi.set(__self__, "position", position)
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the Lambda function to invoke
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the action in the receipt rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `Event` or `RequestResponse`
        """
        return pulumi.get(self, "invocation_type")

    @invocation_type.setter
    def invocation_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "invocation_type", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an SNS topic to notify
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "topic_arn", value)


if not MYPY:
    class ReceiptRuleS3ActionArgsDict(TypedDict):
        bucket_name: pulumi.Input[builtins.str]
        """
        The name of the S3 bucket
        """
        position: pulumi.Input[builtins.int]
        """
        The position of the action in the receipt rule
        """
        iam_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the IAM role to be used by Amazon Simple Email Service while writing to the Amazon S3 bucket, optionally encrypting your mail via the provided customer managed key, and publishing to the Amazon SNS topic
        """
        kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the KMS key
        """
        object_key_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The key prefix of the S3 bucket
        """
        topic_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of an SNS topic to notify
        """
elif False:
    ReceiptRuleS3ActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReceiptRuleS3ActionArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 position: pulumi.Input[builtins.int],
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 object_key_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_name: The name of the S3 bucket
        :param pulumi.Input[builtins.int] position: The position of the action in the receipt rule
        :param pulumi.Input[builtins.str] iam_role_arn: The ARN of the IAM role to be used by Amazon Simple Email Service while writing to the Amazon S3 bucket, optionally encrypting your mail via the provided customer managed key, and publishing to the Amazon SNS topic
        :param pulumi.Input[builtins.str] kms_key_arn: The ARN of the KMS key
        :param pulumi.Input[builtins.str] object_key_prefix: The key prefix of the S3 bucket
        :param pulumi.Input[builtins.str] topic_arn: The ARN of an SNS topic to notify
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "position", position)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 bucket
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the action in the receipt rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the IAM role to be used by Amazon Simple Email Service while writing to the Amazon S3 bucket, optionally encrypting your mail via the provided customer managed key, and publishing to the Amazon SNS topic
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the KMS key
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key prefix of the S3 bucket
        """
        return pulumi.get(self, "object_key_prefix")

    @object_key_prefix.setter
    def object_key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_key_prefix", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an SNS topic to notify
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "topic_arn", value)


if not MYPY:
    class ReceiptRuleSnsActionArgsDict(TypedDict):
        position: pulumi.Input[builtins.int]
        """
        The position of the action in the receipt rule
        """
        topic_arn: pulumi.Input[builtins.str]
        """
        The ARN of an SNS topic to notify
        """
        encoding: NotRequired[pulumi.Input[builtins.str]]
        """
        The encoding to use for the email within the Amazon SNS notification. Default value is `UTF-8`.
        """
elif False:
    ReceiptRuleSnsActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReceiptRuleSnsActionArgs:
    def __init__(__self__, *,
                 position: pulumi.Input[builtins.int],
                 topic_arn: pulumi.Input[builtins.str],
                 encoding: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] position: The position of the action in the receipt rule
        :param pulumi.Input[builtins.str] topic_arn: The ARN of an SNS topic to notify
        :param pulumi.Input[builtins.str] encoding: The encoding to use for the email within the Amazon SNS notification. Default value is `UTF-8`.
        """
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "topic_arn", topic_arn)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the action in the receipt rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of an SNS topic to notify
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "topic_arn", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encoding to use for the email within the Amazon SNS notification. Default value is `UTF-8`.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encoding", value)


if not MYPY:
    class ReceiptRuleStopActionArgsDict(TypedDict):
        position: pulumi.Input[builtins.int]
        """
        The position of the action in the receipt rule
        """
        scope: pulumi.Input[builtins.str]
        """
        The scope to apply. The only acceptable value is `RuleSet`.
        """
        topic_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of an SNS topic to notify
        """
elif False:
    ReceiptRuleStopActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReceiptRuleStopActionArgs:
    def __init__(__self__, *,
                 position: pulumi.Input[builtins.int],
                 scope: pulumi.Input[builtins.str],
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] position: The position of the action in the receipt rule
        :param pulumi.Input[builtins.str] scope: The scope to apply. The only acceptable value is `RuleSet`.
        :param pulumi.Input[builtins.str] topic_arn: The ARN of an SNS topic to notify
        """
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "scope", scope)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the action in the receipt rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[builtins.str]:
        """
        The scope to apply. The only acceptable value is `RuleSet`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an SNS topic to notify
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "topic_arn", value)


if not MYPY:
    class ReceiptRuleWorkmailActionArgsDict(TypedDict):
        organization_arn: pulumi.Input[builtins.str]
        """
        The ARN of the WorkMail organization
        """
        position: pulumi.Input[builtins.int]
        """
        The position of the action in the receipt rule
        """
        topic_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of an SNS topic to notify
        """
elif False:
    ReceiptRuleWorkmailActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReceiptRuleWorkmailActionArgs:
    def __init__(__self__, *,
                 organization_arn: pulumi.Input[builtins.str],
                 position: pulumi.Input[builtins.int],
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] organization_arn: The ARN of the WorkMail organization
        :param pulumi.Input[builtins.int] position: The position of the action in the receipt rule
        :param pulumi.Input[builtins.str] topic_arn: The ARN of an SNS topic to notify
        """
        pulumi.set(__self__, "organization_arn", organization_arn)
        pulumi.set(__self__, "position", position)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="organizationArn")
    def organization_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the WorkMail organization
        """
        return pulumi.get(self, "organization_arn")

    @organization_arn.setter
    def organization_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_arn", value)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the action in the receipt rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an SNS topic to notify
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "topic_arn", value)


