# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDomainIdentityResult',
    'AwaitableGetDomainIdentityResult',
    'get_domain_identity',
    'get_domain_identity_output',
]

@pulumi.output_type
class GetDomainIdentityResult:
    """
    A collection of values returned by getDomainIdentity.
    """
    def __init__(__self__, arn=None, domain=None, id=None, region=None, verification_token=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if verification_token and not isinstance(verification_token, str):
            raise TypeError("Expected argument 'verification_token' to be a str")
        pulumi.set(__self__, "verification_token", verification_token)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the domain identity.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        Name of the domain
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> builtins.str:
        """
        Code which when added to the domain as a TXT record will signal to SES that the owner of the domain has authorized SES to act on their behalf.
        """
        return pulumi.get(self, "verification_token")


class AwaitableGetDomainIdentityResult(GetDomainIdentityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainIdentityResult(
            arn=self.arn,
            domain=self.domain,
            id=self.id,
            region=self.region,
            verification_token=self.verification_token)


def get_domain_identity(domain: Optional[builtins.str] = None,
                        region: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainIdentityResult:
    """
    Retrieve the SES domain identity

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ses.get_domain_identity(domain="example.com")
    ```


    :param builtins.str domain: Name of the domain
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ses/getDomainIdentity:getDomainIdentity', __args__, opts=opts, typ=GetDomainIdentityResult).value

    return AwaitableGetDomainIdentityResult(
        arn=pulumi.get(__ret__, 'arn'),
        domain=pulumi.get(__ret__, 'domain'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        verification_token=pulumi.get(__ret__, 'verification_token'))
def get_domain_identity_output(domain: Optional[pulumi.Input[builtins.str]] = None,
                               region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainIdentityResult]:
    """
    Retrieve the SES domain identity

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ses.get_domain_identity(domain="example.com")
    ```


    :param builtins.str domain: Name of the domain
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ses/getDomainIdentity:getDomainIdentity', __args__, opts=opts, typ=GetDomainIdentityResult)
    return __ret__.apply(lambda __response__: GetDomainIdentityResult(
        arn=pulumi.get(__response__, 'arn'),
        domain=pulumi.get(__response__, 'domain'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        verification_token=pulumi.get(__response__, 'verification_token')))
