# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountSuppressionAttributesArgs', 'AccountSuppressionAttributes']

@pulumi.input_type
class AccountSuppressionAttributesArgs:
    def __init__(__self__, *,
                 suppressed_reasons: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccountSuppressionAttributes resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] suppressed_reasons: A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. Valid values: `COMPLAINT`, `BOUNCE`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "suppressed_reasons", suppressed_reasons)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="suppressedReasons")
    def suppressed_reasons(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. Valid values: `COMPLAINT`, `BOUNCE`.
        """
        return pulumi.get(self, "suppressed_reasons")

    @suppressed_reasons.setter
    def suppressed_reasons(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "suppressed_reasons", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AccountSuppressionAttributesState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 suppressed_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AccountSuppressionAttributes resources.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] suppressed_reasons: A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. Valid values: `COMPLAINT`, `BOUNCE`.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if suppressed_reasons is not None:
            pulumi.set(__self__, "suppressed_reasons", suppressed_reasons)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="suppressedReasons")
    def suppressed_reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. Valid values: `COMPLAINT`, `BOUNCE`.
        """
        return pulumi.get(self, "suppressed_reasons")

    @suppressed_reasons.setter
    def suppressed_reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "suppressed_reasons", value)


@pulumi.type_token("aws:sesv2/accountSuppressionAttributes:AccountSuppressionAttributes")
class AccountSuppressionAttributes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 suppressed_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages AWS SESv2 (Simple Email V2) account-level suppression attributes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sesv2.AccountSuppressionAttributes("example", suppressed_reasons=["COMPLAINT"])
        ```

        ## Import

        Using `pulumi import`, import account-level suppression attributes using the account ID. For example:

        ```sh
        $ pulumi import aws:sesv2/accountSuppressionAttributes:AccountSuppressionAttributes example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] suppressed_reasons: A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. Valid values: `COMPLAINT`, `BOUNCE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountSuppressionAttributesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages AWS SESv2 (Simple Email V2) account-level suppression attributes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sesv2.AccountSuppressionAttributes("example", suppressed_reasons=["COMPLAINT"])
        ```

        ## Import

        Using `pulumi import`, import account-level suppression attributes using the account ID. For example:

        ```sh
        $ pulumi import aws:sesv2/accountSuppressionAttributes:AccountSuppressionAttributes example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param AccountSuppressionAttributesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountSuppressionAttributesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 suppressed_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountSuppressionAttributesArgs.__new__(AccountSuppressionAttributesArgs)

            __props__.__dict__["region"] = region
            if suppressed_reasons is None and not opts.urn:
                raise TypeError("Missing required property 'suppressed_reasons'")
            __props__.__dict__["suppressed_reasons"] = suppressed_reasons
        super(AccountSuppressionAttributes, __self__).__init__(
            'aws:sesv2/accountSuppressionAttributes:AccountSuppressionAttributes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            suppressed_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'AccountSuppressionAttributes':
        """
        Get an existing AccountSuppressionAttributes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] suppressed_reasons: A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. Valid values: `COMPLAINT`, `BOUNCE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountSuppressionAttributesState.__new__(_AccountSuppressionAttributesState)

        __props__.__dict__["region"] = region
        __props__.__dict__["suppressed_reasons"] = suppressed_reasons
        return AccountSuppressionAttributes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="suppressedReasons")
    def suppressed_reasons(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. Valid values: `COMPLAINT`, `BOUNCE`.
        """
        return pulumi.get(self, "suppressed_reasons")

