# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SigningJobDestination',
    'SigningJobDestinationS3',
    'SigningJobRevocationRecord',
    'SigningJobSignedObject',
    'SigningJobSignedObjectS3',
    'SigningJobSource',
    'SigningJobSourceS3',
    'SigningProfileRevocationRecord',
    'SigningProfileSignatureValidityPeriod',
    'SigningProfileSigningMaterial',
    'GetSigningJobRevocationRecordResult',
    'GetSigningJobSignedObjectResult',
    'GetSigningJobSignedObjectS3Result',
    'GetSigningJobSourceResult',
    'GetSigningJobSourceS3Result',
    'GetSigningProfileRevocationRecordResult',
    'GetSigningProfileSignatureValidityPeriodResult',
]

@pulumi.output_type
class SigningJobDestination(dict):
    def __init__(__self__, *,
                 s3: 'outputs.SigningJobDestinationS3'):
        """
        :param 'SigningJobDestinationS3Args' s3: A configuration block describing the S3 Destination object: See S3 Destination below for details.
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> 'outputs.SigningJobDestinationS3':
        """
        A configuration block describing the S3 Destination object: See S3 Destination below for details.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class SigningJobDestinationS3(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str prefix: An Amazon S3 object key prefix that you can use to limit signed objects keys to begin with the specified prefix.
        """
        pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        An Amazon S3 object key prefix that you can use to limit signed objects keys to begin with the specified prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class SigningJobRevocationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revokedAt":
            suggest = "revoked_at"
        elif key == "revokedBy":
            suggest = "revoked_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SigningJobRevocationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SigningJobRevocationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SigningJobRevocationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reason: Optional[builtins.str] = None,
                 revoked_at: Optional[builtins.str] = None,
                 revoked_by: Optional[builtins.str] = None):
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revoked_at is not None:
            pulumi.set(__self__, "revoked_at", revoked_at)
        if revoked_by is not None:
            pulumi.set(__self__, "revoked_by", revoked_by)

    @property
    @pulumi.getter
    def reason(self) -> Optional[builtins.str]:
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revokedAt")
    def revoked_at(self) -> Optional[builtins.str]:
        return pulumi.get(self, "revoked_at")

    @property
    @pulumi.getter(name="revokedBy")
    def revoked_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "revoked_by")


@pulumi.output_type
class SigningJobSignedObject(dict):
    def __init__(__self__, *,
                 s3s: Optional[Sequence['outputs.SigningJobSignedObjectS3']] = None):
        if s3s is not None:
            pulumi.set(__self__, "s3s", s3s)

    @property
    @pulumi.getter
    def s3s(self) -> Optional[Sequence['outputs.SigningJobSignedObjectS3']]:
        return pulumi.get(self, "s3s")


@pulumi.output_type
class SigningJobSignedObjectS3(dict):
    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None):
        """
        :param builtins.str key: Key name of the object that contains your unsigned code.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Key name of the object that contains your unsigned code.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class SigningJobSource(dict):
    def __init__(__self__, *,
                 s3: 'outputs.SigningJobSourceS3'):
        """
        :param 'SigningJobSourceS3Args' s3: A configuration block describing the S3 Source object: See S3 Source below for details.
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> 'outputs.SigningJobSourceS3':
        """
        A configuration block describing the S3 Source object: See S3 Source below for details.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class SigningJobSourceS3(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 key: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str key: Key name of the object that contains your unsigned code.
        :param builtins.str version: Version of your source image in your version enabled S3 bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key name of the object that contains your unsigned code.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of your source image in your version enabled S3 bucket.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SigningProfileRevocationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revocationEffectiveFrom":
            suggest = "revocation_effective_from"
        elif key == "revokedAt":
            suggest = "revoked_at"
        elif key == "revokedBy":
            suggest = "revoked_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SigningProfileRevocationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SigningProfileRevocationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SigningProfileRevocationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revocation_effective_from: Optional[builtins.str] = None,
                 revoked_at: Optional[builtins.str] = None,
                 revoked_by: Optional[builtins.str] = None):
        """
        :param builtins.str revocation_effective_from: The time when revocation becomes effective.
        :param builtins.str revoked_at: The time when the signing profile was revoked.
        :param builtins.str revoked_by: The identity of the revoker.
        """
        if revocation_effective_from is not None:
            pulumi.set(__self__, "revocation_effective_from", revocation_effective_from)
        if revoked_at is not None:
            pulumi.set(__self__, "revoked_at", revoked_at)
        if revoked_by is not None:
            pulumi.set(__self__, "revoked_by", revoked_by)

    @property
    @pulumi.getter(name="revocationEffectiveFrom")
    def revocation_effective_from(self) -> Optional[builtins.str]:
        """
        The time when revocation becomes effective.
        """
        return pulumi.get(self, "revocation_effective_from")

    @property
    @pulumi.getter(name="revokedAt")
    def revoked_at(self) -> Optional[builtins.str]:
        """
        The time when the signing profile was revoked.
        """
        return pulumi.get(self, "revoked_at")

    @property
    @pulumi.getter(name="revokedBy")
    def revoked_by(self) -> Optional[builtins.str]:
        """
        The identity of the revoker.
        """
        return pulumi.get(self, "revoked_by")


@pulumi.output_type
class SigningProfileSignatureValidityPeriod(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.int):
        """
        :param builtins.str type: The time unit for signature validity. Valid values: `DAYS`, `MONTHS`, `YEARS`.
        :param builtins.int value: The numerical value of the time unit for signature validity.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The time unit for signature validity. Valid values: `DAYS`, `MONTHS`, `YEARS`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        """
        The numerical value of the time unit for signature validity.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SigningProfileSigningMaterial(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SigningProfileSigningMaterial. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SigningProfileSigningMaterial.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SigningProfileSigningMaterial.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_arn: builtins.str):
        """
        :param builtins.str certificate_arn: The Amazon Resource Name (ARN) of the certificates that is used to sign your code.
        """
        pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the certificates that is used to sign your code.
        """
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class GetSigningJobRevocationRecordResult(dict):
    def __init__(__self__, *,
                 reason: builtins.str,
                 revoked_at: builtins.str,
                 revoked_by: builtins.str):
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revoked_at", revoked_at)
        pulumi.set(__self__, "revoked_by", revoked_by)

    @property
    @pulumi.getter
    def reason(self) -> builtins.str:
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revokedAt")
    def revoked_at(self) -> builtins.str:
        return pulumi.get(self, "revoked_at")

    @property
    @pulumi.getter(name="revokedBy")
    def revoked_by(self) -> builtins.str:
        return pulumi.get(self, "revoked_by")


@pulumi.output_type
class GetSigningJobSignedObjectResult(dict):
    def __init__(__self__, *,
                 s3s: Sequence['outputs.GetSigningJobSignedObjectS3Result']):
        pulumi.set(__self__, "s3s", s3s)

    @property
    @pulumi.getter
    def s3s(self) -> Sequence['outputs.GetSigningJobSignedObjectS3Result']:
        return pulumi.get(self, "s3s")


@pulumi.output_type
class GetSigningJobSignedObjectS3Result(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 key: builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")


@pulumi.output_type
class GetSigningJobSourceResult(dict):
    def __init__(__self__, *,
                 s3s: Sequence['outputs.GetSigningJobSourceS3Result']):
        pulumi.set(__self__, "s3s", s3s)

    @property
    @pulumi.getter
    def s3s(self) -> Sequence['outputs.GetSigningJobSourceS3Result']:
        return pulumi.get(self, "s3s")


@pulumi.output_type
class GetSigningJobSourceS3Result(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 key: builtins.str,
                 version: builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetSigningProfileRevocationRecordResult(dict):
    def __init__(__self__, *,
                 revocation_effective_from: builtins.str,
                 revoked_at: builtins.str,
                 revoked_by: builtins.str):
        pulumi.set(__self__, "revocation_effective_from", revocation_effective_from)
        pulumi.set(__self__, "revoked_at", revoked_at)
        pulumi.set(__self__, "revoked_by", revoked_by)

    @property
    @pulumi.getter(name="revocationEffectiveFrom")
    def revocation_effective_from(self) -> builtins.str:
        return pulumi.get(self, "revocation_effective_from")

    @property
    @pulumi.getter(name="revokedAt")
    def revoked_at(self) -> builtins.str:
        return pulumi.get(self, "revoked_at")

    @property
    @pulumi.getter(name="revokedBy")
    def revoked_by(self) -> builtins.str:
        return pulumi.get(self, "revoked_by")


@pulumi.output_type
class GetSigningProfileSignatureValidityPeriodResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.int):
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        return pulumi.get(self, "value")


