# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import iam
from .. import iam as _iam
from ._inputs import *

__all__ = ['QueuePolicyArgs', 'QueuePolicy']

@pulumi.input_type
class QueuePolicyArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[Union[builtins.str, 'PolicyDocumentArgs']],
                 queue_url: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a QueuePolicy resource.
        :param pulumi.Input[builtins.str] queue_url: URL of the SQS Queue to which to attach the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "queue_url", queue_url)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[Union[builtins.str, 'PolicyDocumentArgs']]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[Union[builtins.str, 'PolicyDocumentArgs']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> pulumi.Input[builtins.str]:
        """
        URL of the SQS Queue to which to attach the policy.
        """
        return pulumi.get(self, "queue_url")

    @queue_url.setter
    def queue_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "queue_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _QueuePolicyState:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[Union[builtins.str, 'PolicyDocumentArgs']]] = None,
                 queue_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering QueuePolicy resources.
        :param pulumi.Input[builtins.str] queue_url: URL of the SQS Queue to which to attach the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if queue_url is not None:
            pulumi.set(__self__, "queue_url", queue_url)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[Union[builtins.str, 'PolicyDocumentArgs']]]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[Union[builtins.str, 'PolicyDocumentArgs']]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the SQS Queue to which to attach the policy.
        """
        return pulumi.get(self, "queue_url")

    @queue_url.setter
    def queue_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queue_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:sqs/queuePolicy:QueuePolicy")
class QueuePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy: Optional[pulumi.Input[Union[builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
                 queue_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Allows you to set a policy of an SQS Queue while referencing the ARN of the queue within the policy.

        !> AWS will hang indefinitely when creating or updating an `sqs.Queue` with an associated policy if `Version = "2012-10-17"` is not explicitly set in the policy. See below for an example of how to avoid this issue.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        q = aws.sqs.Queue("q", name="examplequeue")
        test = q.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[{
            "sid": "First",
            "effect": "Allow",
            "principals": [{
                "type": "*",
                "identifiers": ["*"],
            }],
            "actions": ["sqs:SendMessage"],
            "resources": [arn],
            "conditions": [{
                "test": "ArnEquals",
                "variable": "aws:SourceArn",
                "values": [example["arn"]],
            }],
        }]))
        test_queue_policy = aws.sqs.QueuePolicy("test",
            queue_url=q.id,
            policy=test.json)
        ```

        ### Timeout Problems Creating/Updating

        If `Version = "2012-10-17"` is not explicitly set in the policy, AWS may hang, causing the AWS provider to time out. To avoid this, make sure to include `Version` as shown in the example below.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="brodobaggins")
        example_queue = aws.sqs.Queue("example", name="be-giant")
        example_queue_policy = aws.sqs.QueuePolicy("example",
            queue_url=example_queue.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Sid": "Cejuwdam",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "s3.amazonaws.com",
                    },
                    "Action": "SQS:SendMessage",
                    "Resource": example_queue.arn,
                    "Condition": {
                        "ArnLike": {
                            "aws:SourceArn": example.arn,
                        },
                    },
                }],
            }))
        ```

        ## Import

        Using `pulumi import`, import SQS Queue Policies using the queue URL. For example:

        ```sh
        $ pulumi import aws:sqs/queuePolicy:QueuePolicy test https://queue.amazonaws.com/123456789012/myqueue
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] queue_url: URL of the SQS Queue to which to attach the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueuePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to set a policy of an SQS Queue while referencing the ARN of the queue within the policy.

        !> AWS will hang indefinitely when creating or updating an `sqs.Queue` with an associated policy if `Version = "2012-10-17"` is not explicitly set in the policy. See below for an example of how to avoid this issue.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        q = aws.sqs.Queue("q", name="examplequeue")
        test = q.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[{
            "sid": "First",
            "effect": "Allow",
            "principals": [{
                "type": "*",
                "identifiers": ["*"],
            }],
            "actions": ["sqs:SendMessage"],
            "resources": [arn],
            "conditions": [{
                "test": "ArnEquals",
                "variable": "aws:SourceArn",
                "values": [example["arn"]],
            }],
        }]))
        test_queue_policy = aws.sqs.QueuePolicy("test",
            queue_url=q.id,
            policy=test.json)
        ```

        ### Timeout Problems Creating/Updating

        If `Version = "2012-10-17"` is not explicitly set in the policy, AWS may hang, causing the AWS provider to time out. To avoid this, make sure to include `Version` as shown in the example below.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="brodobaggins")
        example_queue = aws.sqs.Queue("example", name="be-giant")
        example_queue_policy = aws.sqs.QueuePolicy("example",
            queue_url=example_queue.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Sid": "Cejuwdam",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "s3.amazonaws.com",
                    },
                    "Action": "SQS:SendMessage",
                    "Resource": example_queue.arn,
                    "Condition": {
                        "ArnLike": {
                            "aws:SourceArn": example.arn,
                        },
                    },
                }],
            }))
        ```

        ## Import

        Using `pulumi import`, import SQS Queue Policies using the queue URL. For example:

        ```sh
        $ pulumi import aws:sqs/queuePolicy:QueuePolicy test https://queue.amazonaws.com/123456789012/myqueue
        ```

        :param str resource_name: The name of the resource.
        :param QueuePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueuePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy: Optional[pulumi.Input[Union[builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
                 queue_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueuePolicyArgs.__new__(QueuePolicyArgs)

            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if queue_url is None and not opts.urn:
                raise TypeError("Missing required property 'queue_url'")
            __props__.__dict__["queue_url"] = queue_url
            __props__.__dict__["region"] = region
        super(QueuePolicy, __self__).__init__(
            'aws:sqs/queuePolicy:QueuePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy: Optional[pulumi.Input[Union[builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
            queue_url: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'QueuePolicy':
        """
        Get an existing QueuePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] queue_url: URL of the SQS Queue to which to attach the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueuePolicyState.__new__(_QueuePolicyState)

        __props__.__dict__["policy"] = policy
        __props__.__dict__["queue_url"] = queue_url
        __props__.__dict__["region"] = region
        return QueuePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> pulumi.Output[builtins.str]:
        """
        URL of the SQS Queue to which to attach the policy.
        """
        return pulumi.get(self, "queue_url")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

