# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DocumentArgs', 'Document']

@pulumi.input_type
class DocumentArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[builtins.str],
                 document_type: pulumi.Input[builtins.str],
                 attachments_sources: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]]] = None,
                 document_format: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Document resource.
        :param pulumi.Input[builtins.str] content: The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
        :param pulumi.Input[builtins.str] document_type: The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
        :param pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]] attachments_sources: One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
        :param pulumi.Input[builtins.str] document_format: The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
        :param pulumi.Input[builtins.str] name: The name of the document.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] permissions: Additional permissions to attach to the document. See Permissions below for details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] target_type: The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
        :param pulumi.Input[builtins.str] version_name: The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "document_type", document_type)
        if attachments_sources is not None:
            pulumi.set(__self__, "attachments_sources", attachments_sources)
        if document_format is not None:
            pulumi.set(__self__, "document_format", document_format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "document_type", value)

    @property
    @pulumi.getter(name="attachmentsSources")
    def attachments_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]]]:
        """
        One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
        """
        return pulumi.get(self, "attachments_sources")

    @attachments_sources.setter
    def attachments_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]]]):
        pulumi.set(self, "attachments_sources", value)

    @property
    @pulumi.getter(name="documentFormat")
    def document_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
        """
        return pulumi.get(self, "document_format")

    @document_format.setter
    def document_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_format", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the document.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional permissions to attach to the document. See Permissions below for details.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.input_type
class _DocumentState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 attachments_sources: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 created_date: Optional[pulumi.Input[builtins.str]] = None,
                 default_version: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 document_format: Optional[pulumi.Input[builtins.str]] = None,
                 document_type: Optional[pulumi.Input[builtins.str]] = None,
                 document_version: Optional[pulumi.Input[builtins.str]] = None,
                 hash: Optional[pulumi.Input[builtins.str]] = None,
                 hash_type: Optional[pulumi.Input[builtins.str]] = None,
                 latest_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentParameterArgs']]]] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 platform_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Document resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the document.
        :param pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]] attachments_sources: One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
        :param pulumi.Input[builtins.str] content: The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
        :param pulumi.Input[builtins.str] created_date: The date the document was created.
        :param pulumi.Input[builtins.str] default_version: The default version of the document.
        :param pulumi.Input[builtins.str] description: A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.
        :param pulumi.Input[builtins.str] document_format: The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
        :param pulumi.Input[builtins.str] document_type: The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
        :param pulumi.Input[builtins.str] document_version: The document version.
        :param pulumi.Input[builtins.str] hash: The Sha256 or Sha1 hash created by the system when the document was created.
        :param pulumi.Input[builtins.str] hash_type: The hash type of the document. Valid values: `Sha256`, `Sha1`.
        :param pulumi.Input[builtins.str] latest_version: The latest version of the document.
        :param pulumi.Input[builtins.str] name: The name of the document.
        :param pulumi.Input[builtins.str] owner: The Amazon Web Services user that created the document.
        :param pulumi.Input[Sequence[pulumi.Input['DocumentParameterArgs']]] parameters: One or more configuration blocks describing the parameters for the document. See `parameter` block below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] permissions: Additional permissions to attach to the document. See Permissions below for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] platform_types: The list of operating system (OS) platforms compatible with this SSM document. Valid values: `Windows`, `Linux`, `MacOS`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] schema_version: The schema version of the document.
        :param pulumi.Input[builtins.str] status: The status of the SSM document. Valid values: `Creating`, `Active`, `Updating`, `Deleting`, `Failed`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target_type: The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
        :param pulumi.Input[builtins.str] version_name: The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if attachments_sources is not None:
            pulumi.set(__self__, "attachments_sources", attachments_sources)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document_format is not None:
            pulumi.set(__self__, "document_format", document_format)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if hash_type is not None:
            pulumi.set(__self__, "hash_type", hash_type)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if platform_types is not None:
            pulumi.set(__self__, "platform_types", platform_types)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_version is not None:
            pulumi.set(__self__, "schema_version", schema_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the document.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="attachmentsSources")
    def attachments_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]]]:
        """
        One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
        """
        return pulumi.get(self, "attachments_sources")

    @attachments_sources.setter
    def attachments_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentAttachmentsSourceArgs']]]]):
        pulumi.set(self, "attachments_sources", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date the document was created.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_date", value)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default version of the document.
        """
        return pulumi.get(self, "default_version")

    @default_version.setter
    def default_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentFormat")
    def document_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
        """
        return pulumi.get(self, "document_format")

    @document_format.setter
    def document_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_format", value)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_type", value)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The document version.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_version", value)

    @property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Sha256 or Sha1 hash created by the system when the document was created.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash", value)

    @property
    @pulumi.getter(name="hashType")
    def hash_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hash type of the document. Valid values: `Sha256`, `Sha1`.
        """
        return pulumi.get(self, "hash_type")

    @hash_type.setter
    def hash_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_type", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The latest version of the document.
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the document.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Web Services user that created the document.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DocumentParameterArgs']]]]:
        """
        One or more configuration blocks describing the parameters for the document. See `parameter` block below for details.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional permissions to attach to the document. See Permissions below for details.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="platformTypes")
    def platform_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of operating system (OS) platforms compatible with this SSM document. Valid values: `Windows`, `Linux`, `MacOS`.
        """
        return pulumi.get(self, "platform_types")

    @platform_types.setter
    def platform_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "platform_types", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The schema version of the document.
        """
        return pulumi.get(self, "schema_version")

    @schema_version.setter
    def schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_version", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the SSM document. Valid values: `Creating`, `Active`, `Updating`, `Deleting`, `Failed`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_name", value)


@pulumi.type_token("aws:ssm/document:Document")
class Document(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DocumentAttachmentsSourceArgs', 'DocumentAttachmentsSourceArgsDict']]]]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 document_format: Optional[pulumi.Input[builtins.str]] = None,
                 document_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an SSM Document resource

        > **NOTE on updating SSM documents:** Only documents with a schema version of 2.0
        or greater can update their content once created, see [SSM Schema Features](http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html#document-schemas-features). To update a document with an older schema version you must recreate the resource. Not all document types support a schema version of 2.0 or greater. Refer to [SSM document schema features and examples](https://docs.aws.amazon.com/systems-manager/latest/userguide/document-schemas-features.html) for information about which schema versions are supported for the respective `document_type`.

        ## Example Usage

        ### Create an ssm document in JSON format

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ssm.Document("foo",
            name="test_document",
            document_type="Command",
            content=\"\"\"  {
            "schemaVersion": "1.2",
            "description": "Check ip configuration of a Linux instance.",
            "parameters": {

            },
            "runtimeConfig": {
              "aws:runShellScript": {
                "properties": [
                  {
                    "id": "0.aws:runShellScript",
                    "runCommand": ["ifconfig"]
                  }
                ]
              }
            }
          }
        \"\"\")
        ```

        ### Create an ssm document in YAML format

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ssm.Document("foo",
            name="test_document",
            document_format="YAML",
            document_type="Command",
            content=\"\"\"schemaVersion: '1.2'
        description: Check ip configuration of a Linux instance.
        parameters: {}
        runtimeConfig:
          'aws:runShellScript':
            properties:
              - id: '0.aws:runShellScript'
                runCommand:
                  - ifconfig
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import SSM Documents using the name. For example:

        ```sh
        $ pulumi import aws:ssm/document:Document example example
        ```
        The `attachments_source` argument does not have an SSM API method for reading the attachment information detail after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DocumentAttachmentsSourceArgs', 'DocumentAttachmentsSourceArgsDict']]]] attachments_sources: One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
        :param pulumi.Input[builtins.str] content: The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
        :param pulumi.Input[builtins.str] document_format: The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
        :param pulumi.Input[builtins.str] document_type: The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
        :param pulumi.Input[builtins.str] name: The name of the document.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] permissions: Additional permissions to attach to the document. See Permissions below for details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] target_type: The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
        :param pulumi.Input[builtins.str] version_name: The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DocumentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an SSM Document resource

        > **NOTE on updating SSM documents:** Only documents with a schema version of 2.0
        or greater can update their content once created, see [SSM Schema Features](http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html#document-schemas-features). To update a document with an older schema version you must recreate the resource. Not all document types support a schema version of 2.0 or greater. Refer to [SSM document schema features and examples](https://docs.aws.amazon.com/systems-manager/latest/userguide/document-schemas-features.html) for information about which schema versions are supported for the respective `document_type`.

        ## Example Usage

        ### Create an ssm document in JSON format

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ssm.Document("foo",
            name="test_document",
            document_type="Command",
            content=\"\"\"  {
            "schemaVersion": "1.2",
            "description": "Check ip configuration of a Linux instance.",
            "parameters": {

            },
            "runtimeConfig": {
              "aws:runShellScript": {
                "properties": [
                  {
                    "id": "0.aws:runShellScript",
                    "runCommand": ["ifconfig"]
                  }
                ]
              }
            }
          }
        \"\"\")
        ```

        ### Create an ssm document in YAML format

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ssm.Document("foo",
            name="test_document",
            document_format="YAML",
            document_type="Command",
            content=\"\"\"schemaVersion: '1.2'
        description: Check ip configuration of a Linux instance.
        parameters: {}
        runtimeConfig:
          'aws:runShellScript':
            properties:
              - id: '0.aws:runShellScript'
                runCommand:
                  - ifconfig
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import SSM Documents using the name. For example:

        ```sh
        $ pulumi import aws:ssm/document:Document example example
        ```
        The `attachments_source` argument does not have an SSM API method for reading the attachment information detail after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param DocumentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DocumentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DocumentAttachmentsSourceArgs', 'DocumentAttachmentsSourceArgsDict']]]]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 document_format: Optional[pulumi.Input[builtins.str]] = None,
                 document_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DocumentArgs.__new__(DocumentArgs)

            __props__.__dict__["attachments_sources"] = attachments_sources
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["document_format"] = document_format
            if document_type is None and not opts.urn:
                raise TypeError("Missing required property 'document_type'")
            __props__.__dict__["document_type"] = document_type
            __props__.__dict__["name"] = name
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["version_name"] = version_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["default_version"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["document_version"] = None
            __props__.__dict__["hash"] = None
            __props__.__dict__["hash_type"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["parameters"] = None
            __props__.__dict__["platform_types"] = None
            __props__.__dict__["schema_version"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(Document, __self__).__init__(
            'aws:ssm/document:Document',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            attachments_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DocumentAttachmentsSourceArgs', 'DocumentAttachmentsSourceArgsDict']]]]] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            created_date: Optional[pulumi.Input[builtins.str]] = None,
            default_version: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            document_format: Optional[pulumi.Input[builtins.str]] = None,
            document_type: Optional[pulumi.Input[builtins.str]] = None,
            document_version: Optional[pulumi.Input[builtins.str]] = None,
            hash: Optional[pulumi.Input[builtins.str]] = None,
            hash_type: Optional[pulumi.Input[builtins.str]] = None,
            latest_version: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DocumentParameterArgs', 'DocumentParameterArgsDict']]]]] = None,
            permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            platform_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            schema_version: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_type: Optional[pulumi.Input[builtins.str]] = None,
            version_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Document':
        """
        Get an existing Document resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the document.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DocumentAttachmentsSourceArgs', 'DocumentAttachmentsSourceArgsDict']]]] attachments_sources: One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
        :param pulumi.Input[builtins.str] content: The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
        :param pulumi.Input[builtins.str] created_date: The date the document was created.
        :param pulumi.Input[builtins.str] default_version: The default version of the document.
        :param pulumi.Input[builtins.str] description: A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.
        :param pulumi.Input[builtins.str] document_format: The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
        :param pulumi.Input[builtins.str] document_type: The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
        :param pulumi.Input[builtins.str] document_version: The document version.
        :param pulumi.Input[builtins.str] hash: The Sha256 or Sha1 hash created by the system when the document was created.
        :param pulumi.Input[builtins.str] hash_type: The hash type of the document. Valid values: `Sha256`, `Sha1`.
        :param pulumi.Input[builtins.str] latest_version: The latest version of the document.
        :param pulumi.Input[builtins.str] name: The name of the document.
        :param pulumi.Input[builtins.str] owner: The Amazon Web Services user that created the document.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DocumentParameterArgs', 'DocumentParameterArgsDict']]]] parameters: One or more configuration blocks describing the parameters for the document. See `parameter` block below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] permissions: Additional permissions to attach to the document. See Permissions below for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] platform_types: The list of operating system (OS) platforms compatible with this SSM document. Valid values: `Windows`, `Linux`, `MacOS`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] schema_version: The schema version of the document.
        :param pulumi.Input[builtins.str] status: The status of the SSM document. Valid values: `Creating`, `Active`, `Updating`, `Deleting`, `Failed`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target_type: The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
        :param pulumi.Input[builtins.str] version_name: The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DocumentState.__new__(_DocumentState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["attachments_sources"] = attachments_sources
        __props__.__dict__["content"] = content
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["default_version"] = default_version
        __props__.__dict__["description"] = description
        __props__.__dict__["document_format"] = document_format
        __props__.__dict__["document_type"] = document_type
        __props__.__dict__["document_version"] = document_version
        __props__.__dict__["hash"] = hash
        __props__.__dict__["hash_type"] = hash_type
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["platform_types"] = platform_types
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_version"] = schema_version
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["version_name"] = version_name
        return Document(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the document.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="attachmentsSources")
    def attachments_sources(self) -> pulumi.Output[Optional[Sequence['outputs.DocumentAttachmentsSource']]]:
        """
        One or more configuration blocks describing attachments sources to a version of a document. See `attachments_source` block below for details.
        """
        return pulumi.get(self, "attachments_sources")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[builtins.str]:
        """
        The content for the SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[builtins.str]:
        """
        The date the document was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> pulumi.Output[builtins.str]:
        """
        The default version of the document.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentFormat")
    def document_format(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
        """
        return pulumi.get(self, "document_format")

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the document. For a list of valid values, see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateDocument.html#systemsmanager-CreateDocument-request-DocumentType).
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> pulumi.Output[builtins.str]:
        """
        The document version.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter
    def hash(self) -> pulumi.Output[builtins.str]:
        """
        The Sha256 or Sha1 hash created by the system when the document was created.
        """
        return pulumi.get(self, "hash")

    @property
    @pulumi.getter(name="hashType")
    def hash_type(self) -> pulumi.Output[builtins.str]:
        """
        The hash type of the document. Valid values: `Sha256`, `Sha1`.
        """
        return pulumi.get(self, "hash_type")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[builtins.str]:
        """
        The latest version of the document.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the document.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Web Services user that created the document.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.DocumentParameter']]:
        """
        One or more configuration blocks describing the parameters for the document. See `parameter` block below for details.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Additional permissions to attach to the document. See Permissions below for details.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="platformTypes")
    def platform_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of operating system (OS) platforms compatible with this SSM document. Valid values: `Windows`, `Linux`, `MacOS`.
        """
        return pulumi.get(self, "platform_types")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> pulumi.Output[builtins.str]:
        """
        The schema version of the document.
        """
        return pulumi.get(self, "schema_version")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the SSM document. Valid values: `Creating`, `Active`, `Updating`, `Deleting`, `Failed`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [AWS resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the artifact associated with the document. For example, `12.6`. This value is unique across all versions of a document, and can't be changed.
        """
        return pulumi.get(self, "version_name")

