# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssociationOutputLocation',
    'AssociationTarget',
    'ContactsRotationRecurrence',
    'ContactsRotationRecurrenceDailySetting',
    'ContactsRotationRecurrenceMonthlySetting',
    'ContactsRotationRecurrenceMonthlySettingHandOffTime',
    'ContactsRotationRecurrenceShiftCoverage',
    'ContactsRotationRecurrenceShiftCoverageCoverageTime',
    'ContactsRotationRecurrenceShiftCoverageCoverageTimeEnd',
    'ContactsRotationRecurrenceShiftCoverageCoverageTimeStart',
    'ContactsRotationRecurrenceWeeklySetting',
    'ContactsRotationRecurrenceWeeklySettingHandOffTime',
    'DocumentAttachmentsSource',
    'DocumentParameter',
    'MaintenanceWindowTargetTarget',
    'MaintenanceWindowTaskTarget',
    'MaintenanceWindowTaskTaskInvocationParameters',
    'MaintenanceWindowTaskTaskInvocationParametersAutomationParameters',
    'MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter',
    'MaintenanceWindowTaskTaskInvocationParametersLambdaParameters',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter',
    'MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters',
    'PatchBaselineApprovalRule',
    'PatchBaselineApprovalRulePatchFilter',
    'PatchBaselineGlobalFilter',
    'PatchBaselineSource',
    'QuicksetupConfigurationManagerConfigurationDefinition',
    'QuicksetupConfigurationManagerStatusSummary',
    'QuicksetupConfigurationManagerTimeouts',
    'ResourceDataSyncS3Destination',
    'GetContactsRotationRecurrenceResult',
    'GetContactsRotationRecurrenceDailySettingResult',
    'GetContactsRotationRecurrenceMonthlySettingResult',
    'GetContactsRotationRecurrenceMonthlySettingHandOffTimeResult',
    'GetContactsRotationRecurrenceShiftCoverageResult',
    'GetContactsRotationRecurrenceShiftCoverageCoverageTimeResult',
    'GetContactsRotationRecurrenceShiftCoverageCoverageTimeEndResult',
    'GetContactsRotationRecurrenceShiftCoverageCoverageTimeStartResult',
    'GetContactsRotationRecurrenceWeeklySettingResult',
    'GetContactsRotationRecurrenceWeeklySettingHandOffTimeResult',
    'GetInstancesFilterResult',
    'GetMaintenanceWindowsFilterResult',
    'GetPatchBaselineApprovalRuleResult',
    'GetPatchBaselineApprovalRulePatchFilterResult',
    'GetPatchBaselineGlobalFilterResult',
    'GetPatchBaselineSourceResult',
    'GetPatchBaselinesBaselineIdentityResult',
    'GetPatchBaselinesFilterResult',
]

@pulumi.output_type
class AssociationOutputLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"
        elif key == "s3Region":
            suggest = "s3_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssociationOutputLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssociationOutputLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssociationOutputLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: builtins.str,
                 s3_key_prefix: Optional[builtins.str] = None,
                 s3_region: Optional[builtins.str] = None):
        """
        :param builtins.str s3_bucket_name: The S3 bucket name.
        :param builtins.str s3_key_prefix: The S3 bucket prefix. Results stored in the root if not configured.
        :param builtins.str s3_region: The S3 bucket region.
               
               Targets specify what instance IDs or tags to apply the document to and has these keys:
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)
        if s3_region is not None:
            pulumi.set(__self__, "s3_region", s3_region)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> builtins.str:
        """
        The S3 bucket name.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[builtins.str]:
        """
        The S3 bucket prefix. Results stored in the root if not configured.
        """
        return pulumi.get(self, "s3_key_prefix")

    @property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> Optional[builtins.str]:
        """
        The S3 bucket region.

        Targets specify what instance IDs or tags to apply the document to and has these keys:
        """
        return pulumi.get(self, "s3_region")


@pulumi.output_type
class AssociationTarget(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
        :param Sequence[builtins.str] values: User-defined criteria that maps to Key. A list of instance IDs or tag values.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        User-defined criteria that maps to Key. A list of instance IDs or tag values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ContactsRotationRecurrence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfOnCalls":
            suggest = "number_of_on_calls"
        elif key == "recurrenceMultiplier":
            suggest = "recurrence_multiplier"
        elif key == "dailySettings":
            suggest = "daily_settings"
        elif key == "monthlySettings":
            suggest = "monthly_settings"
        elif key == "shiftCoverages":
            suggest = "shift_coverages"
        elif key == "weeklySettings":
            suggest = "weekly_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 number_of_on_calls: builtins.int,
                 recurrence_multiplier: builtins.int,
                 daily_settings: Optional[Sequence['outputs.ContactsRotationRecurrenceDailySetting']] = None,
                 monthly_settings: Optional[Sequence['outputs.ContactsRotationRecurrenceMonthlySetting']] = None,
                 shift_coverages: Optional[Sequence['outputs.ContactsRotationRecurrenceShiftCoverage']] = None,
                 weekly_settings: Optional[Sequence['outputs.ContactsRotationRecurrenceWeeklySetting']] = None):
        """
        :param builtins.int number_of_on_calls: (Required) The number of contacts, or shift team members designated to be on call concurrently during a shift.
        :param builtins.int recurrence_multiplier: (Required) The number of days, weeks, or months a single rotation lasts.
        :param Sequence['ContactsRotationRecurrenceMonthlySettingArgs'] monthly_settings: (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
        :param Sequence['ContactsRotationRecurrenceShiftCoverageArgs'] shift_coverages: (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
        :param Sequence['ContactsRotationRecurrenceWeeklySettingArgs'] weekly_settings: (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
        """
        pulumi.set(__self__, "number_of_on_calls", number_of_on_calls)
        pulumi.set(__self__, "recurrence_multiplier", recurrence_multiplier)
        if daily_settings is not None:
            pulumi.set(__self__, "daily_settings", daily_settings)
        if monthly_settings is not None:
            pulumi.set(__self__, "monthly_settings", monthly_settings)
        if shift_coverages is not None:
            pulumi.set(__self__, "shift_coverages", shift_coverages)
        if weekly_settings is not None:
            pulumi.set(__self__, "weekly_settings", weekly_settings)

    @property
    @pulumi.getter(name="numberOfOnCalls")
    def number_of_on_calls(self) -> builtins.int:
        """
        (Required) The number of contacts, or shift team members designated to be on call concurrently during a shift.
        """
        return pulumi.get(self, "number_of_on_calls")

    @property
    @pulumi.getter(name="recurrenceMultiplier")
    def recurrence_multiplier(self) -> builtins.int:
        """
        (Required) The number of days, weeks, or months a single rotation lasts.
        """
        return pulumi.get(self, "recurrence_multiplier")

    @property
    @pulumi.getter(name="dailySettings")
    def daily_settings(self) -> Optional[Sequence['outputs.ContactsRotationRecurrenceDailySetting']]:
        return pulumi.get(self, "daily_settings")

    @property
    @pulumi.getter(name="monthlySettings")
    def monthly_settings(self) -> Optional[Sequence['outputs.ContactsRotationRecurrenceMonthlySetting']]:
        """
        (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
        """
        return pulumi.get(self, "monthly_settings")

    @property
    @pulumi.getter(name="shiftCoverages")
    def shift_coverages(self) -> Optional[Sequence['outputs.ContactsRotationRecurrenceShiftCoverage']]:
        """
        (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
        """
        return pulumi.get(self, "shift_coverages")

    @property
    @pulumi.getter(name="weeklySettings")
    def weekly_settings(self) -> Optional[Sequence['outputs.ContactsRotationRecurrenceWeeklySetting']]:
        """
        (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
        """
        return pulumi.get(self, "weekly_settings")


@pulumi.output_type
class ContactsRotationRecurrenceDailySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "minuteOfHour":
            suggest = "minute_of_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceDailySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceDailySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceDailySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        """
        :param builtins.int hour_of_day: (Required) The hour of the day.
        :param builtins.int minute_of_hour: (Required) The minutes of the hour.
        """
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        """
        (Required) The hour of the day.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        """
        (Required) The minutes of the hour.
        """
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class ContactsRotationRecurrenceMonthlySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfMonth":
            suggest = "day_of_month"
        elif key == "handOffTime":
            suggest = "hand_off_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceMonthlySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceMonthlySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceMonthlySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_month: builtins.int,
                 hand_off_time: Optional['outputs.ContactsRotationRecurrenceMonthlySettingHandOffTime'] = None):
        """
        :param builtins.int day_of_month: (Required) The day of the month when monthly recurring on-call rotations begin.
        :param 'ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs' hand_off_time: (Required) The hand off time. See Hand Off Time for more details.
        """
        pulumi.set(__self__, "day_of_month", day_of_month)
        if hand_off_time is not None:
            pulumi.set(__self__, "hand_off_time", hand_off_time)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> builtins.int:
        """
        (Required) The day of the month when monthly recurring on-call rotations begin.
        """
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="handOffTime")
    def hand_off_time(self) -> Optional['outputs.ContactsRotationRecurrenceMonthlySettingHandOffTime']:
        """
        (Required) The hand off time. See Hand Off Time for more details.
        """
        return pulumi.get(self, "hand_off_time")


@pulumi.output_type
class ContactsRotationRecurrenceMonthlySettingHandOffTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "minuteOfHour":
            suggest = "minute_of_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceMonthlySettingHandOffTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceMonthlySettingHandOffTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceMonthlySettingHandOffTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        """
        :param builtins.int hour_of_day: (Required) The hour of the day.
        :param builtins.int minute_of_hour: (Required) The minutes of the hour.
        """
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        """
        (Required) The hour of the day.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        """
        (Required) The minutes of the hour.
        """
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class ContactsRotationRecurrenceShiftCoverage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mapBlockKey":
            suggest = "map_block_key"
        elif key == "coverageTimes":
            suggest = "coverage_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceShiftCoverage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceShiftCoverage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceShiftCoverage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 map_block_key: builtins.str,
                 coverage_times: Optional[Sequence['outputs.ContactsRotationRecurrenceShiftCoverageCoverageTime']] = None):
        """
        :param Sequence['ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs'] coverage_times: (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
        """
        pulumi.set(__self__, "map_block_key", map_block_key)
        if coverage_times is not None:
            pulumi.set(__self__, "coverage_times", coverage_times)

    @property
    @pulumi.getter(name="mapBlockKey")
    def map_block_key(self) -> builtins.str:
        return pulumi.get(self, "map_block_key")

    @property
    @pulumi.getter(name="coverageTimes")
    def coverage_times(self) -> Optional[Sequence['outputs.ContactsRotationRecurrenceShiftCoverageCoverageTime']]:
        """
        (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
        """
        return pulumi.get(self, "coverage_times")


@pulumi.output_type
class ContactsRotationRecurrenceShiftCoverageCoverageTime(dict):
    def __init__(__self__, *,
                 end: Optional['outputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeEnd'] = None,
                 start: Optional['outputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeStart'] = None):
        """
        :param 'ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs' end: (Required) The end time of the on-call shift. See Hand Off Time for more details.
        :param 'ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs' start: (Required) The start time of the on-call shift. See Hand Off Time for more details.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional['outputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeEnd']:
        """
        (Required) The end time of the on-call shift. See Hand Off Time for more details.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> Optional['outputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeStart']:
        """
        (Required) The start time of the on-call shift. See Hand Off Time for more details.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class ContactsRotationRecurrenceShiftCoverageCoverageTimeEnd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "minuteOfHour":
            suggest = "minute_of_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceShiftCoverageCoverageTimeEnd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceShiftCoverageCoverageTimeEnd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceShiftCoverageCoverageTimeEnd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        """
        :param builtins.int hour_of_day: (Required) The hour of the day.
        :param builtins.int minute_of_hour: (Required) The minutes of the hour.
        """
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        """
        (Required) The hour of the day.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        """
        (Required) The minutes of the hour.
        """
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class ContactsRotationRecurrenceShiftCoverageCoverageTimeStart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "minuteOfHour":
            suggest = "minute_of_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceShiftCoverageCoverageTimeStart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceShiftCoverageCoverageTimeStart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceShiftCoverageCoverageTimeStart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        """
        :param builtins.int hour_of_day: (Required) The hour of the day.
        :param builtins.int minute_of_hour: (Required) The minutes of the hour.
        """
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        """
        (Required) The hour of the day.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        """
        (Required) The minutes of the hour.
        """
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class ContactsRotationRecurrenceWeeklySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "handOffTime":
            suggest = "hand_off_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceWeeklySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceWeeklySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceWeeklySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 hand_off_time: Optional['outputs.ContactsRotationRecurrenceWeeklySettingHandOffTime'] = None):
        """
        :param builtins.str day_of_week: (Required) The day of the week when the shift coverage occurs.
        :param 'ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs' hand_off_time: (Required) The hand off time. See Hand Off Time for more details.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        if hand_off_time is not None:
            pulumi.set(__self__, "hand_off_time", hand_off_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        (Required) The day of the week when the shift coverage occurs.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="handOffTime")
    def hand_off_time(self) -> Optional['outputs.ContactsRotationRecurrenceWeeklySettingHandOffTime']:
        """
        (Required) The hand off time. See Hand Off Time for more details.
        """
        return pulumi.get(self, "hand_off_time")


@pulumi.output_type
class ContactsRotationRecurrenceWeeklySettingHandOffTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "minuteOfHour":
            suggest = "minute_of_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactsRotationRecurrenceWeeklySettingHandOffTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactsRotationRecurrenceWeeklySettingHandOffTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactsRotationRecurrenceWeeklySettingHandOffTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        """
        :param builtins.int hour_of_day: (Required) The hour of the day.
        :param builtins.int minute_of_hour: (Required) The minutes of the hour.
        """
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        """
        (Required) The hour of the day.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        """
        (Required) The minutes of the hour.
        """
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class DocumentAttachmentsSource(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str],
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str key: The key of a key-value pair that identifies the location of an attachment to the document. Valid values: `SourceUrl`, `S3FileUrl`, `AttachmentReference`.
        :param Sequence[builtins.str] values: The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
        :param builtins.str name: The name of the document attachment file.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of a key-value pair that identifies the location of an attachment to the document. Valid values: `SourceUrl`, `S3FileUrl`, `AttachmentReference`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the document attachment file.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DocumentParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str default_value: If specified, the default values for the parameters. Parameters without a default value are required. Parameters with a default value are optional.
        :param builtins.str description: A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.
        :param builtins.str name: The name of the document.
        :param builtins.str type: The type of parameter. Valid values: `String`, `StringList`.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        If specified, the default values for the parameters. Parameters without a default value are required. Parameters with a default value are optional.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the document.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of parameter. Valid values: `String`, `StringList`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MaintenanceWindowTargetTarget(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTarget(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] values: The array of strings.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The array of strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automationParameters":
            suggest = "automation_parameters"
        elif key == "lambdaParameters":
            suggest = "lambda_parameters"
        elif key == "runCommandParameters":
            suggest = "run_command_parameters"
        elif key == "stepFunctionsParameters":
            suggest = "step_functions_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automation_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParameters'] = None,
                 lambda_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParameters'] = None,
                 run_command_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters'] = None,
                 step_functions_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters'] = None):
        """
        :param 'MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs' automation_parameters: The parameters for an AUTOMATION task type. Documented below.
        :param 'MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs' lambda_parameters: The parameters for a LAMBDA task type. Documented below.
        :param 'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs' run_command_parameters: The parameters for a RUN_COMMAND task type. Documented below.
        :param 'MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs' step_functions_parameters: The parameters for a STEP_FUNCTIONS task type. Documented below.
        """
        if automation_parameters is not None:
            pulumi.set(__self__, "automation_parameters", automation_parameters)
        if lambda_parameters is not None:
            pulumi.set(__self__, "lambda_parameters", lambda_parameters)
        if run_command_parameters is not None:
            pulumi.set(__self__, "run_command_parameters", run_command_parameters)
        if step_functions_parameters is not None:
            pulumi.set(__self__, "step_functions_parameters", step_functions_parameters)

    @property
    @pulumi.getter(name="automationParameters")
    def automation_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParameters']:
        """
        The parameters for an AUTOMATION task type. Documented below.
        """
        return pulumi.get(self, "automation_parameters")

    @property
    @pulumi.getter(name="lambdaParameters")
    def lambda_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParameters']:
        """
        The parameters for a LAMBDA task type. Documented below.
        """
        return pulumi.get(self, "lambda_parameters")

    @property
    @pulumi.getter(name="runCommandParameters")
    def run_command_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters']:
        """
        The parameters for a RUN_COMMAND task type. Documented below.
        """
        return pulumi.get(self, "run_command_parameters")

    @property
    @pulumi.getter(name="stepFunctionsParameters")
    def step_functions_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters']:
        """
        The parameters for a STEP_FUNCTIONS task type. Documented below.
        """
        return pulumi.get(self, "step_functions_parameters")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersAutomationParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentVersion":
            suggest = "document_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersAutomationParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersAutomationParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersAutomationParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 document_version: Optional[builtins.str] = None,
                 parameters: Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter']] = None):
        """
        :param builtins.str document_version: The version of an Automation document to use during task execution.
        :param Sequence['MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs'] parameters: The parameters for the RUN_COMMAND task execution. Documented below.
        """
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[builtins.str]:
        """
        The version of an Automation document to use during task execution.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter']]:
        """
        The parameters for the RUN_COMMAND task execution. Documented below.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: The parameter name.
        :param Sequence[builtins.str] values: The array of strings.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The array of strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersLambdaParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientContext":
            suggest = "client_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersLambdaParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersLambdaParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersLambdaParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_context: Optional[builtins.str] = None,
                 payload: Optional[builtins.str] = None,
                 qualifier: Optional[builtins.str] = None):
        """
        :param builtins.str client_context: Pass client-specific information to the Lambda function that you are invoking.
        :param builtins.str payload: JSON to provide to your Lambda function as input.
        :param builtins.str qualifier: Specify a Lambda function version or alias name.
        """
        if client_context is not None:
            pulumi.set(__self__, "client_context", client_context)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="clientContext")
    def client_context(self) -> Optional[builtins.str]:
        """
        Pass client-specific information to the Lambda function that you are invoking.
        """
        return pulumi.get(self, "client_context")

    @property
    @pulumi.getter
    def payload(self) -> Optional[builtins.str]:
        """
        JSON to provide to your Lambda function as input.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[builtins.str]:
        """
        Specify a Lambda function version or alias name.
        """
        return pulumi.get(self, "qualifier")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchConfig":
            suggest = "cloudwatch_config"
        elif key == "documentHash":
            suggest = "document_hash"
        elif key == "documentHashType":
            suggest = "document_hash_type"
        elif key == "documentVersion":
            suggest = "document_version"
        elif key == "notificationConfig":
            suggest = "notification_config"
        elif key == "outputS3Bucket":
            suggest = "output_s3_bucket"
        elif key == "outputS3KeyPrefix":
            suggest = "output_s3_key_prefix"
        elif key == "serviceRoleArn":
            suggest = "service_role_arn"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_config: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig'] = None,
                 comment: Optional[builtins.str] = None,
                 document_hash: Optional[builtins.str] = None,
                 document_hash_type: Optional[builtins.str] = None,
                 document_version: Optional[builtins.str] = None,
                 notification_config: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig'] = None,
                 output_s3_bucket: Optional[builtins.str] = None,
                 output_s3_key_prefix: Optional[builtins.str] = None,
                 parameters: Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter']] = None,
                 service_role_arn: Optional[builtins.str] = None,
                 timeout_seconds: Optional[builtins.int] = None):
        """
        :param 'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs' cloudwatch_config: Configuration options for sending command output to CloudWatch Logs. Documented below.
        :param builtins.str comment: Information about the command(s) to execute.
        :param builtins.str document_hash: The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
        :param builtins.str document_hash_type: SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
        :param builtins.str document_version: The version of an Automation document to use during task execution.
        :param 'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs' notification_config: Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
        :param builtins.str output_s3_bucket: The name of the Amazon S3 bucket.
        :param builtins.str output_s3_key_prefix: The Amazon S3 bucket subfolder.
        :param Sequence['MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs'] parameters: The parameters for the RUN_COMMAND task execution. Documented below.
        :param builtins.str service_role_arn: The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
        :param builtins.int timeout_seconds: If this time is reached and the command has not already started executing, it doesn't run.
        """
        if cloudwatch_config is not None:
            pulumi.set(__self__, "cloudwatch_config", cloudwatch_config)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if document_hash is not None:
            pulumi.set(__self__, "document_hash", document_hash)
        if document_hash_type is not None:
            pulumi.set(__self__, "document_hash_type", document_hash_type)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if output_s3_bucket is not None:
            pulumi.set(__self__, "output_s3_bucket", output_s3_bucket)
        if output_s3_key_prefix is not None:
            pulumi.set(__self__, "output_s3_key_prefix", output_s3_key_prefix)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="cloudwatchConfig")
    def cloudwatch_config(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig']:
        """
        Configuration options for sending command output to CloudWatch Logs. Documented below.
        """
        return pulumi.get(self, "cloudwatch_config")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        Information about the command(s) to execute.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="documentHash")
    def document_hash(self) -> Optional[builtins.str]:
        """
        The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
        """
        return pulumi.get(self, "document_hash")

    @property
    @pulumi.getter(name="documentHashType")
    def document_hash_type(self) -> Optional[builtins.str]:
        """
        SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
        """
        return pulumi.get(self, "document_hash_type")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[builtins.str]:
        """
        The version of an Automation document to use during task execution.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig']:
        """
        Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter(name="outputS3Bucket")
    def output_s3_bucket(self) -> Optional[builtins.str]:
        """
        The name of the Amazon S3 bucket.
        """
        return pulumi.get(self, "output_s3_bucket")

    @property
    @pulumi.getter(name="outputS3KeyPrefix")
    def output_s3_key_prefix(self) -> Optional[builtins.str]:
        """
        The Amazon S3 bucket subfolder.
        """
        return pulumi.get(self, "output_s3_key_prefix")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter']]:
        """
        The parameters for the RUN_COMMAND task execution. Documented below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        """
        If this time is reached and the command has not already started executing, it doesn't run.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogGroupName":
            suggest = "cloudwatch_log_group_name"
        elif key == "cloudwatchOutputEnabled":
            suggest = "cloudwatch_output_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_log_group_name: Optional[builtins.str] = None,
                 cloudwatch_output_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str cloudwatch_log_group_name: The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
        :param builtins.bool cloudwatch_output_enabled: Enables Systems Manager to send command output to CloudWatch Logs.
        """
        if cloudwatch_log_group_name is not None:
            pulumi.set(__self__, "cloudwatch_log_group_name", cloudwatch_log_group_name)
        if cloudwatch_output_enabled is not None:
            pulumi.set(__self__, "cloudwatch_output_enabled", cloudwatch_output_enabled)

    @property
    @pulumi.getter(name="cloudwatchLogGroupName")
    def cloudwatch_log_group_name(self) -> Optional[builtins.str]:
        """
        The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
        """
        return pulumi.get(self, "cloudwatch_log_group_name")

    @property
    @pulumi.getter(name="cloudwatchOutputEnabled")
    def cloudwatch_output_enabled(self) -> Optional[builtins.bool]:
        """
        Enables Systems Manager to send command output to CloudWatch Logs.
        """
        return pulumi.get(self, "cloudwatch_output_enabled")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notificationArn":
            suggest = "notification_arn"
        elif key == "notificationEvents":
            suggest = "notification_events"
        elif key == "notificationType":
            suggest = "notification_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notification_arn: Optional[builtins.str] = None,
                 notification_events: Optional[Sequence[builtins.str]] = None,
                 notification_type: Optional[builtins.str] = None):
        """
        :param builtins.str notification_arn: An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
        :param Sequence[builtins.str] notification_events: The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
        :param builtins.str notification_type: When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
        """
        if notification_arn is not None:
            pulumi.set(__self__, "notification_arn", notification_arn)
        if notification_events is not None:
            pulumi.set(__self__, "notification_events", notification_events)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)

    @property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> Optional[builtins.str]:
        """
        An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
        """
        return pulumi.get(self, "notification_arn")

    @property
    @pulumi.getter(name="notificationEvents")
    def notification_events(self) -> Optional[Sequence[builtins.str]]:
        """
        The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
        """
        return pulumi.get(self, "notification_events")

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[builtins.str]:
        """
        When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
        """
        return pulumi.get(self, "notification_type")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: The parameter name.
        :param Sequence[builtins.str] values: The array of strings.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The array of strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters(dict):
    def __init__(__self__, *,
                 input: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str input: The inputs for the STEP_FUNCTION task.
        :param builtins.str name: The name of the STEP_FUNCTION task.
        """
        if input is not None:
            pulumi.set(__self__, "input", input)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def input(self) -> Optional[builtins.str]:
        """
        The inputs for the STEP_FUNCTION task.
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the STEP_FUNCTION task.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PatchBaselineApprovalRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patchFilters":
            suggest = "patch_filters"
        elif key == "approveAfterDays":
            suggest = "approve_after_days"
        elif key == "approveUntilDate":
            suggest = "approve_until_date"
        elif key == "complianceLevel":
            suggest = "compliance_level"
        elif key == "enableNonSecurity":
            suggest = "enable_non_security"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchBaselineApprovalRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchBaselineApprovalRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchBaselineApprovalRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 patch_filters: Sequence['outputs.PatchBaselineApprovalRulePatchFilter'],
                 approve_after_days: Optional[builtins.int] = None,
                 approve_until_date: Optional[builtins.str] = None,
                 compliance_level: Optional[builtins.str] = None,
                 enable_non_security: Optional[builtins.bool] = None):
        """
        :param Sequence['PatchBaselineApprovalRulePatchFilterArgs'] patch_filters: Patch filter group that defines the criteria for the rule. Up to 5 patch filters can be specified per approval rule using Key/Value pairs. Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html). Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values. `PATCH_SET` defaults to `OS` if unspecified
        :param builtins.int approve_after_days: Number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline. Valid Range: 0 to 360. Conflicts with `approve_until_date`.
        :param builtins.str approve_until_date: Cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Date is formatted as `YYYY-MM-DD`. Conflicts with `approve_after_days`
        :param builtins.str compliance_level: Compliance level for patches approved by this rule. Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`. The default value is `UNSPECIFIED`.
        :param builtins.bool enable_non_security: Boolean enabling the application of non-security updates. The default value is `false`. Valid for Linux instances only.
        """
        pulumi.set(__self__, "patch_filters", patch_filters)
        if approve_after_days is not None:
            pulumi.set(__self__, "approve_after_days", approve_after_days)
        if approve_until_date is not None:
            pulumi.set(__self__, "approve_until_date", approve_until_date)
        if compliance_level is not None:
            pulumi.set(__self__, "compliance_level", compliance_level)
        if enable_non_security is not None:
            pulumi.set(__self__, "enable_non_security", enable_non_security)

    @property
    @pulumi.getter(name="patchFilters")
    def patch_filters(self) -> Sequence['outputs.PatchBaselineApprovalRulePatchFilter']:
        """
        Patch filter group that defines the criteria for the rule. Up to 5 patch filters can be specified per approval rule using Key/Value pairs. Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html). Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values. `PATCH_SET` defaults to `OS` if unspecified
        """
        return pulumi.get(self, "patch_filters")

    @property
    @pulumi.getter(name="approveAfterDays")
    def approve_after_days(self) -> Optional[builtins.int]:
        """
        Number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline. Valid Range: 0 to 360. Conflicts with `approve_until_date`.
        """
        return pulumi.get(self, "approve_after_days")

    @property
    @pulumi.getter(name="approveUntilDate")
    def approve_until_date(self) -> Optional[builtins.str]:
        """
        Cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Date is formatted as `YYYY-MM-DD`. Conflicts with `approve_after_days`
        """
        return pulumi.get(self, "approve_until_date")

    @property
    @pulumi.getter(name="complianceLevel")
    def compliance_level(self) -> Optional[builtins.str]:
        """
        Compliance level for patches approved by this rule. Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`. The default value is `UNSPECIFIED`.
        """
        return pulumi.get(self, "compliance_level")

    @property
    @pulumi.getter(name="enableNonSecurity")
    def enable_non_security(self) -> Optional[builtins.bool]:
        """
        Boolean enabling the application of non-security updates. The default value is `false`. Valid for Linux instances only.
        """
        return pulumi.get(self, "enable_non_security")


@pulumi.output_type
class PatchBaselineApprovalRulePatchFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class PatchBaselineGlobalFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class PatchBaselineSource(dict):
    def __init__(__self__, *,
                 configuration: builtins.str,
                 name: builtins.str,
                 products: Sequence[builtins.str]):
        """
        :param builtins.str configuration: Value of the yum repo configuration. For information about other options available for your yum repository configuration, see the [`dnf.conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
        :param builtins.str name: Name specified to identify the patch source.
        :param Sequence[builtins.str] products: Specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`. For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def configuration(self) -> builtins.str:
        """
        Value of the yum repo configuration. For information about other options available for your yum repository configuration, see the [`dnf.conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name specified to identify the patch source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def products(self) -> Sequence[builtins.str]:
        """
        Specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`. For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
        """
        return pulumi.get(self, "products")


@pulumi.output_type
class QuicksetupConfigurationManagerConfigurationDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localDeploymentAdministrationRoleArn":
            suggest = "local_deployment_administration_role_arn"
        elif key == "localDeploymentExecutionRoleName":
            suggest = "local_deployment_execution_role_name"
        elif key == "typeVersion":
            suggest = "type_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuicksetupConfigurationManagerConfigurationDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuicksetupConfigurationManagerConfigurationDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuicksetupConfigurationManagerConfigurationDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters: Mapping[str, builtins.str],
                 type: builtins.str,
                 id: Optional[builtins.str] = None,
                 local_deployment_administration_role_arn: Optional[builtins.str] = None,
                 local_deployment_execution_role_name: Optional[builtins.str] = None,
                 type_version: Optional[builtins.str] = None):
        """
        :param Mapping[str, builtins.str] parameters: Parameters for the configuration definition type. Parameters for configuration definitions vary based the configuration type. See the [AWS API documentation](https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_ConfigurationDefinitionInput.html) for a complete list of parameters for each configuration type.
        :param builtins.str type: Type of the Quick Setup configuration.
        :param builtins.str local_deployment_execution_role_name: Name of the IAM role used to deploy local configurations.
        :param builtins.str type_version: Version of the Quick Setup type to use.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if local_deployment_administration_role_arn is not None:
            pulumi.set(__self__, "local_deployment_administration_role_arn", local_deployment_administration_role_arn)
        if local_deployment_execution_role_name is not None:
            pulumi.set(__self__, "local_deployment_execution_role_name", local_deployment_execution_role_name)
        if type_version is not None:
            pulumi.set(__self__, "type_version", type_version)

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, builtins.str]:
        """
        Parameters for the configuration definition type. Parameters for configuration definitions vary based the configuration type. See the [AWS API documentation](https://docs.aws.amazon.com/quick-setup/latest/APIReference/API_ConfigurationDefinitionInput.html) for a complete list of parameters for each configuration type.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the Quick Setup configuration.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localDeploymentAdministrationRoleArn")
    def local_deployment_administration_role_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "local_deployment_administration_role_arn")

    @property
    @pulumi.getter(name="localDeploymentExecutionRoleName")
    def local_deployment_execution_role_name(self) -> Optional[builtins.str]:
        """
        Name of the IAM role used to deploy local configurations.
        """
        return pulumi.get(self, "local_deployment_execution_role_name")

    @property
    @pulumi.getter(name="typeVersion")
    def type_version(self) -> Optional[builtins.str]:
        """
        Version of the Quick Setup type to use.
        """
        return pulumi.get(self, "type_version")


@pulumi.output_type
class QuicksetupConfigurationManagerStatusSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusMessage":
            suggest = "status_message"
        elif key == "statusType":
            suggest = "status_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuicksetupConfigurationManagerStatusSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuicksetupConfigurationManagerStatusSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuicksetupConfigurationManagerStatusSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: builtins.str,
                 status_message: builtins.str,
                 status_type: builtins.str):
        """
        :param builtins.str status: Current status.
        :param builtins.str status_message: When applicable, returns an informational message relevant to the current status and status type of the status summary object.
        :param builtins.str status_type: Type of a status summary.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "status_type", status_type)

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> builtins.str:
        """
        When applicable, returns an informational message relevant to the current status and status type of the status summary object.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="statusType")
    def status_type(self) -> builtins.str:
        """
        Type of a status summary.
        """
        return pulumi.get(self, "status_type")


@pulumi.output_type
class QuicksetupConfigurationManagerTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ResourceDataSyncS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "syncFormat":
            suggest = "sync_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceDataSyncS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceDataSyncS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceDataSyncS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 region: builtins.str,
                 kms_key_arn: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None,
                 sync_format: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: Name of S3 bucket where the aggregated data is stored.
        :param builtins.str region: Region with the bucket targeted by the Resource Data Sync.
        :param builtins.str kms_key_arn: ARN of an encryption key for a destination in Amazon S3.
        :param builtins.str prefix: Prefix for the bucket.
        :param builtins.str sync_format: A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "region", region)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if sync_format is not None:
            pulumi.set(__self__, "sync_format", sync_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        Name of S3 bucket where the aggregated data is stored.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region with the bucket targeted by the Resource Data Sync.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        ARN of an encryption key for a destination in Amazon S3.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        Prefix for the bucket.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="syncFormat")
    def sync_format(self) -> Optional[builtins.str]:
        """
        A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
        """
        return pulumi.get(self, "sync_format")


@pulumi.output_type
class GetContactsRotationRecurrenceResult(dict):
    def __init__(__self__, *,
                 daily_settings: Sequence['outputs.GetContactsRotationRecurrenceDailySettingResult'],
                 monthly_settings: Sequence['outputs.GetContactsRotationRecurrenceMonthlySettingResult'],
                 number_of_on_calls: builtins.int,
                 recurrence_multiplier: builtins.int,
                 shift_coverages: Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageResult'],
                 weekly_settings: Sequence['outputs.GetContactsRotationRecurrenceWeeklySettingResult']):
        pulumi.set(__self__, "daily_settings", daily_settings)
        pulumi.set(__self__, "monthly_settings", monthly_settings)
        pulumi.set(__self__, "number_of_on_calls", number_of_on_calls)
        pulumi.set(__self__, "recurrence_multiplier", recurrence_multiplier)
        pulumi.set(__self__, "shift_coverages", shift_coverages)
        pulumi.set(__self__, "weekly_settings", weekly_settings)

    @property
    @pulumi.getter(name="dailySettings")
    def daily_settings(self) -> Sequence['outputs.GetContactsRotationRecurrenceDailySettingResult']:
        return pulumi.get(self, "daily_settings")

    @property
    @pulumi.getter(name="monthlySettings")
    def monthly_settings(self) -> Sequence['outputs.GetContactsRotationRecurrenceMonthlySettingResult']:
        return pulumi.get(self, "monthly_settings")

    @property
    @pulumi.getter(name="numberOfOnCalls")
    def number_of_on_calls(self) -> builtins.int:
        return pulumi.get(self, "number_of_on_calls")

    @property
    @pulumi.getter(name="recurrenceMultiplier")
    def recurrence_multiplier(self) -> builtins.int:
        return pulumi.get(self, "recurrence_multiplier")

    @property
    @pulumi.getter(name="shiftCoverages")
    def shift_coverages(self) -> Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageResult']:
        return pulumi.get(self, "shift_coverages")

    @property
    @pulumi.getter(name="weeklySettings")
    def weekly_settings(self) -> Sequence['outputs.GetContactsRotationRecurrenceWeeklySettingResult']:
        return pulumi.get(self, "weekly_settings")


@pulumi.output_type
class GetContactsRotationRecurrenceDailySettingResult(dict):
    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class GetContactsRotationRecurrenceMonthlySettingResult(dict):
    def __init__(__self__, *,
                 day_of_month: builtins.int,
                 hand_off_times: Sequence['outputs.GetContactsRotationRecurrenceMonthlySettingHandOffTimeResult']):
        pulumi.set(__self__, "day_of_month", day_of_month)
        pulumi.set(__self__, "hand_off_times", hand_off_times)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> builtins.int:
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="handOffTimes")
    def hand_off_times(self) -> Sequence['outputs.GetContactsRotationRecurrenceMonthlySettingHandOffTimeResult']:
        return pulumi.get(self, "hand_off_times")


@pulumi.output_type
class GetContactsRotationRecurrenceMonthlySettingHandOffTimeResult(dict):
    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class GetContactsRotationRecurrenceShiftCoverageResult(dict):
    def __init__(__self__, *,
                 coverage_times: Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageCoverageTimeResult'],
                 map_block_key: builtins.str):
        pulumi.set(__self__, "coverage_times", coverage_times)
        pulumi.set(__self__, "map_block_key", map_block_key)

    @property
    @pulumi.getter(name="coverageTimes")
    def coverage_times(self) -> Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageCoverageTimeResult']:
        return pulumi.get(self, "coverage_times")

    @property
    @pulumi.getter(name="mapBlockKey")
    def map_block_key(self) -> builtins.str:
        return pulumi.get(self, "map_block_key")


@pulumi.output_type
class GetContactsRotationRecurrenceShiftCoverageCoverageTimeResult(dict):
    def __init__(__self__, *,
                 ends: Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageCoverageTimeEndResult'],
                 starts: Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageCoverageTimeStartResult']):
        pulumi.set(__self__, "ends", ends)
        pulumi.set(__self__, "starts", starts)

    @property
    @pulumi.getter
    def ends(self) -> Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageCoverageTimeEndResult']:
        return pulumi.get(self, "ends")

    @property
    @pulumi.getter
    def starts(self) -> Sequence['outputs.GetContactsRotationRecurrenceShiftCoverageCoverageTimeStartResult']:
        return pulumi.get(self, "starts")


@pulumi.output_type
class GetContactsRotationRecurrenceShiftCoverageCoverageTimeEndResult(dict):
    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class GetContactsRotationRecurrenceShiftCoverageCoverageTimeStartResult(dict):
    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class GetContactsRotationRecurrenceWeeklySettingResult(dict):
    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 hand_off_times: Sequence['outputs.GetContactsRotationRecurrenceWeeklySettingHandOffTimeResult']):
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hand_off_times", hand_off_times)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="handOffTimes")
    def hand_off_times(self) -> Sequence['outputs.GetContactsRotationRecurrenceWeeklySettingHandOffTimeResult']:
        return pulumi.get(self, "hand_off_times")


@pulumi.output_type
class GetContactsRotationRecurrenceWeeklySettingHandOffTimeResult(dict):
    def __init__(__self__, *,
                 hour_of_day: builtins.int,
                 minute_of_hour: builtins.int):
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "minute_of_hour", minute_of_hour)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="minuteOfHour")
    def minute_of_hour(self) -> builtins.int:
        return pulumi.get(self, "minute_of_hour")


@pulumi.output_type
class GetInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the filter field. Valid values can be found in the [SSM InstanceInformationStringFilter API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_InstanceInformationStringFilter.html).
        :param Sequence[builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the filter field. Valid values can be found in the [SSM InstanceInformationStringFilter API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_InstanceInformationStringFilter.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetMaintenanceWindowsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the filter field. Valid values can be found in the [SSM DescribeMaintenanceWindows API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeMaintenanceWindows.html#API_DescribeMaintenanceWindows_RequestSyntax).
        :param Sequence[builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the filter field. Valid values can be found in the [SSM DescribeMaintenanceWindows API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeMaintenanceWindows.html#API_DescribeMaintenanceWindows_RequestSyntax).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPatchBaselineApprovalRuleResult(dict):
    def __init__(__self__, *,
                 approve_after_days: builtins.int,
                 approve_until_date: builtins.str,
                 compliance_level: builtins.str,
                 enable_non_security: builtins.bool,
                 patch_filters: Sequence['outputs.GetPatchBaselineApprovalRulePatchFilterResult']):
        """
        :param builtins.int approve_after_days: Number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
        :param builtins.str approve_until_date: Cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Date is formatted as `YYYY-MM-DD`. Conflicts with `approve_after_days`
        :param builtins.str compliance_level: Compliance level for patches approved by this rule.
        :param builtins.bool enable_non_security: Boolean enabling the application of non-security updates.
        :param Sequence['GetPatchBaselineApprovalRulePatchFilterArgs'] patch_filters: Patch filter group that defines the criteria for the rule.
        """
        pulumi.set(__self__, "approve_after_days", approve_after_days)
        pulumi.set(__self__, "approve_until_date", approve_until_date)
        pulumi.set(__self__, "compliance_level", compliance_level)
        pulumi.set(__self__, "enable_non_security", enable_non_security)
        pulumi.set(__self__, "patch_filters", patch_filters)

    @property
    @pulumi.getter(name="approveAfterDays")
    def approve_after_days(self) -> builtins.int:
        """
        Number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
        """
        return pulumi.get(self, "approve_after_days")

    @property
    @pulumi.getter(name="approveUntilDate")
    def approve_until_date(self) -> builtins.str:
        """
        Cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Date is formatted as `YYYY-MM-DD`. Conflicts with `approve_after_days`
        """
        return pulumi.get(self, "approve_until_date")

    @property
    @pulumi.getter(name="complianceLevel")
    def compliance_level(self) -> builtins.str:
        """
        Compliance level for patches approved by this rule.
        """
        return pulumi.get(self, "compliance_level")

    @property
    @pulumi.getter(name="enableNonSecurity")
    def enable_non_security(self) -> builtins.bool:
        """
        Boolean enabling the application of non-security updates.
        """
        return pulumi.get(self, "enable_non_security")

    @property
    @pulumi.getter(name="patchFilters")
    def patch_filters(self) -> Sequence['outputs.GetPatchBaselineApprovalRulePatchFilterResult']:
        """
        Patch filter group that defines the criteria for the rule.
        """
        return pulumi.get(self, "patch_filters")


@pulumi.output_type
class GetPatchBaselineApprovalRulePatchFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Key for the filter.
        :param Sequence[builtins.str] values: Value for the filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key for the filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Value for the filter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPatchBaselineGlobalFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Key for the filter.
        :param Sequence[builtins.str] values: Value for the filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key for the filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Value for the filter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPatchBaselineSourceResult(dict):
    def __init__(__self__, *,
                 configuration: builtins.str,
                 name: builtins.str,
                 products: Sequence[builtins.str]):
        """
        :param builtins.str configuration: Value of the yum repo configuration.
        :param builtins.str name: Name specified to identify the patch source.
        :param Sequence[builtins.str] products: Specific operating system versions a patch repository applies to.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def configuration(self) -> builtins.str:
        """
        Value of the yum repo configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name specified to identify the patch source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def products(self) -> Sequence[builtins.str]:
        """
        Specific operating system versions a patch repository applies to.
        """
        return pulumi.get(self, "products")


@pulumi.output_type
class GetPatchBaselinesBaselineIdentityResult(dict):
    def __init__(__self__, *,
                 baseline_description: builtins.str,
                 baseline_id: builtins.str,
                 baseline_name: builtins.str,
                 default_baseline: builtins.bool,
                 operating_system: builtins.str):
        """
        :param builtins.str baseline_description: Description of the patch baseline.
        :param builtins.str baseline_id: ID of the patch baseline.
        :param builtins.str baseline_name: Name of the patch baseline.
        :param builtins.bool default_baseline: Indicates whether this is the default baseline. AWS Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
        :param builtins.str operating_system: Operating system the patch baseline applies to.
        """
        pulumi.set(__self__, "baseline_description", baseline_description)
        pulumi.set(__self__, "baseline_id", baseline_id)
        pulumi.set(__self__, "baseline_name", baseline_name)
        pulumi.set(__self__, "default_baseline", default_baseline)
        pulumi.set(__self__, "operating_system", operating_system)

    @property
    @pulumi.getter(name="baselineDescription")
    def baseline_description(self) -> builtins.str:
        """
        Description of the patch baseline.
        """
        return pulumi.get(self, "baseline_description")

    @property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> builtins.str:
        """
        ID of the patch baseline.
        """
        return pulumi.get(self, "baseline_id")

    @property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> builtins.str:
        """
        Name of the patch baseline.
        """
        return pulumi.get(self, "baseline_name")

    @property
    @pulumi.getter(name="defaultBaseline")
    def default_baseline(self) -> builtins.bool:
        """
        Indicates whether this is the default baseline. AWS Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
        """
        return pulumi.get(self, "default_baseline")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> builtins.str:
        """
        Operating system the patch baseline applies to.
        """
        return pulumi.get(self, "operating_system")


@pulumi.output_type
class GetPatchBaselinesFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Filter key. See the [AWS SSM documentation](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchBaselines.html) for valid values.
        :param Sequence[builtins.str] values: Filter values. See the [AWS SSM documentation](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchBaselines.html) for example values.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Filter key. See the [AWS SSM documentation](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchBaselines.html) for valid values.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Filter values. See the [AWS SSM documentation](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchBaselines.html) for example values.
        """
        return pulumi.get(self, "values")


