# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QuicksetupConfigurationManagerArgs', 'QuicksetupConfigurationManager']

@pulumi.input_type
class QuicksetupConfigurationManagerArgs:
    def __init__(__self__, *,
                 configuration_definition: Optional[pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['QuicksetupConfigurationManagerTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a QuicksetupConfigurationManager resource.
        :param pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs'] configuration_definition: Definition of the Quick Setup configuration that the configuration manager deploys. See `configuration_definition` below.
        :param pulumi.Input[builtins.str] description: Description of the configuration manager.
        :param pulumi.Input[builtins.str] name: Configuration manager name.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if configuration_definition is not None:
            pulumi.set(__self__, "configuration_definition", configuration_definition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="configurationDefinition")
    def configuration_definition(self) -> Optional[pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs']]:
        """
        Definition of the Quick Setup configuration that the configuration manager deploys. See `configuration_definition` below.
        """
        return pulumi.get(self, "configuration_definition")

    @configuration_definition.setter
    def configuration_definition(self, value: Optional[pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs']]):
        pulumi.set(self, "configuration_definition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the configuration manager.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configuration manager name.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['QuicksetupConfigurationManagerTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['QuicksetupConfigurationManagerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _QuicksetupConfigurationManagerState:
    def __init__(__self__, *,
                 configuration_definition: Optional[pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 manager_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['QuicksetupConfigurationManagerStatusSummaryArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['QuicksetupConfigurationManagerTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering QuicksetupConfigurationManager resources.
        :param pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs'] configuration_definition: Definition of the Quick Setup configuration that the configuration manager deploys. See `configuration_definition` below.
        :param pulumi.Input[builtins.str] description: Description of the configuration manager.
        :param pulumi.Input[builtins.str] manager_arn: ARN of the Configuration Manager.
        :param pulumi.Input[builtins.str] name: Configuration manager name.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['QuicksetupConfigurationManagerStatusSummaryArgs']]] status_summaries: A summary of the state of the configuration manager. This includes deployment statuses, association statuses, drift statuses, health checks, and more. See `status_summaries` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if configuration_definition is not None:
            pulumi.set(__self__, "configuration_definition", configuration_definition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if manager_arn is not None:
            pulumi.set(__self__, "manager_arn", manager_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status_summaries is not None:
            pulumi.set(__self__, "status_summaries", status_summaries)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="configurationDefinition")
    def configuration_definition(self) -> Optional[pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs']]:
        """
        Definition of the Quick Setup configuration that the configuration manager deploys. See `configuration_definition` below.
        """
        return pulumi.get(self, "configuration_definition")

    @configuration_definition.setter
    def configuration_definition(self, value: Optional[pulumi.Input['QuicksetupConfigurationManagerConfigurationDefinitionArgs']]):
        pulumi.set(self, "configuration_definition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the configuration manager.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="managerArn")
    def manager_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Configuration Manager.
        """
        return pulumi.get(self, "manager_arn")

    @manager_arn.setter
    def manager_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manager_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configuration manager name.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="statusSummaries")
    def status_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuicksetupConfigurationManagerStatusSummaryArgs']]]]:
        """
        A summary of the state of the configuration manager. This includes deployment statuses, association statuses, drift statuses, health checks, and more. See `status_summaries` below.
        """
        return pulumi.get(self, "status_summaries")

    @status_summaries.setter
    def status_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuicksetupConfigurationManagerStatusSummaryArgs']]]]):
        pulumi.set(self, "status_summaries", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['QuicksetupConfigurationManagerTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['QuicksetupConfigurationManagerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:ssm/quicksetupConfigurationManager:QuicksetupConfigurationManager")
class QuicksetupConfigurationManager(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_definition: Optional[pulumi.Input[Union['QuicksetupConfigurationManagerConfigurationDefinitionArgs', 'QuicksetupConfigurationManagerConfigurationDefinitionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['QuicksetupConfigurationManagerTimeoutsArgs', 'QuicksetupConfigurationManagerTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS SSM Quick Setup Configuration Manager.

        ## Example Usage

        ### Patch Policy Configuration Type

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        current_get_region = aws.get_region()
        example = aws.ssm.get_patch_baselines(default_baselines=True)
        # transform the output of the aws_ssm_patch_baselines data source
        # into the format expected by the SelectedPatchBaselines parameter
        selected_patch_baselines = json.dumps({baseline.operating_system: {
            "value": baseline.baseline_id,
            "label": baseline.baseline_name,
            "description": baseline.baseline_description,
            "disabled": not baseline.default_baseline,
        } for baseline in example.baseline_identities})
        example_quicksetup_configuration_manager = aws.ssm.QuicksetupConfigurationManager("example",
            name="example",
            configuration_definition={
                "local_deployment_administration_role_arn": f"arn:{current_get_partition.partition}:iam::{current.account_id}:role/AWS-QuickSetup-PatchPolicy-LocalAdministrationRole",
                "local_deployment_execution_role_name": "AWS-QuickSetup-PatchPolicy-LocalExecutionRole",
                "type": "AWSQuickSetupType-PatchPolicy",
                "parameters": {
                    "ConfigurationOptionsPatchOperation": "Scan",
                    "ConfigurationOptionsScanValue": "cron(0 1 * * ? *)",
                    "ConfigurationOptionsScanNextInterval": "false",
                    "PatchBaselineRegion": current_get_region.region,
                    "PatchBaselineUseDefault": "default",
                    "PatchPolicyName": "example",
                    "SelectedPatchBaselines": selected_patch_baselines,
                    "OutputLogEnableS3": "false",
                    "RateControlConcurrency": "10%",
                    "RateControlErrorThreshold": "2%",
                    "IsPolicyAttachAllowed": "false",
                    "TargetAccounts": current.account_id,
                    "TargetRegions": current_get_region.region,
                    "TargetType": "*",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import SSM Quick Setup Configuration Manager using the `manager_arn`. For example:

        ```sh
        $ pulumi import aws:ssm/quicksetupConfigurationManager:QuicksetupConfigurationManager example arn:aws:ssm-quicksetup:us-east-1:012345678901:configuration-manager/abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['QuicksetupConfigurationManagerConfigurationDefinitionArgs', 'QuicksetupConfigurationManagerConfigurationDefinitionArgsDict']] configuration_definition: Definition of the Quick Setup configuration that the configuration manager deploys. See `configuration_definition` below.
        :param pulumi.Input[builtins.str] description: Description of the configuration manager.
        :param pulumi.Input[builtins.str] name: Configuration manager name.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[QuicksetupConfigurationManagerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS SSM Quick Setup Configuration Manager.

        ## Example Usage

        ### Patch Policy Configuration Type

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        current_get_region = aws.get_region()
        example = aws.ssm.get_patch_baselines(default_baselines=True)
        # transform the output of the aws_ssm_patch_baselines data source
        # into the format expected by the SelectedPatchBaselines parameter
        selected_patch_baselines = json.dumps({baseline.operating_system: {
            "value": baseline.baseline_id,
            "label": baseline.baseline_name,
            "description": baseline.baseline_description,
            "disabled": not baseline.default_baseline,
        } for baseline in example.baseline_identities})
        example_quicksetup_configuration_manager = aws.ssm.QuicksetupConfigurationManager("example",
            name="example",
            configuration_definition={
                "local_deployment_administration_role_arn": f"arn:{current_get_partition.partition}:iam::{current.account_id}:role/AWS-QuickSetup-PatchPolicy-LocalAdministrationRole",
                "local_deployment_execution_role_name": "AWS-QuickSetup-PatchPolicy-LocalExecutionRole",
                "type": "AWSQuickSetupType-PatchPolicy",
                "parameters": {
                    "ConfigurationOptionsPatchOperation": "Scan",
                    "ConfigurationOptionsScanValue": "cron(0 1 * * ? *)",
                    "ConfigurationOptionsScanNextInterval": "false",
                    "PatchBaselineRegion": current_get_region.region,
                    "PatchBaselineUseDefault": "default",
                    "PatchPolicyName": "example",
                    "SelectedPatchBaselines": selected_patch_baselines,
                    "OutputLogEnableS3": "false",
                    "RateControlConcurrency": "10%",
                    "RateControlErrorThreshold": "2%",
                    "IsPolicyAttachAllowed": "false",
                    "TargetAccounts": current.account_id,
                    "TargetRegions": current_get_region.region,
                    "TargetType": "*",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import SSM Quick Setup Configuration Manager using the `manager_arn`. For example:

        ```sh
        $ pulumi import aws:ssm/quicksetupConfigurationManager:QuicksetupConfigurationManager example arn:aws:ssm-quicksetup:us-east-1:012345678901:configuration-manager/abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param QuicksetupConfigurationManagerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuicksetupConfigurationManagerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_definition: Optional[pulumi.Input[Union['QuicksetupConfigurationManagerConfigurationDefinitionArgs', 'QuicksetupConfigurationManagerConfigurationDefinitionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['QuicksetupConfigurationManagerTimeoutsArgs', 'QuicksetupConfigurationManagerTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuicksetupConfigurationManagerArgs.__new__(QuicksetupConfigurationManagerArgs)

            __props__.__dict__["configuration_definition"] = configuration_definition
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["manager_arn"] = None
            __props__.__dict__["status_summaries"] = None
            __props__.__dict__["tags_all"] = None
        super(QuicksetupConfigurationManager, __self__).__init__(
            'aws:ssm/quicksetupConfigurationManager:QuicksetupConfigurationManager',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_definition: Optional[pulumi.Input[Union['QuicksetupConfigurationManagerConfigurationDefinitionArgs', 'QuicksetupConfigurationManagerConfigurationDefinitionArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            manager_arn: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            status_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuicksetupConfigurationManagerStatusSummaryArgs', 'QuicksetupConfigurationManagerStatusSummaryArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['QuicksetupConfigurationManagerTimeoutsArgs', 'QuicksetupConfigurationManagerTimeoutsArgsDict']]] = None) -> 'QuicksetupConfigurationManager':
        """
        Get an existing QuicksetupConfigurationManager resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['QuicksetupConfigurationManagerConfigurationDefinitionArgs', 'QuicksetupConfigurationManagerConfigurationDefinitionArgsDict']] configuration_definition: Definition of the Quick Setup configuration that the configuration manager deploys. See `configuration_definition` below.
        :param pulumi.Input[builtins.str] description: Description of the configuration manager.
        :param pulumi.Input[builtins.str] manager_arn: ARN of the Configuration Manager.
        :param pulumi.Input[builtins.str] name: Configuration manager name.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QuicksetupConfigurationManagerStatusSummaryArgs', 'QuicksetupConfigurationManagerStatusSummaryArgsDict']]]] status_summaries: A summary of the state of the configuration manager. This includes deployment statuses, association statuses, drift statuses, health checks, and more. See `status_summaries` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuicksetupConfigurationManagerState.__new__(_QuicksetupConfigurationManagerState)

        __props__.__dict__["configuration_definition"] = configuration_definition
        __props__.__dict__["description"] = description
        __props__.__dict__["manager_arn"] = manager_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status_summaries"] = status_summaries
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return QuicksetupConfigurationManager(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationDefinition")
    def configuration_definition(self) -> pulumi.Output[Optional['outputs.QuicksetupConfigurationManagerConfigurationDefinition']]:
        """
        Definition of the Quick Setup configuration that the configuration manager deploys. See `configuration_definition` below.
        """
        return pulumi.get(self, "configuration_definition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the configuration manager.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="managerArn")
    def manager_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Configuration Manager.
        """
        return pulumi.get(self, "manager_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Configuration manager name.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="statusSummaries")
    def status_summaries(self) -> pulumi.Output[Sequence['outputs.QuicksetupConfigurationManagerStatusSummary']]:
        """
        A summary of the state of the configuration manager. This includes deployment statuses, association statuses, drift statuses, health checks, and more. See `status_summaries` below.
        """
        return pulumi.get(self, "status_summaries")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.QuicksetupConfigurationManagerTimeouts']]:
        return pulumi.get(self, "timeouts")

