# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ReplicationSetRegionArgs',
    'ReplicationSetRegionArgsDict',
    'ResponsePlanActionArgs',
    'ResponsePlanActionArgsDict',
    'ResponsePlanActionSsmAutomationArgs',
    'ResponsePlanActionSsmAutomationArgsDict',
    'ResponsePlanActionSsmAutomationParameterArgs',
    'ResponsePlanActionSsmAutomationParameterArgsDict',
    'ResponsePlanIncidentTemplateArgs',
    'ResponsePlanIncidentTemplateArgsDict',
    'ResponsePlanIncidentTemplateNotificationTargetArgs',
    'ResponsePlanIncidentTemplateNotificationTargetArgsDict',
    'ResponsePlanIntegrationArgs',
    'ResponsePlanIntegrationArgsDict',
    'ResponsePlanIntegrationPagerdutyArgs',
    'ResponsePlanIntegrationPagerdutyArgsDict',
]

MYPY = False

if not MYPY:
    class ReplicationSetRegionArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the Region, such as `ap-southeast-2`.
        """
        kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        The current status of the Region.
        * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        """
        status_message: NotRequired[pulumi.Input[builtins.str]]
        """
        More information about the status of a Region.
        """
elif False:
    ReplicationSetRegionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationSetRegionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_message: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the Region, such as `ap-southeast-2`.
        :param pulumi.Input[builtins.str] kms_key_arn: The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
        :param pulumi.Input[builtins.str] status: The current status of the Region.
               * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        :param pulumi.Input[builtins.str] status_message: More information about the status of a Region.
        """
        pulumi.set(__self__, "name", name)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Region, such as `ap-southeast-2`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the Region.
        * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        More information about the status of a Region.
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_message", value)


if not MYPY:
    class ResponsePlanActionArgsDict(TypedDict):
        ssm_automations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationArgsDict']]]]
        """
        The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
        """
elif False:
    ResponsePlanActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponsePlanActionArgs:
    def __init__(__self__, *,
                 ssm_automations: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationArgs']]] ssm_automations: The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
        """
        if ssm_automations is not None:
            pulumi.set(__self__, "ssm_automations", ssm_automations)

    @property
    @pulumi.getter(name="ssmAutomations")
    def ssm_automations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationArgs']]]]:
        """
        The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
        """
        return pulumi.get(self, "ssm_automations")

    @ssm_automations.setter
    def ssm_automations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationArgs']]]]):
        pulumi.set(self, "ssm_automations", value)


if not MYPY:
    class ResponsePlanActionSsmAutomationArgsDict(TypedDict):
        document_name: pulumi.Input[builtins.str]
        """
        The automation document's name.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
        """
        document_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of the automation document to use at runtime.
        """
        dynamic_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
        """
        parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationParameterArgsDict']]]]
        """
        The key-value pair parameters to use when the automation document runs. The following values are supported:
        """
        target_account: NotRequired[pulumi.Input[builtins.str]]
        """
        The account that the automation document runs in. This can be in either the management account or an application account.
        """
elif False:
    ResponsePlanActionSsmAutomationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponsePlanActionSsmAutomationArgs:
    def __init__(__self__, *,
                 document_name: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 document_version: Optional[pulumi.Input[builtins.str]] = None,
                 dynamic_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationParameterArgs']]]] = None,
                 target_account: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] document_name: The automation document's name.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
        :param pulumi.Input[builtins.str] document_version: The version of the automation document to use at runtime.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dynamic_parameters: The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
        :param pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationParameterArgs']]] parameters: The key-value pair parameters to use when the automation document runs. The following values are supported:
        :param pulumi.Input[builtins.str] target_account: The account that the automation document runs in. This can be in either the management account or an application account.
        """
        pulumi.set(__self__, "document_name", document_name)
        pulumi.set(__self__, "role_arn", role_arn)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if dynamic_parameters is not None:
            pulumi.set(__self__, "dynamic_parameters", dynamic_parameters)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if target_account is not None:
            pulumi.set(__self__, "target_account", target_account)

    @property
    @pulumi.getter(name="documentName")
    def document_name(self) -> pulumi.Input[builtins.str]:
        """
        The automation document's name.
        """
        return pulumi.get(self, "document_name")

    @document_name.setter
    def document_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "document_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the automation document to use at runtime.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_version", value)

    @property
    @pulumi.getter(name="dynamicParameters")
    def dynamic_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
        """
        return pulumi.get(self, "dynamic_parameters")

    @dynamic_parameters.setter
    def dynamic_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dynamic_parameters", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationParameterArgs']]]]:
        """
        The key-value pair parameters to use when the automation document runs. The following values are supported:
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanActionSsmAutomationParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="targetAccount")
    def target_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The account that the automation document runs in. This can be in either the management account or an application account.
        """
        return pulumi.get(self, "target_account")

    @target_account.setter
    def target_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_account", value)


if not MYPY:
    class ResponsePlanActionSsmAutomationParameterArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of parameter.
        """
        values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The values for the associated parameter name.
        """
elif False:
    ResponsePlanActionSsmAutomationParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponsePlanActionSsmAutomationParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[builtins.str] name: The name of parameter.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The values for the associated parameter name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The values for the associated parameter name.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ResponsePlanIncidentTemplateArgsDict(TypedDict):
        impact: pulumi.Input[builtins.int]
        """
        The impact value of a generated incident. The following values are supported:
        """
        title: pulumi.Input[builtins.str]
        """
        The title of a generated incident.
        """
        dedupe_string: NotRequired[pulumi.Input[builtins.str]]
        """
        A string used to stop Incident Manager from creating multiple incident records for the same incident.
        """
        incident_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
        """
        notification_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIncidentTemplateNotificationTargetArgsDict']]]]
        """
        The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
        """
        summary: NotRequired[pulumi.Input[builtins.str]]
        """
        The summary of an incident.
        """
elif False:
    ResponsePlanIncidentTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponsePlanIncidentTemplateArgs:
    def __init__(__self__, *,
                 impact: pulumi.Input[builtins.int],
                 title: pulumi.Input[builtins.str],
                 dedupe_string: Optional[pulumi.Input[builtins.str]] = None,
                 incident_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_targets: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIncidentTemplateNotificationTargetArgs']]]] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] impact: The impact value of a generated incident. The following values are supported:
        :param pulumi.Input[builtins.str] title: The title of a generated incident.
        :param pulumi.Input[builtins.str] dedupe_string: A string used to stop Incident Manager from creating multiple incident records for the same incident.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] incident_tags: The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
        :param pulumi.Input[Sequence[pulumi.Input['ResponsePlanIncidentTemplateNotificationTargetArgs']]] notification_targets: The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
        :param pulumi.Input[builtins.str] summary: The summary of an incident.
        """
        pulumi.set(__self__, "impact", impact)
        pulumi.set(__self__, "title", title)
        if dedupe_string is not None:
            pulumi.set(__self__, "dedupe_string", dedupe_string)
        if incident_tags is not None:
            pulumi.set(__self__, "incident_tags", incident_tags)
        if notification_targets is not None:
            pulumi.set(__self__, "notification_targets", notification_targets)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter
    def impact(self) -> pulumi.Input[builtins.int]:
        """
        The impact value of a generated incident. The following values are supported:
        """
        return pulumi.get(self, "impact")

    @impact.setter
    def impact(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "impact", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        The title of a generated incident.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="dedupeString")
    def dedupe_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string used to stop Incident Manager from creating multiple incident records for the same incident.
        """
        return pulumi.get(self, "dedupe_string")

    @dedupe_string.setter
    def dedupe_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dedupe_string", value)

    @property
    @pulumi.getter(name="incidentTags")
    def incident_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
        """
        return pulumi.get(self, "incident_tags")

    @incident_tags.setter
    def incident_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "incident_tags", value)

    @property
    @pulumi.getter(name="notificationTargets")
    def notification_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIncidentTemplateNotificationTargetArgs']]]]:
        """
        The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
        """
        return pulumi.get(self, "notification_targets")

    @notification_targets.setter
    def notification_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIncidentTemplateNotificationTargetArgs']]]]):
        pulumi.set(self, "notification_targets", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The summary of an incident.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "summary", value)


if not MYPY:
    class ResponsePlanIncidentTemplateNotificationTargetArgsDict(TypedDict):
        sns_topic_arn: pulumi.Input[builtins.str]
        """
        The ARN of the Amazon SNS topic.
        """
elif False:
    ResponsePlanIncidentTemplateNotificationTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponsePlanIncidentTemplateNotificationTargetArgs:
    def __init__(__self__, *,
                 sns_topic_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] sns_topic_arn: The ARN of the Amazon SNS topic.
        """
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the Amazon SNS topic.
        """
        return pulumi.get(self, "sns_topic_arn")

    @sns_topic_arn.setter
    def sns_topic_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sns_topic_arn", value)


if not MYPY:
    class ResponsePlanIntegrationArgsDict(TypedDict):
        pagerduties: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIntegrationPagerdutyArgsDict']]]]
        """
        Details about the PagerDuty configuration for a response plan. The following values are supported:
        """
elif False:
    ResponsePlanIntegrationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponsePlanIntegrationArgs:
    def __init__(__self__, *,
                 pagerduties: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIntegrationPagerdutyArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ResponsePlanIntegrationPagerdutyArgs']]] pagerduties: Details about the PagerDuty configuration for a response plan. The following values are supported:
        """
        if pagerduties is not None:
            pulumi.set(__self__, "pagerduties", pagerduties)

    @property
    @pulumi.getter
    def pagerduties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIntegrationPagerdutyArgs']]]]:
        """
        Details about the PagerDuty configuration for a response plan. The following values are supported:
        """
        return pulumi.get(self, "pagerduties")

    @pagerduties.setter
    def pagerduties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePlanIntegrationPagerdutyArgs']]]]):
        pulumi.set(self, "pagerduties", value)


if not MYPY:
    class ResponsePlanIntegrationPagerdutyArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the PagerDuty configuration.
        """
        secret_id: pulumi.Input[builtins.str]
        """
        The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.

        For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
        """
        service_id: pulumi.Input[builtins.str]
        """
        The ID of the PagerDuty service that the response plan associated with the incident at launch.
        """
elif False:
    ResponsePlanIntegrationPagerdutyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResponsePlanIntegrationPagerdutyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 secret_id: pulumi.Input[builtins.str],
                 service_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: The name of the PagerDuty configuration.
        :param pulumi.Input[builtins.str] secret_id: The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
               
               For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
        :param pulumi.Input[builtins.str] service_id: The ID of the PagerDuty service that the response plan associated with the incident at launch.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the PagerDuty configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.

        For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the PagerDuty service that the response plan associated with the incident at launch.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_id", value)


