# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ReplicationSetRegion',
    'ResponsePlanAction',
    'ResponsePlanActionSsmAutomation',
    'ResponsePlanActionSsmAutomationParameter',
    'ResponsePlanIncidentTemplate',
    'ResponsePlanIncidentTemplateNotificationTarget',
    'ResponsePlanIntegration',
    'ResponsePlanIntegrationPagerduty',
    'GetReplicationSetRegionResult',
    'GetResponsePlanActionResult',
    'GetResponsePlanActionSsmAutomationResult',
    'GetResponsePlanActionSsmAutomationParameterResult',
    'GetResponsePlanIncidentTemplateResult',
    'GetResponsePlanIncidentTemplateNotificationTargetResult',
    'GetResponsePlanIntegrationResult',
    'GetResponsePlanIntegrationPagerdutyResult',
]

@pulumi.output_type
class ReplicationSetRegion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationSetRegion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationSetRegion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationSetRegion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 kms_key_arn: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 status_message: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the Region, such as `ap-southeast-2`.
        :param builtins.str kms_key_arn: The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
        :param builtins.str status: The current status of the Region.
               * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        :param builtins.str status_message: More information about the status of a Region.
        """
        pulumi.set(__self__, "name", name)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Region, such as `ap-southeast-2`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The current status of the Region.
        * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[builtins.str]:
        """
        More information about the status of a Region.
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class ResponsePlanAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ssmAutomations":
            suggest = "ssm_automations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePlanAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePlanAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePlanAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssm_automations: Optional[Sequence['outputs.ResponsePlanActionSsmAutomation']] = None):
        """
        :param Sequence['ResponsePlanActionSsmAutomationArgs'] ssm_automations: The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
        """
        if ssm_automations is not None:
            pulumi.set(__self__, "ssm_automations", ssm_automations)

    @property
    @pulumi.getter(name="ssmAutomations")
    def ssm_automations(self) -> Optional[Sequence['outputs.ResponsePlanActionSsmAutomation']]:
        """
        The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
        """
        return pulumi.get(self, "ssm_automations")


@pulumi.output_type
class ResponsePlanActionSsmAutomation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentName":
            suggest = "document_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "documentVersion":
            suggest = "document_version"
        elif key == "dynamicParameters":
            suggest = "dynamic_parameters"
        elif key == "targetAccount":
            suggest = "target_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePlanActionSsmAutomation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePlanActionSsmAutomation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePlanActionSsmAutomation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 document_name: builtins.str,
                 role_arn: builtins.str,
                 document_version: Optional[builtins.str] = None,
                 dynamic_parameters: Optional[Mapping[str, builtins.str]] = None,
                 parameters: Optional[Sequence['outputs.ResponsePlanActionSsmAutomationParameter']] = None,
                 target_account: Optional[builtins.str] = None):
        """
        :param builtins.str document_name: The automation document's name.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
        :param builtins.str document_version: The version of the automation document to use at runtime.
        :param Mapping[str, builtins.str] dynamic_parameters: The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
        :param Sequence['ResponsePlanActionSsmAutomationParameterArgs'] parameters: The key-value pair parameters to use when the automation document runs. The following values are supported:
        :param builtins.str target_account: The account that the automation document runs in. This can be in either the management account or an application account.
        """
        pulumi.set(__self__, "document_name", document_name)
        pulumi.set(__self__, "role_arn", role_arn)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if dynamic_parameters is not None:
            pulumi.set(__self__, "dynamic_parameters", dynamic_parameters)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if target_account is not None:
            pulumi.set(__self__, "target_account", target_account)

    @property
    @pulumi.getter(name="documentName")
    def document_name(self) -> builtins.str:
        """
        The automation document's name.
        """
        return pulumi.get(self, "document_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[builtins.str]:
        """
        The version of the automation document to use at runtime.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter(name="dynamicParameters")
    def dynamic_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
        """
        return pulumi.get(self, "dynamic_parameters")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ResponsePlanActionSsmAutomationParameter']]:
        """
        The key-value pair parameters to use when the automation document runs. The following values are supported:
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="targetAccount")
    def target_account(self) -> Optional[builtins.str]:
        """
        The account that the automation document runs in. This can be in either the management account or an application account.
        """
        return pulumi.get(self, "target_account")


@pulumi.output_type
class ResponsePlanActionSsmAutomationParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of parameter.
        :param Sequence[builtins.str] values: The values for the associated parameter name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The values for the associated parameter name.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ResponsePlanIncidentTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dedupeString":
            suggest = "dedupe_string"
        elif key == "incidentTags":
            suggest = "incident_tags"
        elif key == "notificationTargets":
            suggest = "notification_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePlanIncidentTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePlanIncidentTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePlanIncidentTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 impact: builtins.int,
                 title: builtins.str,
                 dedupe_string: Optional[builtins.str] = None,
                 incident_tags: Optional[Mapping[str, builtins.str]] = None,
                 notification_targets: Optional[Sequence['outputs.ResponsePlanIncidentTemplateNotificationTarget']] = None,
                 summary: Optional[builtins.str] = None):
        """
        :param builtins.int impact: The impact value of a generated incident. The following values are supported:
        :param builtins.str title: The title of a generated incident.
        :param builtins.str dedupe_string: A string used to stop Incident Manager from creating multiple incident records for the same incident.
        :param Mapping[str, builtins.str] incident_tags: The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
        :param Sequence['ResponsePlanIncidentTemplateNotificationTargetArgs'] notification_targets: The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
        :param builtins.str summary: The summary of an incident.
        """
        pulumi.set(__self__, "impact", impact)
        pulumi.set(__self__, "title", title)
        if dedupe_string is not None:
            pulumi.set(__self__, "dedupe_string", dedupe_string)
        if incident_tags is not None:
            pulumi.set(__self__, "incident_tags", incident_tags)
        if notification_targets is not None:
            pulumi.set(__self__, "notification_targets", notification_targets)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter
    def impact(self) -> builtins.int:
        """
        The impact value of a generated incident. The following values are supported:
        """
        return pulumi.get(self, "impact")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        The title of a generated incident.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="dedupeString")
    def dedupe_string(self) -> Optional[builtins.str]:
        """
        A string used to stop Incident Manager from creating multiple incident records for the same incident.
        """
        return pulumi.get(self, "dedupe_string")

    @property
    @pulumi.getter(name="incidentTags")
    def incident_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
        """
        return pulumi.get(self, "incident_tags")

    @property
    @pulumi.getter(name="notificationTargets")
    def notification_targets(self) -> Optional[Sequence['outputs.ResponsePlanIncidentTemplateNotificationTarget']]:
        """
        The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
        """
        return pulumi.get(self, "notification_targets")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        The summary of an incident.
        """
        return pulumi.get(self, "summary")


@pulumi.output_type
class ResponsePlanIncidentTemplateNotificationTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snsTopicArn":
            suggest = "sns_topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePlanIncidentTemplateNotificationTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePlanIncidentTemplateNotificationTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePlanIncidentTemplateNotificationTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sns_topic_arn: builtins.str):
        """
        :param builtins.str sns_topic_arn: The ARN of the Amazon SNS topic.
        """
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> builtins.str:
        """
        The ARN of the Amazon SNS topic.
        """
        return pulumi.get(self, "sns_topic_arn")


@pulumi.output_type
class ResponsePlanIntegration(dict):
    def __init__(__self__, *,
                 pagerduties: Optional[Sequence['outputs.ResponsePlanIntegrationPagerduty']] = None):
        """
        :param Sequence['ResponsePlanIntegrationPagerdutyArgs'] pagerduties: Details about the PagerDuty configuration for a response plan. The following values are supported:
        """
        if pagerduties is not None:
            pulumi.set(__self__, "pagerduties", pagerduties)

    @property
    @pulumi.getter
    def pagerduties(self) -> Optional[Sequence['outputs.ResponsePlanIntegrationPagerduty']]:
        """
        Details about the PagerDuty configuration for a response plan. The following values are supported:
        """
        return pulumi.get(self, "pagerduties")


@pulumi.output_type
class ResponsePlanIntegrationPagerduty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"
        elif key == "serviceId":
            suggest = "service_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePlanIntegrationPagerduty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePlanIntegrationPagerduty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePlanIntegrationPagerduty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 secret_id: builtins.str,
                 service_id: builtins.str):
        """
        :param builtins.str name: The name of the PagerDuty configuration.
        :param builtins.str secret_id: The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
               
               For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
        :param builtins.str service_id: The ID of the PagerDuty service that the response plan associated with the incident at launch.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the PagerDuty configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> builtins.str:
        """
        The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.

        For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> builtins.str:
        """
        The ID of the PagerDuty service that the response plan associated with the incident at launch.
        """
        return pulumi.get(self, "service_id")


@pulumi.output_type
class GetReplicationSetRegionResult(dict):
    def __init__(__self__, *,
                 kms_key_arn: builtins.str,
                 name: builtins.str,
                 status: builtins.str,
                 status_message: builtins.str):
        """
        :param builtins.str kms_key_arn: The ARN of the AWS Key Management Service (AWS KMS) encryption key.
        :param builtins.str name: The name of the Region.
        :param builtins.str status: The current status of the Region.
               * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        :param builtins.str status_message: More information about the status of a Region.
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> builtins.str:
        """
        The ARN of the AWS Key Management Service (AWS KMS) encryption key.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The current status of the Region.
        * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> builtins.str:
        """
        More information about the status of a Region.
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class GetResponsePlanActionResult(dict):
    def __init__(__self__, *,
                 ssm_automations: Sequence['outputs.GetResponsePlanActionSsmAutomationResult']):
        """
        :param Sequence['GetResponsePlanActionSsmAutomationArgs'] ssm_automations: The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
        """
        pulumi.set(__self__, "ssm_automations", ssm_automations)

    @property
    @pulumi.getter(name="ssmAutomations")
    def ssm_automations(self) -> Sequence['outputs.GetResponsePlanActionSsmAutomationResult']:
        """
        The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
        """
        return pulumi.get(self, "ssm_automations")


@pulumi.output_type
class GetResponsePlanActionSsmAutomationResult(dict):
    def __init__(__self__, *,
                 document_name: builtins.str,
                 document_version: builtins.str,
                 dynamic_parameters: Mapping[str, builtins.str],
                 parameters: Sequence['outputs.GetResponsePlanActionSsmAutomationParameterResult'],
                 role_arn: builtins.str,
                 target_account: builtins.str):
        """
        :param builtins.str document_name: The automation document's name.
        :param builtins.str document_version: The version of the automation document to use at runtime.
        :param Mapping[str, builtins.str] dynamic_parameters: The key-value pair used to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
        :param Sequence['GetResponsePlanActionSsmAutomationParameterArgs'] parameters: The key-value pair parameters used when the automation document runs. The following values are supported:
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
        :param builtins.str target_account: The account that runs the automation document. This can be in either the management account or an application account.
        """
        pulumi.set(__self__, "document_name", document_name)
        pulumi.set(__self__, "document_version", document_version)
        pulumi.set(__self__, "dynamic_parameters", dynamic_parameters)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "target_account", target_account)

    @property
    @pulumi.getter(name="documentName")
    def document_name(self) -> builtins.str:
        """
        The automation document's name.
        """
        return pulumi.get(self, "document_name")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> builtins.str:
        """
        The version of the automation document to use at runtime.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter(name="dynamicParameters")
    def dynamic_parameters(self) -> Mapping[str, builtins.str]:
        """
        The key-value pair used to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
        """
        return pulumi.get(self, "dynamic_parameters")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetResponsePlanActionSsmAutomationParameterResult']:
        """
        The key-value pair parameters used when the automation document runs. The following values are supported:
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="targetAccount")
    def target_account(self) -> builtins.str:
        """
        The account that runs the automation document. This can be in either the management account or an application account.
        """
        return pulumi.get(self, "target_account")


@pulumi.output_type
class GetResponsePlanActionSsmAutomationParameterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the PagerDuty configuration.
        :param Sequence[builtins.str] values: The values for the associated parameter name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the PagerDuty configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        The values for the associated parameter name.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetResponsePlanIncidentTemplateResult(dict):
    def __init__(__self__, *,
                 dedupe_string: builtins.str,
                 impact: builtins.int,
                 incident_tags: Mapping[str, builtins.str],
                 notification_targets: Sequence['outputs.GetResponsePlanIncidentTemplateNotificationTargetResult'],
                 summary: builtins.str,
                 title: builtins.str):
        """
        :param builtins.str dedupe_string: A string used to stop Incident Manager from creating multiple incident records for the same incident.
        :param builtins.int impact: The impact value of a generated incident. The following values are supported:
        :param Mapping[str, builtins.str] incident_tags: The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
        :param Sequence['GetResponsePlanIncidentTemplateNotificationTargetArgs'] notification_targets: The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
        :param builtins.str summary: The summary of an incident.
        :param builtins.str title: The title of a generated incident.
        """
        pulumi.set(__self__, "dedupe_string", dedupe_string)
        pulumi.set(__self__, "impact", impact)
        pulumi.set(__self__, "incident_tags", incident_tags)
        pulumi.set(__self__, "notification_targets", notification_targets)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="dedupeString")
    def dedupe_string(self) -> builtins.str:
        """
        A string used to stop Incident Manager from creating multiple incident records for the same incident.
        """
        return pulumi.get(self, "dedupe_string")

    @property
    @pulumi.getter
    def impact(self) -> builtins.int:
        """
        The impact value of a generated incident. The following values are supported:
        """
        return pulumi.get(self, "impact")

    @property
    @pulumi.getter(name="incidentTags")
    def incident_tags(self) -> Mapping[str, builtins.str]:
        """
        The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
        """
        return pulumi.get(self, "incident_tags")

    @property
    @pulumi.getter(name="notificationTargets")
    def notification_targets(self) -> Sequence['outputs.GetResponsePlanIncidentTemplateNotificationTargetResult']:
        """
        The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
        """
        return pulumi.get(self, "notification_targets")

    @property
    @pulumi.getter
    def summary(self) -> builtins.str:
        """
        The summary of an incident.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        The title of a generated incident.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GetResponsePlanIncidentTemplateNotificationTargetResult(dict):
    def __init__(__self__, *,
                 sns_topic_arn: builtins.str):
        """
        :param builtins.str sns_topic_arn: The ARN of the Amazon SNS topic.
        """
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> builtins.str:
        """
        The ARN of the Amazon SNS topic.
        """
        return pulumi.get(self, "sns_topic_arn")


@pulumi.output_type
class GetResponsePlanIntegrationResult(dict):
    def __init__(__self__, *,
                 pagerduties: Sequence['outputs.GetResponsePlanIntegrationPagerdutyResult']):
        """
        :param Sequence['GetResponsePlanIntegrationPagerdutyArgs'] pagerduties: Details about the PagerDuty configuration for a response plan. The following values are supported:
        """
        pulumi.set(__self__, "pagerduties", pagerduties)

    @property
    @pulumi.getter
    def pagerduties(self) -> Sequence['outputs.GetResponsePlanIntegrationPagerdutyResult']:
        """
        Details about the PagerDuty configuration for a response plan. The following values are supported:
        """
        return pulumi.get(self, "pagerduties")


@pulumi.output_type
class GetResponsePlanIntegrationPagerdutyResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 secret_id: builtins.str,
                 service_id: builtins.str):
        """
        :param builtins.str name: The name of the PagerDuty configuration.
        :param builtins.str secret_id: The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
        :param builtins.str service_id: The ID of the PagerDuty service that the response plan associates with an incident when it launches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the PagerDuty configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> builtins.str:
        """
        The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> builtins.str:
        """
        The ID of the PagerDuty service that the response plan associates with an incident when it launches.
        """
        return pulumi.get(self, "service_id")


