# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountAssignmentArgs', 'AccountAssignment']

@pulumi.input_type
class AccountAssignmentArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[builtins.str],
                 permission_set_arn: pulumi.Input[builtins.str],
                 principal_id: pulumi.Input[builtins.str],
                 principal_type: pulumi.Input[builtins.str],
                 target_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccountAssignment resource.
        :param pulumi.Input[builtins.str] instance_arn: The Amazon Resource Name (ARN) of the SSO Instance.
        :param pulumi.Input[builtins.str] permission_set_arn: The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
        :param pulumi.Input[builtins.str] principal_id: An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
        :param pulumi.Input[builtins.str] principal_type: The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
        :param pulumi.Input[builtins.str] target_id: An AWS account identifier, typically a 10-12 digit string.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] target_type: The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        pulumi.set(__self__, "permission_set_arn", permission_set_arn)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "target_id", target_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the SSO Instance.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="permissionSetArn")
    def permission_set_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
        """
        return pulumi.get(self, "permission_set_arn")

    @permission_set_arn.setter
    def permission_set_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission_set_arn", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[builtins.str]:
        """
        An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[builtins.str]:
        """
        The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_type", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[builtins.str]:
        """
        An AWS account identifier, typically a 10-12 digit string.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_type", value)


@pulumi.input_type
class _AccountAssignmentState:
    def __init__(__self__, *,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permission_set_arn: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountAssignment resources.
        :param pulumi.Input[builtins.str] instance_arn: The Amazon Resource Name (ARN) of the SSO Instance.
        :param pulumi.Input[builtins.str] permission_set_arn: The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
        :param pulumi.Input[builtins.str] principal_id: An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
        :param pulumi.Input[builtins.str] principal_type: The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] target_id: An AWS account identifier, typically a 10-12 digit string.
        :param pulumi.Input[builtins.str] target_type: The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
        """
        if instance_arn is not None:
            pulumi.set(__self__, "instance_arn", instance_arn)
        if permission_set_arn is not None:
            pulumi.set(__self__, "permission_set_arn", permission_set_arn)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the SSO Instance.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="permissionSetArn")
    def permission_set_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
        """
        return pulumi.get(self, "permission_set_arn")

    @permission_set_arn.setter
    def permission_set_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "permission_set_arn", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An AWS account identifier, typically a 10-12 digit string.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_type", value)


@pulumi.type_token("aws:ssoadmin/accountAssignment:AccountAssignment")
class AccountAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permission_set_arn: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Single Sign-On (SSO) Account Assignment resource

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_get_permission_set = aws.ssoadmin.get_permission_set(instance_arn=example.arns[0],
            name="AWSReadOnlyAccess")
        example_get_group = aws.identitystore.get_group(identity_store_id=example.identity_store_ids[0],
            alternate_identifier={
                "unique_attribute": {
                    "attribute_path": "DisplayName",
                    "attribute_value": "ExampleGroup",
                },
            })
        example_account_assignment = aws.ssoadmin.AccountAssignment("example",
            instance_arn=example.arns[0],
            permission_set_arn=example_get_permission_set.arn,
            principal_id=example_get_group.group_id,
            principal_type="GROUP",
            target_id="123456789012",
            target_type="AWS_ACCOUNT")
        ```

        ### With Managed Policy Attachment

        > Because destruction of a managed policy attachment resource also re-provisions the associated permission set to all accounts, explicitly indicating the dependency with the account assignment resource via the `depends_on` meta argument is necessary to ensure proper deletion order when these resources are used together.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_permission_set = aws.ssoadmin.PermissionSet("example",
            name="Example",
            instance_arn=example.arns[0])
        example_group = aws.identitystore.Group("example",
            identity_store_id=example.identity_store_ids[0],
            display_name="Admin",
            description="Admin Group")
        account_assignment = aws.ssoadmin.AccountAssignment("account_assignment",
            instance_arn=example.arns[0],
            permission_set_arn=example_permission_set.arn,
            principal_id=example_group.group_id,
            principal_type="GROUP",
            target_id="123456789012",
            target_type="AWS_ACCOUNT")
        example_managed_policy_attachment = aws.ssoadmin.ManagedPolicyAttachment("example",
            instance_arn=example.arns[0],
            managed_policy_arn="arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup",
            permission_set_arn=example_permission_set.arn,
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssoadmin_account_assignment]))
        ```

        ## Import

        Using `pulumi import`, import SSO Account Assignments using the `principal_id`, `principal_type`, `target_id`, `target_type`, `permission_set_arn`, `instance_arn` separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:ssoadmin/accountAssignment:AccountAssignment example f81d4fae-7dec-11d0-a765-00a0c91e6bf6,GROUP,1234567890,AWS_ACCOUNT,arn:aws:sso:::permissionSet/ssoins-0123456789abcdef/ps-0123456789abcdef,arn:aws:sso:::instance/ssoins-0123456789abcdef
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_arn: The Amazon Resource Name (ARN) of the SSO Instance.
        :param pulumi.Input[builtins.str] permission_set_arn: The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
        :param pulumi.Input[builtins.str] principal_id: An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
        :param pulumi.Input[builtins.str] principal_type: The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] target_id: An AWS account identifier, typically a 10-12 digit string.
        :param pulumi.Input[builtins.str] target_type: The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Single Sign-On (SSO) Account Assignment resource

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_get_permission_set = aws.ssoadmin.get_permission_set(instance_arn=example.arns[0],
            name="AWSReadOnlyAccess")
        example_get_group = aws.identitystore.get_group(identity_store_id=example.identity_store_ids[0],
            alternate_identifier={
                "unique_attribute": {
                    "attribute_path": "DisplayName",
                    "attribute_value": "ExampleGroup",
                },
            })
        example_account_assignment = aws.ssoadmin.AccountAssignment("example",
            instance_arn=example.arns[0],
            permission_set_arn=example_get_permission_set.arn,
            principal_id=example_get_group.group_id,
            principal_type="GROUP",
            target_id="123456789012",
            target_type="AWS_ACCOUNT")
        ```

        ### With Managed Policy Attachment

        > Because destruction of a managed policy attachment resource also re-provisions the associated permission set to all accounts, explicitly indicating the dependency with the account assignment resource via the `depends_on` meta argument is necessary to ensure proper deletion order when these resources are used together.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_permission_set = aws.ssoadmin.PermissionSet("example",
            name="Example",
            instance_arn=example.arns[0])
        example_group = aws.identitystore.Group("example",
            identity_store_id=example.identity_store_ids[0],
            display_name="Admin",
            description="Admin Group")
        account_assignment = aws.ssoadmin.AccountAssignment("account_assignment",
            instance_arn=example.arns[0],
            permission_set_arn=example_permission_set.arn,
            principal_id=example_group.group_id,
            principal_type="GROUP",
            target_id="123456789012",
            target_type="AWS_ACCOUNT")
        example_managed_policy_attachment = aws.ssoadmin.ManagedPolicyAttachment("example",
            instance_arn=example.arns[0],
            managed_policy_arn="arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup",
            permission_set_arn=example_permission_set.arn,
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssoadmin_account_assignment]))
        ```

        ## Import

        Using `pulumi import`, import SSO Account Assignments using the `principal_id`, `principal_type`, `target_id`, `target_type`, `permission_set_arn`, `instance_arn` separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:ssoadmin/accountAssignment:AccountAssignment example f81d4fae-7dec-11d0-a765-00a0c91e6bf6,GROUP,1234567890,AWS_ACCOUNT,arn:aws:sso:::permissionSet/ssoins-0123456789abcdef/ps-0123456789abcdef,arn:aws:sso:::instance/ssoins-0123456789abcdef
        ```

        :param str resource_name: The name of the resource.
        :param AccountAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permission_set_arn: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountAssignmentArgs.__new__(AccountAssignmentArgs)

            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            if permission_set_arn is None and not opts.urn:
                raise TypeError("Missing required property 'permission_set_arn'")
            __props__.__dict__["permission_set_arn"] = permission_set_arn
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
            __props__.__dict__["region"] = region
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["target_type"] = target_type
        super(AccountAssignment, __self__).__init__(
            'aws:ssoadmin/accountAssignment:AccountAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_arn: Optional[pulumi.Input[builtins.str]] = None,
            permission_set_arn: Optional[pulumi.Input[builtins.str]] = None,
            principal_id: Optional[pulumi.Input[builtins.str]] = None,
            principal_type: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            target_id: Optional[pulumi.Input[builtins.str]] = None,
            target_type: Optional[pulumi.Input[builtins.str]] = None) -> 'AccountAssignment':
        """
        Get an existing AccountAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_arn: The Amazon Resource Name (ARN) of the SSO Instance.
        :param pulumi.Input[builtins.str] permission_set_arn: The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
        :param pulumi.Input[builtins.str] principal_id: An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
        :param pulumi.Input[builtins.str] principal_type: The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] target_id: An AWS account identifier, typically a 10-12 digit string.
        :param pulumi.Input[builtins.str] target_type: The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountAssignmentState.__new__(_AccountAssignmentState)

        __props__.__dict__["instance_arn"] = instance_arn
        __props__.__dict__["permission_set_arn"] = permission_set_arn
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["region"] = region
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["target_type"] = target_type
        return AccountAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the SSO Instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="permissionSetArn")
    def permission_set_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
        """
        return pulumi.get(self, "permission_set_arn")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[builtins.str]:
        """
        An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[builtins.str]:
        """
        The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[builtins.str]:
        """
        An AWS account identifier, typically a 10-12 digit string.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
        """
        return pulumi.get(self, "target_type")

