# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CanaryArgs', 'Canary']

@pulumi.input_type
class CanaryArgs:
    def __init__(__self__, *,
                 artifact_s3_location: pulumi.Input[builtins.str],
                 execution_role_arn: pulumi.Input[builtins.str],
                 handler: pulumi.Input[builtins.str],
                 runtime_version: pulumi.Input[builtins.str],
                 schedule: pulumi.Input['CanaryScheduleArgs'],
                 artifact_config: Optional[pulumi.Input['CanaryArtifactConfigArgs']] = None,
                 delete_lambda: Optional[pulumi.Input[builtins.bool]] = None,
                 failure_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 run_config: Optional[pulumi.Input['CanaryRunConfigArgs']] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_version: Optional[pulumi.Input[builtins.str]] = None,
                 start_canary: Optional[pulumi.Input[builtins.bool]] = None,
                 success_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input['CanaryVpcConfigArgs']] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Canary resource.
        :param pulumi.Input[builtins.str] artifact_s3_location: Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
        :param pulumi.Input[builtins.str] handler: Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
        :param pulumi.Input[builtins.str] runtime_version: Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
        :param pulumi.Input['CanaryScheduleArgs'] schedule: Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input['CanaryArtifactConfigArgs'] artifact_config: configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
        :param pulumi.Input[builtins.bool] delete_lambda: Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
        :param pulumi.Input[builtins.int] failure_retention_period: Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[builtins.str] name: Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['CanaryRunConfigArgs'] run_config: Configuration block for individual canary runs. Detailed below.
        :param pulumi.Input[builtins.str] s3_bucket: Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_key: S3 key of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_version: S3 version ID of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.bool] start_canary: Whether to run or stop the canary.
        :param pulumi.Input[builtins.int] success_retention_period: Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['CanaryVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        :param pulumi.Input[builtins.str] zip_file: ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
        """
        pulumi.set(__self__, "artifact_s3_location", artifact_s3_location)
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "runtime_version", runtime_version)
        pulumi.set(__self__, "schedule", schedule)
        if artifact_config is not None:
            pulumi.set(__self__, "artifact_config", artifact_config)
        if delete_lambda is not None:
            pulumi.set(__self__, "delete_lambda", delete_lambda)
        if failure_retention_period is not None:
            pulumi.set(__self__, "failure_retention_period", failure_retention_period)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if run_config is not None:
            pulumi.set(__self__, "run_config", run_config)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_version is not None:
            pulumi.set(__self__, "s3_version", s3_version)
        if start_canary is not None:
            pulumi.set(__self__, "start_canary", start_canary)
        if success_retention_period is not None:
            pulumi.set(__self__, "success_retention_period", success_retention_period)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)

    @property
    @pulumi.getter(name="artifactS3Location")
    def artifact_s3_location(self) -> pulumi.Input[builtins.str]:
        """
        Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        """
        return pulumi.get(self, "artifact_s3_location")

    @artifact_s3_location.setter
    def artifact_s3_location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "artifact_s3_location", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Input[builtins.str]:
        """
        Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[builtins.str]:
        """
        Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['CanaryScheduleArgs']:
        """
        Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['CanaryScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="artifactConfig")
    def artifact_config(self) -> Optional[pulumi.Input['CanaryArtifactConfigArgs']]:
        """
        configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
        """
        return pulumi.get(self, "artifact_config")

    @artifact_config.setter
    def artifact_config(self, value: Optional[pulumi.Input['CanaryArtifactConfigArgs']]):
        pulumi.set(self, "artifact_config", value)

    @property
    @pulumi.getter(name="deleteLambda")
    def delete_lambda(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
        """
        return pulumi.get(self, "delete_lambda")

    @delete_lambda.setter
    def delete_lambda(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_lambda", value)

    @property
    @pulumi.getter(name="failureRetentionPeriod")
    def failure_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        """
        return pulumi.get(self, "failure_retention_period")

    @failure_retention_period.setter
    def failure_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "failure_retention_period", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="runConfig")
    def run_config(self) -> Optional[pulumi.Input['CanaryRunConfigArgs']]:
        """
        Configuration block for individual canary runs. Detailed below.
        """
        return pulumi.get(self, "run_config")

    @run_config.setter
    def run_config(self, value: Optional[pulumi.Input['CanaryRunConfigArgs']]):
        pulumi.set(self, "run_config", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 key of your script. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3Version")
    def s3_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 version ID of your script. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_version")

    @s3_version.setter
    def s3_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_version", value)

    @property
    @pulumi.getter(name="startCanary")
    def start_canary(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to run or stop the canary.
        """
        return pulumi.get(self, "start_canary")

    @start_canary.setter
    def start_canary(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "start_canary", value)

    @property
    @pulumi.getter(name="successRetentionPeriod")
    def success_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        """
        return pulumi.get(self, "success_retention_period")

    @success_retention_period.setter
    def success_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "success_retention_period", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['CanaryVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['CanaryVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
        """
        return pulumi.get(self, "zip_file")

    @zip_file.setter
    def zip_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_file", value)


@pulumi.input_type
class _CanaryState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_config: Optional[pulumi.Input['CanaryArtifactConfigArgs']] = None,
                 artifact_s3_location: Optional[pulumi.Input[builtins.str]] = None,
                 delete_lambda: Optional[pulumi.Input[builtins.bool]] = None,
                 engine_arn: Optional[pulumi.Input[builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 failure_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 run_config: Optional[pulumi.Input['CanaryRunConfigArgs']] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_version: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['CanaryScheduleArgs']] = None,
                 source_location_arn: Optional[pulumi.Input[builtins.str]] = None,
                 start_canary: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 success_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timelines: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryTimelineArgs']]]] = None,
                 vpc_config: Optional[pulumi.Input['CanaryVpcConfigArgs']] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Canary resources.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the Canary.
        :param pulumi.Input['CanaryArtifactConfigArgs'] artifact_config: configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
        :param pulumi.Input[builtins.str] artifact_s3_location: Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        :param pulumi.Input[builtins.bool] delete_lambda: Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
        :param pulumi.Input[builtins.str] engine_arn: ARN of the Lambda function that is used as your canary's engine.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
        :param pulumi.Input[builtins.int] failure_retention_period: Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[builtins.str] handler: Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
        :param pulumi.Input[builtins.str] name: Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['CanaryRunConfigArgs'] run_config: Configuration block for individual canary runs. Detailed below.
        :param pulumi.Input[builtins.str] runtime_version: Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
        :param pulumi.Input[builtins.str] s3_bucket: Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_key: S3 key of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_version: S3 version ID of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input['CanaryScheduleArgs'] schedule: Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] source_location_arn: ARN of the Lambda layer where Synthetics stores the canary script code.
        :param pulumi.Input[builtins.bool] start_canary: Whether to run or stop the canary.
        :param pulumi.Input[builtins.str] status: Canary status.
        :param pulumi.Input[builtins.int] success_retention_period: Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['CanaryTimelineArgs']]] timelines: Structure that contains information about when the canary was created, modified, and most recently run. see Timeline.
        :param pulumi.Input['CanaryVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        :param pulumi.Input[builtins.str] zip_file: ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if artifact_config is not None:
            pulumi.set(__self__, "artifact_config", artifact_config)
        if artifact_s3_location is not None:
            pulumi.set(__self__, "artifact_s3_location", artifact_s3_location)
        if delete_lambda is not None:
            pulumi.set(__self__, "delete_lambda", delete_lambda)
        if engine_arn is not None:
            pulumi.set(__self__, "engine_arn", engine_arn)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if failure_retention_period is not None:
            pulumi.set(__self__, "failure_retention_period", failure_retention_period)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if run_config is not None:
            pulumi.set(__self__, "run_config", run_config)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_version is not None:
            pulumi.set(__self__, "s3_version", s3_version)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if source_location_arn is not None:
            pulumi.set(__self__, "source_location_arn", source_location_arn)
        if start_canary is not None:
            pulumi.set(__self__, "start_canary", start_canary)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if success_retention_period is not None:
            pulumi.set(__self__, "success_retention_period", success_retention_period)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timelines is not None:
            pulumi.set(__self__, "timelines", timelines)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the Canary.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="artifactConfig")
    def artifact_config(self) -> Optional[pulumi.Input['CanaryArtifactConfigArgs']]:
        """
        configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
        """
        return pulumi.get(self, "artifact_config")

    @artifact_config.setter
    def artifact_config(self, value: Optional[pulumi.Input['CanaryArtifactConfigArgs']]):
        pulumi.set(self, "artifact_config", value)

    @property
    @pulumi.getter(name="artifactS3Location")
    def artifact_s3_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        """
        return pulumi.get(self, "artifact_s3_location")

    @artifact_s3_location.setter
    def artifact_s3_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_s3_location", value)

    @property
    @pulumi.getter(name="deleteLambda")
    def delete_lambda(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
        """
        return pulumi.get(self, "delete_lambda")

    @delete_lambda.setter
    def delete_lambda(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_lambda", value)

    @property
    @pulumi.getter(name="engineArn")
    def engine_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Lambda function that is used as your canary's engine.
        """
        return pulumi.get(self, "engine_arn")

    @engine_arn.setter
    def engine_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_arn", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="failureRetentionPeriod")
    def failure_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        """
        return pulumi.get(self, "failure_retention_period")

    @failure_retention_period.setter
    def failure_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "failure_retention_period", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="runConfig")
    def run_config(self) -> Optional[pulumi.Input['CanaryRunConfigArgs']]:
        """
        Configuration block for individual canary runs. Detailed below.
        """
        return pulumi.get(self, "run_config")

    @run_config.setter
    def run_config(self, value: Optional[pulumi.Input['CanaryRunConfigArgs']]):
        pulumi.set(self, "run_config", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 key of your script. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3Version")
    def s3_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 version ID of your script. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_version")

    @s3_version.setter
    def s3_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_version", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['CanaryScheduleArgs']]:
        """
        Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['CanaryScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="sourceLocationArn")
    def source_location_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Lambda layer where Synthetics stores the canary script code.
        """
        return pulumi.get(self, "source_location_arn")

    @source_location_arn.setter
    def source_location_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_location_arn", value)

    @property
    @pulumi.getter(name="startCanary")
    def start_canary(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to run or stop the canary.
        """
        return pulumi.get(self, "start_canary")

    @start_canary.setter
    def start_canary(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "start_canary", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Canary status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="successRetentionPeriod")
    def success_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        """
        return pulumi.get(self, "success_retention_period")

    @success_retention_period.setter
    def success_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "success_retention_period", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CanaryTimelineArgs']]]]:
        """
        Structure that contains information about when the canary was created, modified, and most recently run. see Timeline.
        """
        return pulumi.get(self, "timelines")

    @timelines.setter
    def timelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryTimelineArgs']]]]):
        pulumi.set(self, "timelines", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['CanaryVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['CanaryVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
        """
        return pulumi.get(self, "zip_file")

    @zip_file.setter
    def zip_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_file", value)


@pulumi.type_token("aws:synthetics/canary:Canary")
class Canary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_config: Optional[pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']]] = None,
                 artifact_s3_location: Optional[pulumi.Input[builtins.str]] = None,
                 delete_lambda: Optional[pulumi.Input[builtins.bool]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 failure_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 run_config: Optional[pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_version: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']]] = None,
                 start_canary: Optional[pulumi.Input[builtins.bool]] = None,
                 success_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']]] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Synthetics Canary resource.

        > **NOTE:** When you create a canary, AWS creates supporting implicit resources. See the Amazon CloudWatch Synthetics documentation on [DeleteCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html) for a full list. Neither AWS nor this provider deletes these implicit resources automatically when the canary is deleted. Before deleting a canary, ensure you have all the information about the canary that you need to delete the implicit resources using the AWS Console, or AWS CLI.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        some = aws.synthetics.Canary("some",
            name="some-canary",
            artifact_s3_location="s3://some-bucket/",
            execution_role_arn="some-role",
            handler="exports.handler",
            zip_file="test-fixtures/lambdatest.zip",
            runtime_version="syn-1.0",
            schedule={
                "expression": "rate(0 minute)",
            })
        ```

        ## Import

        Using `pulumi import`, import Synthetics Canaries using the `name`. For example:

        ```sh
        $ pulumi import aws:synthetics/canary:Canary some some-canary
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']] artifact_config: configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
        :param pulumi.Input[builtins.str] artifact_s3_location: Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        :param pulumi.Input[builtins.bool] delete_lambda: Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
        :param pulumi.Input[builtins.int] failure_retention_period: Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[builtins.str] handler: Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
        :param pulumi.Input[builtins.str] name: Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']] run_config: Configuration block for individual canary runs. Detailed below.
        :param pulumi.Input[builtins.str] runtime_version: Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
        :param pulumi.Input[builtins.str] s3_bucket: Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_key: S3 key of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_version: S3 version ID of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']] schedule: Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] start_canary: Whether to run or stop the canary.
        :param pulumi.Input[builtins.int] success_retention_period: Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']] vpc_config: Configuration block. Detailed below.
        :param pulumi.Input[builtins.str] zip_file: ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CanaryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Synthetics Canary resource.

        > **NOTE:** When you create a canary, AWS creates supporting implicit resources. See the Amazon CloudWatch Synthetics documentation on [DeleteCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html) for a full list. Neither AWS nor this provider deletes these implicit resources automatically when the canary is deleted. Before deleting a canary, ensure you have all the information about the canary that you need to delete the implicit resources using the AWS Console, or AWS CLI.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        some = aws.synthetics.Canary("some",
            name="some-canary",
            artifact_s3_location="s3://some-bucket/",
            execution_role_arn="some-role",
            handler="exports.handler",
            zip_file="test-fixtures/lambdatest.zip",
            runtime_version="syn-1.0",
            schedule={
                "expression": "rate(0 minute)",
            })
        ```

        ## Import

        Using `pulumi import`, import Synthetics Canaries using the `name`. For example:

        ```sh
        $ pulumi import aws:synthetics/canary:Canary some some-canary
        ```

        :param str resource_name: The name of the resource.
        :param CanaryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CanaryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_config: Optional[pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']]] = None,
                 artifact_s3_location: Optional[pulumi.Input[builtins.str]] = None,
                 delete_lambda: Optional[pulumi.Input[builtins.bool]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 failure_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 run_config: Optional[pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_version: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']]] = None,
                 start_canary: Optional[pulumi.Input[builtins.bool]] = None,
                 success_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']]] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CanaryArgs.__new__(CanaryArgs)

            __props__.__dict__["artifact_config"] = artifact_config
            if artifact_s3_location is None and not opts.urn:
                raise TypeError("Missing required property 'artifact_s3_location'")
            __props__.__dict__["artifact_s3_location"] = artifact_s3_location
            __props__.__dict__["delete_lambda"] = delete_lambda
            if execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role_arn'")
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["failure_retention_period"] = failure_retention_period
            if handler is None and not opts.urn:
                raise TypeError("Missing required property 'handler'")
            __props__.__dict__["handler"] = handler
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["run_config"] = run_config
            if runtime_version is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_version'")
            __props__.__dict__["runtime_version"] = runtime_version
            __props__.__dict__["s3_bucket"] = s3_bucket
            __props__.__dict__["s3_key"] = s3_key
            __props__.__dict__["s3_version"] = s3_version
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["start_canary"] = start_canary
            __props__.__dict__["success_retention_period"] = success_retention_period
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["zip_file"] = zip_file
            __props__.__dict__["arn"] = None
            __props__.__dict__["engine_arn"] = None
            __props__.__dict__["source_location_arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["timelines"] = None
        super(Canary, __self__).__init__(
            'aws:synthetics/canary:Canary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            artifact_config: Optional[pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']]] = None,
            artifact_s3_location: Optional[pulumi.Input[builtins.str]] = None,
            delete_lambda: Optional[pulumi.Input[builtins.bool]] = None,
            engine_arn: Optional[pulumi.Input[builtins.str]] = None,
            execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            failure_retention_period: Optional[pulumi.Input[builtins.int]] = None,
            handler: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            run_config: Optional[pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']]] = None,
            runtime_version: Optional[pulumi.Input[builtins.str]] = None,
            s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
            s3_key: Optional[pulumi.Input[builtins.str]] = None,
            s3_version: Optional[pulumi.Input[builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']]] = None,
            source_location_arn: Optional[pulumi.Input[builtins.str]] = None,
            start_canary: Optional[pulumi.Input[builtins.bool]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            success_retention_period: Optional[pulumi.Input[builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CanaryTimelineArgs', 'CanaryTimelineArgsDict']]]]] = None,
            vpc_config: Optional[pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']]] = None,
            zip_file: Optional[pulumi.Input[builtins.str]] = None) -> 'Canary':
        """
        Get an existing Canary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the Canary.
        :param pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']] artifact_config: configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
        :param pulumi.Input[builtins.str] artifact_s3_location: Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        :param pulumi.Input[builtins.bool] delete_lambda: Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
        :param pulumi.Input[builtins.str] engine_arn: ARN of the Lambda function that is used as your canary's engine.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
        :param pulumi.Input[builtins.int] failure_retention_period: Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[builtins.str] handler: Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
        :param pulumi.Input[builtins.str] name: Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']] run_config: Configuration block for individual canary runs. Detailed below.
        :param pulumi.Input[builtins.str] runtime_version: Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
        :param pulumi.Input[builtins.str] s3_bucket: Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_key: S3 key of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input[builtins.str] s3_version: S3 version ID of your script. **Conflicts with `zip_file`.**
        :param pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']] schedule: Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] source_location_arn: ARN of the Lambda layer where Synthetics stores the canary script code.
        :param pulumi.Input[builtins.bool] start_canary: Whether to run or stop the canary.
        :param pulumi.Input[builtins.str] status: Canary status.
        :param pulumi.Input[builtins.int] success_retention_period: Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CanaryTimelineArgs', 'CanaryTimelineArgsDict']]]] timelines: Structure that contains information about when the canary was created, modified, and most recently run. see Timeline.
        :param pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']] vpc_config: Configuration block. Detailed below.
        :param pulumi.Input[builtins.str] zip_file: ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CanaryState.__new__(_CanaryState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["artifact_config"] = artifact_config
        __props__.__dict__["artifact_s3_location"] = artifact_s3_location
        __props__.__dict__["delete_lambda"] = delete_lambda
        __props__.__dict__["engine_arn"] = engine_arn
        __props__.__dict__["execution_role_arn"] = execution_role_arn
        __props__.__dict__["failure_retention_period"] = failure_retention_period
        __props__.__dict__["handler"] = handler
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["run_config"] = run_config
        __props__.__dict__["runtime_version"] = runtime_version
        __props__.__dict__["s3_bucket"] = s3_bucket
        __props__.__dict__["s3_key"] = s3_key
        __props__.__dict__["s3_version"] = s3_version
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["source_location_arn"] = source_location_arn
        __props__.__dict__["start_canary"] = start_canary
        __props__.__dict__["status"] = status
        __props__.__dict__["success_retention_period"] = success_retention_period
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timelines"] = timelines
        __props__.__dict__["vpc_config"] = vpc_config
        __props__.__dict__["zip_file"] = zip_file
        return Canary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the Canary.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="artifactConfig")
    def artifact_config(self) -> pulumi.Output[Optional['outputs.CanaryArtifactConfig']]:
        """
        configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
        """
        return pulumi.get(self, "artifact_config")

    @property
    @pulumi.getter(name="artifactS3Location")
    def artifact_s3_location(self) -> pulumi.Output[builtins.str]:
        """
        Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
        """
        return pulumi.get(self, "artifact_s3_location")

    @property
    @pulumi.getter(name="deleteLambda")
    def delete_lambda(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
        """
        return pulumi.get(self, "delete_lambda")

    @property
    @pulumi.getter(name="engineArn")
    def engine_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Lambda function that is used as your canary's engine.
        """
        return pulumi.get(self, "engine_arn")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="failureRetentionPeriod")
    def failure_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        """
        return pulumi.get(self, "failure_retention_period")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[builtins.str]:
        """
        Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="runConfig")
    def run_config(self) -> pulumi.Output['outputs.CanaryRunConfig']:
        """
        Configuration block for individual canary runs. Detailed below.
        """
        return pulumi.get(self, "run_config")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Output[builtins.str]:
        """
        Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
        """
        return pulumi.get(self, "runtime_version")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        S3 key of your script. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="s3Version")
    def s3_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        S3 version ID of your script. **Conflicts with `zip_file`.**
        """
        return pulumi.get(self, "s3_version")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.CanarySchedule']:
        """
        Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="sourceLocationArn")
    def source_location_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Lambda layer where Synthetics stores the canary script code.
        """
        return pulumi.get(self, "source_location_arn")

    @property
    @pulumi.getter(name="startCanary")
    def start_canary(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to run or stop the canary.
        """
        return pulumi.get(self, "start_canary")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Canary status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="successRetentionPeriod")
    def success_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
        """
        return pulumi.get(self, "success_retention_period")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timelines(self) -> pulumi.Output[Sequence['outputs.CanaryTimeline']]:
        """
        Structure that contains information about when the canary was created, modified, and most recently run. see Timeline.
        """
        return pulumi.get(self, "timelines")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.CanaryVpcConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
        """
        return pulumi.get(self, "zip_file")

