# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRuntimeVersionResult',
    'AwaitableGetRuntimeVersionResult',
    'get_runtime_version',
    'get_runtime_version_output',
]

@pulumi.output_type
class GetRuntimeVersionResult:
    """
    A collection of values returned by getRuntimeVersion.
    """
    def __init__(__self__, deprecation_date=None, description=None, id=None, latest=None, prefix=None, region=None, release_date=None, version=None, version_name=None):
        if deprecation_date and not isinstance(deprecation_date, str):
            raise TypeError("Expected argument 'deprecation_date' to be a str")
        pulumi.set(__self__, "deprecation_date", deprecation_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest and not isinstance(latest, bool):
            raise TypeError("Expected argument 'latest' to be a bool")
        pulumi.set(__self__, "latest", latest)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if release_date and not isinstance(release_date, str):
            raise TypeError("Expected argument 'release_date' to be a str")
        pulumi.set(__self__, "release_date", release_date)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if version_name and not isinstance(version_name, str):
            raise TypeError("Expected argument 'version_name' to be a str")
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter(name="deprecationDate")
    def deprecation_date(self) -> builtins.str:
        """
        Date of deprecation if the runtme version is deprecated.
        """
        return pulumi.get(self, "deprecation_date")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the runtime version, created by Amazon.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Name of the runtime version. For a list of valid runtime versions, see [Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def latest(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "latest")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="releaseDate")
    def release_date(self) -> builtins.str:
        """
        Date that the runtime version was released.
        """
        return pulumi.get(self, "release_date")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> builtins.str:
        """
        Name of the runtime version. For a list of valid runtime versions, see [Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
        """
        return pulumi.get(self, "version_name")


class AwaitableGetRuntimeVersionResult(GetRuntimeVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuntimeVersionResult(
            deprecation_date=self.deprecation_date,
            description=self.description,
            id=self.id,
            latest=self.latest,
            prefix=self.prefix,
            region=self.region,
            release_date=self.release_date,
            version=self.version,
            version_name=self.version_name)


def get_runtime_version(latest: Optional[builtins.bool] = None,
                        prefix: Optional[builtins.str] = None,
                        region: Optional[builtins.str] = None,
                        version: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuntimeVersionResult:
    """
    Data source for managing an AWS CloudWatch Synthetics Runtime Version.

    ## Example Usage

    ### Latest Runtime Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.synthetics.get_runtime_version(prefix="syn-nodejs-puppeteer",
        latest=True)
    ```

    ### Specific Runtime Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.synthetics.get_runtime_version(prefix="syn-nodejs-puppeteer",
        version="9.0")
    ```


    :param builtins.bool latest: Whether the latest version of the runtime should be fetched. Conflicts with `version`. Valid values: `true`.
    :param builtins.str prefix: Name prefix of the runtime version (for example, `syn-nodejs-puppeteer`).
           
           The following arguments are optional:
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str version: Version of the runtime to be fetched (for example, `9.0`). Conflicts with `latest`.
    """
    __args__ = dict()
    __args__['latest'] = latest
    __args__['prefix'] = prefix
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:synthetics/getRuntimeVersion:getRuntimeVersion', __args__, opts=opts, typ=GetRuntimeVersionResult).value

    return AwaitableGetRuntimeVersionResult(
        deprecation_date=pulumi.get(__ret__, 'deprecation_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        latest=pulumi.get(__ret__, 'latest'),
        prefix=pulumi.get(__ret__, 'prefix'),
        region=pulumi.get(__ret__, 'region'),
        release_date=pulumi.get(__ret__, 'release_date'),
        version=pulumi.get(__ret__, 'version'),
        version_name=pulumi.get(__ret__, 'version_name'))
def get_runtime_version_output(latest: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               prefix: Optional[pulumi.Input[builtins.str]] = None,
                               region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuntimeVersionResult]:
    """
    Data source for managing an AWS CloudWatch Synthetics Runtime Version.

    ## Example Usage

    ### Latest Runtime Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.synthetics.get_runtime_version(prefix="syn-nodejs-puppeteer",
        latest=True)
    ```

    ### Specific Runtime Version

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.synthetics.get_runtime_version(prefix="syn-nodejs-puppeteer",
        version="9.0")
    ```


    :param builtins.bool latest: Whether the latest version of the runtime should be fetched. Conflicts with `version`. Valid values: `true`.
    :param builtins.str prefix: Name prefix of the runtime version (for example, `syn-nodejs-puppeteer`).
           
           The following arguments are optional:
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str version: Version of the runtime to be fetched (for example, `9.0`). Conflicts with `latest`.
    """
    __args__ = dict()
    __args__['latest'] = latest
    __args__['prefix'] = prefix
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:synthetics/getRuntimeVersion:getRuntimeVersion', __args__, opts=opts, typ=GetRuntimeVersionResult)
    return __ret__.apply(lambda __response__: GetRuntimeVersionResult(
        deprecation_date=pulumi.get(__response__, 'deprecation_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        latest=pulumi.get(__response__, 'latest'),
        prefix=pulumi.get(__response__, 'prefix'),
        region=pulumi.get(__response__, 'region'),
        release_date=pulumi.get(__response__, 'release_date'),
        version=pulumi.get(__response__, 'version'),
        version_name=pulumi.get(__response__, 'version_name')))
