# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRuntimeVersionsResult',
    'AwaitableGetRuntimeVersionsResult',
    'get_runtime_versions',
    'get_runtime_versions_output',
]

@pulumi.output_type
class GetRuntimeVersionsResult:
    """
    A collection of values returned by getRuntimeVersions.
    """
    def __init__(__self__, id=None, region=None, runtime_versions=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtime_versions and not isinstance(runtime_versions, list):
            raise TypeError("Expected argument 'runtime_versions' to be a list")
        pulumi.set(__self__, "runtime_versions", runtime_versions)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Name of the AWS region from which runtime versions are fetched.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="runtimeVersions")
    def runtime_versions(self) -> Sequence['outputs.GetRuntimeVersionsRuntimeVersionResult']:
        """
        List of runtime versions. See `runtime_versions` attribute reference.
        """
        return pulumi.get(self, "runtime_versions")


class AwaitableGetRuntimeVersionsResult(GetRuntimeVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuntimeVersionsResult(
            id=self.id,
            region=self.region,
            runtime_versions=self.runtime_versions)


def get_runtime_versions(region: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuntimeVersionsResult:
    """
    Data source for managing an AWS CloudWatch Synthetics Runtime Versions.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.synthetics.get_runtime_versions()
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:synthetics/getRuntimeVersions:getRuntimeVersions', __args__, opts=opts, typ=GetRuntimeVersionsResult).value

    return AwaitableGetRuntimeVersionsResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        runtime_versions=pulumi.get(__ret__, 'runtime_versions'))
def get_runtime_versions_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuntimeVersionsResult]:
    """
    Data source for managing an AWS CloudWatch Synthetics Runtime Versions.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.synthetics.get_runtime_versions()
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:synthetics/getRuntimeVersions:getRuntimeVersions', __args__, opts=opts, typ=GetRuntimeVersionsResult)
    return __ret__.apply(lambda __response__: GetRuntimeVersionsResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        runtime_versions=pulumi.get(__response__, 'runtime_versions')))
