# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ScheduledQueryErrorReportConfiguration',
    'ScheduledQueryErrorReportConfigurationS3Configuration',
    'ScheduledQueryLastRunSummary',
    'ScheduledQueryLastRunSummaryErrorReportLocation',
    'ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocation',
    'ScheduledQueryLastRunSummaryExecutionStat',
    'ScheduledQueryLastRunSummaryQueryInsightsResponse',
    'ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverage',
    'ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxis',
    'ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRange',
    'ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxis',
    'ScheduledQueryNotificationConfiguration',
    'ScheduledQueryNotificationConfigurationSnsConfiguration',
    'ScheduledQueryRecentlyFailedRun',
    'ScheduledQueryRecentlyFailedRunErrorReportLocation',
    'ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocation',
    'ScheduledQueryRecentlyFailedRunExecutionStat',
    'ScheduledQueryRecentlyFailedRunQueryInsightsResponse',
    'ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverage',
    'ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxis',
    'ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRange',
    'ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxis',
    'ScheduledQueryScheduleConfiguration',
    'ScheduledQueryTargetConfiguration',
    'ScheduledQueryTargetConfigurationTimestreamConfiguration',
    'ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMapping',
    'ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMapping',
    'ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMapping',
    'ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappings',
    'ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMapping',
    'ScheduledQueryTimeouts',
]

@pulumi.output_type
class ScheduledQueryErrorReportConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Configuration":
            suggest = "s3_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryErrorReportConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryErrorReportConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryErrorReportConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_configuration: 'outputs.ScheduledQueryErrorReportConfigurationS3Configuration'):
        """
        :param 'ScheduledQueryErrorReportConfigurationS3ConfigurationArgs' s3_configuration: Configuration block for the S3 configuration for the error reports. See below.
        """
        pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.ScheduledQueryErrorReportConfigurationS3Configuration':
        """
        Configuration block for the S3 configuration for the error reports. See below.
        """
        return pulumi.get(self, "s3_configuration")


@pulumi.output_type
class ScheduledQueryErrorReportConfigurationS3Configuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "objectKeyPrefix":
            suggest = "object_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryErrorReportConfigurationS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryErrorReportConfigurationS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryErrorReportConfigurationS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 encryption_option: Optional[builtins.str] = None,
                 object_key_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: Name of the S3 bucket under which error reports will be created.
        :param builtins.str encryption_option: Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose `SSE_S3` as default. Valid values are `SSE_S3`, `SSE_KMS`.
        :param builtins.str object_key_prefix: Prefix for the error report key.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if encryption_option is not None:
            pulumi.set(__self__, "encryption_option", encryption_option)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        Name of the S3 bucket under which error reports will be created.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> Optional[builtins.str]:
        """
        Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose `SSE_S3` as default. Valid values are `SSE_S3`, `SSE_KMS`.
        """
        return pulumi.get(self, "encryption_option")

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[builtins.str]:
        """
        Prefix for the error report key.
        """
        return pulumi.get(self, "object_key_prefix")


@pulumi.output_type
class ScheduledQueryLastRunSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorReportLocations":
            suggest = "error_report_locations"
        elif key == "executionStats":
            suggest = "execution_stats"
        elif key == "failureReason":
            suggest = "failure_reason"
        elif key == "invocationTime":
            suggest = "invocation_time"
        elif key == "queryInsightsResponses":
            suggest = "query_insights_responses"
        elif key == "runStatus":
            suggest = "run_status"
        elif key == "triggerTime":
            suggest = "trigger_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryLastRunSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryLastRunSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryLastRunSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_report_locations: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryErrorReportLocation']] = None,
                 execution_stats: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryExecutionStat']] = None,
                 failure_reason: Optional[builtins.str] = None,
                 invocation_time: Optional[builtins.str] = None,
                 query_insights_responses: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponse']] = None,
                 run_status: Optional[builtins.str] = None,
                 trigger_time: Optional[builtins.str] = None):
        """
        :param Sequence['ScheduledQueryLastRunSummaryErrorReportLocationArgs'] error_report_locations: S3 location for error report.
        :param Sequence['ScheduledQueryLastRunSummaryExecutionStatArgs'] execution_stats: Statistics for a single scheduled query run.
        :param builtins.str failure_reason: Error message for the scheduled query in case of failure. You might have to look at the error report to get more detailed error reasons.
        :param builtins.str invocation_time: InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter `@scheduled_runtime` can be used in the query to get the value.
        :param Sequence['ScheduledQueryLastRunSummaryQueryInsightsResponseArgs'] query_insights_responses: Various insights and metrics related to the run summary of the scheduled query.
        :param builtins.str run_status: Status of a scheduled query run. Valid values: `AUTO_TRIGGER_SUCCESS`, `AUTO_TRIGGER_FAILURE`, `MANUAL_TRIGGER_SUCCESS`, `MANUAL_TRIGGER_FAILURE`.
        :param builtins.str trigger_time: Actual time when the query was run.
        """
        if error_report_locations is not None:
            pulumi.set(__self__, "error_report_locations", error_report_locations)
        if execution_stats is not None:
            pulumi.set(__self__, "execution_stats", execution_stats)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if invocation_time is not None:
            pulumi.set(__self__, "invocation_time", invocation_time)
        if query_insights_responses is not None:
            pulumi.set(__self__, "query_insights_responses", query_insights_responses)
        if run_status is not None:
            pulumi.set(__self__, "run_status", run_status)
        if trigger_time is not None:
            pulumi.set(__self__, "trigger_time", trigger_time)

    @property
    @pulumi.getter(name="errorReportLocations")
    def error_report_locations(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryErrorReportLocation']]:
        """
        S3 location for error report.
        """
        return pulumi.get(self, "error_report_locations")

    @property
    @pulumi.getter(name="executionStats")
    def execution_stats(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryExecutionStat']]:
        """
        Statistics for a single scheduled query run.
        """
        return pulumi.get(self, "execution_stats")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[builtins.str]:
        """
        Error message for the scheduled query in case of failure. You might have to look at the error report to get more detailed error reasons.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter(name="invocationTime")
    def invocation_time(self) -> Optional[builtins.str]:
        """
        InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter `@scheduled_runtime` can be used in the query to get the value.
        """
        return pulumi.get(self, "invocation_time")

    @property
    @pulumi.getter(name="queryInsightsResponses")
    def query_insights_responses(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponse']]:
        """
        Various insights and metrics related to the run summary of the scheduled query.
        """
        return pulumi.get(self, "query_insights_responses")

    @property
    @pulumi.getter(name="runStatus")
    def run_status(self) -> Optional[builtins.str]:
        """
        Status of a scheduled query run. Valid values: `AUTO_TRIGGER_SUCCESS`, `AUTO_TRIGGER_FAILURE`, `MANUAL_TRIGGER_SUCCESS`, `MANUAL_TRIGGER_FAILURE`.
        """
        return pulumi.get(self, "run_status")

    @property
    @pulumi.getter(name="triggerTime")
    def trigger_time(self) -> Optional[builtins.str]:
        """
        Actual time when the query was run.
        """
        return pulumi.get(self, "trigger_time")


@pulumi.output_type
class ScheduledQueryLastRunSummaryErrorReportLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3ReportLocations":
            suggest = "s3_report_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryLastRunSummaryErrorReportLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryLastRunSummaryErrorReportLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryLastRunSummaryErrorReportLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_report_locations: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocation']] = None):
        """
        :param Sequence['ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocationArgs'] s3_report_locations: S3 location where error reports are written.
        """
        if s3_report_locations is not None:
            pulumi.set(__self__, "s3_report_locations", s3_report_locations)

    @property
    @pulumi.getter(name="s3ReportLocations")
    def s3_report_locations(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocation']]:
        """
        S3 location where error reports are written.
        """
        return pulumi.get(self, "s3_report_locations")


@pulumi.output_type
class ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "objectKey":
            suggest = "object_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryLastRunSummaryErrorReportLocationS3ReportLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Optional[builtins.str] = None,
                 object_key: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: S3 bucket name.
        :param builtins.str object_key: S3 key.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if object_key is not None:
            pulumi.set(__self__, "object_key", object_key)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[builtins.str]:
        """
        S3 bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="objectKey")
    def object_key(self) -> Optional[builtins.str]:
        """
        S3 key.
        """
        return pulumi.get(self, "object_key")


@pulumi.output_type
class ScheduledQueryLastRunSummaryExecutionStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesMetered":
            suggest = "bytes_metered"
        elif key == "cumulativeBytesScanned":
            suggest = "cumulative_bytes_scanned"
        elif key == "dataWrites":
            suggest = "data_writes"
        elif key == "executionTimeInMillis":
            suggest = "execution_time_in_millis"
        elif key == "queryResultRows":
            suggest = "query_result_rows"
        elif key == "recordsIngested":
            suggest = "records_ingested"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryLastRunSummaryExecutionStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryLastRunSummaryExecutionStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryLastRunSummaryExecutionStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bytes_metered: Optional[builtins.int] = None,
                 cumulative_bytes_scanned: Optional[builtins.int] = None,
                 data_writes: Optional[builtins.int] = None,
                 execution_time_in_millis: Optional[builtins.int] = None,
                 query_result_rows: Optional[builtins.int] = None,
                 records_ingested: Optional[builtins.int] = None):
        """
        :param builtins.int bytes_metered: Bytes metered for a single scheduled query run.
        :param builtins.int cumulative_bytes_scanned: Bytes scanned for a single scheduled query run.
        :param builtins.int data_writes: Data writes metered for records ingested in a single scheduled query run.
        :param builtins.int execution_time_in_millis: Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
        :param builtins.int query_result_rows: Number of rows present in the output from running a query before ingestion to destination data source.
        :param builtins.int records_ingested: Number of records ingested for a single scheduled query run.
        """
        if bytes_metered is not None:
            pulumi.set(__self__, "bytes_metered", bytes_metered)
        if cumulative_bytes_scanned is not None:
            pulumi.set(__self__, "cumulative_bytes_scanned", cumulative_bytes_scanned)
        if data_writes is not None:
            pulumi.set(__self__, "data_writes", data_writes)
        if execution_time_in_millis is not None:
            pulumi.set(__self__, "execution_time_in_millis", execution_time_in_millis)
        if query_result_rows is not None:
            pulumi.set(__self__, "query_result_rows", query_result_rows)
        if records_ingested is not None:
            pulumi.set(__self__, "records_ingested", records_ingested)

    @property
    @pulumi.getter(name="bytesMetered")
    def bytes_metered(self) -> Optional[builtins.int]:
        """
        Bytes metered for a single scheduled query run.
        """
        return pulumi.get(self, "bytes_metered")

    @property
    @pulumi.getter(name="cumulativeBytesScanned")
    def cumulative_bytes_scanned(self) -> Optional[builtins.int]:
        """
        Bytes scanned for a single scheduled query run.
        """
        return pulumi.get(self, "cumulative_bytes_scanned")

    @property
    @pulumi.getter(name="dataWrites")
    def data_writes(self) -> Optional[builtins.int]:
        """
        Data writes metered for records ingested in a single scheduled query run.
        """
        return pulumi.get(self, "data_writes")

    @property
    @pulumi.getter(name="executionTimeInMillis")
    def execution_time_in_millis(self) -> Optional[builtins.int]:
        """
        Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
        """
        return pulumi.get(self, "execution_time_in_millis")

    @property
    @pulumi.getter(name="queryResultRows")
    def query_result_rows(self) -> Optional[builtins.int]:
        """
        Number of rows present in the output from running a query before ingestion to destination data source.
        """
        return pulumi.get(self, "query_result_rows")

    @property
    @pulumi.getter(name="recordsIngested")
    def records_ingested(self) -> Optional[builtins.int]:
        """
        Number of records ingested for a single scheduled query run.
        """
        return pulumi.get(self, "records_ingested")


@pulumi.output_type
class ScheduledQueryLastRunSummaryQueryInsightsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputBytes":
            suggest = "output_bytes"
        elif key == "outputRows":
            suggest = "output_rows"
        elif key == "querySpatialCoverages":
            suggest = "query_spatial_coverages"
        elif key == "queryTableCount":
            suggest = "query_table_count"
        elif key == "queryTemporalRanges":
            suggest = "query_temporal_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryLastRunSummaryQueryInsightsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryLastRunSummaryQueryInsightsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryLastRunSummaryQueryInsightsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_bytes: Optional[builtins.int] = None,
                 output_rows: Optional[builtins.int] = None,
                 query_spatial_coverages: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverage']] = None,
                 query_table_count: Optional[builtins.int] = None,
                 query_temporal_ranges: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRange']] = None):
        """
        :param builtins.int output_bytes: Size of query result set in bytes. You can use this data to validate if the result set has changed as part of the query tuning exercise.
        :param builtins.int output_rows: Total number of rows returned as part of the query result set. You can use this data to validate if the number of rows in the result set have changed as part of the query tuning exercise.
        :param Sequence['ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageArgs'] query_spatial_coverages: Insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning.
        :param builtins.int query_table_count: Number of tables in the query.
        :param Sequence['ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeArgs'] query_temporal_ranges: Insights into the temporal range of the query, including the table with the largest (max) time range. Following are some of the potential options for optimizing time-based pruning: add missing time-predicates, remove functions around the time predicates, add time predicates to all the sub-queries.
        """
        if output_bytes is not None:
            pulumi.set(__self__, "output_bytes", output_bytes)
        if output_rows is not None:
            pulumi.set(__self__, "output_rows", output_rows)
        if query_spatial_coverages is not None:
            pulumi.set(__self__, "query_spatial_coverages", query_spatial_coverages)
        if query_table_count is not None:
            pulumi.set(__self__, "query_table_count", query_table_count)
        if query_temporal_ranges is not None:
            pulumi.set(__self__, "query_temporal_ranges", query_temporal_ranges)

    @property
    @pulumi.getter(name="outputBytes")
    def output_bytes(self) -> Optional[builtins.int]:
        """
        Size of query result set in bytes. You can use this data to validate if the result set has changed as part of the query tuning exercise.
        """
        return pulumi.get(self, "output_bytes")

    @property
    @pulumi.getter(name="outputRows")
    def output_rows(self) -> Optional[builtins.int]:
        """
        Total number of rows returned as part of the query result set. You can use this data to validate if the number of rows in the result set have changed as part of the query tuning exercise.
        """
        return pulumi.get(self, "output_rows")

    @property
    @pulumi.getter(name="querySpatialCoverages")
    def query_spatial_coverages(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverage']]:
        """
        Insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning.
        """
        return pulumi.get(self, "query_spatial_coverages")

    @property
    @pulumi.getter(name="queryTableCount")
    def query_table_count(self) -> Optional[builtins.int]:
        """
        Number of tables in the query.
        """
        return pulumi.get(self, "query_table_count")

    @property
    @pulumi.getter(name="queryTemporalRanges")
    def query_temporal_ranges(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRange']]:
        """
        Insights into the temporal range of the query, including the table with the largest (max) time range. Following are some of the potential options for optimizing time-based pruning: add missing time-predicates, remove functions around the time predicates, add time predicates to all the sub-queries.
        """
        return pulumi.get(self, "query_temporal_ranges")


@pulumi.output_type
class ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverage(dict):
    def __init__(__self__, *,
                 maxes: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxis']] = None):
        """
        :param Sequence['ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxisArgs'] maxes: Insights into the most sub-optimal performing table on the temporal axis:
        """
        if maxes is not None:
            pulumi.set(__self__, "maxes", maxes)

    @property
    @pulumi.getter
    def maxes(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxis']]:
        """
        Insights into the most sub-optimal performing table on the temporal axis:
        """
        return pulumi.get(self, "maxes")


@pulumi.output_type
class ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKeys":
            suggest = "partition_keys"
        elif key == "tableArn":
            suggest = "table_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryLastRunSummaryQueryInsightsResponseQuerySpatialCoverageMaxis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_keys: Optional[Sequence[builtins.str]] = None,
                 table_arn: Optional[builtins.str] = None,
                 value: Optional[builtins.float] = None):
        """
        :param Sequence[builtins.str] partition_keys: Partition key used for partitioning, which can be a default measure_name or a customer defined partition key.
        :param builtins.str table_arn: ARN of the table which is queried with the largest time range.
        :param builtins.float value: Maximum duration in nanoseconds between the start and end of the query.
        """
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if table_arn is not None:
            pulumi.set(__self__, "table_arn", table_arn)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        Partition key used for partitioning, which can be a default measure_name or a customer defined partition key.
        """
        return pulumi.get(self, "partition_keys")

    @property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> Optional[builtins.str]:
        """
        ARN of the table which is queried with the largest time range.
        """
        return pulumi.get(self, "table_arn")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.float]:
        """
        Maximum duration in nanoseconds between the start and end of the query.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRange(dict):
    def __init__(__self__, *,
                 maxes: Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxis']] = None):
        """
        :param Sequence['ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxisArgs'] maxes: Insights into the most sub-optimal performing table on the temporal axis:
        """
        if maxes is not None:
            pulumi.set(__self__, "maxes", maxes)

    @property
    @pulumi.getter
    def maxes(self) -> Optional[Sequence['outputs.ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxis']]:
        """
        Insights into the most sub-optimal performing table on the temporal axis:
        """
        return pulumi.get(self, "maxes")


@pulumi.output_type
class ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableArn":
            suggest = "table_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryLastRunSummaryQueryInsightsResponseQueryTemporalRangeMaxis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_arn: Optional[builtins.str] = None,
                 value: Optional[builtins.int] = None):
        """
        :param builtins.str table_arn: ARN of the table which is queried with the largest time range.
        :param builtins.int value: Maximum duration in nanoseconds between the start and end of the query.
        """
        if table_arn is not None:
            pulumi.set(__self__, "table_arn", table_arn)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> Optional[builtins.str]:
        """
        ARN of the table which is queried with the largest time range.
        """
        return pulumi.get(self, "table_arn")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.int]:
        """
        Maximum duration in nanoseconds between the start and end of the query.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduledQueryNotificationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snsConfiguration":
            suggest = "sns_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sns_configuration: 'outputs.ScheduledQueryNotificationConfigurationSnsConfiguration'):
        """
        :param 'ScheduledQueryNotificationConfigurationSnsConfigurationArgs' sns_configuration: Configuration block for details about the Amazon Simple Notification Service (SNS) configuration. See below.
        """
        pulumi.set(__self__, "sns_configuration", sns_configuration)

    @property
    @pulumi.getter(name="snsConfiguration")
    def sns_configuration(self) -> 'outputs.ScheduledQueryNotificationConfigurationSnsConfiguration':
        """
        Configuration block for details about the Amazon Simple Notification Service (SNS) configuration. See below.
        """
        return pulumi.get(self, "sns_configuration")


@pulumi.output_type
class ScheduledQueryNotificationConfigurationSnsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicArn":
            suggest = "topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryNotificationConfigurationSnsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryNotificationConfigurationSnsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryNotificationConfigurationSnsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_arn: builtins.str):
        """
        :param builtins.str topic_arn: SNS topic ARN that the scheduled query status notifications will be sent to.
        """
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> builtins.str:
        """
        SNS topic ARN that the scheduled query status notifications will be sent to.
        """
        return pulumi.get(self, "topic_arn")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRun(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorReportLocations":
            suggest = "error_report_locations"
        elif key == "executionStats":
            suggest = "execution_stats"
        elif key == "failureReason":
            suggest = "failure_reason"
        elif key == "invocationTime":
            suggest = "invocation_time"
        elif key == "queryInsightsResponses":
            suggest = "query_insights_responses"
        elif key == "runStatus":
            suggest = "run_status"
        elif key == "triggerTime":
            suggest = "trigger_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRecentlyFailedRun. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRecentlyFailedRun.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRecentlyFailedRun.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_report_locations: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunErrorReportLocation']] = None,
                 execution_stats: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunExecutionStat']] = None,
                 failure_reason: Optional[builtins.str] = None,
                 invocation_time: Optional[builtins.str] = None,
                 query_insights_responses: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponse']] = None,
                 run_status: Optional[builtins.str] = None,
                 trigger_time: Optional[builtins.str] = None):
        """
        :param Sequence['ScheduledQueryRecentlyFailedRunErrorReportLocationArgs'] error_report_locations: S3 location for error report.
        :param Sequence['ScheduledQueryRecentlyFailedRunExecutionStatArgs'] execution_stats: Statistics for a single scheduled query run.
        :param builtins.str failure_reason: Error message for the scheduled query in case of failure. You might have to look at the error report to get more detailed error reasons.
        :param builtins.str invocation_time: InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter `@scheduled_runtime` can be used in the query to get the value.
        :param Sequence['ScheduledQueryRecentlyFailedRunQueryInsightsResponseArgs'] query_insights_responses: Various insights and metrics related to the run summary of the scheduled query.
        :param builtins.str run_status: Status of a scheduled query run. Valid values: `AUTO_TRIGGER_SUCCESS`, `AUTO_TRIGGER_FAILURE`, `MANUAL_TRIGGER_SUCCESS`, `MANUAL_TRIGGER_FAILURE`.
        :param builtins.str trigger_time: Actual time when the query was run.
        """
        if error_report_locations is not None:
            pulumi.set(__self__, "error_report_locations", error_report_locations)
        if execution_stats is not None:
            pulumi.set(__self__, "execution_stats", execution_stats)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if invocation_time is not None:
            pulumi.set(__self__, "invocation_time", invocation_time)
        if query_insights_responses is not None:
            pulumi.set(__self__, "query_insights_responses", query_insights_responses)
        if run_status is not None:
            pulumi.set(__self__, "run_status", run_status)
        if trigger_time is not None:
            pulumi.set(__self__, "trigger_time", trigger_time)

    @property
    @pulumi.getter(name="errorReportLocations")
    def error_report_locations(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunErrorReportLocation']]:
        """
        S3 location for error report.
        """
        return pulumi.get(self, "error_report_locations")

    @property
    @pulumi.getter(name="executionStats")
    def execution_stats(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunExecutionStat']]:
        """
        Statistics for a single scheduled query run.
        """
        return pulumi.get(self, "execution_stats")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[builtins.str]:
        """
        Error message for the scheduled query in case of failure. You might have to look at the error report to get more detailed error reasons.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter(name="invocationTime")
    def invocation_time(self) -> Optional[builtins.str]:
        """
        InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter `@scheduled_runtime` can be used in the query to get the value.
        """
        return pulumi.get(self, "invocation_time")

    @property
    @pulumi.getter(name="queryInsightsResponses")
    def query_insights_responses(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponse']]:
        """
        Various insights and metrics related to the run summary of the scheduled query.
        """
        return pulumi.get(self, "query_insights_responses")

    @property
    @pulumi.getter(name="runStatus")
    def run_status(self) -> Optional[builtins.str]:
        """
        Status of a scheduled query run. Valid values: `AUTO_TRIGGER_SUCCESS`, `AUTO_TRIGGER_FAILURE`, `MANUAL_TRIGGER_SUCCESS`, `MANUAL_TRIGGER_FAILURE`.
        """
        return pulumi.get(self, "run_status")

    @property
    @pulumi.getter(name="triggerTime")
    def trigger_time(self) -> Optional[builtins.str]:
        """
        Actual time when the query was run.
        """
        return pulumi.get(self, "trigger_time")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunErrorReportLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3ReportLocations":
            suggest = "s3_report_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRecentlyFailedRunErrorReportLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRecentlyFailedRunErrorReportLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRecentlyFailedRunErrorReportLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_report_locations: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocation']] = None):
        """
        :param Sequence['ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocationArgs'] s3_report_locations: S3 location where error reports are written.
        """
        if s3_report_locations is not None:
            pulumi.set(__self__, "s3_report_locations", s3_report_locations)

    @property
    @pulumi.getter(name="s3ReportLocations")
    def s3_report_locations(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocation']]:
        """
        S3 location where error reports are written.
        """
        return pulumi.get(self, "s3_report_locations")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "objectKey":
            suggest = "object_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRecentlyFailedRunErrorReportLocationS3ReportLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Optional[builtins.str] = None,
                 object_key: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: S3 bucket name.
        :param builtins.str object_key: S3 key.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if object_key is not None:
            pulumi.set(__self__, "object_key", object_key)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[builtins.str]:
        """
        S3 bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="objectKey")
    def object_key(self) -> Optional[builtins.str]:
        """
        S3 key.
        """
        return pulumi.get(self, "object_key")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunExecutionStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesMetered":
            suggest = "bytes_metered"
        elif key == "cumulativeBytesScanned":
            suggest = "cumulative_bytes_scanned"
        elif key == "dataWrites":
            suggest = "data_writes"
        elif key == "executionTimeInMillis":
            suggest = "execution_time_in_millis"
        elif key == "queryResultRows":
            suggest = "query_result_rows"
        elif key == "recordsIngested":
            suggest = "records_ingested"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRecentlyFailedRunExecutionStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRecentlyFailedRunExecutionStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRecentlyFailedRunExecutionStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bytes_metered: Optional[builtins.int] = None,
                 cumulative_bytes_scanned: Optional[builtins.int] = None,
                 data_writes: Optional[builtins.int] = None,
                 execution_time_in_millis: Optional[builtins.int] = None,
                 query_result_rows: Optional[builtins.int] = None,
                 records_ingested: Optional[builtins.int] = None):
        """
        :param builtins.int bytes_metered: Bytes metered for a single scheduled query run.
        :param builtins.int cumulative_bytes_scanned: Bytes scanned for a single scheduled query run.
        :param builtins.int data_writes: Data writes metered for records ingested in a single scheduled query run.
        :param builtins.int execution_time_in_millis: Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
        :param builtins.int query_result_rows: Number of rows present in the output from running a query before ingestion to destination data source.
        :param builtins.int records_ingested: Number of records ingested for a single scheduled query run.
        """
        if bytes_metered is not None:
            pulumi.set(__self__, "bytes_metered", bytes_metered)
        if cumulative_bytes_scanned is not None:
            pulumi.set(__self__, "cumulative_bytes_scanned", cumulative_bytes_scanned)
        if data_writes is not None:
            pulumi.set(__self__, "data_writes", data_writes)
        if execution_time_in_millis is not None:
            pulumi.set(__self__, "execution_time_in_millis", execution_time_in_millis)
        if query_result_rows is not None:
            pulumi.set(__self__, "query_result_rows", query_result_rows)
        if records_ingested is not None:
            pulumi.set(__self__, "records_ingested", records_ingested)

    @property
    @pulumi.getter(name="bytesMetered")
    def bytes_metered(self) -> Optional[builtins.int]:
        """
        Bytes metered for a single scheduled query run.
        """
        return pulumi.get(self, "bytes_metered")

    @property
    @pulumi.getter(name="cumulativeBytesScanned")
    def cumulative_bytes_scanned(self) -> Optional[builtins.int]:
        """
        Bytes scanned for a single scheduled query run.
        """
        return pulumi.get(self, "cumulative_bytes_scanned")

    @property
    @pulumi.getter(name="dataWrites")
    def data_writes(self) -> Optional[builtins.int]:
        """
        Data writes metered for records ingested in a single scheduled query run.
        """
        return pulumi.get(self, "data_writes")

    @property
    @pulumi.getter(name="executionTimeInMillis")
    def execution_time_in_millis(self) -> Optional[builtins.int]:
        """
        Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
        """
        return pulumi.get(self, "execution_time_in_millis")

    @property
    @pulumi.getter(name="queryResultRows")
    def query_result_rows(self) -> Optional[builtins.int]:
        """
        Number of rows present in the output from running a query before ingestion to destination data source.
        """
        return pulumi.get(self, "query_result_rows")

    @property
    @pulumi.getter(name="recordsIngested")
    def records_ingested(self) -> Optional[builtins.int]:
        """
        Number of records ingested for a single scheduled query run.
        """
        return pulumi.get(self, "records_ingested")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunQueryInsightsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputBytes":
            suggest = "output_bytes"
        elif key == "outputRows":
            suggest = "output_rows"
        elif key == "querySpatialCoverages":
            suggest = "query_spatial_coverages"
        elif key == "queryTableCount":
            suggest = "query_table_count"
        elif key == "queryTemporalRanges":
            suggest = "query_temporal_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRecentlyFailedRunQueryInsightsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRecentlyFailedRunQueryInsightsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRecentlyFailedRunQueryInsightsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_bytes: Optional[builtins.int] = None,
                 output_rows: Optional[builtins.int] = None,
                 query_spatial_coverages: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverage']] = None,
                 query_table_count: Optional[builtins.int] = None,
                 query_temporal_ranges: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRange']] = None):
        """
        :param builtins.int output_bytes: Size of query result set in bytes. You can use this data to validate if the result set has changed as part of the query tuning exercise.
        :param builtins.int output_rows: Total number of rows returned as part of the query result set. You can use this data to validate if the number of rows in the result set have changed as part of the query tuning exercise.
        :param Sequence['ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageArgs'] query_spatial_coverages: Insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning.
        :param builtins.int query_table_count: Number of tables in the query.
        :param Sequence['ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeArgs'] query_temporal_ranges: Insights into the temporal range of the query, including the table with the largest (max) time range. Following are some of the potential options for optimizing time-based pruning: add missing time-predicates, remove functions around the time predicates, add time predicates to all the sub-queries.
        """
        if output_bytes is not None:
            pulumi.set(__self__, "output_bytes", output_bytes)
        if output_rows is not None:
            pulumi.set(__self__, "output_rows", output_rows)
        if query_spatial_coverages is not None:
            pulumi.set(__self__, "query_spatial_coverages", query_spatial_coverages)
        if query_table_count is not None:
            pulumi.set(__self__, "query_table_count", query_table_count)
        if query_temporal_ranges is not None:
            pulumi.set(__self__, "query_temporal_ranges", query_temporal_ranges)

    @property
    @pulumi.getter(name="outputBytes")
    def output_bytes(self) -> Optional[builtins.int]:
        """
        Size of query result set in bytes. You can use this data to validate if the result set has changed as part of the query tuning exercise.
        """
        return pulumi.get(self, "output_bytes")

    @property
    @pulumi.getter(name="outputRows")
    def output_rows(self) -> Optional[builtins.int]:
        """
        Total number of rows returned as part of the query result set. You can use this data to validate if the number of rows in the result set have changed as part of the query tuning exercise.
        """
        return pulumi.get(self, "output_rows")

    @property
    @pulumi.getter(name="querySpatialCoverages")
    def query_spatial_coverages(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverage']]:
        """
        Insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning.
        """
        return pulumi.get(self, "query_spatial_coverages")

    @property
    @pulumi.getter(name="queryTableCount")
    def query_table_count(self) -> Optional[builtins.int]:
        """
        Number of tables in the query.
        """
        return pulumi.get(self, "query_table_count")

    @property
    @pulumi.getter(name="queryTemporalRanges")
    def query_temporal_ranges(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRange']]:
        """
        Insights into the temporal range of the query, including the table with the largest (max) time range. Following are some of the potential options for optimizing time-based pruning: add missing time-predicates, remove functions around the time predicates, add time predicates to all the sub-queries.
        """
        return pulumi.get(self, "query_temporal_ranges")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverage(dict):
    def __init__(__self__, *,
                 maxes: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxis']] = None):
        """
        :param Sequence['ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxisArgs'] maxes: Insights into the most sub-optimal performing table on the temporal axis:
        """
        if maxes is not None:
            pulumi.set(__self__, "maxes", maxes)

    @property
    @pulumi.getter
    def maxes(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxis']]:
        """
        Insights into the most sub-optimal performing table on the temporal axis:
        """
        return pulumi.get(self, "maxes")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKeys":
            suggest = "partition_keys"
        elif key == "tableArn":
            suggest = "table_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRecentlyFailedRunQueryInsightsResponseQuerySpatialCoverageMaxis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_keys: Optional[Sequence[builtins.str]] = None,
                 table_arn: Optional[builtins.str] = None,
                 value: Optional[builtins.float] = None):
        """
        :param Sequence[builtins.str] partition_keys: Partition key used for partitioning, which can be a default measure_name or a customer defined partition key.
        :param builtins.str table_arn: ARN of the table which is queried with the largest time range.
        :param builtins.float value: Maximum duration in nanoseconds between the start and end of the query.
        """
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if table_arn is not None:
            pulumi.set(__self__, "table_arn", table_arn)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        Partition key used for partitioning, which can be a default measure_name or a customer defined partition key.
        """
        return pulumi.get(self, "partition_keys")

    @property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> Optional[builtins.str]:
        """
        ARN of the table which is queried with the largest time range.
        """
        return pulumi.get(self, "table_arn")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.float]:
        """
        Maximum duration in nanoseconds between the start and end of the query.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRange(dict):
    def __init__(__self__, *,
                 maxes: Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxis']] = None):
        """
        :param Sequence['ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxisArgs'] maxes: Insights into the most sub-optimal performing table on the temporal axis:
        """
        if maxes is not None:
            pulumi.set(__self__, "maxes", maxes)

    @property
    @pulumi.getter
    def maxes(self) -> Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxis']]:
        """
        Insights into the most sub-optimal performing table on the temporal axis:
        """
        return pulumi.get(self, "maxes")


@pulumi.output_type
class ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableArn":
            suggest = "table_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRecentlyFailedRunQueryInsightsResponseQueryTemporalRangeMaxis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_arn: Optional[builtins.str] = None,
                 value: Optional[builtins.int] = None):
        """
        :param builtins.str table_arn: ARN of the table which is queried with the largest time range.
        :param builtins.int value: Maximum duration in nanoseconds between the start and end of the query.
        """
        if table_arn is not None:
            pulumi.set(__self__, "table_arn", table_arn)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> Optional[builtins.str]:
        """
        ARN of the table which is queried with the largest time range.
        """
        return pulumi.get(self, "table_arn")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.int]:
        """
        Maximum duration in nanoseconds between the start and end of the query.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduledQueryScheduleConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryScheduleConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryScheduleConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryScheduleConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: builtins.str):
        """
        :param builtins.str schedule_expression: When to trigger the scheduled query run. This can be a cron expression or a rate expression.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> builtins.str:
        """
        When to trigger the scheduled query run. This can be a cron expression or a rate expression.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class ScheduledQueryTargetConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timestreamConfiguration":
            suggest = "timestream_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timestream_configuration: Optional['outputs.ScheduledQueryTargetConfigurationTimestreamConfiguration'] = None):
        """
        :param 'ScheduledQueryTargetConfigurationTimestreamConfigurationArgs' timestream_configuration: Configuration block for information needed to write data into the Timestream database and table. See below.
        """
        if timestream_configuration is not None:
            pulumi.set(__self__, "timestream_configuration", timestream_configuration)

    @property
    @pulumi.getter(name="timestreamConfiguration")
    def timestream_configuration(self) -> Optional['outputs.ScheduledQueryTargetConfigurationTimestreamConfiguration']:
        """
        Configuration block for information needed to write data into the Timestream database and table. See below.
        """
        return pulumi.get(self, "timestream_configuration")


@pulumi.output_type
class ScheduledQueryTargetConfigurationTimestreamConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "timeColumn":
            suggest = "time_column"
        elif key == "dimensionMappings":
            suggest = "dimension_mappings"
        elif key == "measureNameColumn":
            suggest = "measure_name_column"
        elif key == "mixedMeasureMappings":
            suggest = "mixed_measure_mappings"
        elif key == "multiMeasureMappings":
            suggest = "multi_measure_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfigurationTimestreamConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 table_name: builtins.str,
                 time_column: builtins.str,
                 dimension_mappings: Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMapping']] = None,
                 measure_name_column: Optional[builtins.str] = None,
                 mixed_measure_mappings: Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMapping']] = None,
                 multi_measure_mappings: Optional['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappings'] = None):
        """
        :param builtins.str database_name: Name of Timestream database to which the query result will be written.
        :param builtins.str table_name: Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
        :param builtins.str time_column: Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
        :param Sequence['ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMappingArgs'] dimension_mappings: Configuration block for mapping of column(s) from the query result to the dimension in the destination table. See below.
        :param builtins.str measure_name_column: Name of the measure column.
        :param Sequence['ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingArgs'] mixed_measure_mappings: Configuration block for how to map measures to multi-measure records. See below.
        :param 'ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsArgs' multi_measure_mappings: Configuration block for multi-measure mappings. Only one of `mixed_measure_mappings` or `multi_measure_mappings` can be provided. `multi_measure_mappings` can be used to ingest data as multi measures in the derived table. See below.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_column", time_column)
        if dimension_mappings is not None:
            pulumi.set(__self__, "dimension_mappings", dimension_mappings)
        if measure_name_column is not None:
            pulumi.set(__self__, "measure_name_column", measure_name_column)
        if mixed_measure_mappings is not None:
            pulumi.set(__self__, "mixed_measure_mappings", mixed_measure_mappings)
        if multi_measure_mappings is not None:
            pulumi.set(__self__, "multi_measure_mappings", multi_measure_mappings)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of Timestream database to which the query result will be written.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="timeColumn")
    def time_column(self) -> builtins.str:
        """
        Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
        """
        return pulumi.get(self, "time_column")

    @property
    @pulumi.getter(name="dimensionMappings")
    def dimension_mappings(self) -> Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMapping']]:
        """
        Configuration block for mapping of column(s) from the query result to the dimension in the destination table. See below.
        """
        return pulumi.get(self, "dimension_mappings")

    @property
    @pulumi.getter(name="measureNameColumn")
    def measure_name_column(self) -> Optional[builtins.str]:
        """
        Name of the measure column.
        """
        return pulumi.get(self, "measure_name_column")

    @property
    @pulumi.getter(name="mixedMeasureMappings")
    def mixed_measure_mappings(self) -> Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMapping']]:
        """
        Configuration block for how to map measures to multi-measure records. See below.
        """
        return pulumi.get(self, "mixed_measure_mappings")

    @property
    @pulumi.getter(name="multiMeasureMappings")
    def multi_measure_mappings(self) -> Optional['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappings']:
        """
        Configuration block for multi-measure mappings. Only one of `mixed_measure_mappings` or `multi_measure_mappings` can be provided. `multi_measure_mappings` can be used to ingest data as multi measures in the derived table. See below.
        """
        return pulumi.get(self, "multi_measure_mappings")


@pulumi.output_type
class ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionValueType":
            suggest = "dimension_value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationDimensionMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_value_type: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str dimension_value_type: Type for the dimension. Valid value: `VARCHAR`.
        :param builtins.str name: Column name from query result.
        """
        pulumi.set(__self__, "dimension_value_type", dimension_value_type)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dimensionValueType")
    def dimension_value_type(self) -> builtins.str:
        """
        Type for the dimension. Valid value: `VARCHAR`.
        """
        return pulumi.get(self, "dimension_value_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Column name from query result.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "measureValueType":
            suggest = "measure_value_type"
        elif key == "measureName":
            suggest = "measure_name"
        elif key == "multiMeasureAttributeMappings":
            suggest = "multi_measure_attribute_mappings"
        elif key == "sourceColumn":
            suggest = "source_column"
        elif key == "targetMeasureName":
            suggest = "target_measure_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 measure_value_type: builtins.str,
                 measure_name: Optional[builtins.str] = None,
                 multi_measure_attribute_mappings: Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMapping']] = None,
                 source_column: Optional[builtins.str] = None,
                 target_measure_name: Optional[builtins.str] = None):
        """
        :param builtins.str measure_value_type: Type of the value that is to be read from `source_column`. Valid values are `BIGINT`, `BOOLEAN`, `DOUBLE`, `VARCHAR`, `MULTI`.
        :param builtins.str measure_name: Refers to the value of measure_name in a result row. This field is required if `measure_name_column` is provided.
        :param Sequence['ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMappingArgs'] multi_measure_attribute_mappings: Configuration block for attribute mappings for `MULTI` value measures. Required when `measure_value_type` is `MULTI`. See below.
        :param builtins.str source_column: Source column from which measure-value is to be read for result materialization.
        :param builtins.str target_measure_name: Target measure name to be used. If not provided, the target measure name by default is `measure_name`, if provided, or `source_column` otherwise.
        """
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        if measure_name is not None:
            pulumi.set(__self__, "measure_name", measure_name)
        if multi_measure_attribute_mappings is not None:
            pulumi.set(__self__, "multi_measure_attribute_mappings", multi_measure_attribute_mappings)
        if source_column is not None:
            pulumi.set(__self__, "source_column", source_column)
        if target_measure_name is not None:
            pulumi.set(__self__, "target_measure_name", target_measure_name)

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> builtins.str:
        """
        Type of the value that is to be read from `source_column`. Valid values are `BIGINT`, `BOOLEAN`, `DOUBLE`, `VARCHAR`, `MULTI`.
        """
        return pulumi.get(self, "measure_value_type")

    @property
    @pulumi.getter(name="measureName")
    def measure_name(self) -> Optional[builtins.str]:
        """
        Refers to the value of measure_name in a result row. This field is required if `measure_name_column` is provided.
        """
        return pulumi.get(self, "measure_name")

    @property
    @pulumi.getter(name="multiMeasureAttributeMappings")
    def multi_measure_attribute_mappings(self) -> Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMapping']]:
        """
        Configuration block for attribute mappings for `MULTI` value measures. Required when `measure_value_type` is `MULTI`. See below.
        """
        return pulumi.get(self, "multi_measure_attribute_mappings")

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> Optional[builtins.str]:
        """
        Source column from which measure-value is to be read for result materialization.
        """
        return pulumi.get(self, "source_column")

    @property
    @pulumi.getter(name="targetMeasureName")
    def target_measure_name(self) -> Optional[builtins.str]:
        """
        Target measure name to be used. If not provided, the target measure name by default is `measure_name`, if provided, or `source_column` otherwise.
        """
        return pulumi.get(self, "target_measure_name")


@pulumi.output_type
class ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "measureValueType":
            suggest = "measure_value_type"
        elif key == "sourceColumn":
            suggest = "source_column"
        elif key == "targetMultiMeasureAttributeName":
            suggest = "target_multi_measure_attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMixedMeasureMappingMultiMeasureAttributeMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 measure_value_type: builtins.str,
                 source_column: builtins.str,
                 target_multi_measure_attribute_name: Optional[builtins.str] = None):
        """
        :param builtins.str measure_value_type: Type of the attribute to be read from the source column. Valid values are `BIGINT`, `BOOLEAN`, `DOUBLE`, `VARCHAR`, `TIMESTAMP`.
        :param builtins.str source_column: Source column from where the attribute value is to be read.
        :param builtins.str target_multi_measure_attribute_name: Custom name to be used for attribute name in derived table. If not provided, `source_column` is used.
        """
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        pulumi.set(__self__, "source_column", source_column)
        if target_multi_measure_attribute_name is not None:
            pulumi.set(__self__, "target_multi_measure_attribute_name", target_multi_measure_attribute_name)

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> builtins.str:
        """
        Type of the attribute to be read from the source column. Valid values are `BIGINT`, `BOOLEAN`, `DOUBLE`, `VARCHAR`, `TIMESTAMP`.
        """
        return pulumi.get(self, "measure_value_type")

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> builtins.str:
        """
        Source column from where the attribute value is to be read.
        """
        return pulumi.get(self, "source_column")

    @property
    @pulumi.getter(name="targetMultiMeasureAttributeName")
    def target_multi_measure_attribute_name(self) -> Optional[builtins.str]:
        """
        Custom name to be used for attribute name in derived table. If not provided, `source_column` is used.
        """
        return pulumi.get(self, "target_multi_measure_attribute_name")


@pulumi.output_type
class ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multiMeasureAttributeMappings":
            suggest = "multi_measure_attribute_mappings"
        elif key == "targetMultiMeasureName":
            suggest = "target_multi_measure_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multi_measure_attribute_mappings: Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMapping']] = None,
                 target_multi_measure_name: Optional[builtins.str] = None):
        """
        :param Sequence['ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMappingArgs'] multi_measure_attribute_mappings: Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes. See above.
        :param builtins.str target_multi_measure_name: Name of the target multi-measure name in the derived table. This input is required when `measure_name_column` is not provided. If `measure_name_column` is provided, then the value from that column will be used as the multi-measure name.
        """
        if multi_measure_attribute_mappings is not None:
            pulumi.set(__self__, "multi_measure_attribute_mappings", multi_measure_attribute_mappings)
        if target_multi_measure_name is not None:
            pulumi.set(__self__, "target_multi_measure_name", target_multi_measure_name)

    @property
    @pulumi.getter(name="multiMeasureAttributeMappings")
    def multi_measure_attribute_mappings(self) -> Optional[Sequence['outputs.ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMapping']]:
        """
        Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes. See above.
        """
        return pulumi.get(self, "multi_measure_attribute_mappings")

    @property
    @pulumi.getter(name="targetMultiMeasureName")
    def target_multi_measure_name(self) -> Optional[builtins.str]:
        """
        Name of the target multi-measure name in the derived table. This input is required when `measure_name_column` is not provided. If `measure_name_column` is provided, then the value from that column will be used as the multi-measure name.
        """
        return pulumi.get(self, "target_multi_measure_name")


@pulumi.output_type
class ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "measureValueType":
            suggest = "measure_value_type"
        elif key == "sourceColumn":
            suggest = "source_column"
        elif key == "targetMultiMeasureAttributeName":
            suggest = "target_multi_measure_attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfigurationTimestreamConfigurationMultiMeasureMappingsMultiMeasureAttributeMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 measure_value_type: builtins.str,
                 source_column: builtins.str,
                 target_multi_measure_attribute_name: Optional[builtins.str] = None):
        """
        :param builtins.str measure_value_type: Type of the attribute to be read from the source column. Valid values are `BIGINT`, `BOOLEAN`, `DOUBLE`, `VARCHAR`, `TIMESTAMP`.
        :param builtins.str source_column: Source column from where the attribute value is to be read.
        :param builtins.str target_multi_measure_attribute_name: Custom name to be used for attribute name in derived table. If not provided, `source_column` is used.
        """
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        pulumi.set(__self__, "source_column", source_column)
        if target_multi_measure_attribute_name is not None:
            pulumi.set(__self__, "target_multi_measure_attribute_name", target_multi_measure_attribute_name)

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> builtins.str:
        """
        Type of the attribute to be read from the source column. Valid values are `BIGINT`, `BOOLEAN`, `DOUBLE`, `VARCHAR`, `TIMESTAMP`.
        """
        return pulumi.get(self, "measure_value_type")

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> builtins.str:
        """
        Source column from where the attribute value is to be read.
        """
        return pulumi.get(self, "source_column")

    @property
    @pulumi.getter(name="targetMultiMeasureAttributeName")
    def target_multi_measure_attribute_name(self) -> Optional[builtins.str]:
        """
        Custom name to be used for attribute name in derived table. If not provided, `source_column` is used.
        """
        return pulumi.get(self, "target_multi_measure_attribute_name")


@pulumi.output_type
class ScheduledQueryTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


