# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduledQueryArgs', 'ScheduledQuery']

@pulumi.input_type
class ScheduledQueryArgs:
    def __init__(__self__, *,
                 error_report_configuration: pulumi.Input['ScheduledQueryErrorReportConfigurationArgs'],
                 execution_role_arn: pulumi.Input[builtins.str],
                 notification_configuration: pulumi.Input['ScheduledQueryNotificationConfigurationArgs'],
                 query_string: pulumi.Input[builtins.str],
                 schedule_configuration: pulumi.Input['ScheduledQueryScheduleConfigurationArgs'],
                 target_configuration: pulumi.Input['ScheduledQueryTargetConfigurationArgs'],
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_run_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recently_failed_runs: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ScheduledQueryTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ScheduledQuery resource.
        :param pulumi.Input['ScheduledQueryErrorReportConfigurationArgs'] error_report_configuration: Configuration block for error reporting configuration. See below.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN for the IAM role that Timestream will assume when running the scheduled query.
        :param pulumi.Input['ScheduledQueryNotificationConfigurationArgs'] notification_configuration: Configuration block for notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is created, its state is updated, or when it is deleted. See below.
        :param pulumi.Input[builtins.str] query_string: Query string to run. Parameter names can be specified in the query string using the `@` character followed by an identifier. The named parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the `schedule_configuration` parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        :param pulumi.Input['ScheduledQueryScheduleConfigurationArgs'] schedule_configuration: Configuration block for schedule configuration for the query. See below.
        :param pulumi.Input['ScheduledQueryTargetConfigurationArgs'] target_configuration: Configuration block for writing the result of a query. See below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] kms_key_id: Amazon KMS key used to encrypt the scheduled query resource, at-rest. If not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with "alias/". If `error_report_configuration` uses `SSE_KMS` as the encryption type, the same `kms_key_id` is used to encrypt the error report at rest.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]] last_run_summaries: Runtime summary for the last scheduled query run.
        :param pulumi.Input[builtins.str] name: Name of the scheduled query.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]] recently_failed_runs: Runtime summary for the last five failed scheduled query runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "error_report_configuration", error_report_configuration)
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "notification_configuration", notification_configuration)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "schedule_configuration", schedule_configuration)
        pulumi.set(__self__, "target_configuration", target_configuration)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_run_summaries is not None:
            pulumi.set(__self__, "last_run_summaries", last_run_summaries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recently_failed_runs is not None:
            pulumi.set(__self__, "recently_failed_runs", recently_failed_runs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="errorReportConfiguration")
    def error_report_configuration(self) -> pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']:
        """
        Configuration block for error reporting configuration. See below.
        """
        return pulumi.get(self, "error_report_configuration")

    @error_report_configuration.setter
    def error_report_configuration(self, value: pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']):
        pulumi.set(self, "error_report_configuration", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN for the IAM role that Timestream will assume when running the scheduled query.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Input['ScheduledQueryNotificationConfigurationArgs']:
        """
        Configuration block for notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is created, its state is updated, or when it is deleted. See below.
        """
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: pulumi.Input['ScheduledQueryNotificationConfigurationArgs']):
        pulumi.set(self, "notification_configuration", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[builtins.str]:
        """
        Query string to run. Parameter names can be specified in the query string using the `@` character followed by an identifier. The named parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the `schedule_configuration` parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter(name="scheduleConfiguration")
    def schedule_configuration(self) -> pulumi.Input['ScheduledQueryScheduleConfigurationArgs']:
        """
        Configuration block for schedule configuration for the query. See below.
        """
        return pulumi.get(self, "schedule_configuration")

    @schedule_configuration.setter
    def schedule_configuration(self, value: pulumi.Input['ScheduledQueryScheduleConfigurationArgs']):
        pulumi.set(self, "schedule_configuration", value)

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> pulumi.Input['ScheduledQueryTargetConfigurationArgs']:
        """
        Configuration block for writing the result of a query. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: pulumi.Input['ScheduledQueryTargetConfigurationArgs']):
        pulumi.set(self, "target_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon KMS key used to encrypt the scheduled query resource, at-rest. If not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with "alias/". If `error_report_configuration` uses `SSE_KMS` as the encryption type, the same `kms_key_id` is used to encrypt the error report at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lastRunSummaries")
    def last_run_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]]]:
        """
        Runtime summary for the last scheduled query run.
        """
        return pulumi.get(self, "last_run_summaries")

    @last_run_summaries.setter
    def last_run_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]]]):
        pulumi.set(self, "last_run_summaries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the scheduled query.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recentlyFailedRuns")
    def recently_failed_runs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]]]:
        """
        Runtime summary for the last five failed scheduled query runs.
        """
        return pulumi.get(self, "recently_failed_runs")

    @recently_failed_runs.setter
    def recently_failed_runs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]]]):
        pulumi.set(self, "recently_failed_runs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ScheduledQueryTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ScheduledQueryTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ScheduledQueryState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 error_report_configuration: Optional[pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_run_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 next_invocation_time: Optional[pulumi.Input[builtins.str]] = None,
                 notification_configuration: Optional[pulumi.Input['ScheduledQueryNotificationConfigurationArgs']] = None,
                 previous_invocation_time: Optional[pulumi.Input[builtins.str]] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 recently_failed_runs: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_configuration: Optional[pulumi.Input['ScheduledQueryScheduleConfigurationArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_configuration: Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']] = None,
                 timeouts: Optional[pulumi.Input['ScheduledQueryTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ScheduledQuery resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Scheduled Query.
        :param pulumi.Input[builtins.str] creation_time: Creation time for the scheduled query.
        :param pulumi.Input['ScheduledQueryErrorReportConfigurationArgs'] error_report_configuration: Configuration block for error reporting configuration. See below.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN for the IAM role that Timestream will assume when running the scheduled query.
        :param pulumi.Input[builtins.str] kms_key_id: Amazon KMS key used to encrypt the scheduled query resource, at-rest. If not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with "alias/". If `error_report_configuration` uses `SSE_KMS` as the encryption type, the same `kms_key_id` is used to encrypt the error report at rest.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]] last_run_summaries: Runtime summary for the last scheduled query run.
        :param pulumi.Input[builtins.str] name: Name of the scheduled query.
        :param pulumi.Input[builtins.str] next_invocation_time: Next time the scheduled query is scheduled to run.
        :param pulumi.Input['ScheduledQueryNotificationConfigurationArgs'] notification_configuration: Configuration block for notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is created, its state is updated, or when it is deleted. See below.
        :param pulumi.Input[builtins.str] previous_invocation_time: Last time the scheduled query was run.
        :param pulumi.Input[builtins.str] query_string: Query string to run. Parameter names can be specified in the query string using the `@` character followed by an identifier. The named parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the `schedule_configuration` parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]] recently_failed_runs: Runtime summary for the last five failed scheduled query runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ScheduledQueryScheduleConfigurationArgs'] schedule_configuration: Configuration block for schedule configuration for the query. See below.
        :param pulumi.Input[builtins.str] state: State of the scheduled query, either `ENABLED` or `DISABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['ScheduledQueryTargetConfigurationArgs'] target_configuration: Configuration block for writing the result of a query. See below.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if error_report_configuration is not None:
            pulumi.set(__self__, "error_report_configuration", error_report_configuration)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_run_summaries is not None:
            pulumi.set(__self__, "last_run_summaries", last_run_summaries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_invocation_time is not None:
            pulumi.set(__self__, "next_invocation_time", next_invocation_time)
        if notification_configuration is not None:
            pulumi.set(__self__, "notification_configuration", notification_configuration)
        if previous_invocation_time is not None:
            pulumi.set(__self__, "previous_invocation_time", previous_invocation_time)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if recently_failed_runs is not None:
            pulumi.set(__self__, "recently_failed_runs", recently_failed_runs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_configuration is not None:
            pulumi.set(__self__, "schedule_configuration", schedule_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Scheduled Query.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation time for the scheduled query.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="errorReportConfiguration")
    def error_report_configuration(self) -> Optional[pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']]:
        """
        Configuration block for error reporting configuration. See below.
        """
        return pulumi.get(self, "error_report_configuration")

    @error_report_configuration.setter
    def error_report_configuration(self, value: Optional[pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']]):
        pulumi.set(self, "error_report_configuration", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN for the IAM role that Timestream will assume when running the scheduled query.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon KMS key used to encrypt the scheduled query resource, at-rest. If not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with "alias/". If `error_report_configuration` uses `SSE_KMS` as the encryption type, the same `kms_key_id` is used to encrypt the error report at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lastRunSummaries")
    def last_run_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]]]:
        """
        Runtime summary for the last scheduled query run.
        """
        return pulumi.get(self, "last_run_summaries")

    @last_run_summaries.setter
    def last_run_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryLastRunSummaryArgs']]]]):
        pulumi.set(self, "last_run_summaries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the scheduled query.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextInvocationTime")
    def next_invocation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Next time the scheduled query is scheduled to run.
        """
        return pulumi.get(self, "next_invocation_time")

    @next_invocation_time.setter
    def next_invocation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_invocation_time", value)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional[pulumi.Input['ScheduledQueryNotificationConfigurationArgs']]:
        """
        Configuration block for notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is created, its state is updated, or when it is deleted. See below.
        """
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: Optional[pulumi.Input['ScheduledQueryNotificationConfigurationArgs']]):
        pulumi.set(self, "notification_configuration", value)

    @property
    @pulumi.getter(name="previousInvocationTime")
    def previous_invocation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last time the scheduled query was run.
        """
        return pulumi.get(self, "previous_invocation_time")

    @previous_invocation_time.setter
    def previous_invocation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "previous_invocation_time", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Query string to run. Parameter names can be specified in the query string using the `@` character followed by an identifier. The named parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the `schedule_configuration` parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter(name="recentlyFailedRuns")
    def recently_failed_runs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]]]:
        """
        Runtime summary for the last five failed scheduled query runs.
        """
        return pulumi.get(self, "recently_failed_runs")

    @recently_failed_runs.setter
    def recently_failed_runs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRecentlyFailedRunArgs']]]]):
        pulumi.set(self, "recently_failed_runs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scheduleConfiguration")
    def schedule_configuration(self) -> Optional[pulumi.Input['ScheduledQueryScheduleConfigurationArgs']]:
        """
        Configuration block for schedule configuration for the query. See below.
        """
        return pulumi.get(self, "schedule_configuration")

    @schedule_configuration.setter
    def schedule_configuration(self, value: Optional[pulumi.Input['ScheduledQueryScheduleConfigurationArgs']]):
        pulumi.set(self, "schedule_configuration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the scheduled query, either `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']]:
        """
        Configuration block for writing the result of a query. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ScheduledQueryTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ScheduledQueryTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:timestreamquery/scheduledQuery:ScheduledQuery")
class ScheduledQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 error_report_configuration: Optional[pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_run_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryLastRunSummaryArgs', 'ScheduledQueryLastRunSummaryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']]] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 recently_failed_runs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRecentlyFailedRunArgs', 'ScheduledQueryRecentlyFailedRunArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_configuration: Optional[pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['ScheduledQueryTimeoutsArgs', 'ScheduledQueryTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Timestream Query Scheduled Query.

        ## Example Usage

        ### Basic Usage

        Before creating a scheduled query, you must have a source database and table with ingested data. Below is a multi-step example, providing an opportunity for data ingestion.

        If your infrastructure is already set up—including the source database and table with data, results database and table, error report S3 bucket, SNS topic, and IAM role—you can create a scheduled query as follows:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.timestreamquery.ScheduledQuery("example",
            execution_role_arn=example_aws_iam_role["arn"],
            name=example_aws_timestreamwrite_table["tableName"],
            query_string=\"\"\"SELECT region, az, hostname, BIN(time, 15s) AS binned_timestamp,
        \\x09ROUND(AVG(cpu_utilization), 2) AS avg_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.9), 2) AS p90_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.95), 2) AS p95_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.99), 2) AS p99_cpu_utilization
        FROM exampledatabase.exampletable
        WHERE measure_name = 'metrics' AND time > ago(2h)
        GROUP BY region, hostname, az, BIN(time, 15s)
        ORDER BY binned_timestamp ASC
        LIMIT 5
        \"\"\",
            error_report_configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["bucket"],
                },
            },
            notification_configuration={
                "sns_configuration": {
                    "topic_arn": example_aws_sns_topic["arn"],
                },
            },
            schedule_configuration={
                "schedule_expression": "rate(1 hour)",
            },
            target_configuration={
                "timestream_configuration": {
                    "database_name": results["databaseName"],
                    "table_name": results_aws_timestreamwrite_table["tableName"],
                    "time_column": "binned_timestamp",
                    "dimension_mappings": [
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "az",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "region",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "hostname",
                        },
                    ],
                    "multi_measure_mappings": {
                        "target_multi_measure_name": "multi-metrics",
                        "multi_measure_attribute_mappings": [
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "avg_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p90_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p95_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p99_cpu_utilization",
                            },
                        ],
                    },
                },
            })
        ```

        ### Multi-step Example

        To ingest data before creating a scheduled query, this example provides multiple steps:

        1. Create the prerequisite infrastructure
        2. Ingest data
        3. Create the scheduled query

        ### Step 1. Create the prerequisite infrastructure

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        test = aws.s3.Bucket("test",
            bucket="example",
            force_destroy=True)
        test_topic = aws.sns.Topic("test", name="example")
        test_queue = aws.sqs.Queue("test",
            name="example",
            sqs_managed_sse_enabled=True)
        test_topic_subscription = aws.sns.TopicSubscription("test",
            topic=test_topic.arn,
            protocol="sqs",
            endpoint=test_queue.arn)
        test_queue_policy = aws.sqs.QueuePolicy("test",
            queue_url=test_queue.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Principal": {
                        "AWS": "*",
                    },
                    "Action": ["sqs:SendMessage"],
                    "Resource": test_queue.arn,
                    "Condition": {
                        "ArnEquals": {
                            "aws:SourceArn": test_topic.arn,
                        },
                    },
                }],
            }))
        test_role = aws.iam.Role("test",
            name="example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "timestream.amazonaws.com",
                    },
                    "Action": "sts:AssumeRole",
                }],
            }),
            tags={
                "Name": "example",
            })
        test_role_policy = aws.iam.RolePolicy("test",
            name="example",
            role=test_role.id,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "kms:Decrypt",
                        "sns:Publish",
                        "timestream:describeEndpoints",
                        "timestream:Select",
                        "timestream:SelectValues",
                        "timestream:WriteRecords",
                        "s3:PutObject",
                    ],
                    "Resource": "*",
                    "Effect": "Allow",
                }],
            }))
        test_database = aws.timestreamwrite.Database("test", database_name="exampledatabase")
        test_table = aws.timestreamwrite.Table("test",
            database_name=test_database.database_name,
            table_name="exampletable",
            magnetic_store_write_properties={
                "enable_magnetic_store_writes": True,
            },
            retention_properties={
                "magnetic_store_retention_period_in_days": 1,
                "memory_store_retention_period_in_hours": 1,
            })
        results = aws.timestreamwrite.Database("results", database_name="exampledatabase-results")
        results_table = aws.timestreamwrite.Table("results",
            database_name=results.database_name,
            table_name="exampletable-results",
            magnetic_store_write_properties={
                "enable_magnetic_store_writes": True,
            },
            retention_properties={
                "magnetic_store_retention_period_in_days": 1,
                "memory_store_retention_period_in_hours": 1,
            })
        ```

        #### Step 2. Ingest data

        This is done with Amazon Timestream Write [WriteRecords](https://docs.aws.amazon.com/timestream/latest/developerguide/API_WriteRecords.html).

        ### Step 3. Create the scheduled query

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.timestreamquery.ScheduledQuery("example",
            execution_role_arn=example_aws_iam_role["arn"],
            name=example_aws_timestreamwrite_table["tableName"],
            query_string=\"\"\"SELECT region, az, hostname, BIN(time, 15s) AS binned_timestamp,
        \\x09ROUND(AVG(cpu_utilization), 2) AS avg_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.9), 2) AS p90_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.95), 2) AS p95_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.99), 2) AS p99_cpu_utilization
        FROM exampledatabase.exampletable
        WHERE measure_name = 'metrics' AND time > ago(2h)
        GROUP BY region, hostname, az, BIN(time, 15s)
        ORDER BY binned_timestamp ASC
        LIMIT 5
        \"\"\",
            error_report_configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["bucket"],
                },
            },
            notification_configuration={
                "sns_configuration": {
                    "topic_arn": example_aws_sns_topic["arn"],
                },
            },
            schedule_configuration={
                "schedule_expression": "rate(1 hour)",
            },
            target_configuration={
                "timestream_configuration": {
                    "database_name": results["databaseName"],
                    "table_name": results_aws_timestreamwrite_table["tableName"],
                    "time_column": "binned_timestamp",
                    "dimension_mappings": [
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "az",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "region",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "hostname",
                        },
                    ],
                    "multi_measure_mappings": {
                        "target_multi_measure_name": "multi-metrics",
                        "multi_measure_attribute_mappings": [
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "avg_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p90_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p95_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p99_cpu_utilization",
                            },
                        ],
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Timestream Query Scheduled Query using the `arn`. For example:

        ```sh
        $ pulumi import aws:timestreamquery/scheduledQuery:ScheduledQuery example arn:aws:timestream:us-west-2:012345678901:scheduled-query/tf-acc-test-7774188528604787105-e13659544fe66c8d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']] error_report_configuration: Configuration block for error reporting configuration. See below.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN for the IAM role that Timestream will assume when running the scheduled query.
        :param pulumi.Input[builtins.str] kms_key_id: Amazon KMS key used to encrypt the scheduled query resource, at-rest. If not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with "alias/". If `error_report_configuration` uses `SSE_KMS` as the encryption type, the same `kms_key_id` is used to encrypt the error report at rest.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryLastRunSummaryArgs', 'ScheduledQueryLastRunSummaryArgsDict']]]] last_run_summaries: Runtime summary for the last scheduled query run.
        :param pulumi.Input[builtins.str] name: Name of the scheduled query.
        :param pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']] notification_configuration: Configuration block for notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is created, its state is updated, or when it is deleted. See below.
        :param pulumi.Input[builtins.str] query_string: Query string to run. Parameter names can be specified in the query string using the `@` character followed by an identifier. The named parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the `schedule_configuration` parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRecentlyFailedRunArgs', 'ScheduledQueryRecentlyFailedRunArgsDict']]]] recently_failed_runs: Runtime summary for the last five failed scheduled query runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']] schedule_configuration: Configuration block for schedule configuration for the query. See below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']] target_configuration: Configuration block for writing the result of a query. See below.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Timestream Query Scheduled Query.

        ## Example Usage

        ### Basic Usage

        Before creating a scheduled query, you must have a source database and table with ingested data. Below is a multi-step example, providing an opportunity for data ingestion.

        If your infrastructure is already set up—including the source database and table with data, results database and table, error report S3 bucket, SNS topic, and IAM role—you can create a scheduled query as follows:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.timestreamquery.ScheduledQuery("example",
            execution_role_arn=example_aws_iam_role["arn"],
            name=example_aws_timestreamwrite_table["tableName"],
            query_string=\"\"\"SELECT region, az, hostname, BIN(time, 15s) AS binned_timestamp,
        \\x09ROUND(AVG(cpu_utilization), 2) AS avg_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.9), 2) AS p90_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.95), 2) AS p95_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.99), 2) AS p99_cpu_utilization
        FROM exampledatabase.exampletable
        WHERE measure_name = 'metrics' AND time > ago(2h)
        GROUP BY region, hostname, az, BIN(time, 15s)
        ORDER BY binned_timestamp ASC
        LIMIT 5
        \"\"\",
            error_report_configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["bucket"],
                },
            },
            notification_configuration={
                "sns_configuration": {
                    "topic_arn": example_aws_sns_topic["arn"],
                },
            },
            schedule_configuration={
                "schedule_expression": "rate(1 hour)",
            },
            target_configuration={
                "timestream_configuration": {
                    "database_name": results["databaseName"],
                    "table_name": results_aws_timestreamwrite_table["tableName"],
                    "time_column": "binned_timestamp",
                    "dimension_mappings": [
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "az",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "region",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "hostname",
                        },
                    ],
                    "multi_measure_mappings": {
                        "target_multi_measure_name": "multi-metrics",
                        "multi_measure_attribute_mappings": [
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "avg_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p90_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p95_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p99_cpu_utilization",
                            },
                        ],
                    },
                },
            })
        ```

        ### Multi-step Example

        To ingest data before creating a scheduled query, this example provides multiple steps:

        1. Create the prerequisite infrastructure
        2. Ingest data
        3. Create the scheduled query

        ### Step 1. Create the prerequisite infrastructure

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        test = aws.s3.Bucket("test",
            bucket="example",
            force_destroy=True)
        test_topic = aws.sns.Topic("test", name="example")
        test_queue = aws.sqs.Queue("test",
            name="example",
            sqs_managed_sse_enabled=True)
        test_topic_subscription = aws.sns.TopicSubscription("test",
            topic=test_topic.arn,
            protocol="sqs",
            endpoint=test_queue.arn)
        test_queue_policy = aws.sqs.QueuePolicy("test",
            queue_url=test_queue.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Principal": {
                        "AWS": "*",
                    },
                    "Action": ["sqs:SendMessage"],
                    "Resource": test_queue.arn,
                    "Condition": {
                        "ArnEquals": {
                            "aws:SourceArn": test_topic.arn,
                        },
                    },
                }],
            }))
        test_role = aws.iam.Role("test",
            name="example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "timestream.amazonaws.com",
                    },
                    "Action": "sts:AssumeRole",
                }],
            }),
            tags={
                "Name": "example",
            })
        test_role_policy = aws.iam.RolePolicy("test",
            name="example",
            role=test_role.id,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "kms:Decrypt",
                        "sns:Publish",
                        "timestream:describeEndpoints",
                        "timestream:Select",
                        "timestream:SelectValues",
                        "timestream:WriteRecords",
                        "s3:PutObject",
                    ],
                    "Resource": "*",
                    "Effect": "Allow",
                }],
            }))
        test_database = aws.timestreamwrite.Database("test", database_name="exampledatabase")
        test_table = aws.timestreamwrite.Table("test",
            database_name=test_database.database_name,
            table_name="exampletable",
            magnetic_store_write_properties={
                "enable_magnetic_store_writes": True,
            },
            retention_properties={
                "magnetic_store_retention_period_in_days": 1,
                "memory_store_retention_period_in_hours": 1,
            })
        results = aws.timestreamwrite.Database("results", database_name="exampledatabase-results")
        results_table = aws.timestreamwrite.Table("results",
            database_name=results.database_name,
            table_name="exampletable-results",
            magnetic_store_write_properties={
                "enable_magnetic_store_writes": True,
            },
            retention_properties={
                "magnetic_store_retention_period_in_days": 1,
                "memory_store_retention_period_in_hours": 1,
            })
        ```

        #### Step 2. Ingest data

        This is done with Amazon Timestream Write [WriteRecords](https://docs.aws.amazon.com/timestream/latest/developerguide/API_WriteRecords.html).

        ### Step 3. Create the scheduled query

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.timestreamquery.ScheduledQuery("example",
            execution_role_arn=example_aws_iam_role["arn"],
            name=example_aws_timestreamwrite_table["tableName"],
            query_string=\"\"\"SELECT region, az, hostname, BIN(time, 15s) AS binned_timestamp,
        \\x09ROUND(AVG(cpu_utilization), 2) AS avg_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.9), 2) AS p90_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.95), 2) AS p95_cpu_utilization,
        \\x09ROUND(APPROX_PERCENTILE(cpu_utilization, 0.99), 2) AS p99_cpu_utilization
        FROM exampledatabase.exampletable
        WHERE measure_name = 'metrics' AND time > ago(2h)
        GROUP BY region, hostname, az, BIN(time, 15s)
        ORDER BY binned_timestamp ASC
        LIMIT 5
        \"\"\",
            error_report_configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["bucket"],
                },
            },
            notification_configuration={
                "sns_configuration": {
                    "topic_arn": example_aws_sns_topic["arn"],
                },
            },
            schedule_configuration={
                "schedule_expression": "rate(1 hour)",
            },
            target_configuration={
                "timestream_configuration": {
                    "database_name": results["databaseName"],
                    "table_name": results_aws_timestreamwrite_table["tableName"],
                    "time_column": "binned_timestamp",
                    "dimension_mappings": [
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "az",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "region",
                        },
                        {
                            "dimension_value_type": "VARCHAR",
                            "name": "hostname",
                        },
                    ],
                    "multi_measure_mappings": {
                        "target_multi_measure_name": "multi-metrics",
                        "multi_measure_attribute_mappings": [
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "avg_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p90_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p95_cpu_utilization",
                            },
                            {
                                "measure_value_type": "DOUBLE",
                                "source_column": "p99_cpu_utilization",
                            },
                        ],
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Timestream Query Scheduled Query using the `arn`. For example:

        ```sh
        $ pulumi import aws:timestreamquery/scheduledQuery:ScheduledQuery example arn:aws:timestream:us-west-2:012345678901:scheduled-query/tf-acc-test-7774188528604787105-e13659544fe66c8d
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 error_report_configuration: Optional[pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_run_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryLastRunSummaryArgs', 'ScheduledQueryLastRunSummaryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']]] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 recently_failed_runs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRecentlyFailedRunArgs', 'ScheduledQueryRecentlyFailedRunArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_configuration: Optional[pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['ScheduledQueryTimeoutsArgs', 'ScheduledQueryTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledQueryArgs.__new__(ScheduledQueryArgs)

            if error_report_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'error_report_configuration'")
            __props__.__dict__["error_report_configuration"] = error_report_configuration
            if execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role_arn'")
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["last_run_summaries"] = last_run_summaries
            __props__.__dict__["name"] = name
            if notification_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'notification_configuration'")
            __props__.__dict__["notification_configuration"] = notification_configuration
            if query_string is None and not opts.urn:
                raise TypeError("Missing required property 'query_string'")
            __props__.__dict__["query_string"] = query_string
            __props__.__dict__["recently_failed_runs"] = recently_failed_runs
            __props__.__dict__["region"] = region
            if schedule_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_configuration'")
            __props__.__dict__["schedule_configuration"] = schedule_configuration
            __props__.__dict__["tags"] = tags
            if target_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'target_configuration'")
            __props__.__dict__["target_configuration"] = target_configuration
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["next_invocation_time"] = None
            __props__.__dict__["previous_invocation_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
        super(ScheduledQuery, __self__).__init__(
            'aws:timestreamquery/scheduledQuery:ScheduledQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            creation_time: Optional[pulumi.Input[builtins.str]] = None,
            error_report_configuration: Optional[pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']]] = None,
            execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            last_run_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryLastRunSummaryArgs', 'ScheduledQueryLastRunSummaryArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            next_invocation_time: Optional[pulumi.Input[builtins.str]] = None,
            notification_configuration: Optional[pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']]] = None,
            previous_invocation_time: Optional[pulumi.Input[builtins.str]] = None,
            query_string: Optional[pulumi.Input[builtins.str]] = None,
            recently_failed_runs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRecentlyFailedRunArgs', 'ScheduledQueryRecentlyFailedRunArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            schedule_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_configuration: Optional[pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']]] = None,
            timeouts: Optional[pulumi.Input[Union['ScheduledQueryTimeoutsArgs', 'ScheduledQueryTimeoutsArgsDict']]] = None) -> 'ScheduledQuery':
        """
        Get an existing ScheduledQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Scheduled Query.
        :param pulumi.Input[builtins.str] creation_time: Creation time for the scheduled query.
        :param pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']] error_report_configuration: Configuration block for error reporting configuration. See below.
        :param pulumi.Input[builtins.str] execution_role_arn: ARN for the IAM role that Timestream will assume when running the scheduled query.
        :param pulumi.Input[builtins.str] kms_key_id: Amazon KMS key used to encrypt the scheduled query resource, at-rest. If not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with "alias/". If `error_report_configuration` uses `SSE_KMS` as the encryption type, the same `kms_key_id` is used to encrypt the error report at rest.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryLastRunSummaryArgs', 'ScheduledQueryLastRunSummaryArgsDict']]]] last_run_summaries: Runtime summary for the last scheduled query run.
        :param pulumi.Input[builtins.str] name: Name of the scheduled query.
        :param pulumi.Input[builtins.str] next_invocation_time: Next time the scheduled query is scheduled to run.
        :param pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']] notification_configuration: Configuration block for notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is created, its state is updated, or when it is deleted. See below.
        :param pulumi.Input[builtins.str] previous_invocation_time: Last time the scheduled query was run.
        :param pulumi.Input[builtins.str] query_string: Query string to run. Parameter names can be specified in the query string using the `@` character followed by an identifier. The named parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the `schedule_configuration` parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRecentlyFailedRunArgs', 'ScheduledQueryRecentlyFailedRunArgsDict']]]] recently_failed_runs: Runtime summary for the last five failed scheduled query runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']] schedule_configuration: Configuration block for schedule configuration for the query. See below.
        :param pulumi.Input[builtins.str] state: State of the scheduled query, either `ENABLED` or `DISABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']] target_configuration: Configuration block for writing the result of a query. See below.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledQueryState.__new__(_ScheduledQueryState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["error_report_configuration"] = error_report_configuration
        __props__.__dict__["execution_role_arn"] = execution_role_arn
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["last_run_summaries"] = last_run_summaries
        __props__.__dict__["name"] = name
        __props__.__dict__["next_invocation_time"] = next_invocation_time
        __props__.__dict__["notification_configuration"] = notification_configuration
        __props__.__dict__["previous_invocation_time"] = previous_invocation_time
        __props__.__dict__["query_string"] = query_string
        __props__.__dict__["recently_failed_runs"] = recently_failed_runs
        __props__.__dict__["region"] = region
        __props__.__dict__["schedule_configuration"] = schedule_configuration
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_configuration"] = target_configuration
        __props__.__dict__["timeouts"] = timeouts
        return ScheduledQuery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Scheduled Query.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        Creation time for the scheduled query.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="errorReportConfiguration")
    def error_report_configuration(self) -> pulumi.Output['outputs.ScheduledQueryErrorReportConfiguration']:
        """
        Configuration block for error reporting configuration. See below.
        """
        return pulumi.get(self, "error_report_configuration")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN for the IAM role that Timestream will assume when running the scheduled query.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Amazon KMS key used to encrypt the scheduled query resource, at-rest. If not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with "alias/". If `error_report_configuration` uses `SSE_KMS` as the encryption type, the same `kms_key_id` is used to encrypt the error report at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastRunSummaries")
    def last_run_summaries(self) -> pulumi.Output[Optional[Sequence['outputs.ScheduledQueryLastRunSummary']]]:
        """
        Runtime summary for the last scheduled query run.
        """
        return pulumi.get(self, "last_run_summaries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the scheduled query.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextInvocationTime")
    def next_invocation_time(self) -> pulumi.Output[builtins.str]:
        """
        Next time the scheduled query is scheduled to run.
        """
        return pulumi.get(self, "next_invocation_time")

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Output['outputs.ScheduledQueryNotificationConfiguration']:
        """
        Configuration block for notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is created, its state is updated, or when it is deleted. See below.
        """
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="previousInvocationTime")
    def previous_invocation_time(self) -> pulumi.Output[builtins.str]:
        """
        Last time the scheduled query was run.
        """
        return pulumi.get(self, "previous_invocation_time")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[builtins.str]:
        """
        Query string to run. Parameter names can be specified in the query string using the `@` character followed by an identifier. The named parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the `schedule_configuration` parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="recentlyFailedRuns")
    def recently_failed_runs(self) -> pulumi.Output[Optional[Sequence['outputs.ScheduledQueryRecentlyFailedRun']]]:
        """
        Runtime summary for the last five failed scheduled query runs.
        """
        return pulumi.get(self, "recently_failed_runs")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scheduleConfiguration")
    def schedule_configuration(self) -> pulumi.Output['outputs.ScheduledQueryScheduleConfiguration']:
        """
        Configuration block for schedule configuration for the query. See below.
        """
        return pulumi.get(self, "schedule_configuration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the scheduled query, either `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> pulumi.Output['outputs.ScheduledQueryTargetConfiguration']:
        """
        Configuration block for writing the result of a query. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_configuration")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ScheduledQueryTimeouts']]:
        return pulumi.get(self, "timeouts")

