# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LanguageModelArgs', 'LanguageModel']

@pulumi.input_type
class LanguageModelArgs:
    def __init__(__self__, *,
                 base_model_name: pulumi.Input[builtins.str],
                 input_data_config: pulumi.Input['LanguageModelInputDataConfigArgs'],
                 language_code: pulumi.Input[builtins.str],
                 model_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a LanguageModel resource.
        :param pulumi.Input[builtins.str] base_model_name: Name of reference base model.
        :param pulumi.Input['LanguageModelInputDataConfigArgs'] input_data_config: The input data config for the LanguageModel. See Input Data Config for more details.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
        :param pulumi.Input[builtins.str] model_name: The model name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "base_model_name", base_model_name)
        pulumi.set(__self__, "input_data_config", input_data_config)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "model_name", model_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="baseModelName")
    def base_model_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of reference base model.
        """
        return pulumi.get(self, "base_model_name")

    @base_model_name.setter
    def base_model_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "base_model_name", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Input['LanguageModelInputDataConfigArgs']:
        """
        The input data config for the LanguageModel. See Input Data Config for more details.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: pulumi.Input['LanguageModelInputDataConfigArgs']):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input[builtins.str]:
        """
        The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Input[builtins.str]:
        """
        The model name.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LanguageModelState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 base_model_name: Optional[pulumi.Input[builtins.str]] = None,
                 input_data_config: Optional[pulumi.Input['LanguageModelInputDataConfigArgs']] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LanguageModel resources.
        :param pulumi.Input[builtins.str] arn: ARN of the LanguageModel.
        :param pulumi.Input[builtins.str] base_model_name: Name of reference base model.
        :param pulumi.Input['LanguageModelInputDataConfigArgs'] input_data_config: The input data config for the LanguageModel. See Input Data Config for more details.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
        :param pulumi.Input[builtins.str] model_name: The model name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if base_model_name is not None:
            pulumi.set(__self__, "base_model_name", base_model_name)
        if input_data_config is not None:
            pulumi.set(__self__, "input_data_config", input_data_config)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the LanguageModel.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="baseModelName")
    def base_model_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of reference base model.
        """
        return pulumi.get(self, "base_model_name")

    @base_model_name.setter
    def base_model_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_model_name", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> Optional[pulumi.Input['LanguageModelInputDataConfigArgs']]:
        """
        The input data config for the LanguageModel. See Input Data Config for more details.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: Optional[pulumi.Input['LanguageModelInputDataConfigArgs']]):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The model name.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:transcribe/languageModel:LanguageModel")
class LanguageModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_model_name: Optional[pulumi.Input[builtins.str]] = None,
                 input_data_config: Optional[pulumi.Input[Union['LanguageModelInputDataConfigArgs', 'LanguageModelInputDataConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Transcribe LanguageModel.

        > This resource can take a significant amount of time to provision. See Language Model [FAQ](https://aws.amazon.com/transcribe/faqs/) for more details.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["transcribe.amazonaws.com"],
            }],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=example.json)
        test_policy = aws.iam.RolePolicy("test_policy",
            name="example",
            role=example_role.id,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "s3:GetObject",
                        "s3:ListBucket",
                    ],
                    "Effect": "Allow",
                    "Resource": ["*"],
                }],
            }))
        example_bucket = aws.s3.Bucket("example",
            bucket="example-transcribe",
            force_destroy=True)
        object = aws.s3.BucketObjectv2("object",
            bucket=example_bucket.id,
            key="transcribe/test1.txt",
            source=pulumi.FileAsset("test1.txt"))
        example_language_model = aws.transcribe.LanguageModel("example",
            model_name="example",
            base_model_name="NarrowBand",
            input_data_config={
                "data_access_role_arn": example_role.arn,
                "s3_uri": example_bucket.id.apply(lambda id: f"s3://{id}/transcribe/"),
            },
            language_code="en-US",
            tags={
                "ENVIRONMENT": "development",
            })
        ```

        ## Import

        Using `pulumi import`, import Transcribe LanguageModel using the `model_name`. For example:

        ```sh
        $ pulumi import aws:transcribe/languageModel:LanguageModel example example-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] base_model_name: Name of reference base model.
        :param pulumi.Input[Union['LanguageModelInputDataConfigArgs', 'LanguageModelInputDataConfigArgsDict']] input_data_config: The input data config for the LanguageModel. See Input Data Config for more details.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
        :param pulumi.Input[builtins.str] model_name: The model name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LanguageModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Transcribe LanguageModel.

        > This resource can take a significant amount of time to provision. See Language Model [FAQ](https://aws.amazon.com/transcribe/faqs/) for more details.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["transcribe.amazonaws.com"],
            }],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=example.json)
        test_policy = aws.iam.RolePolicy("test_policy",
            name="example",
            role=example_role.id,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": [
                        "s3:GetObject",
                        "s3:ListBucket",
                    ],
                    "Effect": "Allow",
                    "Resource": ["*"],
                }],
            }))
        example_bucket = aws.s3.Bucket("example",
            bucket="example-transcribe",
            force_destroy=True)
        object = aws.s3.BucketObjectv2("object",
            bucket=example_bucket.id,
            key="transcribe/test1.txt",
            source=pulumi.FileAsset("test1.txt"))
        example_language_model = aws.transcribe.LanguageModel("example",
            model_name="example",
            base_model_name="NarrowBand",
            input_data_config={
                "data_access_role_arn": example_role.arn,
                "s3_uri": example_bucket.id.apply(lambda id: f"s3://{id}/transcribe/"),
            },
            language_code="en-US",
            tags={
                "ENVIRONMENT": "development",
            })
        ```

        ## Import

        Using `pulumi import`, import Transcribe LanguageModel using the `model_name`. For example:

        ```sh
        $ pulumi import aws:transcribe/languageModel:LanguageModel example example-name
        ```

        :param str resource_name: The name of the resource.
        :param LanguageModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LanguageModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_model_name: Optional[pulumi.Input[builtins.str]] = None,
                 input_data_config: Optional[pulumi.Input[Union['LanguageModelInputDataConfigArgs', 'LanguageModelInputDataConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LanguageModelArgs.__new__(LanguageModelArgs)

            if base_model_name is None and not opts.urn:
                raise TypeError("Missing required property 'base_model_name'")
            __props__.__dict__["base_model_name"] = base_model_name
            if input_data_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_data_config'")
            __props__.__dict__["input_data_config"] = input_data_config
            if language_code is None and not opts.urn:
                raise TypeError("Missing required property 'language_code'")
            __props__.__dict__["language_code"] = language_code
            if model_name is None and not opts.urn:
                raise TypeError("Missing required property 'model_name'")
            __props__.__dict__["model_name"] = model_name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(LanguageModel, __self__).__init__(
            'aws:transcribe/languageModel:LanguageModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            base_model_name: Optional[pulumi.Input[builtins.str]] = None,
            input_data_config: Optional[pulumi.Input[Union['LanguageModelInputDataConfigArgs', 'LanguageModelInputDataConfigArgsDict']]] = None,
            language_code: Optional[pulumi.Input[builtins.str]] = None,
            model_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'LanguageModel':
        """
        Get an existing LanguageModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the LanguageModel.
        :param pulumi.Input[builtins.str] base_model_name: Name of reference base model.
        :param pulumi.Input[Union['LanguageModelInputDataConfigArgs', 'LanguageModelInputDataConfigArgsDict']] input_data_config: The input data config for the LanguageModel. See Input Data Config for more details.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
        :param pulumi.Input[builtins.str] model_name: The model name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LanguageModelState.__new__(_LanguageModelState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["base_model_name"] = base_model_name
        __props__.__dict__["input_data_config"] = input_data_config
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["model_name"] = model_name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return LanguageModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the LanguageModel.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="baseModelName")
    def base_model_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of reference base model.
        """
        return pulumi.get(self, "base_model_name")

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Output['outputs.LanguageModelInputDataConfig']:
        """
        The input data config for the LanguageModel. See Input Data Config for more details.
        """
        return pulumi.get(self, "input_data_config")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[builtins.str]:
        """
        The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Output[builtins.str]:
        """
        The model name.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

