# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VocabularyArgs', 'Vocabulary']

@pulumi.input_type
class VocabularyArgs:
    def __init__(__self__, *,
                 language_code: pulumi.Input[builtins.str],
                 vocabulary_name: pulumi.Input[builtins.str],
                 phrases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vocabulary_file_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Vocabulary resource.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your vocabulary.
        :param pulumi.Input[builtins.str] vocabulary_name: The name of the Vocabulary.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] phrases: A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] vocabulary_file_uri: The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
        """
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "vocabulary_name", vocabulary_name)
        if phrases is not None:
            pulumi.set(__self__, "phrases", phrases)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vocabulary_file_uri is not None:
            pulumi.set(__self__, "vocabulary_file_uri", vocabulary_file_uri)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input[builtins.str]:
        """
        The language code you selected for your vocabulary.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="vocabularyName")
    def vocabulary_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Vocabulary.

        The following arguments are optional:
        """
        return pulumi.get(self, "vocabulary_name")

    @vocabulary_name.setter
    def vocabulary_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vocabulary_name", value)

    @property
    @pulumi.getter
    def phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
        """
        return pulumi.get(self, "phrases")

    @phrases.setter
    def phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "phrases", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vocabularyFileUri")
    def vocabulary_file_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
        """
        return pulumi.get(self, "vocabulary_file_uri")

    @vocabulary_file_uri.setter
    def vocabulary_file_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vocabulary_file_uri", value)


@pulumi.input_type
class _VocabularyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 download_uri: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 phrases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vocabulary_file_uri: Optional[pulumi.Input[builtins.str]] = None,
                 vocabulary_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Vocabulary resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Vocabulary.
        :param pulumi.Input[builtins.str] download_uri: Generated download URI.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your vocabulary.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] phrases: A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] vocabulary_file_uri: The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
        :param pulumi.Input[builtins.str] vocabulary_name: The name of the Vocabulary.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if download_uri is not None:
            pulumi.set(__self__, "download_uri", download_uri)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if phrases is not None:
            pulumi.set(__self__, "phrases", phrases)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vocabulary_file_uri is not None:
            pulumi.set(__self__, "vocabulary_file_uri", vocabulary_file_uri)
        if vocabulary_name is not None:
            pulumi.set(__self__, "vocabulary_name", vocabulary_name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Vocabulary.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="downloadUri")
    def download_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Generated download URI.
        """
        return pulumi.get(self, "download_uri")

    @download_uri.setter
    def download_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "download_uri", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language code you selected for your vocabulary.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
        """
        return pulumi.get(self, "phrases")

    @phrases.setter
    def phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "phrases", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vocabularyFileUri")
    def vocabulary_file_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
        """
        return pulumi.get(self, "vocabulary_file_uri")

    @vocabulary_file_uri.setter
    def vocabulary_file_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vocabulary_file_uri", value)

    @property
    @pulumi.getter(name="vocabularyName")
    def vocabulary_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Vocabulary.

        The following arguments are optional:
        """
        return pulumi.get(self, "vocabulary_name")

    @vocabulary_name.setter
    def vocabulary_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vocabulary_name", value)


@pulumi.type_token("aws:transcribe/vocabulary:Vocabulary")
class Vocabulary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 phrases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vocabulary_file_uri: Optional[pulumi.Input[builtins.str]] = None,
                 vocabulary_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Transcribe Vocabulary.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example",
            bucket="example-vocab-123",
            force_destroy=True)
        object = aws.s3.BucketObjectv2("object",
            bucket=example.id,
            key="transcribe/test1.txt",
            source=pulumi.FileAsset("test.txt"))
        example_vocabulary = aws.transcribe.Vocabulary("example",
            vocabulary_name="example",
            language_code="en-US",
            vocabulary_file_uri=pulumi.Output.all(
                id=example.id,
                key=object.key
        ).apply(lambda resolved_outputs: f"s3://{resolved_outputs['id']}/{resolved_outputs['key']}")
        ,
            tags={
                "tag1": "value1",
                "tag2": "value3",
            },
            opts = pulumi.ResourceOptions(depends_on=[object]))
        ```

        ## Import

        Using `pulumi import`, import Transcribe Vocabulary using the `vocabulary_name`. For example:

        ```sh
        $ pulumi import aws:transcribe/vocabulary:Vocabulary example example-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your vocabulary.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] phrases: A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] vocabulary_file_uri: The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
        :param pulumi.Input[builtins.str] vocabulary_name: The name of the Vocabulary.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VocabularyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Transcribe Vocabulary.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example",
            bucket="example-vocab-123",
            force_destroy=True)
        object = aws.s3.BucketObjectv2("object",
            bucket=example.id,
            key="transcribe/test1.txt",
            source=pulumi.FileAsset("test.txt"))
        example_vocabulary = aws.transcribe.Vocabulary("example",
            vocabulary_name="example",
            language_code="en-US",
            vocabulary_file_uri=pulumi.Output.all(
                id=example.id,
                key=object.key
        ).apply(lambda resolved_outputs: f"s3://{resolved_outputs['id']}/{resolved_outputs['key']}")
        ,
            tags={
                "tag1": "value1",
                "tag2": "value3",
            },
            opts = pulumi.ResourceOptions(depends_on=[object]))
        ```

        ## Import

        Using `pulumi import`, import Transcribe Vocabulary using the `vocabulary_name`. For example:

        ```sh
        $ pulumi import aws:transcribe/vocabulary:Vocabulary example example-name
        ```

        :param str resource_name: The name of the resource.
        :param VocabularyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VocabularyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 phrases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vocabulary_file_uri: Optional[pulumi.Input[builtins.str]] = None,
                 vocabulary_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VocabularyArgs.__new__(VocabularyArgs)

            if language_code is None and not opts.urn:
                raise TypeError("Missing required property 'language_code'")
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["phrases"] = phrases
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vocabulary_file_uri"] = vocabulary_file_uri
            if vocabulary_name is None and not opts.urn:
                raise TypeError("Missing required property 'vocabulary_name'")
            __props__.__dict__["vocabulary_name"] = vocabulary_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["download_uri"] = None
            __props__.__dict__["tags_all"] = None
        super(Vocabulary, __self__).__init__(
            'aws:transcribe/vocabulary:Vocabulary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            download_uri: Optional[pulumi.Input[builtins.str]] = None,
            language_code: Optional[pulumi.Input[builtins.str]] = None,
            phrases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            vocabulary_file_uri: Optional[pulumi.Input[builtins.str]] = None,
            vocabulary_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Vocabulary':
        """
        Get an existing Vocabulary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Vocabulary.
        :param pulumi.Input[builtins.str] download_uri: Generated download URI.
        :param pulumi.Input[builtins.str] language_code: The language code you selected for your vocabulary.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] phrases: A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] vocabulary_file_uri: The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
        :param pulumi.Input[builtins.str] vocabulary_name: The name of the Vocabulary.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VocabularyState.__new__(_VocabularyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["download_uri"] = download_uri
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["phrases"] = phrases
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vocabulary_file_uri"] = vocabulary_file_uri
        __props__.__dict__["vocabulary_name"] = vocabulary_name
        return Vocabulary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Vocabulary.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="downloadUri")
    def download_uri(self) -> pulumi.Output[builtins.str]:
        """
        Generated download URI.
        """
        return pulumi.get(self, "download_uri")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[builtins.str]:
        """
        The language code you selected for your vocabulary.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def phrases(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
        """
        return pulumi.get(self, "phrases")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vocabularyFileUri")
    def vocabulary_file_uri(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
        """
        return pulumi.get(self, "vocabulary_file_uri")

    @property
    @pulumi.getter(name="vocabularyName")
    def vocabulary_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Vocabulary.

        The following arguments are optional:
        """
        return pulumi.get(self, "vocabulary_name")

