# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorArgs', 'Connector']

@pulumi.input_type
class ConnectorArgs:
    def __init__(__self__, *,
                 access_role: pulumi.Input[builtins.str],
                 url: pulumi.Input[builtins.str],
                 as2_config: Optional[pulumi.Input['ConnectorAs2ConfigArgs']] = None,
                 logging_role: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 sftp_config: Optional[pulumi.Input['ConnectorSftpConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Connector resource.
        :param pulumi.Input[builtins.str] access_role: The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
        :param pulumi.Input[builtins.str] url: The URL of the partners AS2 endpoint or SFTP endpoint.
        :param pulumi.Input['ConnectorAs2ConfigArgs'] as2_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[builtins.str] logging_role: The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_policy_name: Name of the security policy for the connector.
        :param pulumi.Input['ConnectorSftpConfigArgs'] sftp_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "access_role", access_role)
        pulumi.set(__self__, "url", url)
        if as2_config is not None:
            pulumi.set(__self__, "as2_config", as2_config)
        if logging_role is not None:
            pulumi.set(__self__, "logging_role", logging_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_policy_name is not None:
            pulumi.set(__self__, "security_policy_name", security_policy_name)
        if sftp_config is not None:
            pulumi.set(__self__, "sftp_config", sftp_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessRole")
    def access_role(self) -> pulumi.Input[builtins.str]:
        """
        The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
        """
        return pulumi.get(self, "access_role")

    @access_role.setter
    def access_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access_role", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        The URL of the partners AS2 endpoint or SFTP endpoint.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="as2Config")
    def as2_config(self) -> Optional[pulumi.Input['ConnectorAs2ConfigArgs']]:
        """
        Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        """
        return pulumi.get(self, "as2_config")

    @as2_config.setter
    def as2_config(self, value: Optional[pulumi.Input['ConnectorAs2ConfigArgs']]):
        pulumi.set(self, "as2_config", value)

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
        """
        return pulumi.get(self, "logging_role")

    @logging_role.setter
    def logging_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logging_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the security policy for the connector.
        """
        return pulumi.get(self, "security_policy_name")

    @security_policy_name.setter
    def security_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_policy_name", value)

    @property
    @pulumi.getter(name="sftpConfig")
    def sftp_config(self) -> Optional[pulumi.Input['ConnectorSftpConfigArgs']]:
        """
        Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        """
        return pulumi.get(self, "sftp_config")

    @sftp_config.setter
    def sftp_config(self, value: Optional[pulumi.Input['ConnectorSftpConfigArgs']]):
        pulumi.set(self, "sftp_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConnectorState:
    def __init__(__self__, *,
                 access_role: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 as2_config: Optional[pulumi.Input['ConnectorAs2ConfigArgs']] = None,
                 connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 logging_role: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 sftp_config: Optional[pulumi.Input['ConnectorSftpConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connector resources.
        :param pulumi.Input[builtins.str] access_role: The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
        :param pulumi.Input[builtins.str] arn: The ARN of the connector.
        :param pulumi.Input['ConnectorAs2ConfigArgs'] as2_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[builtins.str] connector_id: The unique identifier for the AS2 profile or SFTP Profile.
        :param pulumi.Input[builtins.str] logging_role: The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_policy_name: Name of the security policy for the connector.
        :param pulumi.Input['ConnectorSftpConfigArgs'] sftp_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] url: The URL of the partners AS2 endpoint or SFTP endpoint.
        """
        if access_role is not None:
            pulumi.set(__self__, "access_role", access_role)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if as2_config is not None:
            pulumi.set(__self__, "as2_config", as2_config)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if logging_role is not None:
            pulumi.set(__self__, "logging_role", logging_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_policy_name is not None:
            pulumi.set(__self__, "security_policy_name", security_policy_name)
        if sftp_config is not None:
            pulumi.set(__self__, "sftp_config", sftp_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accessRole")
    def access_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
        """
        return pulumi.get(self, "access_role")

    @access_role.setter
    def access_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_role", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the connector.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="as2Config")
    def as2_config(self) -> Optional[pulumi.Input['ConnectorAs2ConfigArgs']]:
        """
        Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        """
        return pulumi.get(self, "as2_config")

    @as2_config.setter
    def as2_config(self, value: Optional[pulumi.Input['ConnectorAs2ConfigArgs']]):
        pulumi.set(self, "as2_config", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the AS2 profile or SFTP Profile.
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
        """
        return pulumi.get(self, "logging_role")

    @logging_role.setter
    def logging_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logging_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the security policy for the connector.
        """
        return pulumi.get(self, "security_policy_name")

    @security_policy_name.setter
    def security_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_policy_name", value)

    @property
    @pulumi.getter(name="sftpConfig")
    def sftp_config(self) -> Optional[pulumi.Input['ConnectorSftpConfigArgs']]:
        """
        Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        """
        return pulumi.get(self, "sftp_config")

    @sftp_config.setter
    def sftp_config(self, value: Optional[pulumi.Input['ConnectorSftpConfigArgs']]):
        pulumi.set(self, "sftp_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the partners AS2 endpoint or SFTP endpoint.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("aws:transfer/connector:Connector")
class Connector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_role: Optional[pulumi.Input[builtins.str]] = None,
                 as2_config: Optional[pulumi.Input[Union['ConnectorAs2ConfigArgs', 'ConnectorAs2ConfigArgsDict']]] = None,
                 logging_role: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 sftp_config: Optional[pulumi.Input[Union['ConnectorSftpConfigArgs', 'ConnectorSftpConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a AWS Transfer AS2 Connector resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Connector("example",
            access_role=test["arn"],
            as2_config={
                "compression": "DISABLED",
                "encryption_algorithm": "AWS128_CBC",
                "message_subject": "For Connector",
                "local_profile_id": local["profileId"],
                "mdn_response": "NONE",
                "mdn_signing_algorithm": "NONE",
                "partner_profile_id": partner["profileId"],
                "signing_algorithm": "NONE",
            },
            url="http://www.test.com")
        ```

        ### SFTP Connector

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Connector("example",
            access_role=test["arn"],
            sftp_config={
                "trusted_host_keys": ["ssh-rsa AAAAB3NYourKeysHere"],
                "user_secret_id": example_aws_secretsmanager_secret["id"],
            },
            url="sftp://test.com")
        ```

        ## Import

        Using `pulumi import`, import Transfer AS2 Connector using the `connector_id`. For example:

        ```sh
        $ pulumi import aws:transfer/connector:Connector example c-4221a88afd5f4362a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_role: The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
        :param pulumi.Input[Union['ConnectorAs2ConfigArgs', 'ConnectorAs2ConfigArgsDict']] as2_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[builtins.str] logging_role: The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_policy_name: Name of the security policy for the connector.
        :param pulumi.Input[Union['ConnectorSftpConfigArgs', 'ConnectorSftpConfigArgsDict']] sftp_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] url: The URL of the partners AS2 endpoint or SFTP endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AWS Transfer AS2 Connector resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Connector("example",
            access_role=test["arn"],
            as2_config={
                "compression": "DISABLED",
                "encryption_algorithm": "AWS128_CBC",
                "message_subject": "For Connector",
                "local_profile_id": local["profileId"],
                "mdn_response": "NONE",
                "mdn_signing_algorithm": "NONE",
                "partner_profile_id": partner["profileId"],
                "signing_algorithm": "NONE",
            },
            url="http://www.test.com")
        ```

        ### SFTP Connector

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Connector("example",
            access_role=test["arn"],
            sftp_config={
                "trusted_host_keys": ["ssh-rsa AAAAB3NYourKeysHere"],
                "user_secret_id": example_aws_secretsmanager_secret["id"],
            },
            url="sftp://test.com")
        ```

        ## Import

        Using `pulumi import`, import Transfer AS2 Connector using the `connector_id`. For example:

        ```sh
        $ pulumi import aws:transfer/connector:Connector example c-4221a88afd5f4362a
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_role: Optional[pulumi.Input[builtins.str]] = None,
                 as2_config: Optional[pulumi.Input[Union['ConnectorAs2ConfigArgs', 'ConnectorAs2ConfigArgsDict']]] = None,
                 logging_role: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 sftp_config: Optional[pulumi.Input[Union['ConnectorSftpConfigArgs', 'ConnectorSftpConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorArgs.__new__(ConnectorArgs)

            if access_role is None and not opts.urn:
                raise TypeError("Missing required property 'access_role'")
            __props__.__dict__["access_role"] = access_role
            __props__.__dict__["as2_config"] = as2_config
            __props__.__dict__["logging_role"] = logging_role
            __props__.__dict__["region"] = region
            __props__.__dict__["security_policy_name"] = security_policy_name
            __props__.__dict__["sftp_config"] = sftp_config
            __props__.__dict__["tags"] = tags
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["arn"] = None
            __props__.__dict__["connector_id"] = None
            __props__.__dict__["tags_all"] = None
        super(Connector, __self__).__init__(
            'aws:transfer/connector:Connector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_role: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            as2_config: Optional[pulumi.Input[Union['ConnectorAs2ConfigArgs', 'ConnectorAs2ConfigArgsDict']]] = None,
            connector_id: Optional[pulumi.Input[builtins.str]] = None,
            logging_role: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
            sftp_config: Optional[pulumi.Input[Union['ConnectorSftpConfigArgs', 'ConnectorSftpConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'Connector':
        """
        Get an existing Connector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_role: The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
        :param pulumi.Input[builtins.str] arn: The ARN of the connector.
        :param pulumi.Input[Union['ConnectorAs2ConfigArgs', 'ConnectorAs2ConfigArgsDict']] as2_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[builtins.str] connector_id: The unique identifier for the AS2 profile or SFTP Profile.
        :param pulumi.Input[builtins.str] logging_role: The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_policy_name: Name of the security policy for the connector.
        :param pulumi.Input[Union['ConnectorSftpConfigArgs', 'ConnectorSftpConfigArgsDict']] sftp_config: Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] url: The URL of the partners AS2 endpoint or SFTP endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorState.__new__(_ConnectorState)

        __props__.__dict__["access_role"] = access_role
        __props__.__dict__["arn"] = arn
        __props__.__dict__["as2_config"] = as2_config
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["logging_role"] = logging_role
        __props__.__dict__["region"] = region
        __props__.__dict__["security_policy_name"] = security_policy_name
        __props__.__dict__["sftp_config"] = sftp_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["url"] = url
        return Connector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessRole")
    def access_role(self) -> pulumi.Output[builtins.str]:
        """
        The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
        """
        return pulumi.get(self, "access_role")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the connector.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="as2Config")
    def as2_config(self) -> pulumi.Output[Optional['outputs.ConnectorAs2Config']]:
        """
        Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        """
        return pulumi.get(self, "as2_config")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the AS2 profile or SFTP Profile.
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
        """
        return pulumi.get(self, "logging_role")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the security policy for the connector.
        """
        return pulumi.get(self, "security_policy_name")

    @property
    @pulumi.getter(name="sftpConfig")
    def sftp_config(self) -> pulumi.Output[Optional['outputs.ConnectorSftpConfig']]:
        """
        Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
        """
        return pulumi.get(self, "sftp_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the partners AS2 endpoint or SFTP endpoint.
        """
        return pulumi.get(self, "url")

