# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SshKeyArgs', 'SshKey']

@pulumi.input_type
class SshKeyArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[builtins.str],
                 server_id: pulumi.Input[builtins.str],
                 user_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SshKey resource.
        :param pulumi.Input[builtins.str] body: The public key portion of an SSH key pair.
        :param pulumi.Input[builtins.str] server_id: The Server ID of the Transfer Server (e.g., `s-12345678`)
        :param pulumi.Input[builtins.str] user_name: The name of the user account that is assigned to one or more servers.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "user_name", user_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Input[builtins.str]:
        """
        The public key portion of an SSH key pair.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[builtins.str]:
        """
        The Server ID of the Transfer Server (e.g., `s-12345678`)
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the user account that is assigned to one or more servers.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SshKeyState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 server_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SshKey resources.
        :param pulumi.Input[builtins.str] body: The public key portion of an SSH key pair.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] server_id: The Server ID of the Transfer Server (e.g., `s-12345678`)
        :param pulumi.Input[builtins.str] user_name: The name of the user account that is assigned to one or more servers.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if ssh_key_id is not None:
            pulumi.set(__self__, "ssh_key_id", ssh_key_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The public key portion of an SSH key pair.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Server ID of the Transfer Server (e.g., `s-12345678`)
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_id", value)

    @property
    @pulumi.getter(name="sshKeyId")
    def ssh_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ssh_key_id")

    @ssh_key_id.setter
    def ssh_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_key_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user account that is assigned to one or more servers.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("aws:transfer/sshKey:SshKey")
class SshKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 server_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a AWS Transfer User SSH Key resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std
        import pulumi_tls as tls

        example_private_key = tls.index.PrivateKey("example",
            algorithm=RSA,
            rsa_bits=4096)
        example_server = aws.transfer.Server("example",
            identity_provider_type="SERVICE_MANAGED",
            tags={
                "NAME": "tf-acc-test-transfer-server",
            })
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["transfer.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="tf-test-transfer-user-iam-role",
            assume_role_policy=assume_role.json)
        example_user = aws.transfer.User("example",
            server_id=example_server.id,
            user_name="tftestuser",
            role=example_role.arn,
            tags={
                "NAME": "tftestuser",
            })
        example_ssh_key = aws.transfer.SshKey("example",
            server_id=example_server.id,
            user_name=example_user.user_name,
            body=std.trimspace(input=example_private_key["publicKeyOpenssh"]).result)
        example = aws.iam.get_policy_document(statements=[{
            "sid": "AllowFullAccesstoS3",
            "effect": "Allow",
            "actions": ["s3:*"],
            "resources": ["*"],
        }])
        example_role_policy = aws.iam.RolePolicy("example",
            name="tf-test-transfer-user-iam-policy",
            role=example_role.id,
            policy=example.json)
        ```

        ## Import

        Using `pulumi import`, import Transfer SSH Public Key using the `server_id` and `user_name` and `ssh_public_key_id` separated by `/`. For example:

        ```sh
        $ pulumi import aws:transfer/sshKey:SshKey bar s-12345678/test-username/key-12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] body: The public key portion of an SSH key pair.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] server_id: The Server ID of the Transfer Server (e.g., `s-12345678`)
        :param pulumi.Input[builtins.str] user_name: The name of the user account that is assigned to one or more servers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SshKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AWS Transfer User SSH Key resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std
        import pulumi_tls as tls

        example_private_key = tls.index.PrivateKey("example",
            algorithm=RSA,
            rsa_bits=4096)
        example_server = aws.transfer.Server("example",
            identity_provider_type="SERVICE_MANAGED",
            tags={
                "NAME": "tf-acc-test-transfer-server",
            })
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["transfer.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="tf-test-transfer-user-iam-role",
            assume_role_policy=assume_role.json)
        example_user = aws.transfer.User("example",
            server_id=example_server.id,
            user_name="tftestuser",
            role=example_role.arn,
            tags={
                "NAME": "tftestuser",
            })
        example_ssh_key = aws.transfer.SshKey("example",
            server_id=example_server.id,
            user_name=example_user.user_name,
            body=std.trimspace(input=example_private_key["publicKeyOpenssh"]).result)
        example = aws.iam.get_policy_document(statements=[{
            "sid": "AllowFullAccesstoS3",
            "effect": "Allow",
            "actions": ["s3:*"],
            "resources": ["*"],
        }])
        example_role_policy = aws.iam.RolePolicy("example",
            name="tf-test-transfer-user-iam-policy",
            role=example_role.id,
            policy=example.json)
        ```

        ## Import

        Using `pulumi import`, import Transfer SSH Public Key using the `server_id` and `user_name` and `ssh_public_key_id` separated by `/`. For example:

        ```sh
        $ pulumi import aws:transfer/sshKey:SshKey bar s-12345678/test-username/key-12345
        ```

        :param str resource_name: The name of the resource.
        :param SshKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SshKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 server_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SshKeyArgs.__new__(SshKeyArgs)

            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            __props__.__dict__["region"] = region
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["ssh_key_id"] = None
        super(SshKey, __self__).__init__(
            'aws:transfer/sshKey:SshKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            server_id: Optional[pulumi.Input[builtins.str]] = None,
            ssh_key_id: Optional[pulumi.Input[builtins.str]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None) -> 'SshKey':
        """
        Get an existing SshKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] body: The public key portion of an SSH key pair.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] server_id: The Server ID of the Transfer Server (e.g., `s-12345678`)
        :param pulumi.Input[builtins.str] user_name: The name of the user account that is assigned to one or more servers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SshKeyState.__new__(_SshKeyState)

        __props__.__dict__["body"] = body
        __props__.__dict__["region"] = region
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["ssh_key_id"] = ssh_key_id
        __props__.__dict__["user_name"] = user_name
        return SshKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[builtins.str]:
        """
        The public key portion of an SSH key pair.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[builtins.str]:
        """
        The Server ID of the Transfer Server (e.g., `s-12345678`)
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="sshKeyId")
    def ssh_key_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "ssh_key_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the user account that is assigned to one or more servers.
        """
        return pulumi.get(self, "user_name")

