# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkflowArgs', 'Workflow']

@pulumi.input_type
class WorkflowArgs:
    def __init__(__self__, *,
                 steps: pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 on_exception_steps: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Workflow resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]] steps: Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
        :param pulumi.Input[builtins.str] description: A textual description for the workflow.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]] on_exception_steps: Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "steps", steps)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if on_exception_steps is not None:
            pulumi.set(__self__, "on_exception_steps", on_exception_steps)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]]:
        """
        Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A textual description for the workflow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="onExceptionSteps")
    def on_exception_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]]]:
        """
        Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
        """
        return pulumi.get(self, "on_exception_steps")

    @on_exception_steps.setter
    def on_exception_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]]]):
        pulumi.set(self, "on_exception_steps", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkflowState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 on_exception_steps: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Workflow resources.
        :param pulumi.Input[builtins.str] arn: The Workflow ARN.
        :param pulumi.Input[builtins.str] description: A textual description for the workflow.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]] on_exception_steps: Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]] steps: Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if on_exception_steps is not None:
            pulumi.set(__self__, "on_exception_steps", on_exception_steps)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Workflow ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A textual description for the workflow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="onExceptionSteps")
    def on_exception_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]]]:
        """
        Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
        """
        return pulumi.get(self, "on_exception_steps")

    @on_exception_steps.setter
    def on_exception_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepArgs']]]]):
        pulumi.set(self, "on_exception_steps", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]]]:
        """
        Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:transfer/workflow:Workflow")
class Workflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 on_exception_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowOnExceptionStepArgs', 'WorkflowOnExceptionStepArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowStepArgs', 'WorkflowStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a AWS Transfer Workflow resource.

        ## Example Usage

        ### Basic single step example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Workflow("example", steps=[{
            "delete_step_details": {
                "name": "example",
                "source_file_location": "${original.file}",
            },
            "type": "DELETE",
        }])
        ```

        ### Multistep example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Workflow("example", steps=[
            {
                "custom_step_details": {
                    "name": "example",
                    "source_file_location": "${original.file}",
                    "target": example_aws_lambda_function["arn"],
                    "timeout_seconds": 60,
                },
                "type": "CUSTOM",
            },
            {
                "tag_step_details": {
                    "name": "example",
                    "source_file_location": "${original.file}",
                    "tags": [{
                        "key": "Name",
                        "value": "Hello World",
                    }],
                },
                "type": "TAG",
            },
        ])
        ```

        ## Import

        Using `pulumi import`, import Transfer Workflows using the `worflow_id`. For example:

        ```sh
        $ pulumi import aws:transfer/workflow:Workflow example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A textual description for the workflow.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkflowOnExceptionStepArgs', 'WorkflowOnExceptionStepArgsDict']]]] on_exception_steps: Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkflowStepArgs', 'WorkflowStepArgsDict']]]] steps: Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AWS Transfer Workflow resource.

        ## Example Usage

        ### Basic single step example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Workflow("example", steps=[{
            "delete_step_details": {
                "name": "example",
                "source_file_location": "${original.file}",
            },
            "type": "DELETE",
        }])
        ```

        ### Multistep example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Workflow("example", steps=[
            {
                "custom_step_details": {
                    "name": "example",
                    "source_file_location": "${original.file}",
                    "target": example_aws_lambda_function["arn"],
                    "timeout_seconds": 60,
                },
                "type": "CUSTOM",
            },
            {
                "tag_step_details": {
                    "name": "example",
                    "source_file_location": "${original.file}",
                    "tags": [{
                        "key": "Name",
                        "value": "Hello World",
                    }],
                },
                "type": "TAG",
            },
        ])
        ```

        ## Import

        Using `pulumi import`, import Transfer Workflows using the `worflow_id`. For example:

        ```sh
        $ pulumi import aws:transfer/workflow:Workflow example example
        ```

        :param str resource_name: The name of the resource.
        :param WorkflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 on_exception_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowOnExceptionStepArgs', 'WorkflowOnExceptionStepArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowStepArgs', 'WorkflowStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowArgs.__new__(WorkflowArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["on_exception_steps"] = on_exception_steps
            __props__.__dict__["region"] = region
            if steps is None and not opts.urn:
                raise TypeError("Missing required property 'steps'")
            __props__.__dict__["steps"] = steps
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Workflow, __self__).__init__(
            'aws:transfer/workflow:Workflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            on_exception_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowOnExceptionStepArgs', 'WorkflowOnExceptionStepArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowStepArgs', 'WorkflowStepArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Workflow':
        """
        Get an existing Workflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Workflow ARN.
        :param pulumi.Input[builtins.str] description: A textual description for the workflow.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkflowOnExceptionStepArgs', 'WorkflowOnExceptionStepArgsDict']]]] on_exception_steps: Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkflowStepArgs', 'WorkflowStepArgsDict']]]] steps: Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkflowState.__new__(_WorkflowState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["on_exception_steps"] = on_exception_steps
        __props__.__dict__["region"] = region
        __props__.__dict__["steps"] = steps
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Workflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Workflow ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A textual description for the workflow.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="onExceptionSteps")
    def on_exception_steps(self) -> pulumi.Output[Optional[Sequence['outputs.WorkflowOnExceptionStep']]]:
        """
        Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
        """
        return pulumi.get(self, "on_exception_steps")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.WorkflowStep']]:
        """
        Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

