# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrustProviderArgs', 'TrustProvider']

@pulumi.input_type
class TrustProviderArgs:
    def __init__(__self__, *,
                 policy_reference_name: pulumi.Input[builtins.str],
                 trust_provider_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_options: Optional[pulumi.Input['TrustProviderDeviceOptionsArgs']] = None,
                 device_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 native_application_oidc_options: Optional[pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs']] = None,
                 oidc_options: Optional[pulumi.Input['TrustProviderOidcOptionsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sse_specification: Optional[pulumi.Input['TrustProviderSseSpecificationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TrustProvider resource.
        :param pulumi.Input[builtins.str] policy_reference_name: The identifier to be used when working with policy rules.
        :param pulumi.Input[builtins.str] trust_provider_type: The type of trust provider can be either user or device-based.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] description: A description for the AWS Verified Access trust provider.
        :param pulumi.Input['TrustProviderDeviceOptionsArgs'] device_options: A block of options for device identity based trust providers.
        :param pulumi.Input[builtins.str] device_trust_provider_type: The type of device-based trust provider.
        :param pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs'] native_application_oidc_options: The OpenID Connect details for an Native Application OIDC, user-identity based trust provider.
        :param pulumi.Input['TrustProviderOidcOptionsArgs'] oidc_options: The OpenID Connect details for an oidc-type, user-identity based trust provider.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_trust_provider_type: The type of user-based trust provider.
        """
        pulumi.set(__self__, "policy_reference_name", policy_reference_name)
        pulumi.set(__self__, "trust_provider_type", trust_provider_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_options is not None:
            pulumi.set(__self__, "device_options", device_options)
        if device_trust_provider_type is not None:
            pulumi.set(__self__, "device_trust_provider_type", device_trust_provider_type)
        if native_application_oidc_options is not None:
            pulumi.set(__self__, "native_application_oidc_options", native_application_oidc_options)
        if oidc_options is not None:
            pulumi.set(__self__, "oidc_options", oidc_options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sse_specification is not None:
            pulumi.set(__self__, "sse_specification", sse_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_trust_provider_type is not None:
            pulumi.set(__self__, "user_trust_provider_type", user_trust_provider_type)

    @property
    @pulumi.getter(name="policyReferenceName")
    def policy_reference_name(self) -> pulumi.Input[builtins.str]:
        """
        The identifier to be used when working with policy rules.
        """
        return pulumi.get(self, "policy_reference_name")

    @policy_reference_name.setter
    def policy_reference_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_reference_name", value)

    @property
    @pulumi.getter(name="trustProviderType")
    def trust_provider_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of trust provider can be either user or device-based.

        The following arguments are optional:
        """
        return pulumi.get(self, "trust_provider_type")

    @trust_provider_type.setter
    def trust_provider_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "trust_provider_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the AWS Verified Access trust provider.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceOptions")
    def device_options(self) -> Optional[pulumi.Input['TrustProviderDeviceOptionsArgs']]:
        """
        A block of options for device identity based trust providers.
        """
        return pulumi.get(self, "device_options")

    @device_options.setter
    def device_options(self, value: Optional[pulumi.Input['TrustProviderDeviceOptionsArgs']]):
        pulumi.set(self, "device_options", value)

    @property
    @pulumi.getter(name="deviceTrustProviderType")
    def device_trust_provider_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of device-based trust provider.
        """
        return pulumi.get(self, "device_trust_provider_type")

    @device_trust_provider_type.setter
    def device_trust_provider_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_trust_provider_type", value)

    @property
    @pulumi.getter(name="nativeApplicationOidcOptions")
    def native_application_oidc_options(self) -> Optional[pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs']]:
        """
        The OpenID Connect details for an Native Application OIDC, user-identity based trust provider.
        """
        return pulumi.get(self, "native_application_oidc_options")

    @native_application_oidc_options.setter
    def native_application_oidc_options(self, value: Optional[pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs']]):
        pulumi.set(self, "native_application_oidc_options", value)

    @property
    @pulumi.getter(name="oidcOptions")
    def oidc_options(self) -> Optional[pulumi.Input['TrustProviderOidcOptionsArgs']]:
        """
        The OpenID Connect details for an oidc-type, user-identity based trust provider.
        """
        return pulumi.get(self, "oidc_options")

    @oidc_options.setter
    def oidc_options(self, value: Optional[pulumi.Input['TrustProviderOidcOptionsArgs']]):
        pulumi.set(self, "oidc_options", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> Optional[pulumi.Input['TrustProviderSseSpecificationArgs']]:
        return pulumi.get(self, "sse_specification")

    @sse_specification.setter
    def sse_specification(self, value: Optional[pulumi.Input['TrustProviderSseSpecificationArgs']]):
        pulumi.set(self, "sse_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userTrustProviderType")
    def user_trust_provider_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of user-based trust provider.
        """
        return pulumi.get(self, "user_trust_provider_type")

    @user_trust_provider_type.setter
    def user_trust_provider_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_trust_provider_type", value)


@pulumi.input_type
class _TrustProviderState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_options: Optional[pulumi.Input['TrustProviderDeviceOptionsArgs']] = None,
                 device_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 native_application_oidc_options: Optional[pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs']] = None,
                 oidc_options: Optional[pulumi.Input['TrustProviderOidcOptionsArgs']] = None,
                 policy_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sse_specification: Optional[pulumi.Input['TrustProviderSseSpecificationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 user_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrustProvider resources.
        :param pulumi.Input[builtins.str] description: A description for the AWS Verified Access trust provider.
        :param pulumi.Input['TrustProviderDeviceOptionsArgs'] device_options: A block of options for device identity based trust providers.
        :param pulumi.Input[builtins.str] device_trust_provider_type: The type of device-based trust provider.
        :param pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs'] native_application_oidc_options: The OpenID Connect details for an Native Application OIDC, user-identity based trust provider.
        :param pulumi.Input['TrustProviderOidcOptionsArgs'] oidc_options: The OpenID Connect details for an oidc-type, user-identity based trust provider.
        :param pulumi.Input[builtins.str] policy_reference_name: The identifier to be used when working with policy rules.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] trust_provider_type: The type of trust provider can be either user or device-based.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] user_trust_provider_type: The type of user-based trust provider.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_options is not None:
            pulumi.set(__self__, "device_options", device_options)
        if device_trust_provider_type is not None:
            pulumi.set(__self__, "device_trust_provider_type", device_trust_provider_type)
        if native_application_oidc_options is not None:
            pulumi.set(__self__, "native_application_oidc_options", native_application_oidc_options)
        if oidc_options is not None:
            pulumi.set(__self__, "oidc_options", oidc_options)
        if policy_reference_name is not None:
            pulumi.set(__self__, "policy_reference_name", policy_reference_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sse_specification is not None:
            pulumi.set(__self__, "sse_specification", sse_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if trust_provider_type is not None:
            pulumi.set(__self__, "trust_provider_type", trust_provider_type)
        if user_trust_provider_type is not None:
            pulumi.set(__self__, "user_trust_provider_type", user_trust_provider_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the AWS Verified Access trust provider.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceOptions")
    def device_options(self) -> Optional[pulumi.Input['TrustProviderDeviceOptionsArgs']]:
        """
        A block of options for device identity based trust providers.
        """
        return pulumi.get(self, "device_options")

    @device_options.setter
    def device_options(self, value: Optional[pulumi.Input['TrustProviderDeviceOptionsArgs']]):
        pulumi.set(self, "device_options", value)

    @property
    @pulumi.getter(name="deviceTrustProviderType")
    def device_trust_provider_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of device-based trust provider.
        """
        return pulumi.get(self, "device_trust_provider_type")

    @device_trust_provider_type.setter
    def device_trust_provider_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_trust_provider_type", value)

    @property
    @pulumi.getter(name="nativeApplicationOidcOptions")
    def native_application_oidc_options(self) -> Optional[pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs']]:
        """
        The OpenID Connect details for an Native Application OIDC, user-identity based trust provider.
        """
        return pulumi.get(self, "native_application_oidc_options")

    @native_application_oidc_options.setter
    def native_application_oidc_options(self, value: Optional[pulumi.Input['TrustProviderNativeApplicationOidcOptionsArgs']]):
        pulumi.set(self, "native_application_oidc_options", value)

    @property
    @pulumi.getter(name="oidcOptions")
    def oidc_options(self) -> Optional[pulumi.Input['TrustProviderOidcOptionsArgs']]:
        """
        The OpenID Connect details for an oidc-type, user-identity based trust provider.
        """
        return pulumi.get(self, "oidc_options")

    @oidc_options.setter
    def oidc_options(self, value: Optional[pulumi.Input['TrustProviderOidcOptionsArgs']]):
        pulumi.set(self, "oidc_options", value)

    @property
    @pulumi.getter(name="policyReferenceName")
    def policy_reference_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier to be used when working with policy rules.
        """
        return pulumi.get(self, "policy_reference_name")

    @policy_reference_name.setter
    def policy_reference_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_reference_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> Optional[pulumi.Input['TrustProviderSseSpecificationArgs']]:
        return pulumi.get(self, "sse_specification")

    @sse_specification.setter
    def sse_specification(self, value: Optional[pulumi.Input['TrustProviderSseSpecificationArgs']]):
        pulumi.set(self, "sse_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="trustProviderType")
    def trust_provider_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of trust provider can be either user or device-based.

        The following arguments are optional:
        """
        return pulumi.get(self, "trust_provider_type")

    @trust_provider_type.setter
    def trust_provider_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_provider_type", value)

    @property
    @pulumi.getter(name="userTrustProviderType")
    def user_trust_provider_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of user-based trust provider.
        """
        return pulumi.get(self, "user_trust_provider_type")

    @user_trust_provider_type.setter
    def user_trust_provider_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_trust_provider_type", value)


@pulumi.type_token("aws:verifiedaccess/trustProvider:TrustProvider")
class TrustProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_options: Optional[pulumi.Input[Union['TrustProviderDeviceOptionsArgs', 'TrustProviderDeviceOptionsArgsDict']]] = None,
                 device_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 native_application_oidc_options: Optional[pulumi.Input[Union['TrustProviderNativeApplicationOidcOptionsArgs', 'TrustProviderNativeApplicationOidcOptionsArgsDict']]] = None,
                 oidc_options: Optional[pulumi.Input[Union['TrustProviderOidcOptionsArgs', 'TrustProviderOidcOptionsArgsDict']]] = None,
                 policy_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sse_specification: Optional[pulumi.Input[Union['TrustProviderSseSpecificationArgs', 'TrustProviderSseSpecificationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 user_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing a Verified Access Trust Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedaccess.TrustProvider("example",
            policy_reference_name="example",
            trust_provider_type="user",
            user_trust_provider_type="iam-identity-center")
        ```

        ## Import

        Using `pulumi import`, import Transfer Workflows using the  `id`. For example:

        ```sh
        $ pulumi import aws:verifiedaccess/trustProvider:TrustProvider example vatp-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description for the AWS Verified Access trust provider.
        :param pulumi.Input[Union['TrustProviderDeviceOptionsArgs', 'TrustProviderDeviceOptionsArgsDict']] device_options: A block of options for device identity based trust providers.
        :param pulumi.Input[builtins.str] device_trust_provider_type: The type of device-based trust provider.
        :param pulumi.Input[Union['TrustProviderNativeApplicationOidcOptionsArgs', 'TrustProviderNativeApplicationOidcOptionsArgsDict']] native_application_oidc_options: The OpenID Connect details for an Native Application OIDC, user-identity based trust provider.
        :param pulumi.Input[Union['TrustProviderOidcOptionsArgs', 'TrustProviderOidcOptionsArgsDict']] oidc_options: The OpenID Connect details for an oidc-type, user-identity based trust provider.
        :param pulumi.Input[builtins.str] policy_reference_name: The identifier to be used when working with policy rules.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] trust_provider_type: The type of trust provider can be either user or device-based.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] user_trust_provider_type: The type of user-based trust provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrustProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Verified Access Trust Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedaccess.TrustProvider("example",
            policy_reference_name="example",
            trust_provider_type="user",
            user_trust_provider_type="iam-identity-center")
        ```

        ## Import

        Using `pulumi import`, import Transfer Workflows using the  `id`. For example:

        ```sh
        $ pulumi import aws:verifiedaccess/trustProvider:TrustProvider example vatp-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param TrustProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrustProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_options: Optional[pulumi.Input[Union['TrustProviderDeviceOptionsArgs', 'TrustProviderDeviceOptionsArgsDict']]] = None,
                 device_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 native_application_oidc_options: Optional[pulumi.Input[Union['TrustProviderNativeApplicationOidcOptionsArgs', 'TrustProviderNativeApplicationOidcOptionsArgsDict']]] = None,
                 oidc_options: Optional[pulumi.Input[Union['TrustProviderOidcOptionsArgs', 'TrustProviderOidcOptionsArgsDict']]] = None,
                 policy_reference_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sse_specification: Optional[pulumi.Input[Union['TrustProviderSseSpecificationArgs', 'TrustProviderSseSpecificationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 user_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrustProviderArgs.__new__(TrustProviderArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["device_options"] = device_options
            __props__.__dict__["device_trust_provider_type"] = device_trust_provider_type
            __props__.__dict__["native_application_oidc_options"] = native_application_oidc_options
            __props__.__dict__["oidc_options"] = oidc_options
            if policy_reference_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_reference_name'")
            __props__.__dict__["policy_reference_name"] = policy_reference_name
            __props__.__dict__["region"] = region
            __props__.__dict__["sse_specification"] = sse_specification
            __props__.__dict__["tags"] = tags
            if trust_provider_type is None and not opts.urn:
                raise TypeError("Missing required property 'trust_provider_type'")
            __props__.__dict__["trust_provider_type"] = trust_provider_type
            __props__.__dict__["user_trust_provider_type"] = user_trust_provider_type
            __props__.__dict__["tags_all"] = None
        super(TrustProvider, __self__).__init__(
            'aws:verifiedaccess/trustProvider:TrustProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_options: Optional[pulumi.Input[Union['TrustProviderDeviceOptionsArgs', 'TrustProviderDeviceOptionsArgsDict']]] = None,
            device_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
            native_application_oidc_options: Optional[pulumi.Input[Union['TrustProviderNativeApplicationOidcOptionsArgs', 'TrustProviderNativeApplicationOidcOptionsArgsDict']]] = None,
            oidc_options: Optional[pulumi.Input[Union['TrustProviderOidcOptionsArgs', 'TrustProviderOidcOptionsArgsDict']]] = None,
            policy_reference_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            sse_specification: Optional[pulumi.Input[Union['TrustProviderSseSpecificationArgs', 'TrustProviderSseSpecificationArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            trust_provider_type: Optional[pulumi.Input[builtins.str]] = None,
            user_trust_provider_type: Optional[pulumi.Input[builtins.str]] = None) -> 'TrustProvider':
        """
        Get an existing TrustProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description for the AWS Verified Access trust provider.
        :param pulumi.Input[Union['TrustProviderDeviceOptionsArgs', 'TrustProviderDeviceOptionsArgsDict']] device_options: A block of options for device identity based trust providers.
        :param pulumi.Input[builtins.str] device_trust_provider_type: The type of device-based trust provider.
        :param pulumi.Input[Union['TrustProviderNativeApplicationOidcOptionsArgs', 'TrustProviderNativeApplicationOidcOptionsArgsDict']] native_application_oidc_options: The OpenID Connect details for an Native Application OIDC, user-identity based trust provider.
        :param pulumi.Input[Union['TrustProviderOidcOptionsArgs', 'TrustProviderOidcOptionsArgsDict']] oidc_options: The OpenID Connect details for an oidc-type, user-identity based trust provider.
        :param pulumi.Input[builtins.str] policy_reference_name: The identifier to be used when working with policy rules.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] trust_provider_type: The type of trust provider can be either user or device-based.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] user_trust_provider_type: The type of user-based trust provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrustProviderState.__new__(_TrustProviderState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_options"] = device_options
        __props__.__dict__["device_trust_provider_type"] = device_trust_provider_type
        __props__.__dict__["native_application_oidc_options"] = native_application_oidc_options
        __props__.__dict__["oidc_options"] = oidc_options
        __props__.__dict__["policy_reference_name"] = policy_reference_name
        __props__.__dict__["region"] = region
        __props__.__dict__["sse_specification"] = sse_specification
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["trust_provider_type"] = trust_provider_type
        __props__.__dict__["user_trust_provider_type"] = user_trust_provider_type
        return TrustProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the AWS Verified Access trust provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceOptions")
    def device_options(self) -> pulumi.Output[Optional['outputs.TrustProviderDeviceOptions']]:
        """
        A block of options for device identity based trust providers.
        """
        return pulumi.get(self, "device_options")

    @property
    @pulumi.getter(name="deviceTrustProviderType")
    def device_trust_provider_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of device-based trust provider.
        """
        return pulumi.get(self, "device_trust_provider_type")

    @property
    @pulumi.getter(name="nativeApplicationOidcOptions")
    def native_application_oidc_options(self) -> pulumi.Output[Optional['outputs.TrustProviderNativeApplicationOidcOptions']]:
        """
        The OpenID Connect details for an Native Application OIDC, user-identity based trust provider.
        """
        return pulumi.get(self, "native_application_oidc_options")

    @property
    @pulumi.getter(name="oidcOptions")
    def oidc_options(self) -> pulumi.Output[Optional['outputs.TrustProviderOidcOptions']]:
        """
        The OpenID Connect details for an oidc-type, user-identity based trust provider.
        """
        return pulumi.get(self, "oidc_options")

    @property
    @pulumi.getter(name="policyReferenceName")
    def policy_reference_name(self) -> pulumi.Output[builtins.str]:
        """
        The identifier to be used when working with policy rules.
        """
        return pulumi.get(self, "policy_reference_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> pulumi.Output['outputs.TrustProviderSseSpecification']:
        return pulumi.get(self, "sse_specification")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="trustProviderType")
    def trust_provider_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of trust provider can be either user or device-based.

        The following arguments are optional:
        """
        return pulumi.get(self, "trust_provider_type")

    @property
    @pulumi.getter(name="userTrustProviderType")
    def user_trust_provider_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of user-based trust provider.
        """
        return pulumi.get(self, "user_trust_provider_type")

