# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IdentitySourceArgs', 'IdentitySource']

@pulumi.input_type
class IdentitySourceArgs:
    def __init__(__self__, *,
                 policy_store_id: pulumi.Input[builtins.str],
                 configuration: Optional[pulumi.Input['IdentitySourceConfigurationArgs']] = None,
                 principal_entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IdentitySource resource.
        :param pulumi.Input[builtins.str] policy_store_id: Specifies the ID of the policy store in which you want to store this identity source.
        :param pulumi.Input['IdentitySourceConfigurationArgs'] configuration: Specifies the details required to communicate with the identity provider (IdP) associated with this identity source. See Configuration below.
        :param pulumi.Input[builtins.str] principal_entity_type: Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "policy_store_id", policy_store_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if principal_entity_type is not None:
            pulumi.set(__self__, "principal_entity_type", principal_entity_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the policy store in which you want to store this identity source.
        """
        return pulumi.get(self, "policy_store_id")

    @policy_store_id.setter
    def policy_store_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_store_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['IdentitySourceConfigurationArgs']]:
        """
        Specifies the details required to communicate with the identity provider (IdP) associated with this identity source. See Configuration below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['IdentitySourceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="principalEntityType")
    def principal_entity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
        """
        return pulumi.get(self, "principal_entity_type")

    @principal_entity_type.setter
    def principal_entity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_entity_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _IdentitySourceState:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['IdentitySourceConfigurationArgs']] = None,
                 policy_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IdentitySource resources.
        :param pulumi.Input['IdentitySourceConfigurationArgs'] configuration: Specifies the details required to communicate with the identity provider (IdP) associated with this identity source. See Configuration below.
        :param pulumi.Input[builtins.str] policy_store_id: Specifies the ID of the policy store in which you want to store this identity source.
        :param pulumi.Input[builtins.str] principal_entity_type: Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if policy_store_id is not None:
            pulumi.set(__self__, "policy_store_id", policy_store_id)
        if principal_entity_type is not None:
            pulumi.set(__self__, "principal_entity_type", principal_entity_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['IdentitySourceConfigurationArgs']]:
        """
        Specifies the details required to communicate with the identity provider (IdP) associated with this identity source. See Configuration below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['IdentitySourceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the policy store in which you want to store this identity source.
        """
        return pulumi.get(self, "policy_store_id")

    @policy_store_id.setter
    def policy_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_store_id", value)

    @property
    @pulumi.getter(name="principalEntityType")
    def principal_entity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
        """
        return pulumi.get(self, "principal_entity_type")

    @principal_entity_type.setter
    def principal_entity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_entity_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:verifiedpermissions/identitySource:IdentitySource")
class IdentitySource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['IdentitySourceConfigurationArgs', 'IdentitySourceConfigurationArgsDict']]] = None,
                 policy_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Verified Permissions Identity Source.

        ## Example Usage

        ### Cognito User Pool Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
            "mode": "STRICT",
        })
        example_user_pool = aws.cognito.UserPool("example", name="example")
        example_user_pool_client = aws.cognito.UserPoolClient("example",
            name="example",
            user_pool_id=example_user_pool.id,
            explicit_auth_flows=["ADMIN_NO_SRP_AUTH"])
        example_identity_source = aws.verifiedpermissions.IdentitySource("example",
            policy_store_id=example.id,
            configuration={
                "cognito_user_pool_configuration": {
                    "user_pool_arn": example_user_pool.arn,
                    "client_ids": [example_user_pool_client.id],
                },
            })
        ```

        ### OpenID Connect Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
            "mode": "STRICT",
        })
        example_identity_source = aws.verifiedpermissions.IdentitySource("example",
            policy_store_id=example.id,
            configuration={
                "open_id_connect_configuration": {
                    "issuer": "https://auth.example.com",
                    "token_selection": {
                        "access_token_only": {
                            "audiences": ["https://myapp.example.com"],
                            "principal_id_claim": "sub",
                        },
                    },
                    "entity_id_prefix": "MyOIDCProvider",
                    "group_configuration": {
                        "group_claim": "groups",
                        "group_entity_type": "MyCorp::UserGroup",
                    },
                },
            },
            principal_entity_type="MyCorp::User")
        ```

        ## Import

        Using `pulumi import`, import Verified Permissions Identity Source using the `policy_store_id:identity_source_id`. For example:

        ```sh
        $ pulumi import aws:verifiedpermissions/identitySource:IdentitySource example policy-store-id-12345678:identity-source-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IdentitySourceConfigurationArgs', 'IdentitySourceConfigurationArgsDict']] configuration: Specifies the details required to communicate with the identity provider (IdP) associated with this identity source. See Configuration below.
        :param pulumi.Input[builtins.str] policy_store_id: Specifies the ID of the policy store in which you want to store this identity source.
        :param pulumi.Input[builtins.str] principal_entity_type: Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentitySourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Verified Permissions Identity Source.

        ## Example Usage

        ### Cognito User Pool Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
            "mode": "STRICT",
        })
        example_user_pool = aws.cognito.UserPool("example", name="example")
        example_user_pool_client = aws.cognito.UserPoolClient("example",
            name="example",
            user_pool_id=example_user_pool.id,
            explicit_auth_flows=["ADMIN_NO_SRP_AUTH"])
        example_identity_source = aws.verifiedpermissions.IdentitySource("example",
            policy_store_id=example.id,
            configuration={
                "cognito_user_pool_configuration": {
                    "user_pool_arn": example_user_pool.arn,
                    "client_ids": [example_user_pool_client.id],
                },
            })
        ```

        ### OpenID Connect Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
            "mode": "STRICT",
        })
        example_identity_source = aws.verifiedpermissions.IdentitySource("example",
            policy_store_id=example.id,
            configuration={
                "open_id_connect_configuration": {
                    "issuer": "https://auth.example.com",
                    "token_selection": {
                        "access_token_only": {
                            "audiences": ["https://myapp.example.com"],
                            "principal_id_claim": "sub",
                        },
                    },
                    "entity_id_prefix": "MyOIDCProvider",
                    "group_configuration": {
                        "group_claim": "groups",
                        "group_entity_type": "MyCorp::UserGroup",
                    },
                },
            },
            principal_entity_type="MyCorp::User")
        ```

        ## Import

        Using `pulumi import`, import Verified Permissions Identity Source using the `policy_store_id:identity_source_id`. For example:

        ```sh
        $ pulumi import aws:verifiedpermissions/identitySource:IdentitySource example policy-store-id-12345678:identity-source-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param IdentitySourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentitySourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['IdentitySourceConfigurationArgs', 'IdentitySourceConfigurationArgsDict']]] = None,
                 policy_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentitySourceArgs.__new__(IdentitySourceArgs)

            __props__.__dict__["configuration"] = configuration
            if policy_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_store_id'")
            __props__.__dict__["policy_store_id"] = policy_store_id
            __props__.__dict__["principal_entity_type"] = principal_entity_type
            __props__.__dict__["region"] = region
        super(IdentitySource, __self__).__init__(
            'aws:verifiedpermissions/identitySource:IdentitySource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration: Optional[pulumi.Input[Union['IdentitySourceConfigurationArgs', 'IdentitySourceConfigurationArgsDict']]] = None,
            policy_store_id: Optional[pulumi.Input[builtins.str]] = None,
            principal_entity_type: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'IdentitySource':
        """
        Get an existing IdentitySource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IdentitySourceConfigurationArgs', 'IdentitySourceConfigurationArgsDict']] configuration: Specifies the details required to communicate with the identity provider (IdP) associated with this identity source. See Configuration below.
        :param pulumi.Input[builtins.str] policy_store_id: Specifies the ID of the policy store in which you want to store this identity source.
        :param pulumi.Input[builtins.str] principal_entity_type: Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentitySourceState.__new__(_IdentitySourceState)

        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["policy_store_id"] = policy_store_id
        __props__.__dict__["principal_entity_type"] = principal_entity_type
        __props__.__dict__["region"] = region
        return IdentitySource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.IdentitySourceConfiguration']]:
        """
        Specifies the details required to communicate with the identity provider (IdP) associated with this identity source. See Configuration below.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the policy store in which you want to store this identity source.
        """
        return pulumi.get(self, "policy_store_id")

    @property
    @pulumi.getter(name="principalEntityType")
    def principal_entity_type(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
        """
        return pulumi.get(self, "principal_entity_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

