# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEndpointAssociationsResult',
    'AwaitableGetEndpointAssociationsResult',
    'get_endpoint_associations',
    'get_endpoint_associations_output',
]

@pulumi.output_type
class GetEndpointAssociationsResult:
    """
    A collection of values returned by getEndpointAssociations.
    """
    def __init__(__self__, associations=None, id=None, region=None, vpc_endpoint_id=None):
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vpc_endpoint_id and not isinstance(vpc_endpoint_id, str):
            raise TypeError("Expected argument 'vpc_endpoint_id' to be a str")
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)

    @property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetEndpointAssociationsAssociationResult']:
        """
        Associations for the VPC Endpoint. Association blocks are documented below.
        """
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> builtins.str:
        return pulumi.get(self, "vpc_endpoint_id")


class AwaitableGetEndpointAssociationsResult(GetEndpointAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointAssociationsResult(
            associations=self.associations,
            id=self.id,
            region=self.region,
            vpc_endpoint_id=self.vpc_endpoint_id)


def get_endpoint_associations(region: Optional[builtins.str] = None,
                              vpc_endpoint_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointAssociationsResult:
    """
    Data source for managing an AWS EC2 (Elastic Compute Cloud) Vpc Endpoint Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpc.get_endpoint_associations(vpc_endpoint_id=example_aws_vpc_endpoint["id"])
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str vpc_endpoint_id: ID of the specific VPC Endpoint to retrieve.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['vpcEndpointId'] = vpc_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:vpc/getEndpointAssociations:getEndpointAssociations', __args__, opts=opts, typ=GetEndpointAssociationsResult).value

    return AwaitableGetEndpointAssociationsResult(
        associations=pulumi.get(__ret__, 'associations'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        vpc_endpoint_id=pulumi.get(__ret__, 'vpc_endpoint_id'))
def get_endpoint_associations_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndpointAssociationsResult]:
    """
    Data source for managing an AWS EC2 (Elastic Compute Cloud) Vpc Endpoint Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpc.get_endpoint_associations(vpc_endpoint_id=example_aws_vpc_endpoint["id"])
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str vpc_endpoint_id: ID of the specific VPC Endpoint to retrieve.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['vpcEndpointId'] = vpc_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:vpc/getEndpointAssociations:getEndpointAssociations', __args__, opts=opts, typ=GetEndpointAssociationsResult)
    return __ret__.apply(lambda __response__: GetEndpointAssociationsResult(
        associations=pulumi.get(__response__, 'associations'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        vpc_endpoint_id=pulumi.get(__response__, 'vpc_endpoint_id')))
