# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityGroupRuleResult',
    'AwaitableGetSecurityGroupRuleResult',
    'get_security_group_rule',
    'get_security_group_rule_output',
]

@pulumi.output_type
class GetSecurityGroupRuleResult:
    """
    A collection of values returned by getSecurityGroupRule.
    """
    def __init__(__self__, arn=None, cidr_ipv4=None, cidr_ipv6=None, description=None, filters=None, from_port=None, id=None, ip_protocol=None, is_egress=None, prefix_list_id=None, referenced_security_group_id=None, region=None, security_group_id=None, security_group_rule_id=None, tags=None, to_port=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cidr_ipv4 and not isinstance(cidr_ipv4, str):
            raise TypeError("Expected argument 'cidr_ipv4' to be a str")
        pulumi.set(__self__, "cidr_ipv4", cidr_ipv4)
        if cidr_ipv6 and not isinstance(cidr_ipv6, str):
            raise TypeError("Expected argument 'cidr_ipv6' to be a str")
        pulumi.set(__self__, "cidr_ipv6", cidr_ipv6)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if from_port and not isinstance(from_port, int):
            raise TypeError("Expected argument 'from_port' to be a int")
        pulumi.set(__self__, "from_port", from_port)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_protocol and not isinstance(ip_protocol, str):
            raise TypeError("Expected argument 'ip_protocol' to be a str")
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        if is_egress and not isinstance(is_egress, bool):
            raise TypeError("Expected argument 'is_egress' to be a bool")
        pulumi.set(__self__, "is_egress", is_egress)
        if prefix_list_id and not isinstance(prefix_list_id, str):
            raise TypeError("Expected argument 'prefix_list_id' to be a str")
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if referenced_security_group_id and not isinstance(referenced_security_group_id, str):
            raise TypeError("Expected argument 'referenced_security_group_id' to be a str")
        pulumi.set(__self__, "referenced_security_group_id", referenced_security_group_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_rule_id and not isinstance(security_group_rule_id, str):
            raise TypeError("Expected argument 'security_group_rule_id' to be a str")
        pulumi.set(__self__, "security_group_rule_id", security_group_rule_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if to_port and not isinstance(to_port, int):
            raise TypeError("Expected argument 'to_port' to be a int")
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the security group rule.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cidrIpv4")
    def cidr_ipv4(self) -> builtins.str:
        """
        The destination IPv4 CIDR range.
        """
        return pulumi.get(self, "cidr_ipv4")

    @property
    @pulumi.getter(name="cidrIpv6")
    def cidr_ipv6(self) -> builtins.str:
        """
        The destination IPv6 CIDR range.
        """
        return pulumi.get(self, "cidr_ipv6")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The security group rule description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityGroupRuleFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        """
        The IP protocol name or number. Use `-1` to specify all protocols.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="isEgress")
    def is_egress(self) -> builtins.bool:
        """
        Indicates whether the security group rule is an outbound rule.
        """
        return pulumi.get(self, "is_egress")

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> builtins.str:
        """
        The ID of the destination prefix list.
        """
        return pulumi.get(self, "prefix_list_id")

    @property
    @pulumi.getter(name="referencedSecurityGroupId")
    def referenced_security_group_id(self) -> builtins.str:
        """
        The destination security group that is referenced in the rule.
        """
        return pulumi.get(self, "referenced_security_group_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> builtins.str:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupRuleId")
    def security_group_rule_id(self) -> builtins.str:
        return pulumi.get(self, "security_group_rule_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        (Optional) The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
        """
        return pulumi.get(self, "to_port")


class AwaitableGetSecurityGroupRuleResult(GetSecurityGroupRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupRuleResult(
            arn=self.arn,
            cidr_ipv4=self.cidr_ipv4,
            cidr_ipv6=self.cidr_ipv6,
            description=self.description,
            filters=self.filters,
            from_port=self.from_port,
            id=self.id,
            ip_protocol=self.ip_protocol,
            is_egress=self.is_egress,
            prefix_list_id=self.prefix_list_id,
            referenced_security_group_id=self.referenced_security_group_id,
            region=self.region,
            security_group_id=self.security_group_id,
            security_group_rule_id=self.security_group_rule_id,
            tags=self.tags,
            to_port=self.to_port)


def get_security_group_rule(filters: Optional[Sequence[Union['GetSecurityGroupRuleFilterArgs', 'GetSecurityGroupRuleFilterArgsDict']]] = None,
                            region: Optional[builtins.str] = None,
                            security_group_rule_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupRuleResult:
    """
    `vpc_get_security_group_rule` provides details about a specific security group rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpc.get_security_group_rule(security_group_rule_id=security_group_rule_id)
    ```


    :param Sequence[Union['GetSecurityGroupRuleFilterArgs', 'GetSecurityGroupRuleFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           security group rules. The given filters must match exactly one security group rule
           whose data will be exported as attributes.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str security_group_rule_id: ID of the security group rule to select.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['securityGroupRuleId'] = security_group_rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:vpc/getSecurityGroupRule:getSecurityGroupRule', __args__, opts=opts, typ=GetSecurityGroupRuleResult).value

    return AwaitableGetSecurityGroupRuleResult(
        arn=pulumi.get(__ret__, 'arn'),
        cidr_ipv4=pulumi.get(__ret__, 'cidr_ipv4'),
        cidr_ipv6=pulumi.get(__ret__, 'cidr_ipv6'),
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        from_port=pulumi.get(__ret__, 'from_port'),
        id=pulumi.get(__ret__, 'id'),
        ip_protocol=pulumi.get(__ret__, 'ip_protocol'),
        is_egress=pulumi.get(__ret__, 'is_egress'),
        prefix_list_id=pulumi.get(__ret__, 'prefix_list_id'),
        referenced_security_group_id=pulumi.get(__ret__, 'referenced_security_group_id'),
        region=pulumi.get(__ret__, 'region'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        security_group_rule_id=pulumi.get(__ret__, 'security_group_rule_id'),
        tags=pulumi.get(__ret__, 'tags'),
        to_port=pulumi.get(__ret__, 'to_port'))
def get_security_group_rule_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityGroupRuleFilterArgs', 'GetSecurityGroupRuleFilterArgsDict']]]]] = None,
                                   region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   security_group_rule_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGroupRuleResult]:
    """
    `vpc_get_security_group_rule` provides details about a specific security group rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpc.get_security_group_rule(security_group_rule_id=security_group_rule_id)
    ```


    :param Sequence[Union['GetSecurityGroupRuleFilterArgs', 'GetSecurityGroupRuleFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           security group rules. The given filters must match exactly one security group rule
           whose data will be exported as attributes.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str security_group_rule_id: ID of the security group rule to select.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['securityGroupRuleId'] = security_group_rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:vpc/getSecurityGroupRule:getSecurityGroupRule', __args__, opts=opts, typ=GetSecurityGroupRuleResult)
    return __ret__.apply(lambda __response__: GetSecurityGroupRuleResult(
        arn=pulumi.get(__response__, 'arn'),
        cidr_ipv4=pulumi.get(__response__, 'cidr_ipv4'),
        cidr_ipv6=pulumi.get(__response__, 'cidr_ipv6'),
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        from_port=pulumi.get(__response__, 'from_port'),
        id=pulumi.get(__response__, 'id'),
        ip_protocol=pulumi.get(__response__, 'ip_protocol'),
        is_egress=pulumi.get(__response__, 'is_egress'),
        prefix_list_id=pulumi.get(__response__, 'prefix_list_id'),
        referenced_security_group_id=pulumi.get(__response__, 'referenced_security_group_id'),
        region=pulumi.get(__response__, 'region'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        security_group_rule_id=pulumi.get(__response__, 'security_group_rule_id'),
        tags=pulumi.get(__response__, 'tags'),
        to_port=pulumi.get(__response__, 'to_port')))
