# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'EndpointServicePrivateDnsVerificationTimeouts',
    'RouteServerEndpointTimeouts',
    'RouteServerPeerBgpOptions',
    'RouteServerPeerTimeouts',
    'RouteServerPropagationTimeouts',
    'RouteServerTimeouts',
    'RouteServerVpcAssociationTimeouts',
    'SecurityGroupVpcAssociationTimeouts',
    'GetEndpointAssociationsAssociationResult',
    'GetEndpointAssociationsAssociationDnsEntryResult',
    'GetEndpointAssociationsAssociationPrivateDnsEntryResult',
    'GetSecurityGroupRuleFilterResult',
    'GetSecurityGroupRulesFilterResult',
]

@pulumi.output_type
class EndpointServicePrivateDnsVerificationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class RouteServerEndpointTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class RouteServerPeerBgpOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerAsn":
            suggest = "peer_asn"
        elif key == "peerLivenessDetection":
            suggest = "peer_liveness_detection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteServerPeerBgpOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteServerPeerBgpOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteServerPeerBgpOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peer_asn: builtins.int,
                 peer_liveness_detection: Optional[builtins.str] = None):
        """
        :param builtins.int peer_asn: The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294 (32-bit ASN) range.
        :param builtins.str peer_liveness_detection: The requested liveness detection protocol for the BGP peer. Valid values are `bgp-keepalive` and `bfd`. Default value is `bgp-keepalive`.
        """
        pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_liveness_detection is not None:
            pulumi.set(__self__, "peer_liveness_detection", peer_liveness_detection)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> builtins.int:
        """
        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294 (32-bit ASN) range.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peerLivenessDetection")
    def peer_liveness_detection(self) -> Optional[builtins.str]:
        """
        The requested liveness detection protocol for the BGP peer. Valid values are `bgp-keepalive` and `bfd`. Default value is `bgp-keepalive`.
        """
        return pulumi.get(self, "peer_liveness_detection")


@pulumi.output_type
class RouteServerPeerTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class RouteServerPropagationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class RouteServerTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class RouteServerVpcAssociationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class SecurityGroupVpcAssociationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class GetEndpointAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 associated_resource_accessibility: builtins.str,
                 associated_resource_arn: builtins.str,
                 dns_entries: Sequence['outputs.GetEndpointAssociationsAssociationDnsEntryResult'],
                 id: builtins.str,
                 private_dns_entries: Sequence['outputs.GetEndpointAssociationsAssociationPrivateDnsEntryResult'],
                 resource_configuration_group_arn: builtins.str,
                 service_network_arn: builtins.str,
                 service_network_name: builtins.str,
                 tags: Mapping[str, builtins.str]):
        """
        :param builtins.str associated_resource_accessibility: Accessibility of the resource.
        :param builtins.str associated_resource_arn: ARN of the resource for this association.
        :param Sequence['GetEndpointAssociationsAssociationDnsEntryArgs'] dns_entries: DNS entries for the Association. DNS entry blocks are documented below.
        :param Sequence['GetEndpointAssociationsAssociationPrivateDnsEntryArgs'] private_dns_entries: DNS entries for the Association. Private DNS entry blocks are documented below.
        :param builtins.str resource_configuration_group_arn: ARN of the Resource Group if the Resource is a member of a group.
        :param builtins.str service_network_arn: Service Network ARN. Applicable for endpoints of type `ServiceNetwork`.
        :param builtins.str service_network_name: Service Network Name. Applicable for endpoints of type `ServiceNetwork`.
        :param Mapping[str, builtins.str] tags: Tags of the association.
        """
        pulumi.set(__self__, "associated_resource_accessibility", associated_resource_accessibility)
        pulumi.set(__self__, "associated_resource_arn", associated_resource_arn)
        pulumi.set(__self__, "dns_entries", dns_entries)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "private_dns_entries", private_dns_entries)
        pulumi.set(__self__, "resource_configuration_group_arn", resource_configuration_group_arn)
        pulumi.set(__self__, "service_network_arn", service_network_arn)
        pulumi.set(__self__, "service_network_name", service_network_name)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="associatedResourceAccessibility")
    def associated_resource_accessibility(self) -> builtins.str:
        """
        Accessibility of the resource.
        """
        return pulumi.get(self, "associated_resource_accessibility")

    @property
    @pulumi.getter(name="associatedResourceArn")
    def associated_resource_arn(self) -> builtins.str:
        """
        ARN of the resource for this association.
        """
        return pulumi.get(self, "associated_resource_arn")

    @property
    @pulumi.getter(name="dnsEntries")
    def dns_entries(self) -> Sequence['outputs.GetEndpointAssociationsAssociationDnsEntryResult']:
        """
        DNS entries for the Association. DNS entry blocks are documented below.
        """
        return pulumi.get(self, "dns_entries")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateDnsEntries")
    def private_dns_entries(self) -> Sequence['outputs.GetEndpointAssociationsAssociationPrivateDnsEntryResult']:
        """
        DNS entries for the Association. Private DNS entry blocks are documented below.
        """
        return pulumi.get(self, "private_dns_entries")

    @property
    @pulumi.getter(name="resourceConfigurationGroupArn")
    def resource_configuration_group_arn(self) -> builtins.str:
        """
        ARN of the Resource Group if the Resource is a member of a group.
        """
        return pulumi.get(self, "resource_configuration_group_arn")

    @property
    @pulumi.getter(name="serviceNetworkArn")
    def service_network_arn(self) -> builtins.str:
        """
        Service Network ARN. Applicable for endpoints of type `ServiceNetwork`.
        """
        return pulumi.get(self, "service_network_arn")

    @property
    @pulumi.getter(name="serviceNetworkName")
    def service_network_name(self) -> builtins.str:
        """
        Service Network Name. Applicable for endpoints of type `ServiceNetwork`.
        """
        return pulumi.get(self, "service_network_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Tags of the association.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEndpointAssociationsAssociationDnsEntryResult(dict):
    def __init__(__self__, *,
                 dns_name: builtins.str,
                 hosted_zone_id: builtins.str):
        """
        :param builtins.str dns_name: DNS name.
        :param builtins.str hosted_zone_id: ID of the private hosted zone.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> builtins.str:
        """
        DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> builtins.str:
        """
        ID of the private hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")


@pulumi.output_type
class GetEndpointAssociationsAssociationPrivateDnsEntryResult(dict):
    def __init__(__self__, *,
                 dns_name: builtins.str,
                 hosted_zone_id: builtins.str):
        """
        :param builtins.str dns_name: DNS name.
        :param builtins.str hosted_zone_id: ID of the private hosted zone.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> builtins.str:
        """
        DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> builtins.str:
        """
        ID of the private hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")


@pulumi.output_type
class GetSecurityGroupRuleFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the filter field. Valid values can be found in the EC2 [`DescribeSecurityGroupRules`](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupRules.html) API Reference.
        :param Sequence[builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the filter field. Valid values can be found in the EC2 [`DescribeSecurityGroupRules`](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupRules.html) API Reference.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSecurityGroupRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the field to filter by, as defined by
               [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupRules.html).
        :param Sequence[builtins.str] values: Set of values that are accepted for the given field.
               
               Security group rule IDs will be selected if any one of the given values match.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the field to filter by, as defined by
        [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupRules.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Set of values that are accepted for the given field.

        Security group rule IDs will be selected if any one of the given values match.
        """
        return pulumi.get(self, "values")


