# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteServerArgs', 'RouteServer']

@pulumi.input_type
class RouteServerArgs:
    def __init__(__self__, *,
                 amazon_side_asn: pulumi.Input[builtins.int],
                 persist_routes: Optional[pulumi.Input[builtins.str]] = None,
                 persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a RouteServer resource.
        :param pulumi.Input[builtins.int] amazon_side_asn: The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] persist_routes: Indicates whether routes should be persisted after all BGP sessions are terminated. Valid values are `enable`, `disable`, `reset`
        :param pulumi.Input[builtins.int] persist_routes_duration: The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB. Value must be in the range of 1-5. Required if `persist_routes` is enabled.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] sns_notifications_enabled: Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "amazon_side_asn", amazon_side_asn)
        if persist_routes is not None:
            pulumi.set(__self__, "persist_routes", persist_routes)
        if persist_routes_duration is not None:
            pulumi.set(__self__, "persist_routes_duration", persist_routes_duration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sns_notifications_enabled is not None:
            pulumi.set(__self__, "sns_notifications_enabled", sns_notifications_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="amazonSideAsn")
    def amazon_side_asn(self) -> pulumi.Input[builtins.int]:
        """
        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295.

        The following arguments are optional:
        """
        return pulumi.get(self, "amazon_side_asn")

    @amazon_side_asn.setter
    def amazon_side_asn(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "amazon_side_asn", value)

    @property
    @pulumi.getter(name="persistRoutes")
    def persist_routes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether routes should be persisted after all BGP sessions are terminated. Valid values are `enable`, `disable`, `reset`
        """
        return pulumi.get(self, "persist_routes")

    @persist_routes.setter
    def persist_routes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persist_routes", value)

    @property
    @pulumi.getter(name="persistRoutesDuration")
    def persist_routes_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB. Value must be in the range of 1-5. Required if `persist_routes` is enabled.
        """
        return pulumi.get(self, "persist_routes_duration")

    @persist_routes_duration.setter
    def persist_routes_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "persist_routes_duration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="snsNotificationsEnabled")
    def sns_notifications_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS`.
        """
        return pulumi.get(self, "sns_notifications_enabled")

    @sns_notifications_enabled.setter
    def sns_notifications_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sns_notifications_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _RouteServerState:
    def __init__(__self__, *,
                 amazon_side_asn: Optional[pulumi.Input[builtins.int]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 persist_routes: Optional[pulumi.Input[builtins.str]] = None,
                 persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering RouteServer resources.
        :param pulumi.Input[builtins.int] amazon_side_asn: The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] arn: The ARN of the route server.
        :param pulumi.Input[builtins.str] persist_routes: Indicates whether routes should be persisted after all BGP sessions are terminated. Valid values are `enable`, `disable`, `reset`
        :param pulumi.Input[builtins.int] persist_routes_duration: The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB. Value must be in the range of 1-5. Required if `persist_routes` is enabled.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_id: The unique identifier of the route server.
        :param pulumi.Input[builtins.bool] sns_notifications_enabled: Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS`.
        :param pulumi.Input[builtins.str] sns_topic_arn: The ARN of the SNS topic where notifications are published.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if amazon_side_asn is not None:
            pulumi.set(__self__, "amazon_side_asn", amazon_side_asn)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if persist_routes is not None:
            pulumi.set(__self__, "persist_routes", persist_routes)
        if persist_routes_duration is not None:
            pulumi.set(__self__, "persist_routes_duration", persist_routes_duration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_server_id is not None:
            pulumi.set(__self__, "route_server_id", route_server_id)
        if sns_notifications_enabled is not None:
            pulumi.set(__self__, "sns_notifications_enabled", sns_notifications_enabled)
        if sns_topic_arn is not None:
            pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="amazonSideAsn")
    def amazon_side_asn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295.

        The following arguments are optional:
        """
        return pulumi.get(self, "amazon_side_asn")

    @amazon_side_asn.setter
    def amazon_side_asn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "amazon_side_asn", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the route server.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="persistRoutes")
    def persist_routes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether routes should be persisted after all BGP sessions are terminated. Valid values are `enable`, `disable`, `reset`
        """
        return pulumi.get(self, "persist_routes")

    @persist_routes.setter
    def persist_routes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persist_routes", value)

    @property
    @pulumi.getter(name="persistRoutesDuration")
    def persist_routes_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB. Value must be in the range of 1-5. Required if `persist_routes` is enabled.
        """
        return pulumi.get(self, "persist_routes_duration")

    @persist_routes_duration.setter
    def persist_routes_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "persist_routes_duration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the route server.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_server_id", value)

    @property
    @pulumi.getter(name="snsNotificationsEnabled")
    def sns_notifications_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS`.
        """
        return pulumi.get(self, "sns_notifications_enabled")

    @sns_notifications_enabled.setter
    def sns_notifications_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sns_notifications_enabled", value)

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the SNS topic where notifications are published.
        """
        return pulumi.get(self, "sns_topic_arn")

    @sns_topic_arn.setter
    def sns_topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sns_topic_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:vpc/routeServer:RouteServer")
class RouteServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_side_asn: Optional[pulumi.Input[builtins.int]] = None,
                 persist_routes: Optional[pulumi.Input[builtins.str]] = None,
                 persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerTimeoutsArgs', 'RouteServerTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource for managing a VPC (Virtual Private Cloud) Route Server.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServer("test",
            amazon_side_asn=65534,
            tags={
                "Name": "Test",
            })
        ```

        ### Persist Route and SNS Notification

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServer("test",
            amazon_side_asn=65534,
            persist_routes="enable",
            persist_routes_duration=2,
            sns_notifications_enabled=True,
            tags={
                "Name": "Main Route Server",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC (Virtual Private Cloud) Route Server using the `route_server_id`. For example:

        ```sh
        $ pulumi import aws:vpc/routeServer:RouteServer example rs-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] amazon_side_asn: The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] persist_routes: Indicates whether routes should be persisted after all BGP sessions are terminated. Valid values are `enable`, `disable`, `reset`
        :param pulumi.Input[builtins.int] persist_routes_duration: The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB. Value must be in the range of 1-5. Required if `persist_routes` is enabled.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] sns_notifications_enabled: Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing a VPC (Virtual Private Cloud) Route Server.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServer("test",
            amazon_side_asn=65534,
            tags={
                "Name": "Test",
            })
        ```

        ### Persist Route and SNS Notification

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServer("test",
            amazon_side_asn=65534,
            persist_routes="enable",
            persist_routes_duration=2,
            sns_notifications_enabled=True,
            tags={
                "Name": "Main Route Server",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC (Virtual Private Cloud) Route Server using the `route_server_id`. For example:

        ```sh
        $ pulumi import aws:vpc/routeServer:RouteServer example rs-12345678
        ```

        :param str resource_name: The name of the resource.
        :param RouteServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_side_asn: Optional[pulumi.Input[builtins.int]] = None,
                 persist_routes: Optional[pulumi.Input[builtins.str]] = None,
                 persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerTimeoutsArgs', 'RouteServerTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerArgs.__new__(RouteServerArgs)

            if amazon_side_asn is None and not opts.urn:
                raise TypeError("Missing required property 'amazon_side_asn'")
            __props__.__dict__["amazon_side_asn"] = amazon_side_asn
            __props__.__dict__["persist_routes"] = persist_routes
            __props__.__dict__["persist_routes_duration"] = persist_routes_duration
            __props__.__dict__["region"] = region
            __props__.__dict__["sns_notifications_enabled"] = sns_notifications_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["route_server_id"] = None
            __props__.__dict__["sns_topic_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(RouteServer, __self__).__init__(
            'aws:vpc/routeServer:RouteServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amazon_side_asn: Optional[pulumi.Input[builtins.int]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            persist_routes: Optional[pulumi.Input[builtins.str]] = None,
            persist_routes_duration: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            route_server_id: Optional[pulumi.Input[builtins.str]] = None,
            sns_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['RouteServerTimeoutsArgs', 'RouteServerTimeoutsArgsDict']]] = None) -> 'RouteServer':
        """
        Get an existing RouteServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] amazon_side_asn: The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] arn: The ARN of the route server.
        :param pulumi.Input[builtins.str] persist_routes: Indicates whether routes should be persisted after all BGP sessions are terminated. Valid values are `enable`, `disable`, `reset`
        :param pulumi.Input[builtins.int] persist_routes_duration: The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB. Value must be in the range of 1-5. Required if `persist_routes` is enabled.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_id: The unique identifier of the route server.
        :param pulumi.Input[builtins.bool] sns_notifications_enabled: Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS`.
        :param pulumi.Input[builtins.str] sns_topic_arn: The ARN of the SNS topic where notifications are published.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServerState.__new__(_RouteServerState)

        __props__.__dict__["amazon_side_asn"] = amazon_side_asn
        __props__.__dict__["arn"] = arn
        __props__.__dict__["persist_routes"] = persist_routes
        __props__.__dict__["persist_routes_duration"] = persist_routes_duration
        __props__.__dict__["region"] = region
        __props__.__dict__["route_server_id"] = route_server_id
        __props__.__dict__["sns_notifications_enabled"] = sns_notifications_enabled
        __props__.__dict__["sns_topic_arn"] = sns_topic_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return RouteServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amazonSideAsn")
    def amazon_side_asn(self) -> pulumi.Output[builtins.int]:
        """
        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to 4294967295.

        The following arguments are optional:
        """
        return pulumi.get(self, "amazon_side_asn")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the route server.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="persistRoutes")
    def persist_routes(self) -> pulumi.Output[builtins.str]:
        """
        Indicates whether routes should be persisted after all BGP sessions are terminated. Valid values are `enable`, `disable`, `reset`
        """
        return pulumi.get(self, "persist_routes")

    @property
    @pulumi.getter(name="persistRoutesDuration")
    def persist_routes_duration(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and RIB. Value must be in the range of 1-5. Required if `persist_routes` is enabled.
        """
        return pulumi.get(self, "persist_routes_duration")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the route server.
        """
        return pulumi.get(self, "route_server_id")

    @property
    @pulumi.getter(name="snsNotificationsEnabled")
    def sns_notifications_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications persists BGP status changes to an SNS topic provisioned by AWS`.
        """
        return pulumi.get(self, "sns_notifications_enabled")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the SNS topic where notifications are published.
        """
        return pulumi.get(self, "sns_topic_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RouteServerTimeouts']]:
        return pulumi.get(self, "timeouts")

