# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteServerPeerArgs', 'RouteServerPeer']

@pulumi.input_type
class RouteServerPeerArgs:
    def __init__(__self__, *,
                 peer_address: pulumi.Input[builtins.str],
                 route_server_endpoint_id: pulumi.Input[builtins.str],
                 bgp_options: Optional[pulumi.Input['RouteServerPeerBgpOptionsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerPeerTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a RouteServerPeer resource.
        :param pulumi.Input[builtins.str] peer_address: The IPv4 address of the peer device.
        :param pulumi.Input[builtins.str] route_server_endpoint_id: The ID of the route server endpoint for which to create a peer.
               
               The following arguments are optional:
        :param pulumi.Input['RouteServerPeerBgpOptionsArgs'] bgp_options: The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings. Configuration block with BGP Options configuration Detailed below
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "peer_address", peer_address)
        pulumi.set(__self__, "route_server_endpoint_id", route_server_endpoint_id)
        if bgp_options is not None:
            pulumi.set(__self__, "bgp_options", bgp_options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> pulumi.Input[builtins.str]:
        """
        The IPv4 address of the peer device.
        """
        return pulumi.get(self, "peer_address")

    @peer_address.setter
    def peer_address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peer_address", value)

    @property
    @pulumi.getter(name="routeServerEndpointId")
    def route_server_endpoint_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the route server endpoint for which to create a peer.

        The following arguments are optional:
        """
        return pulumi.get(self, "route_server_endpoint_id")

    @route_server_endpoint_id.setter
    def route_server_endpoint_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_server_endpoint_id", value)

    @property
    @pulumi.getter(name="bgpOptions")
    def bgp_options(self) -> Optional[pulumi.Input['RouteServerPeerBgpOptionsArgs']]:
        """
        The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings. Configuration block with BGP Options configuration Detailed below
        """
        return pulumi.get(self, "bgp_options")

    @bgp_options.setter
    def bgp_options(self, value: Optional[pulumi.Input['RouteServerPeerBgpOptionsArgs']]):
        pulumi.set(self, "bgp_options", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerPeerTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerPeerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _RouteServerPeerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 bgp_options: Optional[pulumi.Input['RouteServerPeerBgpOptionsArgs']] = None,
                 endpoint_eni_address: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_eni_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_address: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_peer_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerPeerTimeoutsArgs']] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteServerPeer resources.
        :param pulumi.Input[builtins.str] arn: The ARN of the route server peer.
        :param pulumi.Input['RouteServerPeerBgpOptionsArgs'] bgp_options: The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings. Configuration block with BGP Options configuration Detailed below
        :param pulumi.Input[builtins.str] endpoint_eni_address: The IP address of the Elastic network interface for the route server endpoint.
        :param pulumi.Input[builtins.str] endpoint_eni_id: The ID of the Elastic network interface for the route server endpoint.
        :param pulumi.Input[builtins.str] peer_address: The IPv4 address of the peer device.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_endpoint_id: The ID of the route server endpoint for which to create a peer.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] route_server_id: The ID of the route server associated with this peer.
        :param pulumi.Input[builtins.str] route_server_peer_id: The unique identifier of the route server peer.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet containing the route server peer.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC containing the route server peer.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bgp_options is not None:
            pulumi.set(__self__, "bgp_options", bgp_options)
        if endpoint_eni_address is not None:
            pulumi.set(__self__, "endpoint_eni_address", endpoint_eni_address)
        if endpoint_eni_id is not None:
            pulumi.set(__self__, "endpoint_eni_id", endpoint_eni_id)
        if peer_address is not None:
            pulumi.set(__self__, "peer_address", peer_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_server_endpoint_id is not None:
            pulumi.set(__self__, "route_server_endpoint_id", route_server_endpoint_id)
        if route_server_id is not None:
            pulumi.set(__self__, "route_server_id", route_server_id)
        if route_server_peer_id is not None:
            pulumi.set(__self__, "route_server_peer_id", route_server_peer_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the route server peer.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="bgpOptions")
    def bgp_options(self) -> Optional[pulumi.Input['RouteServerPeerBgpOptionsArgs']]:
        """
        The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings. Configuration block with BGP Options configuration Detailed below
        """
        return pulumi.get(self, "bgp_options")

    @bgp_options.setter
    def bgp_options(self, value: Optional[pulumi.Input['RouteServerPeerBgpOptionsArgs']]):
        pulumi.set(self, "bgp_options", value)

    @property
    @pulumi.getter(name="endpointEniAddress")
    def endpoint_eni_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address of the Elastic network interface for the route server endpoint.
        """
        return pulumi.get(self, "endpoint_eni_address")

    @endpoint_eni_address.setter
    def endpoint_eni_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_eni_address", value)

    @property
    @pulumi.getter(name="endpointEniId")
    def endpoint_eni_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Elastic network interface for the route server endpoint.
        """
        return pulumi.get(self, "endpoint_eni_id")

    @endpoint_eni_id.setter
    def endpoint_eni_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_eni_id", value)

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv4 address of the peer device.
        """
        return pulumi.get(self, "peer_address")

    @peer_address.setter
    def peer_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_address", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeServerEndpointId")
    def route_server_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the route server endpoint for which to create a peer.

        The following arguments are optional:
        """
        return pulumi.get(self, "route_server_endpoint_id")

    @route_server_endpoint_id.setter
    def route_server_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_server_endpoint_id", value)

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the route server associated with this peer.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_server_id", value)

    @property
    @pulumi.getter(name="routeServerPeerId")
    def route_server_peer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the route server peer.
        """
        return pulumi.get(self, "route_server_peer_id")

    @route_server_peer_id.setter
    def route_server_peer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_server_peer_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the subnet containing the route server peer.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerPeerTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerPeerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VPC containing the route server peer.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:vpc/routeServerPeer:RouteServerPeer")
class RouteServerPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_options: Optional[pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']]] = None,
                 peer_address: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerPeerTimeoutsArgs', 'RouteServerPeerTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource for managing a VPC (Virtual Private Cloud) Route Server Peer.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServerPeer("test",
            route_server_endpoint_id=example["routeServerEndpointId"],
            peer_address="10.0.1.250",
            bgp_options={
                "peer_asn": 65200,
            },
            tags={
                "Name": "Appliance 1",
            })
        ```

        ### Complete Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServer("test",
            amazon_side_asn=4294967294,
            tags={
                "Name": "Test",
            })
        test_vpc_route_server_association = aws.index.VpcRouteServerAssociation("test",
            route_server_id=test.route_server_id,
            vpc_id=test_aws_vpc.id)
        test_route_server_endpoint = aws.vpc.RouteServerEndpoint("test",
            route_server_id=test.route_server_id,
            subnet_id=test_aws_subnet["id"],
            tags={
                "Name": "Test Endpoint",
            },
            opts = pulumi.ResourceOptions(depends_on=[test_vpc_route_server_association]))
        test_route_server_propagation = aws.vpc.RouteServerPropagation("test",
            route_server_id=test.route_server_id,
            route_table_id=test_aws_route_table["id"],
            opts = pulumi.ResourceOptions(depends_on=[test_vpc_route_server_association]))
        test_route_server_peer = aws.vpc.RouteServerPeer("test",
            route_server_endpoint_id=test_route_server_endpoint.route_server_endpoint_id,
            peer_address="10.0.1.250",
            bgp_options={
                "peer_asn": 65000,
                "peer_liveness_detection": "bgp-keepalive",
            },
            tags={
                "Name": "Test Appliance",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC (Virtual Private Cloud) Route Server using the `route_server_peer_id`. For example:

        ```sh
        $ pulumi import aws:vpc/routeServerPeer:RouteServerPeer example rsp-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']] bgp_options: The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings. Configuration block with BGP Options configuration Detailed below
        :param pulumi.Input[builtins.str] peer_address: The IPv4 address of the peer device.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_endpoint_id: The ID of the route server endpoint for which to create a peer.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing a VPC (Virtual Private Cloud) Route Server Peer.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServerPeer("test",
            route_server_endpoint_id=example["routeServerEndpointId"],
            peer_address="10.0.1.250",
            bgp_options={
                "peer_asn": 65200,
            },
            tags={
                "Name": "Appliance 1",
            })
        ```

        ### Complete Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServer("test",
            amazon_side_asn=4294967294,
            tags={
                "Name": "Test",
            })
        test_vpc_route_server_association = aws.index.VpcRouteServerAssociation("test",
            route_server_id=test.route_server_id,
            vpc_id=test_aws_vpc.id)
        test_route_server_endpoint = aws.vpc.RouteServerEndpoint("test",
            route_server_id=test.route_server_id,
            subnet_id=test_aws_subnet["id"],
            tags={
                "Name": "Test Endpoint",
            },
            opts = pulumi.ResourceOptions(depends_on=[test_vpc_route_server_association]))
        test_route_server_propagation = aws.vpc.RouteServerPropagation("test",
            route_server_id=test.route_server_id,
            route_table_id=test_aws_route_table["id"],
            opts = pulumi.ResourceOptions(depends_on=[test_vpc_route_server_association]))
        test_route_server_peer = aws.vpc.RouteServerPeer("test",
            route_server_endpoint_id=test_route_server_endpoint.route_server_endpoint_id,
            peer_address="10.0.1.250",
            bgp_options={
                "peer_asn": 65000,
                "peer_liveness_detection": "bgp-keepalive",
            },
            tags={
                "Name": "Test Appliance",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC (Virtual Private Cloud) Route Server using the `route_server_peer_id`. For example:

        ```sh
        $ pulumi import aws:vpc/routeServerPeer:RouteServerPeer example rsp-12345678
        ```

        :param str resource_name: The name of the resource.
        :param RouteServerPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_options: Optional[pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']]] = None,
                 peer_address: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerPeerTimeoutsArgs', 'RouteServerPeerTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerPeerArgs.__new__(RouteServerPeerArgs)

            __props__.__dict__["bgp_options"] = bgp_options
            if peer_address is None and not opts.urn:
                raise TypeError("Missing required property 'peer_address'")
            __props__.__dict__["peer_address"] = peer_address
            __props__.__dict__["region"] = region
            if route_server_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_server_endpoint_id'")
            __props__.__dict__["route_server_endpoint_id"] = route_server_endpoint_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint_eni_address"] = None
            __props__.__dict__["endpoint_eni_id"] = None
            __props__.__dict__["route_server_id"] = None
            __props__.__dict__["route_server_peer_id"] = None
            __props__.__dict__["subnet_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(RouteServerPeer, __self__).__init__(
            'aws:vpc/routeServerPeer:RouteServerPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            bgp_options: Optional[pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']]] = None,
            endpoint_eni_address: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_eni_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_address: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            route_server_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            route_server_id: Optional[pulumi.Input[builtins.str]] = None,
            route_server_peer_id: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['RouteServerPeerTimeoutsArgs', 'RouteServerPeerTimeoutsArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RouteServerPeer':
        """
        Get an existing RouteServerPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The ARN of the route server peer.
        :param pulumi.Input[Union['RouteServerPeerBgpOptionsArgs', 'RouteServerPeerBgpOptionsArgsDict']] bgp_options: The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings. Configuration block with BGP Options configuration Detailed below
        :param pulumi.Input[builtins.str] endpoint_eni_address: The IP address of the Elastic network interface for the route server endpoint.
        :param pulumi.Input[builtins.str] endpoint_eni_id: The ID of the Elastic network interface for the route server endpoint.
        :param pulumi.Input[builtins.str] peer_address: The IPv4 address of the peer device.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_endpoint_id: The ID of the route server endpoint for which to create a peer.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] route_server_id: The ID of the route server associated with this peer.
        :param pulumi.Input[builtins.str] route_server_peer_id: The unique identifier of the route server peer.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet containing the route server peer.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC containing the route server peer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServerPeerState.__new__(_RouteServerPeerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["bgp_options"] = bgp_options
        __props__.__dict__["endpoint_eni_address"] = endpoint_eni_address
        __props__.__dict__["endpoint_eni_id"] = endpoint_eni_id
        __props__.__dict__["peer_address"] = peer_address
        __props__.__dict__["region"] = region
        __props__.__dict__["route_server_endpoint_id"] = route_server_endpoint_id
        __props__.__dict__["route_server_id"] = route_server_id
        __props__.__dict__["route_server_peer_id"] = route_server_peer_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_id"] = vpc_id
        return RouteServerPeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the route server peer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bgpOptions")
    def bgp_options(self) -> pulumi.Output[Optional['outputs.RouteServerPeerBgpOptions']]:
        """
        The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding Detection) settings. Configuration block with BGP Options configuration Detailed below
        """
        return pulumi.get(self, "bgp_options")

    @property
    @pulumi.getter(name="endpointEniAddress")
    def endpoint_eni_address(self) -> pulumi.Output[builtins.str]:
        """
        The IP address of the Elastic network interface for the route server endpoint.
        """
        return pulumi.get(self, "endpoint_eni_address")

    @property
    @pulumi.getter(name="endpointEniId")
    def endpoint_eni_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Elastic network interface for the route server endpoint.
        """
        return pulumi.get(self, "endpoint_eni_id")

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> pulumi.Output[builtins.str]:
        """
        The IPv4 address of the peer device.
        """
        return pulumi.get(self, "peer_address")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeServerEndpointId")
    def route_server_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the route server endpoint for which to create a peer.

        The following arguments are optional:
        """
        return pulumi.get(self, "route_server_endpoint_id")

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the route server associated with this peer.
        """
        return pulumi.get(self, "route_server_id")

    @property
    @pulumi.getter(name="routeServerPeerId")
    def route_server_peer_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the route server peer.
        """
        return pulumi.get(self, "route_server_peer_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the subnet containing the route server peer.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RouteServerPeerTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC containing the route server peer.
        """
        return pulumi.get(self, "vpc_id")

