# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteServerVpcAssociationArgs', 'RouteServerVpcAssociation']

@pulumi.input_type
class RouteServerVpcAssociationArgs:
    def __init__(__self__, *,
                 route_server_id: pulumi.Input[builtins.str],
                 vpc_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerVpcAssociationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a RouteServerVpcAssociation resource.
        :param pulumi.Input[builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC to associate with the route server.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "route_server_id", route_server_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the route server to be associated.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_server_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the VPC to associate with the route server.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerVpcAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerVpcAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _RouteServerVpcAssociationState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerVpcAssociationTimeoutsArgs']] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteServerVpcAssociation resources.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC to associate with the route server.
               
               The following arguments are optional:
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_server_id is not None:
            pulumi.set(__self__, "route_server_id", route_server_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the route server to be associated.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_server_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerVpcAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerVpcAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VPC to associate with the route server.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:vpc/routeServerVpcAssociation:RouteServerVpcAssociation")
class RouteServerVpcAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerVpcAssociationTimeoutsArgs', 'RouteServerVpcAssociationTimeoutsArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource for managing association between VPC (Virtual Private Cloud) route server and a VPC.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpc.RouteServerVpcAssociation("example",
            route_server_id=example_aws_vpc_route_server["routeServerId"],
            vpc_id=example_aws_vpc["id"])
        ```

        ## Import

        Using `pulumi import`, to  to import VPC (Virtual Private Cloud) Route Server Association using the associated resource ID and VPC Id separated by a comma (,). For example:

        ```sh
        $ pulumi import aws:vpc/routeServerVpcAssociation:RouteServerVpcAssociation example rs-12345678,vpc-0f001273ec18911b1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC to associate with the route server.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerVpcAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing association between VPC (Virtual Private Cloud) route server and a VPC.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpc.RouteServerVpcAssociation("example",
            route_server_id=example_aws_vpc_route_server["routeServerId"],
            vpc_id=example_aws_vpc["id"])
        ```

        ## Import

        Using `pulumi import`, to  to import VPC (Virtual Private Cloud) Route Server Association using the associated resource ID and VPC Id separated by a comma (,). For example:

        ```sh
        $ pulumi import aws:vpc/routeServerVpcAssociation:RouteServerVpcAssociation example rs-12345678,vpc-0f001273ec18911b1
        ```

        :param str resource_name: The name of the resource.
        :param RouteServerVpcAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerVpcAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerVpcAssociationTimeoutsArgs', 'RouteServerVpcAssociationTimeoutsArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerVpcAssociationArgs.__new__(RouteServerVpcAssociationArgs)

            __props__.__dict__["region"] = region
            if route_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_server_id'")
            __props__.__dict__["route_server_id"] = route_server_id
            __props__.__dict__["timeouts"] = timeouts
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(RouteServerVpcAssociation, __self__).__init__(
            'aws:vpc/routeServerVpcAssociation:RouteServerVpcAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            route_server_id: Optional[pulumi.Input[builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['RouteServerVpcAssociationTimeoutsArgs', 'RouteServerVpcAssociationTimeoutsArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RouteServerVpcAssociation':
        """
        Get an existing RouteServerVpcAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC to associate with the route server.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServerVpcAssociationState.__new__(_RouteServerVpcAssociationState)

        __props__.__dict__["region"] = region
        __props__.__dict__["route_server_id"] = route_server_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_id"] = vpc_id
        return RouteServerVpcAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the route server to be associated.
        """
        return pulumi.get(self, "route_server_id")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RouteServerVpcAssociationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC to associate with the route server.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_id")

