# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceNetworkResourceAssociationArgs', 'ServiceNetworkResourceAssociation']

@pulumi.input_type
class ServiceNetworkResourceAssociationArgs:
    def __init__(__self__, *,
                 resource_configuration_identifier: pulumi.Input[builtins.str],
                 service_network_identifier: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ServiceNetworkResourceAssociationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ServiceNetworkResourceAssociation resource.
        :param pulumi.Input[builtins.str] resource_configuration_identifier: Identifier of Resource Configuration to associate to the Service Network.
        :param pulumi.Input[builtins.str] service_network_identifier: Identifier of the Service Network to associate the Resource to.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "resource_configuration_identifier", resource_configuration_identifier)
        pulumi.set(__self__, "service_network_identifier", service_network_identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="resourceConfigurationIdentifier")
    def resource_configuration_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of Resource Configuration to associate to the Service Network.
        """
        return pulumi.get(self, "resource_configuration_identifier")

    @resource_configuration_identifier.setter
    def resource_configuration_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_configuration_identifier", value)

    @property
    @pulumi.getter(name="serviceNetworkIdentifier")
    def service_network_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the Service Network to associate the Resource to.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_network_identifier")

    @service_network_identifier.setter
    def service_network_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_network_identifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ServiceNetworkResourceAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ServiceNetworkResourceAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ServiceNetworkResourceAssociationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 dns_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceNetworkResourceAssociationDnsEntryArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_configuration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ServiceNetworkResourceAssociationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ServiceNetworkResourceAssociation resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Service Network Resource Association.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceNetworkResourceAssociationDnsEntryArgs']]] dns_entries: DNS entry of the association in the service network.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_configuration_identifier: Identifier of Resource Configuration to associate to the Service Network.
        :param pulumi.Input[builtins.str] service_network_identifier: Identifier of the Service Network to associate the Resource to.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if dns_entries is not None:
            pulumi.set(__self__, "dns_entries", dns_entries)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_configuration_identifier is not None:
            pulumi.set(__self__, "resource_configuration_identifier", resource_configuration_identifier)
        if service_network_identifier is not None:
            pulumi.set(__self__, "service_network_identifier", service_network_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Service Network Resource Association.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="dnsEntries")
    def dns_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceNetworkResourceAssociationDnsEntryArgs']]]]:
        """
        DNS entry of the association in the service network.
        """
        return pulumi.get(self, "dns_entries")

    @dns_entries.setter
    def dns_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceNetworkResourceAssociationDnsEntryArgs']]]]):
        pulumi.set(self, "dns_entries", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceConfigurationIdentifier")
    def resource_configuration_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of Resource Configuration to associate to the Service Network.
        """
        return pulumi.get(self, "resource_configuration_identifier")

    @resource_configuration_identifier.setter
    def resource_configuration_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_configuration_identifier", value)

    @property
    @pulumi.getter(name="serviceNetworkIdentifier")
    def service_network_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the Service Network to associate the Resource to.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_network_identifier")

    @service_network_identifier.setter
    def service_network_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_network_identifier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ServiceNetworkResourceAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ServiceNetworkResourceAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:vpclattice/serviceNetworkResourceAssociation:ServiceNetworkResourceAssociation")
class ServiceNetworkResourceAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_configuration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ServiceNetworkResourceAssociationTimeoutsArgs', 'ServiceNetworkResourceAssociationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS VPC Lattice Service Network Resource Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.ServiceNetworkResourceAssociation("example",
            resource_configuration_identifier=example_aws_vpclattice_resource_configuration["id"],
            service_network_identifier=example_aws_vpclattice_service_network["id"],
            tags={
                "Name": "Example",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC Lattice Service Network Resource Association using the `id`. For example:

        ```sh
        $ pulumi import aws:vpclattice/serviceNetworkResourceAssociation:ServiceNetworkResourceAssociation example snra-1234567890abcef12
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_configuration_identifier: Identifier of Resource Configuration to associate to the Service Network.
        :param pulumi.Input[builtins.str] service_network_identifier: Identifier of the Service Network to associate the Resource to.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceNetworkResourceAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS VPC Lattice Service Network Resource Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.ServiceNetworkResourceAssociation("example",
            resource_configuration_identifier=example_aws_vpclattice_resource_configuration["id"],
            service_network_identifier=example_aws_vpclattice_service_network["id"],
            tags={
                "Name": "Example",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC Lattice Service Network Resource Association using the `id`. For example:

        ```sh
        $ pulumi import aws:vpclattice/serviceNetworkResourceAssociation:ServiceNetworkResourceAssociation example snra-1234567890abcef12
        ```

        :param str resource_name: The name of the resource.
        :param ServiceNetworkResourceAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceNetworkResourceAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_configuration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ServiceNetworkResourceAssociationTimeoutsArgs', 'ServiceNetworkResourceAssociationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceNetworkResourceAssociationArgs.__new__(ServiceNetworkResourceAssociationArgs)

            __props__.__dict__["region"] = region
            if resource_configuration_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'resource_configuration_identifier'")
            __props__.__dict__["resource_configuration_identifier"] = resource_configuration_identifier
            if service_network_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'service_network_identifier'")
            __props__.__dict__["service_network_identifier"] = service_network_identifier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["dns_entries"] = None
            __props__.__dict__["tags_all"] = None
        super(ServiceNetworkResourceAssociation, __self__).__init__(
            'aws:vpclattice/serviceNetworkResourceAssociation:ServiceNetworkResourceAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            dns_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceNetworkResourceAssociationDnsEntryArgs', 'ServiceNetworkResourceAssociationDnsEntryArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_configuration_identifier: Optional[pulumi.Input[builtins.str]] = None,
            service_network_identifier: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ServiceNetworkResourceAssociationTimeoutsArgs', 'ServiceNetworkResourceAssociationTimeoutsArgsDict']]] = None) -> 'ServiceNetworkResourceAssociation':
        """
        Get an existing ServiceNetworkResourceAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Service Network Resource Association.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceNetworkResourceAssociationDnsEntryArgs', 'ServiceNetworkResourceAssociationDnsEntryArgsDict']]]] dns_entries: DNS entry of the association in the service network.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_configuration_identifier: Identifier of Resource Configuration to associate to the Service Network.
        :param pulumi.Input[builtins.str] service_network_identifier: Identifier of the Service Network to associate the Resource to.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceNetworkResourceAssociationState.__new__(_ServiceNetworkResourceAssociationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["dns_entries"] = dns_entries
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_configuration_identifier"] = resource_configuration_identifier
        __props__.__dict__["service_network_identifier"] = service_network_identifier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return ServiceNetworkResourceAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Service Network Resource Association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dnsEntries")
    def dns_entries(self) -> pulumi.Output[Sequence['outputs.ServiceNetworkResourceAssociationDnsEntry']]:
        """
        DNS entry of the association in the service network.
        """
        return pulumi.get(self, "dns_entries")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceConfigurationIdentifier")
    def resource_configuration_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of Resource Configuration to associate to the Service Network.
        """
        return pulumi.get(self, "resource_configuration_identifier")

    @property
    @pulumi.getter(name="serviceNetworkIdentifier")
    def service_network_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the Service Network to associate the Resource to.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_network_identifier")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ServiceNetworkResourceAssociationTimeouts']]:
        return pulumi.get(self, "timeouts")

