# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DirectoryArgs', 'Directory']

@pulumi.input_type
class DirectoryArgs:
    def __init__(__self__, *,
                 active_directory_config: Optional[pulumi.Input['DirectoryActiveDirectoryConfigArgs']] = None,
                 certificate_based_auth_properties: Optional[pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs']] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 saml_properties: Optional[pulumi.Input['DirectorySamlPropertiesArgs']] = None,
                 self_service_permissions: Optional[pulumi.Input['DirectorySelfServicePermissionsArgs']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access_properties: Optional[pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs']] = None,
                 workspace_creation_properties: Optional[pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs']] = None,
                 workspace_directory_description: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_directory_name: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Directory resource.
        :param pulumi.Input['DirectoryActiveDirectoryConfigArgs'] active_directory_config: Configuration for Active Directory integration when `workspace_type` is set to `POOLS`. Defined below.
        :param pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs'] certificate_based_auth_properties: Configuration of certificate-based authentication (CBA) integration. Requires SAML authentication to be enabled. Defined below.
        :param pulumi.Input[builtins.str] directory_id: The directory identifier for registration in WorkSpaces service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_group_ids: The identifiers of the IP access control groups associated with the directory.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['DirectorySamlPropertiesArgs'] saml_properties: Configuration of SAML authentication integration. Defined below.
        :param pulumi.Input['DirectorySelfServicePermissionsArgs'] self_service_permissions: Permissions to enable or disable self-service capabilities when `workspace_type` is set to `PERSONAL`.. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The identifiers of the subnets where the directory resides.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_identity_type: Specifies the user identity type for the WorkSpaces directory. Valid values are `CUSTOMER_MANAGED`, `AWS_DIRECTORY_SERVICE`, `AWS_IAM_IDENTITY_CENTER`.
               
               > **Note:** When `workspace_type` is set to `POOLS`, the `directory_id` is automatically generated and cannot be manually set.
        :param pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs'] workspace_access_properties: Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
        :param pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs'] workspace_creation_properties: Default properties that are used for creating WorkSpaces. Defined below.
        :param pulumi.Input[builtins.str] workspace_directory_description: The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_directory_name: The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_type: Specifies the type of WorkSpaces directory. Valid values are `PERSONAL` and `POOLS`. Default is `PERSONAL`.
        """
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if certificate_based_auth_properties is not None:
            pulumi.set(__self__, "certificate_based_auth_properties", certificate_based_auth_properties)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if ip_group_ids is not None:
            pulumi.set(__self__, "ip_group_ids", ip_group_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if saml_properties is not None:
            pulumi.set(__self__, "saml_properties", saml_properties)
        if self_service_permissions is not None:
            pulumi.set(__self__, "self_service_permissions", self_service_permissions)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_identity_type is not None:
            pulumi.set(__self__, "user_identity_type", user_identity_type)
        if workspace_access_properties is not None:
            pulumi.set(__self__, "workspace_access_properties", workspace_access_properties)
        if workspace_creation_properties is not None:
            pulumi.set(__self__, "workspace_creation_properties", workspace_creation_properties)
        if workspace_directory_description is not None:
            pulumi.set(__self__, "workspace_directory_description", workspace_directory_description)
        if workspace_directory_name is not None:
            pulumi.set(__self__, "workspace_directory_name", workspace_directory_name)
        if workspace_type is not None:
            pulumi.set(__self__, "workspace_type", workspace_type)

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional[pulumi.Input['DirectoryActiveDirectoryConfigArgs']]:
        """
        Configuration for Active Directory integration when `workspace_type` is set to `POOLS`. Defined below.
        """
        return pulumi.get(self, "active_directory_config")

    @active_directory_config.setter
    def active_directory_config(self, value: Optional[pulumi.Input['DirectoryActiveDirectoryConfigArgs']]):
        pulumi.set(self, "active_directory_config", value)

    @property
    @pulumi.getter(name="certificateBasedAuthProperties")
    def certificate_based_auth_properties(self) -> Optional[pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs']]:
        """
        Configuration of certificate-based authentication (CBA) integration. Requires SAML authentication to be enabled. Defined below.
        """
        return pulumi.get(self, "certificate_based_auth_properties")

    @certificate_based_auth_properties.setter
    def certificate_based_auth_properties(self, value: Optional[pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs']]):
        pulumi.set(self, "certificate_based_auth_properties", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The directory identifier for registration in WorkSpaces service.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter(name="ipGroupIds")
    def ip_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The identifiers of the IP access control groups associated with the directory.
        """
        return pulumi.get(self, "ip_group_ids")

    @ip_group_ids.setter
    def ip_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_group_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="samlProperties")
    def saml_properties(self) -> Optional[pulumi.Input['DirectorySamlPropertiesArgs']]:
        """
        Configuration of SAML authentication integration. Defined below.
        """
        return pulumi.get(self, "saml_properties")

    @saml_properties.setter
    def saml_properties(self, value: Optional[pulumi.Input['DirectorySamlPropertiesArgs']]):
        pulumi.set(self, "saml_properties", value)

    @property
    @pulumi.getter(name="selfServicePermissions")
    def self_service_permissions(self) -> Optional[pulumi.Input['DirectorySelfServicePermissionsArgs']]:
        """
        Permissions to enable or disable self-service capabilities when `workspace_type` is set to `PERSONAL`.. Defined below.
        """
        return pulumi.get(self, "self_service_permissions")

    @self_service_permissions.setter
    def self_service_permissions(self, value: Optional[pulumi.Input['DirectorySelfServicePermissionsArgs']]):
        pulumi.set(self, "self_service_permissions", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The identifiers of the subnets where the directory resides.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userIdentityType")
    def user_identity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the user identity type for the WorkSpaces directory. Valid values are `CUSTOMER_MANAGED`, `AWS_DIRECTORY_SERVICE`, `AWS_IAM_IDENTITY_CENTER`.

        > **Note:** When `workspace_type` is set to `POOLS`, the `directory_id` is automatically generated and cannot be manually set.
        """
        return pulumi.get(self, "user_identity_type")

    @user_identity_type.setter
    def user_identity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_identity_type", value)

    @property
    @pulumi.getter(name="workspaceAccessProperties")
    def workspace_access_properties(self) -> Optional[pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs']]:
        """
        Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
        """
        return pulumi.get(self, "workspace_access_properties")

    @workspace_access_properties.setter
    def workspace_access_properties(self, value: Optional[pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs']]):
        pulumi.set(self, "workspace_access_properties", value)

    @property
    @pulumi.getter(name="workspaceCreationProperties")
    def workspace_creation_properties(self) -> Optional[pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs']]:
        """
        Default properties that are used for creating WorkSpaces. Defined below.
        """
        return pulumi.get(self, "workspace_creation_properties")

    @workspace_creation_properties.setter
    def workspace_creation_properties(self, value: Optional[pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs']]):
        pulumi.set(self, "workspace_creation_properties", value)

    @property
    @pulumi.getter(name="workspaceDirectoryDescription")
    def workspace_directory_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_description")

    @workspace_directory_description.setter
    def workspace_directory_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_directory_description", value)

    @property
    @pulumi.getter(name="workspaceDirectoryName")
    def workspace_directory_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_name")

    @workspace_directory_name.setter
    def workspace_directory_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_directory_name", value)

    @property
    @pulumi.getter(name="workspaceType")
    def workspace_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of WorkSpaces directory. Valid values are `PERSONAL` and `POOLS`. Default is `PERSONAL`.
        """
        return pulumi.get(self, "workspace_type")

    @workspace_type.setter
    def workspace_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_type", value)


@pulumi.input_type
class _DirectoryState:
    def __init__(__self__, *,
                 active_directory_config: Optional[pulumi.Input['DirectoryActiveDirectoryConfigArgs']] = None,
                 alias: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_based_auth_properties: Optional[pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs']] = None,
                 customer_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 directory_name: Optional[pulumi.Input[builtins.str]] = None,
                 directory_type: Optional[pulumi.Input[builtins.str]] = None,
                 dns_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 iam_role_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registration_code: Optional[pulumi.Input[builtins.str]] = None,
                 saml_properties: Optional[pulumi.Input['DirectorySamlPropertiesArgs']] = None,
                 self_service_permissions: Optional[pulumi.Input['DirectorySelfServicePermissionsArgs']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access_properties: Optional[pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs']] = None,
                 workspace_creation_properties: Optional[pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs']] = None,
                 workspace_directory_description: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_directory_name: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Directory resources.
        :param pulumi.Input['DirectoryActiveDirectoryConfigArgs'] active_directory_config: Configuration for Active Directory integration when `workspace_type` is set to `POOLS`. Defined below.
        :param pulumi.Input[builtins.str] alias: The directory alias.
        :param pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs'] certificate_based_auth_properties: Configuration of certificate-based authentication (CBA) integration. Requires SAML authentication to be enabled. Defined below.
        :param pulumi.Input[builtins.str] customer_user_name: The user name for the service account.
        :param pulumi.Input[builtins.str] directory_id: The directory identifier for registration in WorkSpaces service.
        :param pulumi.Input[builtins.str] directory_name: The name of the directory.
        :param pulumi.Input[builtins.str] directory_type: The directory type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_ip_addresses: The IP addresses of the DNS servers for the directory.
        :param pulumi.Input[builtins.str] iam_role_id: The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_group_ids: The identifiers of the IP access control groups associated with the directory.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] registration_code: The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
        :param pulumi.Input['DirectorySamlPropertiesArgs'] saml_properties: Configuration of SAML authentication integration. Defined below.
        :param pulumi.Input['DirectorySelfServicePermissionsArgs'] self_service_permissions: Permissions to enable or disable self-service capabilities when `workspace_type` is set to `PERSONAL`.. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The identifiers of the subnets where the directory resides.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] user_identity_type: Specifies the user identity type for the WorkSpaces directory. Valid values are `CUSTOMER_MANAGED`, `AWS_DIRECTORY_SERVICE`, `AWS_IAM_IDENTITY_CENTER`.
               
               > **Note:** When `workspace_type` is set to `POOLS`, the `directory_id` is automatically generated and cannot be manually set.
        :param pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs'] workspace_access_properties: Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
        :param pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs'] workspace_creation_properties: Default properties that are used for creating WorkSpaces. Defined below.
        :param pulumi.Input[builtins.str] workspace_directory_description: The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_directory_name: The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_security_group_id: The identifier of the security group that is assigned to new WorkSpaces.
        :param pulumi.Input[builtins.str] workspace_type: Specifies the type of WorkSpaces directory. Valid values are `PERSONAL` and `POOLS`. Default is `PERSONAL`.
        """
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if certificate_based_auth_properties is not None:
            pulumi.set(__self__, "certificate_based_auth_properties", certificate_based_auth_properties)
        if customer_user_name is not None:
            pulumi.set(__self__, "customer_user_name", customer_user_name)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if directory_type is not None:
            pulumi.set(__self__, "directory_type", directory_type)
        if dns_ip_addresses is not None:
            pulumi.set(__self__, "dns_ip_addresses", dns_ip_addresses)
        if iam_role_id is not None:
            pulumi.set(__self__, "iam_role_id", iam_role_id)
        if ip_group_ids is not None:
            pulumi.set(__self__, "ip_group_ids", ip_group_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registration_code is not None:
            pulumi.set(__self__, "registration_code", registration_code)
        if saml_properties is not None:
            pulumi.set(__self__, "saml_properties", saml_properties)
        if self_service_permissions is not None:
            pulumi.set(__self__, "self_service_permissions", self_service_permissions)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_identity_type is not None:
            pulumi.set(__self__, "user_identity_type", user_identity_type)
        if workspace_access_properties is not None:
            pulumi.set(__self__, "workspace_access_properties", workspace_access_properties)
        if workspace_creation_properties is not None:
            pulumi.set(__self__, "workspace_creation_properties", workspace_creation_properties)
        if workspace_directory_description is not None:
            pulumi.set(__self__, "workspace_directory_description", workspace_directory_description)
        if workspace_directory_name is not None:
            pulumi.set(__self__, "workspace_directory_name", workspace_directory_name)
        if workspace_security_group_id is not None:
            pulumi.set(__self__, "workspace_security_group_id", workspace_security_group_id)
        if workspace_type is not None:
            pulumi.set(__self__, "workspace_type", workspace_type)

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional[pulumi.Input['DirectoryActiveDirectoryConfigArgs']]:
        """
        Configuration for Active Directory integration when `workspace_type` is set to `POOLS`. Defined below.
        """
        return pulumi.get(self, "active_directory_config")

    @active_directory_config.setter
    def active_directory_config(self, value: Optional[pulumi.Input['DirectoryActiveDirectoryConfigArgs']]):
        pulumi.set(self, "active_directory_config", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The directory alias.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="certificateBasedAuthProperties")
    def certificate_based_auth_properties(self) -> Optional[pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs']]:
        """
        Configuration of certificate-based authentication (CBA) integration. Requires SAML authentication to be enabled. Defined below.
        """
        return pulumi.get(self, "certificate_based_auth_properties")

    @certificate_based_auth_properties.setter
    def certificate_based_auth_properties(self, value: Optional[pulumi.Input['DirectoryCertificateBasedAuthPropertiesArgs']]):
        pulumi.set(self, "certificate_based_auth_properties", value)

    @property
    @pulumi.getter(name="customerUserName")
    def customer_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user name for the service account.
        """
        return pulumi.get(self, "customer_user_name")

    @customer_user_name.setter
    def customer_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_user_name", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The directory identifier for registration in WorkSpaces service.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the directory.
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_name", value)

    @property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The directory type.
        """
        return pulumi.get(self, "directory_type")

    @directory_type.setter
    def directory_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_type", value)

    @property
    @pulumi.getter(name="dnsIpAddresses")
    def dns_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IP addresses of the DNS servers for the directory.
        """
        return pulumi.get(self, "dns_ip_addresses")

    @dns_ip_addresses.setter
    def dns_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_ip_addresses", value)

    @property
    @pulumi.getter(name="iamRoleId")
    def iam_role_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
        """
        return pulumi.get(self, "iam_role_id")

    @iam_role_id.setter
    def iam_role_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_role_id", value)

    @property
    @pulumi.getter(name="ipGroupIds")
    def ip_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The identifiers of the IP access control groups associated with the directory.
        """
        return pulumi.get(self, "ip_group_ids")

    @ip_group_ids.setter
    def ip_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_group_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registrationCode")
    def registration_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
        """
        return pulumi.get(self, "registration_code")

    @registration_code.setter
    def registration_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registration_code", value)

    @property
    @pulumi.getter(name="samlProperties")
    def saml_properties(self) -> Optional[pulumi.Input['DirectorySamlPropertiesArgs']]:
        """
        Configuration of SAML authentication integration. Defined below.
        """
        return pulumi.get(self, "saml_properties")

    @saml_properties.setter
    def saml_properties(self, value: Optional[pulumi.Input['DirectorySamlPropertiesArgs']]):
        pulumi.set(self, "saml_properties", value)

    @property
    @pulumi.getter(name="selfServicePermissions")
    def self_service_permissions(self) -> Optional[pulumi.Input['DirectorySelfServicePermissionsArgs']]:
        """
        Permissions to enable or disable self-service capabilities when `workspace_type` is set to `PERSONAL`.. Defined below.
        """
        return pulumi.get(self, "self_service_permissions")

    @self_service_permissions.setter
    def self_service_permissions(self, value: Optional[pulumi.Input['DirectorySelfServicePermissionsArgs']]):
        pulumi.set(self, "self_service_permissions", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The identifiers of the subnets where the directory resides.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="userIdentityType")
    def user_identity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the user identity type for the WorkSpaces directory. Valid values are `CUSTOMER_MANAGED`, `AWS_DIRECTORY_SERVICE`, `AWS_IAM_IDENTITY_CENTER`.

        > **Note:** When `workspace_type` is set to `POOLS`, the `directory_id` is automatically generated and cannot be manually set.
        """
        return pulumi.get(self, "user_identity_type")

    @user_identity_type.setter
    def user_identity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_identity_type", value)

    @property
    @pulumi.getter(name="workspaceAccessProperties")
    def workspace_access_properties(self) -> Optional[pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs']]:
        """
        Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
        """
        return pulumi.get(self, "workspace_access_properties")

    @workspace_access_properties.setter
    def workspace_access_properties(self, value: Optional[pulumi.Input['DirectoryWorkspaceAccessPropertiesArgs']]):
        pulumi.set(self, "workspace_access_properties", value)

    @property
    @pulumi.getter(name="workspaceCreationProperties")
    def workspace_creation_properties(self) -> Optional[pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs']]:
        """
        Default properties that are used for creating WorkSpaces. Defined below.
        """
        return pulumi.get(self, "workspace_creation_properties")

    @workspace_creation_properties.setter
    def workspace_creation_properties(self, value: Optional[pulumi.Input['DirectoryWorkspaceCreationPropertiesArgs']]):
        pulumi.set(self, "workspace_creation_properties", value)

    @property
    @pulumi.getter(name="workspaceDirectoryDescription")
    def workspace_directory_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_description")

    @workspace_directory_description.setter
    def workspace_directory_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_directory_description", value)

    @property
    @pulumi.getter(name="workspaceDirectoryName")
    def workspace_directory_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_name")

    @workspace_directory_name.setter
    def workspace_directory_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_directory_name", value)

    @property
    @pulumi.getter(name="workspaceSecurityGroupId")
    def workspace_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the security group that is assigned to new WorkSpaces.
        """
        return pulumi.get(self, "workspace_security_group_id")

    @workspace_security_group_id.setter
    def workspace_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_security_group_id", value)

    @property
    @pulumi.getter(name="workspaceType")
    def workspace_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of WorkSpaces directory. Valid values are `PERSONAL` and `POOLS`. Default is `PERSONAL`.
        """
        return pulumi.get(self, "workspace_type")

    @workspace_type.setter
    def workspace_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_type", value)


@pulumi.type_token("aws:workspaces/directory:Directory")
class Directory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory_config: Optional[pulumi.Input[Union['DirectoryActiveDirectoryConfigArgs', 'DirectoryActiveDirectoryConfigArgsDict']]] = None,
                 certificate_based_auth_properties: Optional[pulumi.Input[Union['DirectoryCertificateBasedAuthPropertiesArgs', 'DirectoryCertificateBasedAuthPropertiesArgsDict']]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 saml_properties: Optional[pulumi.Input[Union['DirectorySamlPropertiesArgs', 'DirectorySamlPropertiesArgsDict']]] = None,
                 self_service_permissions: Optional[pulumi.Input[Union['DirectorySelfServicePermissionsArgs', 'DirectorySelfServicePermissionsArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access_properties: Optional[pulumi.Input[Union['DirectoryWorkspaceAccessPropertiesArgs', 'DirectoryWorkspaceAccessPropertiesArgsDict']]] = None,
                 workspace_creation_properties: Optional[pulumi.Input[Union['DirectoryWorkspaceCreationPropertiesArgs', 'DirectoryWorkspaceCreationPropertiesArgsDict']]] = None,
                 workspace_directory_description: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_directory_name: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a WorkSpaces directory in AWS WorkSpaces Service.

        > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
        example_a = aws.ec2.Subnet("example_a",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1a",
            cidr_block="10.0.0.0/24")
        example_b = aws.ec2.Subnet("example_b",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1b",
            cidr_block="10.0.1.0/24")
        example_directory = aws.directoryservice.Directory("example",
            name="corp.example.com",
            password="#S1ncerely",
            size="Small",
            vpc_settings={
                "vpc_id": example_vpc.id,
                "subnet_ids": [
                    example_a.id,
                    example_b.id,
                ],
            })
        workspaces = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["workspaces.amazonaws.com"],
            }],
        }])
        workspaces_default = aws.iam.Role("workspaces_default",
            name="workspaces_DefaultRole",
            assume_role_policy=workspaces.json)
        workspaces_default_service_access = aws.iam.RolePolicyAttachment("workspaces_default_service_access",
            role=workspaces_default.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess")
        workspaces_default_self_service_access = aws.iam.RolePolicyAttachment("workspaces_default_self_service_access",
            role=workspaces_default.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess")
        example_c = aws.ec2.Subnet("example_c",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1c",
            cidr_block="10.0.2.0/24")
        example_d = aws.ec2.Subnet("example_d",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1d",
            cidr_block="10.0.3.0/24")
        example = aws.workspaces.Directory("example",
            directory_id=example_directory.id,
            subnet_ids=[
                example_c.id,
                example_d.id,
            ],
            tags={
                "Example": "true",
            },
            certificate_based_auth_properties={
                "certificate_authority_arn": "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012",
                "status": "ENABLED",
            },
            saml_properties={
                "user_access_url": "https://sso.example.com/",
                "status": "ENABLED",
            },
            self_service_permissions={
                "change_compute_type": True,
                "increase_volume_size": True,
                "rebuild_workspace": True,
                "restart_workspace": True,
                "switch_running_mode": True,
            },
            workspace_access_properties={
                "device_type_android": "ALLOW",
                "device_type_chromeos": "ALLOW",
                "device_type_ios": "ALLOW",
                "device_type_linux": "DENY",
                "device_type_osx": "ALLOW",
                "device_type_web": "DENY",
                "device_type_windows": "DENY",
                "device_type_zeroclient": "DENY",
            },
            workspace_creation_properties={
                "custom_security_group_id": example_aws_security_group["id"],
                "default_ou": "OU=AWS,DC=Workgroup,DC=Example,DC=com",
                "enable_internet_access": True,
                "enable_maintenance_mode": True,
                "user_enabled_as_local_administrator": True,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    workspaces_default_service_access,
                    workspaces_default_self_service_access,
                ]))
        ```

        ### WorkSpaces Pools

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspaces.Directory("example",
            subnet_ids=[
                example_c["id"],
                example_d["id"],
            ],
            workspace_type="POOLS",
            workspace_directory_name="Pool directory",
            workspace_directory_description="WorkSpaces Pools directory",
            user_identity_type="CUSTOMER_MANAGED",
            active_directory_config={
                "domain_name": "example.internal",
                "service_account_secret_arn": example_aws_secretsmanager_secret["arn"],
            },
            workspace_access_properties={
                "device_type_android": "ALLOW",
                "device_type_chromeos": "ALLOW",
                "device_type_ios": "ALLOW",
                "device_type_linux": "DENY",
                "device_type_osx": "ALLOW",
                "device_type_web": "DENY",
                "device_type_windows": "DENY",
                "device_type_zeroclient": "DENY",
            },
            workspace_creation_properties={
                "custom_security_group_id": example_aws_security_group["id"],
                "default_ou": "OU=AWS,DC=Workgroup,DC=Example,DC=com",
                "enable_internet_access": True,
            },
            saml_properties={
                "relay_state_parameter_name": "RelayState",
                "user_access_url": "https://sso.example.com/",
                "status": "ENABLED",
            })
        ```

        ### IP Groups

        ```python
        import pulumi
        import pulumi_aws as aws

        example_ip_group = aws.workspaces.IpGroup("example", name="example")
        example = aws.workspaces.Directory("example",
            directory_id=example_aws_directory_service_directory["id"],
            ip_group_ids=[example_ip_group.id])
        ```

        ## Import

        Using `pulumi import`, import Workspaces directory using the directory ID. For example:

        ```sh
        $ pulumi import aws:workspaces/directory:Directory main d-4444444444
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DirectoryActiveDirectoryConfigArgs', 'DirectoryActiveDirectoryConfigArgsDict']] active_directory_config: Configuration for Active Directory integration when `workspace_type` is set to `POOLS`. Defined below.
        :param pulumi.Input[Union['DirectoryCertificateBasedAuthPropertiesArgs', 'DirectoryCertificateBasedAuthPropertiesArgsDict']] certificate_based_auth_properties: Configuration of certificate-based authentication (CBA) integration. Requires SAML authentication to be enabled. Defined below.
        :param pulumi.Input[builtins.str] directory_id: The directory identifier for registration in WorkSpaces service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_group_ids: The identifiers of the IP access control groups associated with the directory.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['DirectorySamlPropertiesArgs', 'DirectorySamlPropertiesArgsDict']] saml_properties: Configuration of SAML authentication integration. Defined below.
        :param pulumi.Input[Union['DirectorySelfServicePermissionsArgs', 'DirectorySelfServicePermissionsArgsDict']] self_service_permissions: Permissions to enable or disable self-service capabilities when `workspace_type` is set to `PERSONAL`.. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The identifiers of the subnets where the directory resides.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_identity_type: Specifies the user identity type for the WorkSpaces directory. Valid values are `CUSTOMER_MANAGED`, `AWS_DIRECTORY_SERVICE`, `AWS_IAM_IDENTITY_CENTER`.
               
               > **Note:** When `workspace_type` is set to `POOLS`, the `directory_id` is automatically generated and cannot be manually set.
        :param pulumi.Input[Union['DirectoryWorkspaceAccessPropertiesArgs', 'DirectoryWorkspaceAccessPropertiesArgsDict']] workspace_access_properties: Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
        :param pulumi.Input[Union['DirectoryWorkspaceCreationPropertiesArgs', 'DirectoryWorkspaceCreationPropertiesArgsDict']] workspace_creation_properties: Default properties that are used for creating WorkSpaces. Defined below.
        :param pulumi.Input[builtins.str] workspace_directory_description: The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_directory_name: The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_type: Specifies the type of WorkSpaces directory. Valid values are `PERSONAL` and `POOLS`. Default is `PERSONAL`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DirectoryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a WorkSpaces directory in AWS WorkSpaces Service.

        > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
        example_a = aws.ec2.Subnet("example_a",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1a",
            cidr_block="10.0.0.0/24")
        example_b = aws.ec2.Subnet("example_b",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1b",
            cidr_block="10.0.1.0/24")
        example_directory = aws.directoryservice.Directory("example",
            name="corp.example.com",
            password="#S1ncerely",
            size="Small",
            vpc_settings={
                "vpc_id": example_vpc.id,
                "subnet_ids": [
                    example_a.id,
                    example_b.id,
                ],
            })
        workspaces = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["workspaces.amazonaws.com"],
            }],
        }])
        workspaces_default = aws.iam.Role("workspaces_default",
            name="workspaces_DefaultRole",
            assume_role_policy=workspaces.json)
        workspaces_default_service_access = aws.iam.RolePolicyAttachment("workspaces_default_service_access",
            role=workspaces_default.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess")
        workspaces_default_self_service_access = aws.iam.RolePolicyAttachment("workspaces_default_self_service_access",
            role=workspaces_default.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess")
        example_c = aws.ec2.Subnet("example_c",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1c",
            cidr_block="10.0.2.0/24")
        example_d = aws.ec2.Subnet("example_d",
            vpc_id=example_vpc.id,
            availability_zone="us-east-1d",
            cidr_block="10.0.3.0/24")
        example = aws.workspaces.Directory("example",
            directory_id=example_directory.id,
            subnet_ids=[
                example_c.id,
                example_d.id,
            ],
            tags={
                "Example": "true",
            },
            certificate_based_auth_properties={
                "certificate_authority_arn": "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012",
                "status": "ENABLED",
            },
            saml_properties={
                "user_access_url": "https://sso.example.com/",
                "status": "ENABLED",
            },
            self_service_permissions={
                "change_compute_type": True,
                "increase_volume_size": True,
                "rebuild_workspace": True,
                "restart_workspace": True,
                "switch_running_mode": True,
            },
            workspace_access_properties={
                "device_type_android": "ALLOW",
                "device_type_chromeos": "ALLOW",
                "device_type_ios": "ALLOW",
                "device_type_linux": "DENY",
                "device_type_osx": "ALLOW",
                "device_type_web": "DENY",
                "device_type_windows": "DENY",
                "device_type_zeroclient": "DENY",
            },
            workspace_creation_properties={
                "custom_security_group_id": example_aws_security_group["id"],
                "default_ou": "OU=AWS,DC=Workgroup,DC=Example,DC=com",
                "enable_internet_access": True,
                "enable_maintenance_mode": True,
                "user_enabled_as_local_administrator": True,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    workspaces_default_service_access,
                    workspaces_default_self_service_access,
                ]))
        ```

        ### WorkSpaces Pools

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspaces.Directory("example",
            subnet_ids=[
                example_c["id"],
                example_d["id"],
            ],
            workspace_type="POOLS",
            workspace_directory_name="Pool directory",
            workspace_directory_description="WorkSpaces Pools directory",
            user_identity_type="CUSTOMER_MANAGED",
            active_directory_config={
                "domain_name": "example.internal",
                "service_account_secret_arn": example_aws_secretsmanager_secret["arn"],
            },
            workspace_access_properties={
                "device_type_android": "ALLOW",
                "device_type_chromeos": "ALLOW",
                "device_type_ios": "ALLOW",
                "device_type_linux": "DENY",
                "device_type_osx": "ALLOW",
                "device_type_web": "DENY",
                "device_type_windows": "DENY",
                "device_type_zeroclient": "DENY",
            },
            workspace_creation_properties={
                "custom_security_group_id": example_aws_security_group["id"],
                "default_ou": "OU=AWS,DC=Workgroup,DC=Example,DC=com",
                "enable_internet_access": True,
            },
            saml_properties={
                "relay_state_parameter_name": "RelayState",
                "user_access_url": "https://sso.example.com/",
                "status": "ENABLED",
            })
        ```

        ### IP Groups

        ```python
        import pulumi
        import pulumi_aws as aws

        example_ip_group = aws.workspaces.IpGroup("example", name="example")
        example = aws.workspaces.Directory("example",
            directory_id=example_aws_directory_service_directory["id"],
            ip_group_ids=[example_ip_group.id])
        ```

        ## Import

        Using `pulumi import`, import Workspaces directory using the directory ID. For example:

        ```sh
        $ pulumi import aws:workspaces/directory:Directory main d-4444444444
        ```

        :param str resource_name: The name of the resource.
        :param DirectoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory_config: Optional[pulumi.Input[Union['DirectoryActiveDirectoryConfigArgs', 'DirectoryActiveDirectoryConfigArgsDict']]] = None,
                 certificate_based_auth_properties: Optional[pulumi.Input[Union['DirectoryCertificateBasedAuthPropertiesArgs', 'DirectoryCertificateBasedAuthPropertiesArgsDict']]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 saml_properties: Optional[pulumi.Input[Union['DirectorySamlPropertiesArgs', 'DirectorySamlPropertiesArgsDict']]] = None,
                 self_service_permissions: Optional[pulumi.Input[Union['DirectorySelfServicePermissionsArgs', 'DirectorySelfServicePermissionsArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access_properties: Optional[pulumi.Input[Union['DirectoryWorkspaceAccessPropertiesArgs', 'DirectoryWorkspaceAccessPropertiesArgsDict']]] = None,
                 workspace_creation_properties: Optional[pulumi.Input[Union['DirectoryWorkspaceCreationPropertiesArgs', 'DirectoryWorkspaceCreationPropertiesArgsDict']]] = None,
                 workspace_directory_description: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_directory_name: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectoryArgs.__new__(DirectoryArgs)

            __props__.__dict__["active_directory_config"] = active_directory_config
            __props__.__dict__["certificate_based_auth_properties"] = certificate_based_auth_properties
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["ip_group_ids"] = ip_group_ids
            __props__.__dict__["region"] = region
            __props__.__dict__["saml_properties"] = saml_properties
            __props__.__dict__["self_service_permissions"] = self_service_permissions
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_identity_type"] = user_identity_type
            __props__.__dict__["workspace_access_properties"] = workspace_access_properties
            __props__.__dict__["workspace_creation_properties"] = workspace_creation_properties
            __props__.__dict__["workspace_directory_description"] = workspace_directory_description
            __props__.__dict__["workspace_directory_name"] = workspace_directory_name
            __props__.__dict__["workspace_type"] = workspace_type
            __props__.__dict__["alias"] = None
            __props__.__dict__["customer_user_name"] = None
            __props__.__dict__["directory_name"] = None
            __props__.__dict__["directory_type"] = None
            __props__.__dict__["dns_ip_addresses"] = None
            __props__.__dict__["iam_role_id"] = None
            __props__.__dict__["registration_code"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["workspace_security_group_id"] = None
        super(Directory, __self__).__init__(
            'aws:workspaces/directory:Directory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_directory_config: Optional[pulumi.Input[Union['DirectoryActiveDirectoryConfigArgs', 'DirectoryActiveDirectoryConfigArgsDict']]] = None,
            alias: Optional[pulumi.Input[builtins.str]] = None,
            certificate_based_auth_properties: Optional[pulumi.Input[Union['DirectoryCertificateBasedAuthPropertiesArgs', 'DirectoryCertificateBasedAuthPropertiesArgsDict']]] = None,
            customer_user_name: Optional[pulumi.Input[builtins.str]] = None,
            directory_id: Optional[pulumi.Input[builtins.str]] = None,
            directory_name: Optional[pulumi.Input[builtins.str]] = None,
            directory_type: Optional[pulumi.Input[builtins.str]] = None,
            dns_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            iam_role_id: Optional[pulumi.Input[builtins.str]] = None,
            ip_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            registration_code: Optional[pulumi.Input[builtins.str]] = None,
            saml_properties: Optional[pulumi.Input[Union['DirectorySamlPropertiesArgs', 'DirectorySamlPropertiesArgsDict']]] = None,
            self_service_permissions: Optional[pulumi.Input[Union['DirectorySelfServicePermissionsArgs', 'DirectorySelfServicePermissionsArgsDict']]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            user_identity_type: Optional[pulumi.Input[builtins.str]] = None,
            workspace_access_properties: Optional[pulumi.Input[Union['DirectoryWorkspaceAccessPropertiesArgs', 'DirectoryWorkspaceAccessPropertiesArgsDict']]] = None,
            workspace_creation_properties: Optional[pulumi.Input[Union['DirectoryWorkspaceCreationPropertiesArgs', 'DirectoryWorkspaceCreationPropertiesArgsDict']]] = None,
            workspace_directory_description: Optional[pulumi.Input[builtins.str]] = None,
            workspace_directory_name: Optional[pulumi.Input[builtins.str]] = None,
            workspace_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
            workspace_type: Optional[pulumi.Input[builtins.str]] = None) -> 'Directory':
        """
        Get an existing Directory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DirectoryActiveDirectoryConfigArgs', 'DirectoryActiveDirectoryConfigArgsDict']] active_directory_config: Configuration for Active Directory integration when `workspace_type` is set to `POOLS`. Defined below.
        :param pulumi.Input[builtins.str] alias: The directory alias.
        :param pulumi.Input[Union['DirectoryCertificateBasedAuthPropertiesArgs', 'DirectoryCertificateBasedAuthPropertiesArgsDict']] certificate_based_auth_properties: Configuration of certificate-based authentication (CBA) integration. Requires SAML authentication to be enabled. Defined below.
        :param pulumi.Input[builtins.str] customer_user_name: The user name for the service account.
        :param pulumi.Input[builtins.str] directory_id: The directory identifier for registration in WorkSpaces service.
        :param pulumi.Input[builtins.str] directory_name: The name of the directory.
        :param pulumi.Input[builtins.str] directory_type: The directory type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_ip_addresses: The IP addresses of the DNS servers for the directory.
        :param pulumi.Input[builtins.str] iam_role_id: The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_group_ids: The identifiers of the IP access control groups associated with the directory.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] registration_code: The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
        :param pulumi.Input[Union['DirectorySamlPropertiesArgs', 'DirectorySamlPropertiesArgsDict']] saml_properties: Configuration of SAML authentication integration. Defined below.
        :param pulumi.Input[Union['DirectorySelfServicePermissionsArgs', 'DirectorySelfServicePermissionsArgsDict']] self_service_permissions: Permissions to enable or disable self-service capabilities when `workspace_type` is set to `PERSONAL`.. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The identifiers of the subnets where the directory resides.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] user_identity_type: Specifies the user identity type for the WorkSpaces directory. Valid values are `CUSTOMER_MANAGED`, `AWS_DIRECTORY_SERVICE`, `AWS_IAM_IDENTITY_CENTER`.
               
               > **Note:** When `workspace_type` is set to `POOLS`, the `directory_id` is automatically generated and cannot be manually set.
        :param pulumi.Input[Union['DirectoryWorkspaceAccessPropertiesArgs', 'DirectoryWorkspaceAccessPropertiesArgsDict']] workspace_access_properties: Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
        :param pulumi.Input[Union['DirectoryWorkspaceCreationPropertiesArgs', 'DirectoryWorkspaceCreationPropertiesArgsDict']] workspace_creation_properties: Default properties that are used for creating WorkSpaces. Defined below.
        :param pulumi.Input[builtins.str] workspace_directory_description: The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_directory_name: The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        :param pulumi.Input[builtins.str] workspace_security_group_id: The identifier of the security group that is assigned to new WorkSpaces.
        :param pulumi.Input[builtins.str] workspace_type: Specifies the type of WorkSpaces directory. Valid values are `PERSONAL` and `POOLS`. Default is `PERSONAL`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DirectoryState.__new__(_DirectoryState)

        __props__.__dict__["active_directory_config"] = active_directory_config
        __props__.__dict__["alias"] = alias
        __props__.__dict__["certificate_based_auth_properties"] = certificate_based_auth_properties
        __props__.__dict__["customer_user_name"] = customer_user_name
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["directory_name"] = directory_name
        __props__.__dict__["directory_type"] = directory_type
        __props__.__dict__["dns_ip_addresses"] = dns_ip_addresses
        __props__.__dict__["iam_role_id"] = iam_role_id
        __props__.__dict__["ip_group_ids"] = ip_group_ids
        __props__.__dict__["region"] = region
        __props__.__dict__["registration_code"] = registration_code
        __props__.__dict__["saml_properties"] = saml_properties
        __props__.__dict__["self_service_permissions"] = self_service_permissions
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_identity_type"] = user_identity_type
        __props__.__dict__["workspace_access_properties"] = workspace_access_properties
        __props__.__dict__["workspace_creation_properties"] = workspace_creation_properties
        __props__.__dict__["workspace_directory_description"] = workspace_directory_description
        __props__.__dict__["workspace_directory_name"] = workspace_directory_name
        __props__.__dict__["workspace_security_group_id"] = workspace_security_group_id
        __props__.__dict__["workspace_type"] = workspace_type
        return Directory(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> pulumi.Output[Optional['outputs.DirectoryActiveDirectoryConfig']]:
        """
        Configuration for Active Directory integration when `workspace_type` is set to `POOLS`. Defined below.
        """
        return pulumi.get(self, "active_directory_config")

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[builtins.str]:
        """
        The directory alias.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateBasedAuthProperties")
    def certificate_based_auth_properties(self) -> pulumi.Output['outputs.DirectoryCertificateBasedAuthProperties']:
        """
        Configuration of certificate-based authentication (CBA) integration. Requires SAML authentication to be enabled. Defined below.
        """
        return pulumi.get(self, "certificate_based_auth_properties")

    @property
    @pulumi.getter(name="customerUserName")
    def customer_user_name(self) -> pulumi.Output[builtins.str]:
        """
        The user name for the service account.
        """
        return pulumi.get(self, "customer_user_name")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[builtins.str]:
        """
        The directory identifier for registration in WorkSpaces service.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the directory.
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> pulumi.Output[builtins.str]:
        """
        The directory type.
        """
        return pulumi.get(self, "directory_type")

    @property
    @pulumi.getter(name="dnsIpAddresses")
    def dns_ip_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The IP addresses of the DNS servers for the directory.
        """
        return pulumi.get(self, "dns_ip_addresses")

    @property
    @pulumi.getter(name="iamRoleId")
    def iam_role_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
        """
        return pulumi.get(self, "iam_role_id")

    @property
    @pulumi.getter(name="ipGroupIds")
    def ip_group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The identifiers of the IP access control groups associated with the directory.
        """
        return pulumi.get(self, "ip_group_ids")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registrationCode")
    def registration_code(self) -> pulumi.Output[builtins.str]:
        """
        The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
        """
        return pulumi.get(self, "registration_code")

    @property
    @pulumi.getter(name="samlProperties")
    def saml_properties(self) -> pulumi.Output['outputs.DirectorySamlProperties']:
        """
        Configuration of SAML authentication integration. Defined below.
        """
        return pulumi.get(self, "saml_properties")

    @property
    @pulumi.getter(name="selfServicePermissions")
    def self_service_permissions(self) -> pulumi.Output['outputs.DirectorySelfServicePermissions']:
        """
        Permissions to enable or disable self-service capabilities when `workspace_type` is set to `PERSONAL`.. Defined below.
        """
        return pulumi.get(self, "self_service_permissions")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The identifiers of the subnets where the directory resides.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="userIdentityType")
    def user_identity_type(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the user identity type for the WorkSpaces directory. Valid values are `CUSTOMER_MANAGED`, `AWS_DIRECTORY_SERVICE`, `AWS_IAM_IDENTITY_CENTER`.

        > **Note:** When `workspace_type` is set to `POOLS`, the `directory_id` is automatically generated and cannot be manually set.
        """
        return pulumi.get(self, "user_identity_type")

    @property
    @pulumi.getter(name="workspaceAccessProperties")
    def workspace_access_properties(self) -> pulumi.Output['outputs.DirectoryWorkspaceAccessProperties']:
        """
        Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
        """
        return pulumi.get(self, "workspace_access_properties")

    @property
    @pulumi.getter(name="workspaceCreationProperties")
    def workspace_creation_properties(self) -> pulumi.Output['outputs.DirectoryWorkspaceCreationProperties']:
        """
        Default properties that are used for creating WorkSpaces. Defined below.
        """
        return pulumi.get(self, "workspace_creation_properties")

    @property
    @pulumi.getter(name="workspaceDirectoryDescription")
    def workspace_directory_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_description")

    @property
    @pulumi.getter(name="workspaceDirectoryName")
    def workspace_directory_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_name")

    @property
    @pulumi.getter(name="workspaceSecurityGroupId")
    def workspace_security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the security group that is assigned to new WorkSpaces.
        """
        return pulumi.get(self, "workspace_security_group_id")

    @property
    @pulumi.getter(name="workspaceType")
    def workspace_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the type of WorkSpaces directory. Valid values are `PERSONAL` and `POOLS`. Default is `PERSONAL`.
        """
        return pulumi.get(self, "workspace_type")

