# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDirectoryResult',
    'AwaitableGetDirectoryResult',
    'get_directory',
    'get_directory_output',
]

@pulumi.output_type
class GetDirectoryResult:
    """
    A collection of values returned by getDirectory.
    """
    def __init__(__self__, active_directory_configs=None, alias=None, certificate_based_auth_properties=None, customer_user_name=None, directory_id=None, directory_name=None, directory_type=None, dns_ip_addresses=None, iam_role_id=None, id=None, ip_group_ids=None, region=None, registration_code=None, saml_properties=None, self_service_permissions=None, subnet_ids=None, tags=None, user_identity_type=None, workspace_access_properties=None, workspace_creation_properties=None, workspace_directory_description=None, workspace_directory_name=None, workspace_security_group_id=None, workspace_type=None):
        if active_directory_configs and not isinstance(active_directory_configs, list):
            raise TypeError("Expected argument 'active_directory_configs' to be a list")
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if certificate_based_auth_properties and not isinstance(certificate_based_auth_properties, list):
            raise TypeError("Expected argument 'certificate_based_auth_properties' to be a list")
        pulumi.set(__self__, "certificate_based_auth_properties", certificate_based_auth_properties)
        if customer_user_name and not isinstance(customer_user_name, str):
            raise TypeError("Expected argument 'customer_user_name' to be a str")
        pulumi.set(__self__, "customer_user_name", customer_user_name)
        if directory_id and not isinstance(directory_id, str):
            raise TypeError("Expected argument 'directory_id' to be a str")
        pulumi.set(__self__, "directory_id", directory_id)
        if directory_name and not isinstance(directory_name, str):
            raise TypeError("Expected argument 'directory_name' to be a str")
        pulumi.set(__self__, "directory_name", directory_name)
        if directory_type and not isinstance(directory_type, str):
            raise TypeError("Expected argument 'directory_type' to be a str")
        pulumi.set(__self__, "directory_type", directory_type)
        if dns_ip_addresses and not isinstance(dns_ip_addresses, list):
            raise TypeError("Expected argument 'dns_ip_addresses' to be a list")
        pulumi.set(__self__, "dns_ip_addresses", dns_ip_addresses)
        if iam_role_id and not isinstance(iam_role_id, str):
            raise TypeError("Expected argument 'iam_role_id' to be a str")
        pulumi.set(__self__, "iam_role_id", iam_role_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_group_ids and not isinstance(ip_group_ids, list):
            raise TypeError("Expected argument 'ip_group_ids' to be a list")
        pulumi.set(__self__, "ip_group_ids", ip_group_ids)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if registration_code and not isinstance(registration_code, str):
            raise TypeError("Expected argument 'registration_code' to be a str")
        pulumi.set(__self__, "registration_code", registration_code)
        if saml_properties and not isinstance(saml_properties, list):
            raise TypeError("Expected argument 'saml_properties' to be a list")
        pulumi.set(__self__, "saml_properties", saml_properties)
        if self_service_permissions and not isinstance(self_service_permissions, list):
            raise TypeError("Expected argument 'self_service_permissions' to be a list")
        pulumi.set(__self__, "self_service_permissions", self_service_permissions)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_identity_type and not isinstance(user_identity_type, str):
            raise TypeError("Expected argument 'user_identity_type' to be a str")
        pulumi.set(__self__, "user_identity_type", user_identity_type)
        if workspace_access_properties and not isinstance(workspace_access_properties, list):
            raise TypeError("Expected argument 'workspace_access_properties' to be a list")
        pulumi.set(__self__, "workspace_access_properties", workspace_access_properties)
        if workspace_creation_properties and not isinstance(workspace_creation_properties, list):
            raise TypeError("Expected argument 'workspace_creation_properties' to be a list")
        pulumi.set(__self__, "workspace_creation_properties", workspace_creation_properties)
        if workspace_directory_description and not isinstance(workspace_directory_description, str):
            raise TypeError("Expected argument 'workspace_directory_description' to be a str")
        pulumi.set(__self__, "workspace_directory_description", workspace_directory_description)
        if workspace_directory_name and not isinstance(workspace_directory_name, str):
            raise TypeError("Expected argument 'workspace_directory_name' to be a str")
        pulumi.set(__self__, "workspace_directory_name", workspace_directory_name)
        if workspace_security_group_id and not isinstance(workspace_security_group_id, str):
            raise TypeError("Expected argument 'workspace_security_group_id' to be a str")
        pulumi.set(__self__, "workspace_security_group_id", workspace_security_group_id)
        if workspace_type and not isinstance(workspace_type, str):
            raise TypeError("Expected argument 'workspace_type' to be a str")
        pulumi.set(__self__, "workspace_type", workspace_type)

    @property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDirectoryActiveDirectoryConfigResult']:
        """
        Configuration for Active Directory integration when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "active_directory_configs")

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        Directory alias.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certificateBasedAuthProperties")
    def certificate_based_auth_properties(self) -> Sequence['outputs.GetDirectoryCertificateBasedAuthPropertyResult']:
        return pulumi.get(self, "certificate_based_auth_properties")

    @property
    @pulumi.getter(name="customerUserName")
    def customer_user_name(self) -> builtins.str:
        """
        User name for the service account.
        """
        return pulumi.get(self, "customer_user_name")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> builtins.str:
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> builtins.str:
        """
        Name of the directory.
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> builtins.str:
        """
        Directory type.
        """
        return pulumi.get(self, "directory_type")

    @property
    @pulumi.getter(name="dnsIpAddresses")
    def dns_ip_addresses(self) -> Sequence[builtins.str]:
        """
        IP addresses of the DNS servers for the directory.
        """
        return pulumi.get(self, "dns_ip_addresses")

    @property
    @pulumi.getter(name="iamRoleId")
    def iam_role_id(self) -> builtins.str:
        """
        Identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
        """
        return pulumi.get(self, "iam_role_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipGroupIds")
    def ip_group_ids(self) -> Sequence[builtins.str]:
        """
        Identifiers of the IP access control groups associated with the directory.
        """
        return pulumi.get(self, "ip_group_ids")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registrationCode")
    def registration_code(self) -> builtins.str:
        """
        Registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
        """
        return pulumi.get(self, "registration_code")

    @property
    @pulumi.getter(name="samlProperties")
    def saml_properties(self) -> Sequence['outputs.GetDirectorySamlPropertyResult']:
        return pulumi.get(self, "saml_properties")

    @property
    @pulumi.getter(name="selfServicePermissions")
    def self_service_permissions(self) -> Sequence['outputs.GetDirectorySelfServicePermissionResult']:
        """
        The permissions to enable or disable self-service capabilities.
        """
        return pulumi.get(self, "self_service_permissions")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        Identifiers of the subnets where the directory resides.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A map of tags assigned to the WorkSpaces directory.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userIdentityType")
    def user_identity_type(self) -> builtins.str:
        """
        The user identity type for the WorkSpaces directory.
        """
        return pulumi.get(self, "user_identity_type")

    @property
    @pulumi.getter(name="workspaceAccessProperties")
    def workspace_access_properties(self) -> Sequence['outputs.GetDirectoryWorkspaceAccessPropertyResult']:
        """
        Specifies which devices and operating systems users can use to access their WorkSpaces.
        """
        return pulumi.get(self, "workspace_access_properties")

    @property
    @pulumi.getter(name="workspaceCreationProperties")
    def workspace_creation_properties(self) -> Sequence['outputs.GetDirectoryWorkspaceCreationPropertyResult']:
        """
        The default properties that are used for creating WorkSpaces.
        """
        return pulumi.get(self, "workspace_creation_properties")

    @property
    @pulumi.getter(name="workspaceDirectoryDescription")
    def workspace_directory_description(self) -> builtins.str:
        """
        The description of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_description")

    @property
    @pulumi.getter(name="workspaceDirectoryName")
    def workspace_directory_name(self) -> builtins.str:
        """
        The name of the WorkSpaces directory when `workspace_type` is set to `POOLS`.
        """
        return pulumi.get(self, "workspace_directory_name")

    @property
    @pulumi.getter(name="workspaceSecurityGroupId")
    def workspace_security_group_id(self) -> builtins.str:
        """
        The identifier of the security group that is assigned to new WorkSpaces.
        """
        return pulumi.get(self, "workspace_security_group_id")

    @property
    @pulumi.getter(name="workspaceType")
    def workspace_type(self) -> builtins.str:
        """
        The type of WorkSpaces directory.
        """
        return pulumi.get(self, "workspace_type")


class AwaitableGetDirectoryResult(GetDirectoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDirectoryResult(
            active_directory_configs=self.active_directory_configs,
            alias=self.alias,
            certificate_based_auth_properties=self.certificate_based_auth_properties,
            customer_user_name=self.customer_user_name,
            directory_id=self.directory_id,
            directory_name=self.directory_name,
            directory_type=self.directory_type,
            dns_ip_addresses=self.dns_ip_addresses,
            iam_role_id=self.iam_role_id,
            id=self.id,
            ip_group_ids=self.ip_group_ids,
            region=self.region,
            registration_code=self.registration_code,
            saml_properties=self.saml_properties,
            self_service_permissions=self.self_service_permissions,
            subnet_ids=self.subnet_ids,
            tags=self.tags,
            user_identity_type=self.user_identity_type,
            workspace_access_properties=self.workspace_access_properties,
            workspace_creation_properties=self.workspace_creation_properties,
            workspace_directory_description=self.workspace_directory_description,
            workspace_directory_name=self.workspace_directory_name,
            workspace_security_group_id=self.workspace_security_group_id,
            workspace_type=self.workspace_type)


def get_directory(directory_id: Optional[builtins.str] = None,
                  region: Optional[builtins.str] = None,
                  tags: Optional[Mapping[str, builtins.str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDirectoryResult:
    """
    Retrieve information about an AWS WorkSpaces directory.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.workspaces.get_directory(directory_id="d-9067783251")
    ```


    :param builtins.str directory_id: Directory identifier for registration in WorkSpaces service.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags assigned to the WorkSpaces directory.
    """
    __args__ = dict()
    __args__['directoryId'] = directory_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:workspaces/getDirectory:getDirectory', __args__, opts=opts, typ=GetDirectoryResult).value

    return AwaitableGetDirectoryResult(
        active_directory_configs=pulumi.get(__ret__, 'active_directory_configs'),
        alias=pulumi.get(__ret__, 'alias'),
        certificate_based_auth_properties=pulumi.get(__ret__, 'certificate_based_auth_properties'),
        customer_user_name=pulumi.get(__ret__, 'customer_user_name'),
        directory_id=pulumi.get(__ret__, 'directory_id'),
        directory_name=pulumi.get(__ret__, 'directory_name'),
        directory_type=pulumi.get(__ret__, 'directory_type'),
        dns_ip_addresses=pulumi.get(__ret__, 'dns_ip_addresses'),
        iam_role_id=pulumi.get(__ret__, 'iam_role_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_group_ids=pulumi.get(__ret__, 'ip_group_ids'),
        region=pulumi.get(__ret__, 'region'),
        registration_code=pulumi.get(__ret__, 'registration_code'),
        saml_properties=pulumi.get(__ret__, 'saml_properties'),
        self_service_permissions=pulumi.get(__ret__, 'self_service_permissions'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        tags=pulumi.get(__ret__, 'tags'),
        user_identity_type=pulumi.get(__ret__, 'user_identity_type'),
        workspace_access_properties=pulumi.get(__ret__, 'workspace_access_properties'),
        workspace_creation_properties=pulumi.get(__ret__, 'workspace_creation_properties'),
        workspace_directory_description=pulumi.get(__ret__, 'workspace_directory_description'),
        workspace_directory_name=pulumi.get(__ret__, 'workspace_directory_name'),
        workspace_security_group_id=pulumi.get(__ret__, 'workspace_security_group_id'),
        workspace_type=pulumi.get(__ret__, 'workspace_type'))
def get_directory_output(directory_id: Optional[pulumi.Input[builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDirectoryResult]:
    """
    Retrieve information about an AWS WorkSpaces directory.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.workspaces.get_directory(directory_id="d-9067783251")
    ```


    :param builtins.str directory_id: Directory identifier for registration in WorkSpaces service.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags assigned to the WorkSpaces directory.
    """
    __args__ = dict()
    __args__['directoryId'] = directory_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:workspaces/getDirectory:getDirectory', __args__, opts=opts, typ=GetDirectoryResult)
    return __ret__.apply(lambda __response__: GetDirectoryResult(
        active_directory_configs=pulumi.get(__response__, 'active_directory_configs'),
        alias=pulumi.get(__response__, 'alias'),
        certificate_based_auth_properties=pulumi.get(__response__, 'certificate_based_auth_properties'),
        customer_user_name=pulumi.get(__response__, 'customer_user_name'),
        directory_id=pulumi.get(__response__, 'directory_id'),
        directory_name=pulumi.get(__response__, 'directory_name'),
        directory_type=pulumi.get(__response__, 'directory_type'),
        dns_ip_addresses=pulumi.get(__response__, 'dns_ip_addresses'),
        iam_role_id=pulumi.get(__response__, 'iam_role_id'),
        id=pulumi.get(__response__, 'id'),
        ip_group_ids=pulumi.get(__response__, 'ip_group_ids'),
        region=pulumi.get(__response__, 'region'),
        registration_code=pulumi.get(__response__, 'registration_code'),
        saml_properties=pulumi.get(__response__, 'saml_properties'),
        self_service_permissions=pulumi.get(__response__, 'self_service_permissions'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        tags=pulumi.get(__response__, 'tags'),
        user_identity_type=pulumi.get(__response__, 'user_identity_type'),
        workspace_access_properties=pulumi.get(__response__, 'workspace_access_properties'),
        workspace_creation_properties=pulumi.get(__response__, 'workspace_creation_properties'),
        workspace_directory_description=pulumi.get(__response__, 'workspace_directory_description'),
        workspace_directory_name=pulumi.get(__response__, 'workspace_directory_name'),
        workspace_security_group_id=pulumi.get(__response__, 'workspace_security_group_id'),
        workspace_type=pulumi.get(__response__, 'workspace_type')))
