# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BrowserSettingsArgs', 'BrowserSettings']

@pulumi.input_type
class BrowserSettingsArgs:
    def __init__(__self__, *,
                 browser_policy: pulumi.Input[builtins.str],
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a BrowserSettings resource.
        :param pulumi.Input[builtins.str] browser_policy: Browser policy for the browser settings. This is a JSON string that defines the browser settings policy.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the browser settings.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "browser_policy", browser_policy)
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="browserPolicy")
    def browser_policy(self) -> pulumi.Input[builtins.str]:
        """
        Browser policy for the browser settings. This is a JSON string that defines the browser settings policy.

        The following arguments are optional:
        """
        return pulumi.get(self, "browser_policy")

    @browser_policy.setter
    def browser_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "browser_policy", value)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional encryption context for the browser settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _BrowserSettingsState:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 browser_policy: Optional[pulumi.Input[builtins.str]] = None,
                 browser_settings_arn: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering BrowserSettings resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the browser settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs to associate with the browser settings.
        :param pulumi.Input[builtins.str] browser_policy: Browser policy for the browser settings. This is a JSON string that defines the browser settings policy.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] browser_settings_arn: ARN of the browser settings resource.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if associated_portal_arns is not None:
            pulumi.set(__self__, "associated_portal_arns", associated_portal_arns)
        if browser_policy is not None:
            pulumi.set(__self__, "browser_policy", browser_policy)
        if browser_settings_arn is not None:
            pulumi.set(__self__, "browser_settings_arn", browser_settings_arn)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional encryption context for the browser settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of web portal ARNs to associate with the browser settings.
        """
        return pulumi.get(self, "associated_portal_arns")

    @associated_portal_arns.setter
    def associated_portal_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_portal_arns", value)

    @property
    @pulumi.getter(name="browserPolicy")
    def browser_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Browser policy for the browser settings. This is a JSON string that defines the browser settings policy.

        The following arguments are optional:
        """
        return pulumi.get(self, "browser_policy")

    @browser_policy.setter
    def browser_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "browser_policy", value)

    @property
    @pulumi.getter(name="browserSettingsArn")
    def browser_settings_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the browser settings resource.
        """
        return pulumi.get(self, "browser_settings_arn")

    @browser_settings_arn.setter
    def browser_settings_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "browser_settings_arn", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:workspacesweb/browserSettings:BrowserSettings")
class BrowserSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 browser_policy: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web Browser Settings resource.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.workspacesweb.BrowserSettings("example", browser_policy=json.dumps({
            "AdditionalSettings": {
                "DownloadsSettings": {
                    "Behavior": "DISABLE",
                },
            },
        }))
        ```

        ### With All Arguments

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Browser Settings",
            deletion_window_in_days=7)
        example_browser_settings = aws.workspacesweb.BrowserSettings("example",
            browser_policy=json.dumps({
                "chromePolicies": {
                    "DefaultDownloadDirectory": {
                        "value": "/home/as2-streaming-user/MyFiles/TemporaryFiles1",
                    },
                },
            }),
            customer_managed_key=example.arn,
            additional_encryption_context={
                "Environment": "Production",
            },
            tags={
                "Name": "example-browser-settings",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Browser Settings using the `browser_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/browserSettings:BrowserSettings example arn:aws:workspacesweb:us-west-2:123456789012:browsersettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the browser settings.
        :param pulumi.Input[builtins.str] browser_policy: Browser policy for the browser settings. This is a JSON string that defines the browser settings policy.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BrowserSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web Browser Settings resource.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.workspacesweb.BrowserSettings("example", browser_policy=json.dumps({
            "AdditionalSettings": {
                "DownloadsSettings": {
                    "Behavior": "DISABLE",
                },
            },
        }))
        ```

        ### With All Arguments

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Browser Settings",
            deletion_window_in_days=7)
        example_browser_settings = aws.workspacesweb.BrowserSettings("example",
            browser_policy=json.dumps({
                "chromePolicies": {
                    "DefaultDownloadDirectory": {
                        "value": "/home/as2-streaming-user/MyFiles/TemporaryFiles1",
                    },
                },
            }),
            customer_managed_key=example.arn,
            additional_encryption_context={
                "Environment": "Production",
            },
            tags={
                "Name": "example-browser-settings",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Browser Settings using the `browser_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/browserSettings:BrowserSettings example arn:aws:workspacesweb:us-west-2:123456789012:browsersettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param BrowserSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BrowserSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 browser_policy: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BrowserSettingsArgs.__new__(BrowserSettingsArgs)

            __props__.__dict__["additional_encryption_context"] = additional_encryption_context
            if browser_policy is None and not opts.urn:
                raise TypeError("Missing required property 'browser_policy'")
            __props__.__dict__["browser_policy"] = browser_policy
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["associated_portal_arns"] = None
            __props__.__dict__["browser_settings_arn"] = None
            __props__.__dict__["tags_all"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:workspaces/webBrowserSettings:WebBrowserSettings")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(BrowserSettings, __self__).__init__(
            'aws:workspacesweb/browserSettings:BrowserSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            browser_policy: Optional[pulumi.Input[builtins.str]] = None,
            browser_settings_arn: Optional[pulumi.Input[builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'BrowserSettings':
        """
        Get an existing BrowserSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the browser settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs to associate with the browser settings.
        :param pulumi.Input[builtins.str] browser_policy: Browser policy for the browser settings. This is a JSON string that defines the browser settings policy.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] browser_settings_arn: ARN of the browser settings resource.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BrowserSettingsState.__new__(_BrowserSettingsState)

        __props__.__dict__["additional_encryption_context"] = additional_encryption_context
        __props__.__dict__["associated_portal_arns"] = associated_portal_arns
        __props__.__dict__["browser_policy"] = browser_policy
        __props__.__dict__["browser_settings_arn"] = browser_settings_arn
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return BrowserSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Additional encryption context for the browser settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of web portal ARNs to associate with the browser settings.
        """
        return pulumi.get(self, "associated_portal_arns")

    @property
    @pulumi.getter(name="browserPolicy")
    def browser_policy(self) -> pulumi.Output[builtins.str]:
        """
        Browser policy for the browser settings. This is a JSON string that defines the browser settings policy.

        The following arguments are optional:
        """
        return pulumi.get(self, "browser_policy")

    @property
    @pulumi.getter(name="browserSettingsArn")
    def browser_settings_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the browser settings resource.
        """
        return pulumi.get(self, "browser_settings_arn")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

