# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataProtectionSettingsArgs', 'DataProtectionSettings']

@pulumi.input_type
class DataProtectionSettingsArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 inline_redaction_configuration: Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DataProtectionSettings resource.
        :param pulumi.Input[builtins.str] display_name: The display name of the data protection settings.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the data protection settings.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] description: The description of the data protection settings.
        :param pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs'] inline_redaction_configuration: The inline redaction configuration of the data protection settings. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "display_name", display_name)
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline_redaction_configuration is not None:
            pulumi.set(__self__, "inline_redaction_configuration", inline_redaction_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name of the data protection settings.

        The following arguments are optional:
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional encryption context for the data protection settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the data protection settings.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inlineRedactionConfiguration")
    def inline_redaction_configuration(self) -> Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']]:
        """
        The inline redaction configuration of the data protection settings. Detailed below.
        """
        return pulumi.get(self, "inline_redaction_configuration")

    @inline_redaction_configuration.setter
    def inline_redaction_configuration(self, value: Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']]):
        pulumi.set(self, "inline_redaction_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DataProtectionSettingsState:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 data_protection_settings_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inline_redaction_configuration: Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DataProtectionSettings resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the data protection settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs that this data protection settings resource is associated with.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] data_protection_settings_arn: ARN of the data protection settings resource.
        :param pulumi.Input[builtins.str] description: The description of the data protection settings.
        :param pulumi.Input[builtins.str] display_name: The display name of the data protection settings.
               
               The following arguments are optional:
        :param pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs'] inline_redaction_configuration: The inline redaction configuration of the data protection settings. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if associated_portal_arns is not None:
            pulumi.set(__self__, "associated_portal_arns", associated_portal_arns)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if data_protection_settings_arn is not None:
            pulumi.set(__self__, "data_protection_settings_arn", data_protection_settings_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inline_redaction_configuration is not None:
            pulumi.set(__self__, "inline_redaction_configuration", inline_redaction_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional encryption context for the data protection settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of web portal ARNs that this data protection settings resource is associated with.
        """
        return pulumi.get(self, "associated_portal_arns")

    @associated_portal_arns.setter
    def associated_portal_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_portal_arns", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="dataProtectionSettingsArn")
    def data_protection_settings_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the data protection settings resource.
        """
        return pulumi.get(self, "data_protection_settings_arn")

    @data_protection_settings_arn.setter
    def data_protection_settings_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_protection_settings_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the data protection settings.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the data protection settings.

        The following arguments are optional:
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inlineRedactionConfiguration")
    def inline_redaction_configuration(self) -> Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']]:
        """
        The inline redaction configuration of the data protection settings. Detailed below.
        """
        return pulumi.get(self, "inline_redaction_configuration")

    @inline_redaction_configuration.setter
    def inline_redaction_configuration(self, value: Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']]):
        pulumi.set(self, "inline_redaction_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:workspacesweb/dataProtectionSettings:DataProtectionSettings")
class DataProtectionSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inline_redaction_configuration: Optional[pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web Data Protection Settings resource. Once associated with a web portal, data protection settings control how sensitive information is redacted in streaming sessions.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.DataProtectionSettings("example", display_name="example")
        ```

        ### With Inline Redaction Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.DataProtectionSettings("example",
            display_name="example",
            description="Example data protection settings",
            inline_redaction_configuration={
                "global_confidence_level": 2,
                "global_enforced_urls": ["https://example.com"],
                "inline_redaction_patterns": [{
                    "built_in_pattern_id": "ssn",
                    "confidence_level": 3,
                    "redaction_place_holders": [{
                        "redaction_place_holder_type": "CustomText",
                        "redaction_place_holder_text": "REDACTED",
                    }],
                }],
            })
        ```

        ### Complete Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Data Protection Settings",
            deletion_window_in_days=7)
        example_data_protection_settings = aws.workspacesweb.DataProtectionSettings("example",
            display_name="example-complete",
            description="Complete example data protection settings",
            customer_managed_key=example.arn,
            additional_encryption_context={
                "Environment": "Production",
            },
            inline_redaction_configuration={
                "global_confidence_level": 2,
                "global_enforced_urls": [
                    "https://example.com",
                    "https://test.example.com",
                ],
                "global_exempt_urls": ["https://exempt.example.com"],
                "inline_redaction_patterns": [
                    {
                        "built_in_pattern_id": "ssn",
                        "confidence_level": 3,
                        "enforced_urls": ["https://pattern1.example.com"],
                        "exempt_urls": ["https://exempt-pattern1.example.com"],
                        "redaction_place_holders": [{
                            "redaction_place_holder_type": "CustomText",
                            "redaction_place_holder_text": "REDACTED-SSN",
                        }],
                    },
                    {
                        "custom_pattern": {
                            "pattern_name": "CustomPattern",
                            "pattern_regex": "/\\\\d{3}-\\\\d{2}-\\\\d{4}/g",
                            "keyword_regex": "/SSN|Social Security/gi",
                            "pattern_description": "Custom SSN pattern",
                        },
                        "redaction_place_holders": [{
                            "redaction_place_holder_type": "CustomText",
                            "redaction_place_holder_text": "REDACTED-CUSTOM",
                        }],
                    },
                ],
            },
            tags={
                "Name": "example-data-protection-settings",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Data Protection Settings using the `data_protection_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/dataProtectionSettings:DataProtectionSettings example arn:aws:workspaces-web:us-west-2:123456789012:dataprotectionsettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the data protection settings.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] description: The description of the data protection settings.
        :param pulumi.Input[builtins.str] display_name: The display name of the data protection settings.
               
               The following arguments are optional:
        :param pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']] inline_redaction_configuration: The inline redaction configuration of the data protection settings. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataProtectionSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web Data Protection Settings resource. Once associated with a web portal, data protection settings control how sensitive information is redacted in streaming sessions.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.DataProtectionSettings("example", display_name="example")
        ```

        ### With Inline Redaction Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.DataProtectionSettings("example",
            display_name="example",
            description="Example data protection settings",
            inline_redaction_configuration={
                "global_confidence_level": 2,
                "global_enforced_urls": ["https://example.com"],
                "inline_redaction_patterns": [{
                    "built_in_pattern_id": "ssn",
                    "confidence_level": 3,
                    "redaction_place_holders": [{
                        "redaction_place_holder_type": "CustomText",
                        "redaction_place_holder_text": "REDACTED",
                    }],
                }],
            })
        ```

        ### Complete Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Data Protection Settings",
            deletion_window_in_days=7)
        example_data_protection_settings = aws.workspacesweb.DataProtectionSettings("example",
            display_name="example-complete",
            description="Complete example data protection settings",
            customer_managed_key=example.arn,
            additional_encryption_context={
                "Environment": "Production",
            },
            inline_redaction_configuration={
                "global_confidence_level": 2,
                "global_enforced_urls": [
                    "https://example.com",
                    "https://test.example.com",
                ],
                "global_exempt_urls": ["https://exempt.example.com"],
                "inline_redaction_patterns": [
                    {
                        "built_in_pattern_id": "ssn",
                        "confidence_level": 3,
                        "enforced_urls": ["https://pattern1.example.com"],
                        "exempt_urls": ["https://exempt-pattern1.example.com"],
                        "redaction_place_holders": [{
                            "redaction_place_holder_type": "CustomText",
                            "redaction_place_holder_text": "REDACTED-SSN",
                        }],
                    },
                    {
                        "custom_pattern": {
                            "pattern_name": "CustomPattern",
                            "pattern_regex": "/\\\\d{3}-\\\\d{2}-\\\\d{4}/g",
                            "keyword_regex": "/SSN|Social Security/gi",
                            "pattern_description": "Custom SSN pattern",
                        },
                        "redaction_place_holders": [{
                            "redaction_place_holder_type": "CustomText",
                            "redaction_place_holder_text": "REDACTED-CUSTOM",
                        }],
                    },
                ],
            },
            tags={
                "Name": "example-data-protection-settings",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Data Protection Settings using the `data_protection_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/dataProtectionSettings:DataProtectionSettings example arn:aws:workspaces-web:us-west-2:123456789012:dataprotectionsettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param DataProtectionSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataProtectionSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inline_redaction_configuration: Optional[pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataProtectionSettingsArgs.__new__(DataProtectionSettingsArgs)

            __props__.__dict__["additional_encryption_context"] = additional_encryption_context
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["inline_redaction_configuration"] = inline_redaction_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["associated_portal_arns"] = None
            __props__.__dict__["data_protection_settings_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(DataProtectionSettings, __self__).__init__(
            'aws:workspacesweb/dataProtectionSettings:DataProtectionSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
            data_protection_settings_arn: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            inline_redaction_configuration: Optional[pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'DataProtectionSettings':
        """
        Get an existing DataProtectionSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the data protection settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs that this data protection settings resource is associated with.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] data_protection_settings_arn: ARN of the data protection settings resource.
        :param pulumi.Input[builtins.str] description: The description of the data protection settings.
        :param pulumi.Input[builtins.str] display_name: The display name of the data protection settings.
               
               The following arguments are optional:
        :param pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']] inline_redaction_configuration: The inline redaction configuration of the data protection settings. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataProtectionSettingsState.__new__(_DataProtectionSettingsState)

        __props__.__dict__["additional_encryption_context"] = additional_encryption_context
        __props__.__dict__["associated_portal_arns"] = associated_portal_arns
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["data_protection_settings_arn"] = data_protection_settings_arn
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["inline_redaction_configuration"] = inline_redaction_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return DataProtectionSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Additional encryption context for the data protection settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of web portal ARNs that this data protection settings resource is associated with.
        """
        return pulumi.get(self, "associated_portal_arns")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="dataProtectionSettingsArn")
    def data_protection_settings_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the data protection settings resource.
        """
        return pulumi.get(self, "data_protection_settings_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the data protection settings.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the data protection settings.

        The following arguments are optional:
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inlineRedactionConfiguration")
    def inline_redaction_configuration(self) -> pulumi.Output[Optional['outputs.DataProtectionSettingsInlineRedactionConfiguration']]:
        """
        The inline redaction configuration of the data protection settings. Detailed below.
        """
        return pulumi.get(self, "inline_redaction_configuration")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

