# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserAccessLoggingSettingsArgs', 'UserAccessLoggingSettings']

@pulumi.input_type
class UserAccessLoggingSettingsArgs:
    def __init__(__self__, *,
                 kinesis_stream_arn: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a UserAccessLoggingSettings resource.
        :param pulumi.Input[builtins.str] kinesis_stream_arn: ARN of the Kinesis stream.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "kinesis_stream_arn", kinesis_stream_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="kinesisStreamArn")
    def kinesis_stream_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Kinesis stream.

        The following arguments are optional:
        """
        return pulumi.get(self, "kinesis_stream_arn")

    @kinesis_stream_arn.setter
    def kinesis_stream_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kinesis_stream_arn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _UserAccessLoggingSettingsState:
    def __init__(__self__, *,
                 associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kinesis_stream_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_access_logging_settings_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserAccessLoggingSettings resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs that this user access logging settings resource is associated with.
        :param pulumi.Input[builtins.str] kinesis_stream_arn: ARN of the Kinesis stream.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings resource.
        """
        if associated_portal_arns is not None:
            pulumi.set(__self__, "associated_portal_arns", associated_portal_arns)
        if kinesis_stream_arn is not None:
            pulumi.set(__self__, "kinesis_stream_arn", kinesis_stream_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_access_logging_settings_arn is not None:
            pulumi.set(__self__, "user_access_logging_settings_arn", user_access_logging_settings_arn)

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of web portal ARNs that this user access logging settings resource is associated with.
        """
        return pulumi.get(self, "associated_portal_arns")

    @associated_portal_arns.setter
    def associated_portal_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_portal_arns", value)

    @property
    @pulumi.getter(name="kinesisStreamArn")
    def kinesis_stream_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Kinesis stream.

        The following arguments are optional:
        """
        return pulumi.get(self, "kinesis_stream_arn")

    @kinesis_stream_arn.setter
    def kinesis_stream_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kinesis_stream_arn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="userAccessLoggingSettingsArn")
    def user_access_logging_settings_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the user access logging settings resource.
        """
        return pulumi.get(self, "user_access_logging_settings_arn")

    @user_access_logging_settings_arn.setter
    def user_access_logging_settings_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_access_logging_settings_arn", value)


@pulumi.type_token("aws:workspacesweb/userAccessLoggingSettings:UserAccessLoggingSettings")
class UserAccessLoggingSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kinesis_stream_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web User Access Logging Settings resource. Once associated with a web portal, user access logging settings control how user access events are logged to Amazon Kinesis.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kinesis.Stream("example",
            name="amazon-workspaces-web-example-stream",
            shard_count=1)
        example_user_access_logging_settings = aws.workspacesweb.UserAccessLoggingSettings("example", kinesis_stream_arn=example.arn)
        ```

        ### With Tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kinesis.Stream("example",
            name="example-stream",
            shard_count=1)
        example_user_access_logging_settings = aws.workspacesweb.UserAccessLoggingSettings("example",
            kinesis_stream_arn=example.arn,
            tags={
                "Name": "example-user-access-logging-settings",
                "Environment": "Production",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web User Access Logging Settings using the `user_access_logging_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/userAccessLoggingSettings:UserAccessLoggingSettings example arn:aws:workspaces-web:us-west-2:123456789012:userAccessLoggingSettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] kinesis_stream_arn: ARN of the Kinesis stream.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserAccessLoggingSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web User Access Logging Settings resource. Once associated with a web portal, user access logging settings control how user access events are logged to Amazon Kinesis.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kinesis.Stream("example",
            name="amazon-workspaces-web-example-stream",
            shard_count=1)
        example_user_access_logging_settings = aws.workspacesweb.UserAccessLoggingSettings("example", kinesis_stream_arn=example.arn)
        ```

        ### With Tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kinesis.Stream("example",
            name="example-stream",
            shard_count=1)
        example_user_access_logging_settings = aws.workspacesweb.UserAccessLoggingSettings("example",
            kinesis_stream_arn=example.arn,
            tags={
                "Name": "example-user-access-logging-settings",
                "Environment": "Production",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web User Access Logging Settings using the `user_access_logging_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/userAccessLoggingSettings:UserAccessLoggingSettings example arn:aws:workspaces-web:us-west-2:123456789012:userAccessLoggingSettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param UserAccessLoggingSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserAccessLoggingSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kinesis_stream_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserAccessLoggingSettingsArgs.__new__(UserAccessLoggingSettingsArgs)

            if kinesis_stream_arn is None and not opts.urn:
                raise TypeError("Missing required property 'kinesis_stream_arn'")
            __props__.__dict__["kinesis_stream_arn"] = kinesis_stream_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["associated_portal_arns"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["user_access_logging_settings_arn"] = None
        super(UserAccessLoggingSettings, __self__).__init__(
            'aws:workspacesweb/userAccessLoggingSettings:UserAccessLoggingSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            kinesis_stream_arn: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            user_access_logging_settings_arn: Optional[pulumi.Input[builtins.str]] = None) -> 'UserAccessLoggingSettings':
        """
        Get an existing UserAccessLoggingSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs that this user access logging settings resource is associated with.
        :param pulumi.Input[builtins.str] kinesis_stream_arn: ARN of the Kinesis stream.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserAccessLoggingSettingsState.__new__(_UserAccessLoggingSettingsState)

        __props__.__dict__["associated_portal_arns"] = associated_portal_arns
        __props__.__dict__["kinesis_stream_arn"] = kinesis_stream_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_access_logging_settings_arn"] = user_access_logging_settings_arn
        return UserAccessLoggingSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of web portal ARNs that this user access logging settings resource is associated with.
        """
        return pulumi.get(self, "associated_portal_arns")

    @property
    @pulumi.getter(name="kinesisStreamArn")
    def kinesis_stream_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Kinesis stream.

        The following arguments are optional:
        """
        return pulumi.get(self, "kinesis_stream_arn")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="userAccessLoggingSettingsArn")
    def user_access_logging_settings_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the user access logging settings resource.
        """
        return pulumi.get(self, "user_access_logging_settings_arn")

