# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserSettingsArgs', 'UserSettings']

@pulumi.input_type
class UserSettingsArgs:
    def __init__(__self__, *,
                 copy_allowed: pulumi.Input[builtins.str],
                 download_allowed: pulumi.Input[builtins.str],
                 paste_allowed: pulumi.Input[builtins.str],
                 print_allowed: pulumi.Input[builtins.str],
                 upload_allowed: pulumi.Input[builtins.str],
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cookie_synchronization_configuration: Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 deep_link_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 toolbar_configuration: Optional[pulumi.Input['UserSettingsToolbarConfigurationArgs']] = None):
        """
        The set of arguments for constructing a UserSettings resource.
        :param pulumi.Input[builtins.str] copy_allowed: Specifies whether the user can copy text from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] download_allowed: Specifies whether the user can download files from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] paste_allowed: Specifies whether the user can paste text from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] print_allowed: Specifies whether the user can print to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] upload_allowed: Specifies whether the user can upload files from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the user settings.
        :param pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs'] cookie_synchronization_configuration: Configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser. Detailed below.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] deep_link_allowed: Specifies whether the user can use deep links that open automatically when connecting to a session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.int] disconnect_timeout_in_minutes: Amount of time that a streaming session remains active after users disconnect. Value must be between 1 and 600 minutes.
        :param pulumi.Input[builtins.int] idle_disconnect_timeout_in_minutes: Amount of time that users can be idle before they are disconnected from their streaming session. Value must be between 0 and 60 minutes.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['UserSettingsToolbarConfigurationArgs'] toolbar_configuration: Configuration of the toolbar. Detailed below.
        """
        pulumi.set(__self__, "copy_allowed", copy_allowed)
        pulumi.set(__self__, "download_allowed", download_allowed)
        pulumi.set(__self__, "paste_allowed", paste_allowed)
        pulumi.set(__self__, "print_allowed", print_allowed)
        pulumi.set(__self__, "upload_allowed", upload_allowed)
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if cookie_synchronization_configuration is not None:
            pulumi.set(__self__, "cookie_synchronization_configuration", cookie_synchronization_configuration)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if deep_link_allowed is not None:
            pulumi.set(__self__, "deep_link_allowed", deep_link_allowed)
        if disconnect_timeout_in_minutes is not None:
            pulumi.set(__self__, "disconnect_timeout_in_minutes", disconnect_timeout_in_minutes)
        if idle_disconnect_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_disconnect_timeout_in_minutes", idle_disconnect_timeout_in_minutes)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if toolbar_configuration is not None:
            pulumi.set(__self__, "toolbar_configuration", toolbar_configuration)

    @property
    @pulumi.getter(name="copyAllowed")
    def copy_allowed(self) -> pulumi.Input[builtins.str]:
        """
        Specifies whether the user can copy text from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "copy_allowed")

    @copy_allowed.setter
    def copy_allowed(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "copy_allowed", value)

    @property
    @pulumi.getter(name="downloadAllowed")
    def download_allowed(self) -> pulumi.Input[builtins.str]:
        """
        Specifies whether the user can download files from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "download_allowed")

    @download_allowed.setter
    def download_allowed(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "download_allowed", value)

    @property
    @pulumi.getter(name="pasteAllowed")
    def paste_allowed(self) -> pulumi.Input[builtins.str]:
        """
        Specifies whether the user can paste text from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "paste_allowed")

    @paste_allowed.setter
    def paste_allowed(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "paste_allowed", value)

    @property
    @pulumi.getter(name="printAllowed")
    def print_allowed(self) -> pulumi.Input[builtins.str]:
        """
        Specifies whether the user can print to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "print_allowed")

    @print_allowed.setter
    def print_allowed(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "print_allowed", value)

    @property
    @pulumi.getter(name="uploadAllowed")
    def upload_allowed(self) -> pulumi.Input[builtins.str]:
        """
        Specifies whether the user can upload files from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.

        The following arguments are optional:
        """
        return pulumi.get(self, "upload_allowed")

    @upload_allowed.setter
    def upload_allowed(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "upload_allowed", value)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional encryption context for the user settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="cookieSynchronizationConfiguration")
    def cookie_synchronization_configuration(self) -> Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']]:
        """
        Configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser. Detailed below.
        """
        return pulumi.get(self, "cookie_synchronization_configuration")

    @cookie_synchronization_configuration.setter
    def cookie_synchronization_configuration(self, value: Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']]):
        pulumi.set(self, "cookie_synchronization_configuration", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="deepLinkAllowed")
    def deep_link_allowed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the user can use deep links that open automatically when connecting to a session. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "deep_link_allowed")

    @deep_link_allowed.setter
    def deep_link_allowed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deep_link_allowed", value)

    @property
    @pulumi.getter(name="disconnectTimeoutInMinutes")
    def disconnect_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time that a streaming session remains active after users disconnect. Value must be between 1 and 600 minutes.
        """
        return pulumi.get(self, "disconnect_timeout_in_minutes")

    @disconnect_timeout_in_minutes.setter
    def disconnect_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disconnect_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="idleDisconnectTimeoutInMinutes")
    def idle_disconnect_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time that users can be idle before they are disconnected from their streaming session. Value must be between 0 and 60 minutes.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_minutes")

    @idle_disconnect_timeout_in_minutes.setter
    def idle_disconnect_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_disconnect_timeout_in_minutes", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="toolbarConfiguration")
    def toolbar_configuration(self) -> Optional[pulumi.Input['UserSettingsToolbarConfigurationArgs']]:
        """
        Configuration of the toolbar. Detailed below.
        """
        return pulumi.get(self, "toolbar_configuration")

    @toolbar_configuration.setter
    def toolbar_configuration(self, value: Optional[pulumi.Input['UserSettingsToolbarConfigurationArgs']]):
        pulumi.set(self, "toolbar_configuration", value)


@pulumi.input_type
class _UserSettingsState:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cookie_synchronization_configuration: Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']] = None,
                 copy_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 deep_link_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 download_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 paste_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 print_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 toolbar_configuration: Optional[pulumi.Input['UserSettingsToolbarConfigurationArgs']] = None,
                 upload_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 user_settings_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserSettings resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the user settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs to associate with the user settings.
        :param pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs'] cookie_synchronization_configuration: Configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser. Detailed below.
        :param pulumi.Input[builtins.str] copy_allowed: Specifies whether the user can copy text from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] deep_link_allowed: Specifies whether the user can use deep links that open automatically when connecting to a session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.int] disconnect_timeout_in_minutes: Amount of time that a streaming session remains active after users disconnect. Value must be between 1 and 600 minutes.
        :param pulumi.Input[builtins.str] download_allowed: Specifies whether the user can download files from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.int] idle_disconnect_timeout_in_minutes: Amount of time that users can be idle before they are disconnected from their streaming session. Value must be between 0 and 60 minutes.
        :param pulumi.Input[builtins.str] paste_allowed: Specifies whether the user can paste text from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] print_allowed: Specifies whether the user can print to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['UserSettingsToolbarConfigurationArgs'] toolbar_configuration: Configuration of the toolbar. Detailed below.
        :param pulumi.Input[builtins.str] upload_allowed: Specifies whether the user can upload files from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] user_settings_arn: ARN of the user settings resource.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if associated_portal_arns is not None:
            pulumi.set(__self__, "associated_portal_arns", associated_portal_arns)
        if cookie_synchronization_configuration is not None:
            pulumi.set(__self__, "cookie_synchronization_configuration", cookie_synchronization_configuration)
        if copy_allowed is not None:
            pulumi.set(__self__, "copy_allowed", copy_allowed)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if deep_link_allowed is not None:
            pulumi.set(__self__, "deep_link_allowed", deep_link_allowed)
        if disconnect_timeout_in_minutes is not None:
            pulumi.set(__self__, "disconnect_timeout_in_minutes", disconnect_timeout_in_minutes)
        if download_allowed is not None:
            pulumi.set(__self__, "download_allowed", download_allowed)
        if idle_disconnect_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_disconnect_timeout_in_minutes", idle_disconnect_timeout_in_minutes)
        if paste_allowed is not None:
            pulumi.set(__self__, "paste_allowed", paste_allowed)
        if print_allowed is not None:
            pulumi.set(__self__, "print_allowed", print_allowed)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if toolbar_configuration is not None:
            pulumi.set(__self__, "toolbar_configuration", toolbar_configuration)
        if upload_allowed is not None:
            pulumi.set(__self__, "upload_allowed", upload_allowed)
        if user_settings_arn is not None:
            pulumi.set(__self__, "user_settings_arn", user_settings_arn)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional encryption context for the user settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of web portal ARNs to associate with the user settings.
        """
        return pulumi.get(self, "associated_portal_arns")

    @associated_portal_arns.setter
    def associated_portal_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_portal_arns", value)

    @property
    @pulumi.getter(name="cookieSynchronizationConfiguration")
    def cookie_synchronization_configuration(self) -> Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']]:
        """
        Configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser. Detailed below.
        """
        return pulumi.get(self, "cookie_synchronization_configuration")

    @cookie_synchronization_configuration.setter
    def cookie_synchronization_configuration(self, value: Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']]):
        pulumi.set(self, "cookie_synchronization_configuration", value)

    @property
    @pulumi.getter(name="copyAllowed")
    def copy_allowed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the user can copy text from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "copy_allowed")

    @copy_allowed.setter
    def copy_allowed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "copy_allowed", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="deepLinkAllowed")
    def deep_link_allowed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the user can use deep links that open automatically when connecting to a session. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "deep_link_allowed")

    @deep_link_allowed.setter
    def deep_link_allowed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deep_link_allowed", value)

    @property
    @pulumi.getter(name="disconnectTimeoutInMinutes")
    def disconnect_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time that a streaming session remains active after users disconnect. Value must be between 1 and 600 minutes.
        """
        return pulumi.get(self, "disconnect_timeout_in_minutes")

    @disconnect_timeout_in_minutes.setter
    def disconnect_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disconnect_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="downloadAllowed")
    def download_allowed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the user can download files from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "download_allowed")

    @download_allowed.setter
    def download_allowed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "download_allowed", value)

    @property
    @pulumi.getter(name="idleDisconnectTimeoutInMinutes")
    def idle_disconnect_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time that users can be idle before they are disconnected from their streaming session. Value must be between 0 and 60 minutes.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_minutes")

    @idle_disconnect_timeout_in_minutes.setter
    def idle_disconnect_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_disconnect_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="pasteAllowed")
    def paste_allowed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the user can paste text from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "paste_allowed")

    @paste_allowed.setter
    def paste_allowed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "paste_allowed", value)

    @property
    @pulumi.getter(name="printAllowed")
    def print_allowed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the user can print to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "print_allowed")

    @print_allowed.setter
    def print_allowed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "print_allowed", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="toolbarConfiguration")
    def toolbar_configuration(self) -> Optional[pulumi.Input['UserSettingsToolbarConfigurationArgs']]:
        """
        Configuration of the toolbar. Detailed below.
        """
        return pulumi.get(self, "toolbar_configuration")

    @toolbar_configuration.setter
    def toolbar_configuration(self, value: Optional[pulumi.Input['UserSettingsToolbarConfigurationArgs']]):
        pulumi.set(self, "toolbar_configuration", value)

    @property
    @pulumi.getter(name="uploadAllowed")
    def upload_allowed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the user can upload files from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.

        The following arguments are optional:
        """
        return pulumi.get(self, "upload_allowed")

    @upload_allowed.setter
    def upload_allowed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upload_allowed", value)

    @property
    @pulumi.getter(name="userSettingsArn")
    def user_settings_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the user settings resource.
        """
        return pulumi.get(self, "user_settings_arn")

    @user_settings_arn.setter
    def user_settings_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_settings_arn", value)


@pulumi.type_token("aws:workspacesweb/userSettings:UserSettings")
class UserSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cookie_synchronization_configuration: Optional[pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']]] = None,
                 copy_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 deep_link_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 download_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 paste_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 print_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 toolbar_configuration: Optional[pulumi.Input[Union['UserSettingsToolbarConfigurationArgs', 'UserSettingsToolbarConfigurationArgsDict']]] = None,
                 upload_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web User Settings resource. Once associated with a web portal, user settings control how users can transfer data between a streaming session and their local devices.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.UserSettings("example",
            copy_allowed="Enabled",
            download_allowed="Enabled",
            paste_allowed="Enabled",
            print_allowed="Enabled",
            upload_allowed="Enabled")
        ```

        ### With Toolbar Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.UserSettings("example",
            copy_allowed="Enabled",
            download_allowed="Enabled",
            paste_allowed="Enabled",
            print_allowed="Enabled",
            upload_allowed="Enabled",
            toolbar_configuration={
                "toolbar_type": "Docked",
                "visual_mode": "Dark",
                "hidden_toolbar_items": [
                    "Webcam",
                    "Microphone",
                ],
            })
        ```

        ### Complete Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web User Settings",
            deletion_window_in_days=7)
        example_user_settings = aws.workspacesweb.UserSettings("example",
            copy_allowed="Enabled",
            download_allowed="Enabled",
            paste_allowed="Enabled",
            print_allowed="Enabled",
            upload_allowed="Enabled",
            deep_link_allowed="Enabled",
            disconnect_timeout_in_minutes=30,
            idle_disconnect_timeout_in_minutes=15,
            customer_managed_key=example.arn,
            additional_encryption_context={
                "Environment": "Production",
            },
            toolbar_configuration={
                "toolbar_type": "Docked",
                "visual_mode": "Dark",
                "hidden_toolbar_items": [
                    "Webcam",
                    "Microphone",
                ],
                "max_display_resolution": "size1920X1080",
            },
            cookie_synchronization_configuration={
                "allowlists": [{
                    "domain": "example.com",
                    "path": "/path",
                }],
                "blocklists": [{
                    "domain": "blocked.com",
                }],
            },
            tags={
                "Name": "example-user-settings",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web User Settings using the `user_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/userSettings:UserSettings example arn:aws:workspacesweb:us-west-2:123456789012:usersettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the user settings.
        :param pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']] cookie_synchronization_configuration: Configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser. Detailed below.
        :param pulumi.Input[builtins.str] copy_allowed: Specifies whether the user can copy text from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] deep_link_allowed: Specifies whether the user can use deep links that open automatically when connecting to a session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.int] disconnect_timeout_in_minutes: Amount of time that a streaming session remains active after users disconnect. Value must be between 1 and 600 minutes.
        :param pulumi.Input[builtins.str] download_allowed: Specifies whether the user can download files from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.int] idle_disconnect_timeout_in_minutes: Amount of time that users can be idle before they are disconnected from their streaming session. Value must be between 0 and 60 minutes.
        :param pulumi.Input[builtins.str] paste_allowed: Specifies whether the user can paste text from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] print_allowed: Specifies whether the user can print to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['UserSettingsToolbarConfigurationArgs', 'UserSettingsToolbarConfigurationArgsDict']] toolbar_configuration: Configuration of the toolbar. Detailed below.
        :param pulumi.Input[builtins.str] upload_allowed: Specifies whether the user can upload files from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web User Settings resource. Once associated with a web portal, user settings control how users can transfer data between a streaming session and their local devices.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.UserSettings("example",
            copy_allowed="Enabled",
            download_allowed="Enabled",
            paste_allowed="Enabled",
            print_allowed="Enabled",
            upload_allowed="Enabled")
        ```

        ### With Toolbar Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.UserSettings("example",
            copy_allowed="Enabled",
            download_allowed="Enabled",
            paste_allowed="Enabled",
            print_allowed="Enabled",
            upload_allowed="Enabled",
            toolbar_configuration={
                "toolbar_type": "Docked",
                "visual_mode": "Dark",
                "hidden_toolbar_items": [
                    "Webcam",
                    "Microphone",
                ],
            })
        ```

        ### Complete Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web User Settings",
            deletion_window_in_days=7)
        example_user_settings = aws.workspacesweb.UserSettings("example",
            copy_allowed="Enabled",
            download_allowed="Enabled",
            paste_allowed="Enabled",
            print_allowed="Enabled",
            upload_allowed="Enabled",
            deep_link_allowed="Enabled",
            disconnect_timeout_in_minutes=30,
            idle_disconnect_timeout_in_minutes=15,
            customer_managed_key=example.arn,
            additional_encryption_context={
                "Environment": "Production",
            },
            toolbar_configuration={
                "toolbar_type": "Docked",
                "visual_mode": "Dark",
                "hidden_toolbar_items": [
                    "Webcam",
                    "Microphone",
                ],
                "max_display_resolution": "size1920X1080",
            },
            cookie_synchronization_configuration={
                "allowlists": [{
                    "domain": "example.com",
                    "path": "/path",
                }],
                "blocklists": [{
                    "domain": "blocked.com",
                }],
            },
            tags={
                "Name": "example-user-settings",
            })
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web User Settings using the `user_settings_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/userSettings:UserSettings example arn:aws:workspacesweb:us-west-2:123456789012:usersettings/abcdef12345
        ```

        :param str resource_name: The name of the resource.
        :param UserSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cookie_synchronization_configuration: Optional[pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']]] = None,
                 copy_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 deep_link_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 download_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 paste_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 print_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 toolbar_configuration: Optional[pulumi.Input[Union['UserSettingsToolbarConfigurationArgs', 'UserSettingsToolbarConfigurationArgsDict']]] = None,
                 upload_allowed: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserSettingsArgs.__new__(UserSettingsArgs)

            __props__.__dict__["additional_encryption_context"] = additional_encryption_context
            __props__.__dict__["cookie_synchronization_configuration"] = cookie_synchronization_configuration
            if copy_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'copy_allowed'")
            __props__.__dict__["copy_allowed"] = copy_allowed
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["deep_link_allowed"] = deep_link_allowed
            __props__.__dict__["disconnect_timeout_in_minutes"] = disconnect_timeout_in_minutes
            if download_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'download_allowed'")
            __props__.__dict__["download_allowed"] = download_allowed
            __props__.__dict__["idle_disconnect_timeout_in_minutes"] = idle_disconnect_timeout_in_minutes
            if paste_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'paste_allowed'")
            __props__.__dict__["paste_allowed"] = paste_allowed
            if print_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'print_allowed'")
            __props__.__dict__["print_allowed"] = print_allowed
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["toolbar_configuration"] = toolbar_configuration
            if upload_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'upload_allowed'")
            __props__.__dict__["upload_allowed"] = upload_allowed
            __props__.__dict__["associated_portal_arns"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["user_settings_arn"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:workspaces/webUserSettings:WebUserSettings")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(UserSettings, __self__).__init__(
            'aws:workspacesweb/userSettings:UserSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            cookie_synchronization_configuration: Optional[pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']]] = None,
            copy_allowed: Optional[pulumi.Input[builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
            deep_link_allowed: Optional[pulumi.Input[builtins.str]] = None,
            disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
            download_allowed: Optional[pulumi.Input[builtins.str]] = None,
            idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
            paste_allowed: Optional[pulumi.Input[builtins.str]] = None,
            print_allowed: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            toolbar_configuration: Optional[pulumi.Input[Union['UserSettingsToolbarConfigurationArgs', 'UserSettingsToolbarConfigurationArgsDict']]] = None,
            upload_allowed: Optional[pulumi.Input[builtins.str]] = None,
            user_settings_arn: Optional[pulumi.Input[builtins.str]] = None) -> 'UserSettings':
        """
        Get an existing UserSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: Additional encryption context for the user settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_portal_arns: List of web portal ARNs to associate with the user settings.
        :param pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']] cookie_synchronization_configuration: Configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser. Detailed below.
        :param pulumi.Input[builtins.str] copy_allowed: Specifies whether the user can copy text from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] customer_managed_key: ARN of the customer managed KMS key.
        :param pulumi.Input[builtins.str] deep_link_allowed: Specifies whether the user can use deep links that open automatically when connecting to a session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.int] disconnect_timeout_in_minutes: Amount of time that a streaming session remains active after users disconnect. Value must be between 1 and 600 minutes.
        :param pulumi.Input[builtins.str] download_allowed: Specifies whether the user can download files from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.int] idle_disconnect_timeout_in_minutes: Amount of time that users can be idle before they are disconnected from their streaming session. Value must be between 0 and 60 minutes.
        :param pulumi.Input[builtins.str] paste_allowed: Specifies whether the user can paste text from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] print_allowed: Specifies whether the user can print to the local device. Valid values are `Enabled` or `Disabled`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['UserSettingsToolbarConfigurationArgs', 'UserSettingsToolbarConfigurationArgsDict']] toolbar_configuration: Configuration of the toolbar. Detailed below.
        :param pulumi.Input[builtins.str] upload_allowed: Specifies whether the user can upload files from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] user_settings_arn: ARN of the user settings resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserSettingsState.__new__(_UserSettingsState)

        __props__.__dict__["additional_encryption_context"] = additional_encryption_context
        __props__.__dict__["associated_portal_arns"] = associated_portal_arns
        __props__.__dict__["cookie_synchronization_configuration"] = cookie_synchronization_configuration
        __props__.__dict__["copy_allowed"] = copy_allowed
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["deep_link_allowed"] = deep_link_allowed
        __props__.__dict__["disconnect_timeout_in_minutes"] = disconnect_timeout_in_minutes
        __props__.__dict__["download_allowed"] = download_allowed
        __props__.__dict__["idle_disconnect_timeout_in_minutes"] = idle_disconnect_timeout_in_minutes
        __props__.__dict__["paste_allowed"] = paste_allowed
        __props__.__dict__["print_allowed"] = print_allowed
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["toolbar_configuration"] = toolbar_configuration
        __props__.__dict__["upload_allowed"] = upload_allowed
        __props__.__dict__["user_settings_arn"] = user_settings_arn
        return UserSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Additional encryption context for the user settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of web portal ARNs to associate with the user settings.
        """
        return pulumi.get(self, "associated_portal_arns")

    @property
    @pulumi.getter(name="cookieSynchronizationConfiguration")
    def cookie_synchronization_configuration(self) -> pulumi.Output[Optional['outputs.UserSettingsCookieSynchronizationConfiguration']]:
        """
        Configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser. Detailed below.
        """
        return pulumi.get(self, "cookie_synchronization_configuration")

    @property
    @pulumi.getter(name="copyAllowed")
    def copy_allowed(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the user can copy text from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "copy_allowed")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the customer managed KMS key.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="deepLinkAllowed")
    def deep_link_allowed(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the user can use deep links that open automatically when connecting to a session. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "deep_link_allowed")

    @property
    @pulumi.getter(name="disconnectTimeoutInMinutes")
    def disconnect_timeout_in_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Amount of time that a streaming session remains active after users disconnect. Value must be between 1 and 600 minutes.
        """
        return pulumi.get(self, "disconnect_timeout_in_minutes")

    @property
    @pulumi.getter(name="downloadAllowed")
    def download_allowed(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the user can download files from the streaming session to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "download_allowed")

    @property
    @pulumi.getter(name="idleDisconnectTimeoutInMinutes")
    def idle_disconnect_timeout_in_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Amount of time that users can be idle before they are disconnected from their streaming session. Value must be between 0 and 60 minutes.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_minutes")

    @property
    @pulumi.getter(name="pasteAllowed")
    def paste_allowed(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the user can paste text from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "paste_allowed")

    @property
    @pulumi.getter(name="printAllowed")
    def print_allowed(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the user can print to the local device. Valid values are `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "print_allowed")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="toolbarConfiguration")
    def toolbar_configuration(self) -> pulumi.Output[Optional['outputs.UserSettingsToolbarConfiguration']]:
        """
        Configuration of the toolbar. Detailed below.
        """
        return pulumi.get(self, "toolbar_configuration")

    @property
    @pulumi.getter(name="uploadAllowed")
    def upload_allowed(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the user can upload files from the local device to the streaming session. Valid values are `Enabled` or `Disabled`.

        The following arguments are optional:
        """
        return pulumi.get(self, "upload_allowed")

    @property
    @pulumi.getter(name="userSettingsArn")
    def user_settings_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the user settings resource.
        """
        return pulumi.get(self, "user_settings_arn")

