import gradio as gr
from particleanalyzer.core.about import (
    about_ru,
    about_en,
    about_zh_cn,
    about_zh_tw,
)
from particleanalyzer.core.parameter_information import (
    reference_ru,
    reference_en,
    reference_zh_cn,
    reference_zh_tw,
)

translations = {
    "ru": {
        "Подготовка...": "Подготовка...",
        "Загрузка изображения...": "Загрузка изображения...",
        "Instrument scale in µm": "Instrument scale in µm",
        "Pixels": "Pixels",
        "Original": "Original",
        "YOLO обрабатывает изображение...": "YOLO обрабатывает изображение...",
        "Ошибка: недостаточно памяти CUDA. Освобождаем память. Попробуйте уменьшить разрешение изображения или включите режим SAHI...": "Ошибка: недостаточно памяти CUDA. Освобождаем память. Попробуйте уменьшить разрешение изображения или включите режим SAHI...",
        "Произошла другая ошибка": "Произошла другая ошибка",
        "Объекты не обнаружены.": "Объекты не обнаружены.",
        "Достигнут предел количества обнаружений. Увеличьте максимальное количество обнаружений в настройках.": "Достигнут предел количества обнаружений. Увеличьте максимальное количество обнаружений в настройках.",
        "Обработка частиц...": "Обработка частиц...",
        "мкм": "мкм",
        "нм": "нм",
        "пикс": "пикс",
        "ед.": "ед.",
        "Диаметр": "Диаметр",
        "Средний диаметр": "Средний диаметр",
        "Максимальный диаметр": "Максимальный диаметр",
        "Минимальный диаметр": "Минимальный диаметр",
        "Максимальный угол": "Максимальный угол",
        "Минимальный угол": "Минимальный угол",
        "Площадь": "Площадь",
        "Периметр": "Периметр",
        "Detectron2 обрабатывает изображение...": "Detectron2 обрабатывает изображение...",
        "Произошла ошибка:": "Произошла ошибка:",
        "SAHI обрабатывает изображение...": "SAHI обрабатывает изображение...",
        "Построение таблицы...": "Построение таблицы...",
        "Параметр": "Параметр",
        "Среднее": "Среднее",
        "Медиана": "Медиана",
        "Максимум": "Максимум",
        "Минимум": "Минимум",
        "СО": "СО",
        "Построение графиков...": "Построение графиков...",
        "Распределение площади": "Распределение площади",
        "Распределение периметра": "Распределение периметра",
        "Распределение диаметра": "Распределение диаметра",
        "Распределение эксцентриситета": "Распределение эксцентриситета",
        "Распределение интенсивности": "Распределение интенсивности",
        "(норм. распр.)": "(норм. распр.)",
        "Количество": "Количество",
        "Плотность вероятности": "Плотность вероятности",
        "Эксцентриситет": "Эксцентриситет",
        "Интенсивность": "Интенсивность",
        "Критическая ошибка в process_image": "Критическая ошибка в process_image",
        "Ошибка в вычислении центроида.": "Ошибка в вычислении центроида.",
        "Найдено больше двух точек.": "Найдено больше двух точек.",
        "Обозначьте на изображении масштабную шкалу при помощи двух точек.": "Обозначьте на изображении масштабную шкалу при помощи двух точек.",
        "Тёмный режим": "Тёмный режим",
        "Светлый режим": "Светлый режим",
        "ParticleAnalyzer — Инструмент для анализа изображений SEM": "ParticleAnalyzer — Инструмент для анализа изображений SEM",
        "Инструмент для анализа размерных характеристик частиц на изображениях SEM.<br>В случае проблем с сегментацией изображения или возникновения ошибок, пожалуйста, направляйте материалы на электронную почту: rybakov-ks@ya.ru": "Инструмент для анализа размерных характеристик частиц на изображениях SEM.<br>В случае проблем с сегментацией изображения или возникновения ошибок, пожалуйста, направляйте материалы на электронную почту: rybakov-ks@ya.ru",
        "Анализ": "Анализ",
        "Изображение СЭМ": "Изображение СЭМ",
        "Результат сегментации": "Результат сегментации",
        "Примеры": "Примеры",
        "Характеристики частицы": "Характеристики частицы",
        "Анализировать": "Анализировать",
        "Очистить": "Очистить",
        "Количество частиц": "Количество частиц",
        "Статистика по частицам": "Статистика по частицам",
        "Характеристики частиц": "Характеристики частиц",
        "Файлы для скачивания": "Файлы для скачивания",
        "Графики распределения": "Графики распределения",
        "Вы удовлетворены качеством сегментации?": "Вы удовлетворены качеством сегментации?",
        "Да": "Да",
        "Нет": "Нет",
        "Настройки": "Настройки",
        "Модель обнаружения": "Модель обнаружения",
        "Включить": "Включить",
        "Включить обработку с разбиением на фрагменты (SAHI)?": "Включить обработку с разбиением на фрагменты (SAHI)?",
        "Высота слайса": "Высота слайса",
        "Ширина слайса": "Ширина слайса",
        "Перекрытие по высоте": "Перекрытие по высоте",
        "Перекрытие по ширине": "Перекрытие по ширине",
        "Точность обнаружения": "Точность обнаружения",
        "Порог перекрытия (IoU)": "Порог перекрытия (IoU)",
        "Максимальное количество обнаружений": "Максимальное количество обнаружений",
        "Режим масштабирования": "Режим масштабирования",
        "Разрешение изображения": "Разрешение изображения",
        "Округлять результаты до": "Округлять результаты до",
        "Включить режим анализа отдельных частиц?": "Включить режим анализа отдельных частиц?",
        "Интервалов на гистограмме": "Интервалов на гистограмме",
        "Ошибка: изображение отсутствует...": "Ошибка: изображение отсутствует...",
        "Используется CUDA устройство:": "Используется CUDA устройство:",
        "CUDA не доступна, используется CPU": "CUDA не доступна, используется CPU",
        "Шкала прибора в мкм": "Instrument scale in µm",
        "Включить отображение диаметров Ферета?": "Включить отображение диаметров Ферета?",
        "Распределение диаметра Ферета": "Распределение диаметра Ферета",
        "Распределение угла Ферета": "Распределение угла Ферета",
        "Векторное поле ориентации": "Векторное поле ориентации",
        "Удлинение": "Удлинение",
        "Утолщение": "Утолщение",
        "ИИ-интерпретация SEM-данных": "ИИ-интерпретация SEM-данных",
        "Запустить ИИ-анализ": "Запустить ИИ-анализ",
        "Языковая модель (LLM)": "Языковая модель (LLM)",
        "Готово!": "Готово!",
        "Длина шкалы в мкм": "Длина шкалы в мкм",
        "Длина шкалы в нм": "Длина шкалы в нм",
        "О программе": "О программе",
        "Статистика": "Статистика",
        "Графики": "Графики",
        "ИИ-анализ": "ИИ-анализ",
        "Файлы": "Файлы",
        "Оценить результаты": "Оценить результаты",
        "Результаты сегментации частиц": "Результаты сегментации частиц",
        "Отменить": "Отменить",
        about_ru: about_ru,
        "ru": "'ru'",
        "Помощь": "Помощь",
        "Как задать масштаб?": "Как задать масштаб?",
        "Справочник параметров": "Справочник параметров",
        reference_ru: reference_ru,
        """🔬 **Добро пожаловать в систему анализа SEM-изображений!**
        Я – ваш виртуальный ассистент в сканирующей электронной микроскопии. Готов провести детальный анализ морфологии и размерных характеристик частиц.""": """🔬 **Добро пожаловать в систему анализа SEM-изображений!**
            Я – ваш виртуальный ассистент в сканирующей электронной микроскопии. Готов провести детальный анализ морфологии и размерных характеристик частиц.""",
        "Видео инструкция": "Видео инструкция",
        "Параметры фильтрации": "Параметры фильтрации",
        "Включить контур?": "Включить контур?",
        "Цвет контура": "Цвет контура",
        "Включить заливку?": "Включить заливку?",
        "Тип заливки": "Тип заливки",
        "Цвет заливки": "Цвет заливки",
        "Прозрачность заливки": "Прозрачность заливки",
        "Удалить частицы": "Удалить частицы",
        "Сбросить таблицу": "Сбросить таблицу",
        "Загрузить изображение СЭМ": "Загрузить изображение СЭМ",
        "Статус калибровки масштаба": "Статус калибровки масштаба",
        "Выберите две крайние точки на шкале": "Выберите две крайние точки на шкале",
        "Расстояние равно": "Расстояние равно",
        "пикселей": "пикселей",
        "Выбрано точек": "Выбрано точек",
        "Ориентация": "Ориентация",
        "Количество обнаружений": "Количество обнаружений",
        "Настройки обнаружения": "Настройки обнаружения",
        "Обработка с разбиением (SAHI)": "Обработка с разбиением (SAHI)",
        "Основные параметры": "Основные параметры",
        "Параметры визуализации": "Параметры визуализации",
    },
    "en": {
        "Подготовка...": "Initializing...",
        "Загрузка изображения...": "Loading image...",
        "Instrument scale in µm": "Instrument scale in µm",
        "Pixels": "Pixels",
        "Оригинал": "Original",
        "YOLO обрабатывает изображение...": "YOLO is processing image...",
        "Ошибка: недостаточно памяти CUDA. Освобождаем память. Попробуйте уменьшить разрешение изображения или включите режим SAHI...": "Error: Not enough CUDA memory. Freeing up memory. Please try reducing the image resolution or enable SAHI mode...",
        "Произошла другая ошибка": "An error occurred",
        "Объекты не обнаружены.": "No objects detected.",
        "Достигнут предел количества обнаружений. Увеличьте максимальное количество обнаружений в настройках.": "Detection limit reached. Increase maximum detections in settings.",
        "Обработка частиц...": "Processing particles...",
        "ед.": "units",
        "мкм": "µm",
        "нм": "nm",
        "пикс": "px",
        "Диаметр": "Diameter",
        "Средний диаметр": "Average diameter",
        "Максимальный диаметр": "Maximum diameter",
        "Минимальный диаметр": "Minimum diameter",
        "Максимальный угол": "Maximum angle",
        "Минимальный угол": "Minimum angle",
        "Площадь": "Area",
        "Периметр": "Perimeter",
        "Detectron2 обрабатывает изображение...": "Detectron2 is processing images...",
        "Произошла ошибка:": "Error occurred:",
        "SAHI обрабатывает изображение...": "SAHI is processing the image...",
        "Построение таблицы...": "Generating table...",
        "Параметр": "Parameter",
        "Среднее": "Average",
        "Медиана": "Median",
        "Максимум": "Maximum",
        "Минимум": "Minimum",
        "СО": "SD",
        "Построение графиков...": "Generating plots...",
        "Распределение площади": "Area distribution",
        "Распределение периметра": "Perimeter distribution",
        "Распределение диаметра": "Diameter distribution",
        "Распределение эксцентриситета": "Eccentricity distribution",
        "Распределение интенсивности": "Intensity distribution",
        "(норм. распр.)": "(normal distribution)",
        "Количество": "Count",
        "Плотность вероятности": "Probability density",
        "Эксцентриситет": "Eccentricity",
        "Интенсивность": "Intensity",
        "Критическая ошибка в process_image": "Critical error in process_image",
        "Ошибка в вычислении центроида.": "Error in centroid calculation.",
        "Найдено больше двух точек.": "More than two points found.",
        "Обозначьте на изображении масштабную шкалу при помощи двух точек.": "Please mark the scale bar on the image using two points.",
        "Тёмный режим": "Dark mode",
        "Светлый режим": "Light mode",
        "ParticleAnalyzer — Инструмент для анализа изображений SEM": "ParticleAnalyzer — SEM Image Analysis Tool",
        "Инструмент для анализа размерных характеристик частиц на изображениях SEM.<br>В случае проблем с сегментацией изображения или возникновения ошибок, пожалуйста, направляйте материалы на электронную почту: rybakov-ks@ya.ru": "This tool can be used to analyze particle size characteristics in SEM images.<br>In case of problems with image segmentation or errors, please send materials to e-mail: rybakov-ks@ya.ru",
        "Анализ": "Analysis",
        "Изображение СЭМ": "SEM Image",
        "Результат сегментации": "Segmentation result",
        "Примеры": "Examples",
        "Характеристики частицы": "Particle characteristics",
        "Анализировать": "Analyze",
        "Очистить": "Clear",
        "Количество частиц": "Particle count",
        "Статистика по частицам": "Particle statistics",
        "Характеристики частиц": "Particles characteristics",
        "Файлы для скачивания": "Downloadable files",
        "Графики распределения": "Distribution plots",
        "Вы удовлетворены качеством сегментации?": "Are you satisfied with the segmentation quality?",
        "Да": "Yes",
        "Нет": "No",
        "Настройки": "Settings",
        "Модель обнаружения": "Detection model",
        "Включить": "Enable",
        "Включить обработку с разбиением на фрагменты (SAHI)?": "Enable tiled processing (SAHI)?",
        "Высота слайса": "Slice height",
        "Ширина слайса": "Slice width",
        "Перекрытие по высоте": "Height overlap ratio",
        "Перекрытие по ширине": "Width overlap ratio",
        "Точность обнаружения": "Detection confidence threshold",
        "Порог перекрытия (IoU)": "IoU threshold",
        "Максимальное количество обнаружений": "Maximum detections",
        "Режим масштабирования": "Scaling mode",
        "Разрешение изображения": "Image resolution",
        "Округлять результаты до": "Round values to",
        "Включить режим анализа отдельных частиц?": "Enable single particle analysis mode?",
        "Интервалов на гистограмме": "Number of histogram bins",
        "Ошибка: изображение отсутствует...": "Error: Image is missing...",
        "Используется CUDA устройство:": "CUDA device in use:",
        "CUDA не доступна, используется CPU": "CUDA not available, using CPU",
        "Шкала прибора в мкм": "Instrument scale in µm",
        "Включить отображение диаметров Ферета?": "Enable display of ferret diameters?",
        "Распределение диаметра Ферета": "Distribution of Feret diameter",
        "Распределение угла Ферета": "Distribution of Feret's angle",
        "Векторное поле ориентации": "Orientation Vector Field",
        "Удлинение": "Elongation",
        "Утолщение": "Thickening",
        "ИИ-интерпретация SEM-данных": "AI Interpretation of SEM Data",
        "Запустить ИИ-анализ": "Launch AI analysis",
        "Языковая модель (LLM)": "Language Model (LLM)",
        "Готово!": "Ready!",
        "Длина шкалы в мкм": "Scale length in µm",
        "Длина шкалы в нм": "Scale length in nm",
        "О программе": "About",
        "Статистика": "Statistics",
        "Графики": "Charts",
        "ИИ-анализ": "AI Analysis",
        "Файлы": "Files",
        "Оценить результаты": "Evaluate Results",
        "Результаты сегментации частиц": "Particle Segmentation Results",
        "Отменить": "Cancel",
        about_ru: about_en,
        "ru": "'en'",
        "Помощь": "Show Guide",
        "Как задать масштаб?": "How to set the scale?",
        "Справочник параметров": "Parameters Reference",
        reference_ru: reference_en,
        """🔬 **Добро пожаловать в систему анализа SEM-изображений!**
        Я – ваш виртуальный ассистент в сканирующей электронной микроскопии. Готов провести детальный анализ морфологии и размерных характеристик частиц.""": """🔬 **Welcome to the SEM Image Analysis System!**
            I am your virtual assistant for scanning electron microscopy. Ready to perform detailed analysis of particle morphology and size characteristics.""",
        "Видео инструкция": "Video instructions",
        "Параметры фильтрации": "Filtering Options",
        "Включить контур?": "Enable outline?",
        "Цвет контура": "Outline color",
        "Включить заливку?": "Enable fill?",
        "Тип заливки": "Fill Type",
        "Цвет заливки": "Fill Color",
        "Прозрачность заливки": "Fill Transparency",
        "Удалить частицы": "Remove particles",
        "Сбросить таблицу": "Reset table",
        "Загрузить изображение СЭМ": "Upload SEM image",
        "Статус калибровки масштаба": "Scale calibration status",
        "Выберите две крайние точки на шкале": "Select the two extreme points of the scale.",
        "Расстояние равно": "Distance is",
        "пикселей": "pixels",
        "Выбрано точек": "Points selected",
        "Ориентация": "Orientation",
        "Количество обнаружений": "Number of detections",
        "Настройки обнаружения": "Discovery Settings",
        "Обработка с разбиением (SAHI)": "Split processing (SAHI)",
        "Основные параметры": "Basic parameters",
        "Параметры визуализации": "Visualization Parameters",
    },
    "zh-cn": {
        "Подготовка...": "初始化中...",
        "Загрузка изображения...": "正在加载图像...",
        "Instrument scale in µm": "Instrument scale in µm",
        "Pixels": "Pixels",
        "Original": "Original",
        "YOLO обрабатывает изображение...": "YOLO正在处理图像...",
        "Ошибка: недостаточно памяти CUDA. Освобождаем память. Попробуйте уменьшить разрешение изображения или включите режим SAHI...": "错误：CUDA内存不足。正在释放内存。请尝试降低图像分辨率或启用SAHI模式...",
        "Произошла другая ошибка": "发生其他错误",
        "Объекты не обнаружены.": "未检测到对象",
        "Достигнут предел количества обнаружений. Увеличьте максимальное количество обнаружений в настройках.": "达到检测数量上限。请在设置中增加最大检测数量",
        "Обработка частиц...": "正在处理粒子...",
        "мкм": "微米",
        "нм": "纳米",
        "пикс": "像素",
        "ед.": "单位",
        "Диаметр": "直径",
        "Средний диаметр": "平均直径",
        "Максимальный диаметр": "最大直径",
        "Минимальный диаметр": "最小直径",
        "Максимальный угол": "最大角度",
        "Минимальный угол": "最小角度",
        "Площадь": "面积",
        "Периметр": "周长",
        "Detectron2 обрабатывает изображение...": "Detectron2正在处理图像...",
        "Произошла ошибка:": "发生错误:",
        "SAHI обрабатывает изображение...": "SAHI 正在处理图像...",
        "Построение таблицы...": "正在生成表格...",
        "Параметр": "参数",
        "Среднее": "平均值",
        "Медиана": "中位数",
        "Максимум": "最大值",
        "Минимум": "最小值",
        "СО": "标准差",
        "Построение графиков...": "正在生成图表...",
        "Распределение площади": "面积分布",
        "Распределение периметра": "周长分布",
        "Распределение диаметра": "直径分布",
        "Распределение эксцентриситета": "偏心率分布",
        "Распределение интенсивности": "强度分布",
        "(норм. распр.)": "(正态分布)",
        "Количество": "数量",
        "Плотность вероятности": "概率密度",
        "Эксцентриситет": "偏心率",
        "Интенсивность": "强度",
        "Критическая ошибка в process_image": "process_image中的关键错误",
        "Ошибка в вычислении центроида.": "计算质心时出错",
        "Найдено больше двух точек.": "找到超过两个点",
        "Обозначьте на изображении масштабную шкалу при помощи двух точек.": "请在图像上用两点标记比例尺",
        "Тёмный режим": "暗黑模式",
        "Светлый режим": "明亮模式",
        "ParticleAnalyzer — Инструмент для анализа изображений SEM": "ParticleAnalyzer — SEM图像分析工具",
        "Инструмент для анализа размерных характеристик частиц на изображениях SEM.<br>В случае проблем с сегментацией изображения или возникновения ошибок, пожалуйста, направляйте материалы на электронную почту: rybakov-ks@ya.ru": "该工具可用于分析SEM图像中的粒度特征。<br>如遇图像分割问题或错误，请将资料发送至邮箱：rybakov-ks@ya.ru",
        "Анализ": "分析",
        "Изображение СЭМ": "SEM图像",
        "Результат сегментации": "分割结果",
        "Примеры": "示例",
        "Характеристики частицы": "粒子特征",
        "Анализировать": "分析",
        "Очистить": "清除",
        "Количество частиц": "粒子数量",
        "Статистика по частицам": "粒子统计",
        "Характеристики частиц": "粒子特性",
        "Файлы для скачивания": "可下载文件",
        "Графики распределения": "分布图表",
        "Вы удовлетворены качеством сегментации?": "您对分割质量满意吗?",
        "Да": "是",
        "Нет": "否",
        "Настройки": "设置",
        "Модель обнаружения": "检测模型",
        "Включить": "启用",
        "Включить обработку с разбиением на фрагменты (SAHI)?": "启用分块处理(SAHI)?",
        "Высота слайса": "切片高度",
        "Ширина слайса": "切片宽度",
        "Перекрытие по высоте": "高度重叠率",
        "Перекрытие по ширине": "宽度重叠率",
        "Точность обнаружения": "检测置信度阈值",
        "Порог перекрытия (IoU)": "IoU阈值",
        "Максимальное количество обнаружений": "最大检测数量",
        "Режим масштабирования": "缩放模式",
        "Разрешение изображения": "图像分辨率",
        "Округлять результаты до": "结果四舍五入至",
        "Включить режим анализа отдельных частиц?": "启用单粒子分析模式?",
        "Интервалов на гистограмме": "直方图区间数",
        "Ошибка: изображение отсутствует...": "错误：图片缺失...",
        "Используется CUDA устройство:": "CUDA 设备正在使用中：",
        "CUDA не доступна, используется CPU": "CUDA 不可用，正在占用 CPU",
        "Шкала прибора в мкм": "Instrument scale in µm",
        "Включить отображение диаметров Ферета?": "是否显示雪貂直径？",
        "Распределение диаметра Ферета": "費雷特直徑分佈",
        "Распределение угла Ферета": "費雷特角的分佈",
        "Векторное поле ориентации": "取向矢量场",
        "Удлинение": "伸长",
        "Утолщение": "加厚",
        "ИИ-интерпретация SEM-данных": "SEM数据的AI解读",
        "Запустить ИИ-анализ": "启动人工智能分析",
        "Языковая модель (LLM)": "语言模型（法学硕士）",
        "Готово!": "准备好！",
        "Длина шкалы в мкм": "比例尺长度（微米）",
        "Длина шкалы в нм": "比例尺长度（纳米）",
        "О программе": "关于",
        "Статистика": "统计数据",
        "Графики": "图表",
        "ИИ-анализ": "人工智能分析",
        "Файлы": "文件",
        "Оценить результаты": "评估结果",
        "Результаты сегментации частиц": "颗粒分割结果",
        "Отменить": "取消",
        about_ru: about_zh_cn,
        "ru": "'zh-cn'",
        "Помощь": "演出指南",
        "Как задать масштаб?": "如何设定比例？",
        "Справочник параметров": "参数参考",
        reference_ru: reference_zh_cn,
        """🔬 **Добро пожаловать в систему анализа SEM-изображений!**
        Я – ваш виртуальный ассистент в сканирующей электронной микроскопии. Готов провести детальный анализ морфологии и размерных характеристик частиц.""": """🔬 **欢迎使用扫描电镜图像分析系统！**
            我是您的电子显微镜虚拟助手，可对颗粒形貌和尺寸特征进行详细分析。""",
        "Видео инструкция": "视频说明",
        "Параметры фильтрации": "过滤选项",
        "Включить контур?": "启用轮廓？",
        "Цвет контура": "轮廓颜色",
        "Включить заливку?": "启用填充？",
        "Тип заливки": "填充类型",
        "Цвет заливки": "填充颜色",
        "Прозрачность заливки": "填充透明度",
        "Удалить частицы": "去除颗粒",
        "Сбросить таблицу": "重置表",
        "Загрузить изображение СЭМ": "上传扫描电镜图像",
        "Статус калибровки масштаба": "秤校准状态",
        "Выберите две крайние точки на шкале": "选择尺度的两个极值点。",
        "Расстояние равно": "距离",
        "пикселей": "像素",
        "Выбрано точек": "已选点",
        "Ориентация": "方向",
        "Количество обнаружений": "检测次数",
        "Настройки обнаружения": "发现设置",
        "Обработка с разбиением (SAHI)": "分区处理（SAHI）",
        "Основные параметры": "基本参数",
        "Параметры визуализации": "渲染选项",
    },
    "zh-tw": {
        "Подготовка...": "初始化中...",
        "Загрузка изображения...": "正在載入圖像...",
        "Instrument scale in µm": "Instrument scale in µm",
        "Pixels": "Pixels",
        "Original": "Original",
        "YOLO обрабатывает изображение...": "YOLO正在處理圖像...",
        "Ошибка: недостаточно памяти CUDA. Освобождаем память. Попробуйте уменьшить разрешение изображения или включите режим SAHI...": "錯誤：CUDA記憶體不足。正在釋放記憶體。請嘗試降低圖像解析度或啟用SAHI模式...",
        "Произошла другая ошибка": "發生其他錯誤",
        "Объекты не обнаружены.": "未檢測到對象",
        "Достигнут предел количества обнаружений. Увеличьте максимальное количество обнаружений в настройках.": "達到檢測數量上限。請在設定中增加最大檢測數量",
        "Обработка частиц...": "正在處理粒子...",
        "мкм": "微米",
        "нм": "奈米",
        "пикс": "像素",
        "ед.": "單位",
        "Диаметр": "直徑",
        "Средний диаметр": "平均直徑",
        "Максимальный диаметр": "最大直徑",
        "Минимальный диаметр": "最小直徑",
        "Максимальный угол": "最大角度",
        "Минимальный угол": "最小角度",
        "Площадь": "面積",
        "Периметр": "周長",
        "Detectron2 обрабатывает изображение...": "Detectron2正在處理圖像...",
        "Произошла ошибка:": "發生錯誤:",
        "SAHI обрабатывает изображение...": "SAHI 正在處理影像...",
        "Построение таблицы...": "正在生成表格...",
        "Параметр": "參數",
        "Среднее": "平均值",
        "Медиана": "中位數",
        "Максимум": "最大值",
        "Минимум": "最小值",
        "СО": "標準差",
        "Построение графиков...": "正在生成圖表...",
        "Распределение площади": "面積分布",
        "Распределение периметра": "周長分布",
        "Распределение диаметра": "直徑分布",
        "Распределение эксцентриситета": "偏心率分布",
        "Распределение интенсивности": "強度分布",
        "(норм. распр.)": "(正態分布)",
        "Количество": "數量",
        "Плотность вероятности": "概率密度",
        "Эксцентриситет": "偏心率",
        "Интенсивность": "強度",
        "Критическая ошибка в process_image": "process_image中的關鍵錯誤",
        "Ошибка в вычислении центроида.": "計算質心時出錯",
        "Найдено больше двух точек.": "找到超過兩個點",
        "Обозначьте на изображении масштабную шкалу при помощи двух точек.": "請在圖像上用兩點標記比例尺",
        "Тёмный режим": "暗黑模式",
        "Светлый режим": "明亮模式",
        "ParticleAnalyzer — Инструмент для анализа изображений SEM": "ParticleAnalyzer — SEM圖像分析工具",
        "Инструмент для анализа размерных характеристик частиц на изображениях SEM.<br>В случае проблем с сегментацией изображения или возникновения ошибок, пожалуйста, направляйте материалы на электронную почту: rybakov-ks@ya.ru": "此工具可用於分析SEM影像中的粒度特徵。 <br>如遇影像分割問題或錯誤，請將資料寄至信箱：rybakov-ks@ya.ru",
        "Анализ": "分析",
        "Изображение СЭМ": "SEM圖像",
        "Результат сегментации": "分割結果",
        "Примеры": "示例",
        "Характеристики частицы": "粒子特徵",
        "Анализировать": "分析",
        "Очистить": "清除",
        "Количество частиц": "粒子數量",
        "Статистика по частицам": "粒子統計",
        "Характеристики частиц": "粒子特性",
        "Файлы для скачивания": "可下載文件",
        "Графики распределения": "分布圖表",
        "Вы удовлетворены качеством сегментации?": "您對分割質量滿意嗎?",
        "Да": "是",
        "Нет": "否",
        "Настройки": "設定",
        "Модель обнаружения": "檢測模型",
        "Включить": "啟用",
        "Включить обработку с разбиением на фрагменты (SAHI)?": "啟用分塊處理(SAHI)?",
        "Высота слайса": "切片高度",
        "Ширина слайса": "切片寬度",
        "Перекрытие по высоте": "高度重疊率",
        "Перекрытие по ширине": "寬度重疊率",
        "Точность обнаружения": "檢測置信度閾值",
        "Порог перекрытия (IoU)": "IoU閾值",
        "Максимальное количество обнаружений": "最大檢測數量",
        "Режим масштабирования": "縮放模式",
        "Разрешение изображения": "圖像解析度",
        "Округлять результаты до": "結果四捨五入至",
        "Включить режим анализа отдельных частиц?": "啟用單粒子分析模式?",
        "Интервалов на гистограмме": "直方圖區間數",
        "Ошибка: изображение отсутствует...": "錯誤：圖片缺失...",
        "Используется CUDA устройство:": "CUDA 設備正在使用中：",
        "CUDA не доступна, используется CPU": "CUDA 不可用，正在佔用 CPU",
        "Шкала прибора в мкм": "Instrument scale in µm",
        "Включить отображение диаметров Ферета?": "是否顯示雪貂直徑？",
        "Распределение диаметра Ферета": "費雷特直徑分佈",
        "Распределение угла Ферета": "費雷特角的分佈",
        "Средний диаметр [мкм]": "平均直徑[微米]",
        "Максимальный диаметр [мкм]": "最大直徑[微米]",
        "Минимальный диаметр [мкм]": "最小直徑[微米]",
        "Средний диаметр [пикс]": "平均直徑[像素]",
        "Максимальный диаметр [пикс]": "最大直徑[像素]",
        "Минимальный диаметр [пикс]": "最小直徑[像素]",
        "Максимальный угол [°]": "最大角度[°]",
        "Минимальный угол [°]": "最小角度[°]",
        "Векторное поле ориентации": "取向向量場",
        "Удлинение": "伸長",
        "Утолщение": "加厚",
        "ИИ-интерпретация SEM-данных": "SEM數據的AI解讀",
        "Запустить ИИ-анализ": "啟動人工智慧分析",
        "Языковая модель (LLM)": "語言模型（法學碩士）",
        "Готово!": "準備好！",
        "Длина шкалы в мкм": "比例尺長度（微米）",
        "Длина шкалы в нм": "比例尺長度（納米）",
        "О программе": "關於",
        "Статистика": "統計數據",
        "Графики": "圖表",
        "ИИ-анализ": "人工智慧分析",
        "Файлы": "檔案",
        "Оценить результаты": "評估結果",
        "Результаты сегментации частиц": "粒子分割結果",
        "Отменить": "取消",
        about_ru: about_zh_tw,
        "ru": "'zh-tw'",
        "Помощь": "演出指南",
        "Как задать масштаб?": "如何設定比例？",
        "Справочник параметров": "參數參考",
        reference_ru: reference_zh_tw,
        """🔬 **Добро пожаловать в систему анализа SEM-изображений!**
        Я – ваш виртуальный ассистент в сканирующей электронной микроскопии. Готов провести детальный анализ морфологии и размерных характеристик частиц.""": """🔬 **歡迎使用掃描式電子顯微鏡影像分析系統！**
            我是您的電子顯微鏡虛擬助手，可對顆粒形貌和尺寸特徵進行詳細分析。""",
        "Видео инструкция": "影片說明",
        "Параметры фильтрации": "過濾選項",
        "Включить контур?": "啟用輪廓？",
        "Цвет контура": "輪廓顏色",
        "Включить заливку?": "啟用填充？",
        "Тип заливки": "填滿類型",
        "Цвет заливки": "填滿顏色",
        "Удалить частицы": "去除顆粒",
        "Сбросить таблицу": "重設表",
        "Загрузить изображение СЭМ": "上傳掃描電子顯微鏡影像",
        "Статус калибровки масштаба": "秤校準狀態",
        "Выберите две крайние точки на шкале": "選擇尺度的兩個極值點。",
        "Расстояние равно": "距離",
        "пикселей": "像素",
        "Выбрано точек": "已選點",
        "Ориентация": "方向",
        "Количество обнаружений": "檢測次數",
        "Настройки обнаружения": "發現設定",
        "Обработка с разбиением (SAHI)": "分區處理（SAHI）",
        "Основные параметры": "基本參數",
        "Параметры визуализации": "渲染選項",
    },
}

i18n = gr.I18n(
    ru=translations["ru"],
    en=translations["en"],
    **{"zh-CN": translations["zh-cn"], "zh-TW": translations["zh-tw"]}
)
