# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .config_values import ConfigValues


class AuthProviderConnectionUpdate(UniversalBaseModel):
    """
    Schema for updating an auth provider connection.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-readable name for this auth provider connection
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional detailed description of what this auth provider connection provides.
    """

    auth_fields: typing.Optional[ConfigValues] = pydantic.Field(default=None)
    """
    Updated authentication credentials for the auth provider. The required fields vary by auth provider type. If provided, all existing credentials will be replaced.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
