# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .authentication_method import AuthenticationMethod
from .integration_type import IntegrationType
from .o_auth_type import OAuthType


class IntegrationCredentialRawCreate(UniversalBaseModel):
    """
    Create class for integration credentials with raw auth fields.

    This schema is used when auth fields need to be validated and encrypted
    before creating the credential.
    """

    name: str
    integration_short_name: str
    description: typing.Optional[str] = None
    integration_type: IntegrationType
    authentication_method: AuthenticationMethod
    oauth_type: typing.Optional[OAuthType] = None
    auth_config_class: typing.Optional[str] = None
    auth_fields: typing.Dict[str, typing.Optional[typing.Any]]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
