# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .authentication_method import AuthenticationMethod
from .source_connection_status import SourceConnectionStatus


class SourceConnectionListItem(UniversalBaseModel):
    """
    Clean source connection for list views.
    """

    id: str
    name: str
    short_name: str
    readable_collection_id: str
    created_at: dt.datetime
    modified_at: dt.datetime
    is_authenticated: bool
    entity_count: typing.Optional[int] = None
    auth_method: AuthenticationMethod = pydantic.Field()
    """
    Get authentication method from database value.
    """

    status: SourceConnectionStatus = pydantic.Field()
    """
    Compute connection status from current state.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
