import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AdminRoleCustomAssignmentsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the Custom Role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments.html#custom_role_id AdminRoleCustomAssignments#custom_role_id}
     *
     * @stability stable
     */
    readonly customRoleId: string;
    /**
     * The hrefs that point to User(s) and/or Group(s) that receive the Role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments.html#members AdminRoleCustomAssignments#members}
     *
     * @stability stable
     */
    readonly members?: string[];
    /**
     * ID of the target Resource Set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments.html#resource_set_id AdminRoleCustomAssignments#resource_set_id}
     *
     * @stability stable
     */
    readonly resourceSetId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments.html okta_admin_role_custom_assignments}.
 *
 * @stability stable
 */
export declare class AdminRoleCustomAssignments extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments.html okta_admin_role_custom_assignments} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AdminRoleCustomAssignmentsConfig);
    private _customRoleId?;
    /**
     * @stability stable
     */
    get customRoleId(): string;
    /**
     * @stability stable
     */
    set customRoleId(value: string);
    /**
     * @stability stable
     */
    get customRoleIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _members?;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    resetMembers(): void;
    /**
     * @stability stable
     */
    get membersInput(): string[] | undefined;
    private _resourceSetId?;
    /**
     * @stability stable
     */
    get resourceSetId(): string;
    /**
     * @stability stable
     */
    set resourceSetId(value: string);
    /**
     * @stability stable
     */
    get resourceSetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
