import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AdminRoleCustomConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the new Role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom.html#description AdminRoleCustom#description}
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * The name given to the new Role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom.html#label AdminRoleCustom#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * The permissions that the new Role grants.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom.html#permissions AdminRoleCustom#permissions}
     *
     * @stability stable
     */
    readonly permissions?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom.html okta_admin_role_custom}.
 *
 * @stability stable
 */
export declare class AdminRoleCustom extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom.html okta_admin_role_custom} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AdminRoleCustomConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): string[];
    /**
     * @stability stable
     */
    set permissions(value: string[]);
    /**
     * @stability stable
     */
    resetPermissions(): void;
    /**
     * @stability stable
     */
    get permissionsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
