import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AdminRoleTargetsConfig extends cdktf.TerraformMetaArguments {
    /**
     * List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3').
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets.html#apps AdminRoleTargets#apps}
     *
     * @stability stable
     */
    readonly apps?: string[];
    /**
     * List of group IDs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets.html#groups AdminRoleTargets#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * Type of the role that is assigned to the user and supports optional targets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets.html#role_type AdminRoleTargets#role_type}
     *
     * @stability stable
     */
    readonly roleType: string;
    /**
     * User associated with the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets.html#user_id AdminRoleTargets#user_id}
     *
     * @stability stable
     */
    readonly userId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets.html okta_admin_role_targets}.
 *
 * @stability stable
 */
export declare class AdminRoleTargets extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets.html okta_admin_role_targets} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AdminRoleTargetsConfig);
    private _apps?;
    /**
     * @stability stable
     */
    get apps(): string[];
    /**
     * @stability stable
     */
    set apps(value: string[]);
    /**
     * @stability stable
     */
    resetApps(): void;
    /**
     * @stability stable
     */
    get appsInput(): string[] | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get roleId(): string;
    private _roleType?;
    /**
     * @stability stable
     */
    get roleType(): string;
    /**
     * @stability stable
     */
    set roleType(value: string);
    /**
     * @stability stable
     */
    get roleTypeInput(): string | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
