import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppAutoLoginConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom error page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#accessibility_error_redirect_url AppAutoLogin#accessibility_error_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
     * Custom login page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#accessibility_login_redirect_url AppAutoLogin#accessibility_login_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
     * Enable self service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#accessibility_self_service AppAutoLogin#accessibility_self_service}
     *
     * @stability stable
     */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
     * Application notes for admins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#admin_note AppAutoLogin#admin_note}
     *
     * @stability stable
     */
    readonly adminNote?: string;
    /**
     * Displays specific appLinks for the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#app_links_json AppAutoLogin#app_links_json}
     *
     * @stability stable
     */
    readonly appLinksJson?: string;
    /**
     * Application settings in JSON format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#app_settings_json AppAutoLogin#app_settings_json}
     *
     * @stability stable
     */
    readonly appSettingsJson?: string;
    /**
     * Display auto submit toolbar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#auto_submit_toolbar AppAutoLogin#auto_submit_toolbar}
     *
     * @stability stable
     */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
     * Application credentials scheme.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#credentials_scheme AppAutoLogin#credentials_scheme}
     *
     * @stability stable
     */
    readonly credentialsScheme?: string;
    /**
     * Application notes for end users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#enduser_note AppAutoLogin#enduser_note}
     *
     * @stability stable
     */
    readonly enduserNote?: string;
    /**
     * Groups associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#groups AppAutoLogin#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * Do not display application icon on mobile app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#hide_ios AppAutoLogin#hide_ios}
     *
     * @stability stable
     */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
     * Do not display application icon to users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#hide_web AppAutoLogin#hide_web}
     *
     * @stability stable
     */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
     * Pretty name of app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#label AppAutoLogin#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Local path to logo of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#logo AppAutoLogin#logo}
     *
     * @stability stable
     */
    readonly logo?: string;
    /**
     * Preconfigured app name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#preconfigured_app AppAutoLogin#preconfigured_app}
     *
     * @stability stable
     */
    readonly preconfiguredApp?: string;
    /**
     * Allow user to reveal password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#reveal_password AppAutoLogin#reveal_password}
     *
     * @stability stable
     */
    readonly revealPassword?: boolean | cdktf.IResolvable;
    /**
     * Shared password, required for certain schemes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#shared_password AppAutoLogin#shared_password}
     *
     * @stability stable
     */
    readonly sharedPassword?: string;
    /**
     * Shared username, required for certain schemes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#shared_username AppAutoLogin#shared_username}
     *
     * @stability stable
     */
    readonly sharedUsername?: string;
    /**
     * Post login redirect URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#sign_on_redirect_url AppAutoLogin#sign_on_redirect_url}
     *
     * @stability stable
     */
    readonly signOnRedirectUrl?: string;
    /**
     * Login URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#sign_on_url AppAutoLogin#sign_on_url}
     *
     * @stability stable
     */
    readonly signOnUrl?: string;
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#skip_groups AppAutoLogin#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#skip_users AppAutoLogin#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
     * Status of application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#status AppAutoLogin#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Username template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#user_name_template AppAutoLogin#user_name_template}
     *
     * @stability stable
     */
    readonly userNameTemplate?: string;
    /**
     * Push username on update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#user_name_template_push_status AppAutoLogin#user_name_template_push_status}
     *
     * @stability stable
     */
    readonly userNameTemplatePushStatus?: string;
    /**
     * Username template suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#user_name_template_suffix AppAutoLogin#user_name_template_suffix}
     *
     * @stability stable
     */
    readonly userNameTemplateSuffix?: string;
    /**
     * Username template type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#user_name_template_type AppAutoLogin#user_name_template_type}
     *
     * @stability stable
     */
    readonly userNameTemplateType?: string;
    /**
     * users block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#users AppAutoLogin#users}
     *
     * @stability stable
     */
    readonly users?: AppAutoLoginUsers[];
}
/**
 * @stability stable
 */
export interface AppAutoLoginUsers {
    /**
     * User ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#id AppAutoLogin#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Password for user application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#password AppAutoLogin#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Username for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html#username AppAutoLogin#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function appAutoLoginUsersToTerraform(struct?: AppAutoLoginUsers): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html okta_app_auto_login}.
 *
 * @stability stable
 */
export declare class AppAutoLogin extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login.html okta_app_auto_login} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppAutoLoginConfig);
    private _accessibilityErrorRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityErrorRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityErrorRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityLoginRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityLoginRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    /**
     * @stability stable
     */
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessibilitySelfService(): void;
    /**
     * @stability stable
     */
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    /**
     * @stability stable
     */
    get adminNote(): string;
    /**
     * @stability stable
     */
    set adminNote(value: string);
    /**
     * @stability stable
     */
    resetAdminNote(): void;
    /**
     * @stability stable
     */
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    /**
     * @stability stable
     */
    get appLinksJson(): string;
    /**
     * @stability stable
     */
    set appLinksJson(value: string);
    /**
     * @stability stable
     */
    resetAppLinksJson(): void;
    /**
     * @stability stable
     */
    get appLinksJsonInput(): string | undefined;
    private _appSettingsJson?;
    /**
     * @stability stable
     */
    get appSettingsJson(): string;
    /**
     * @stability stable
     */
    set appSettingsJson(value: string);
    /**
     * @stability stable
     */
    resetAppSettingsJson(): void;
    /**
     * @stability stable
     */
    get appSettingsJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoSubmitToolbar(): void;
    /**
     * @stability stable
     */
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _credentialsScheme?;
    /**
     * @stability stable
     */
    get credentialsScheme(): string;
    /**
     * @stability stable
     */
    set credentialsScheme(value: string);
    /**
     * @stability stable
     */
    resetCredentialsScheme(): void;
    /**
     * @stability stable
     */
    get credentialsSchemeInput(): string | undefined;
    private _enduserNote?;
    /**
     * @stability stable
     */
    get enduserNote(): string;
    /**
     * @stability stable
     */
    set enduserNote(value: string);
    /**
     * @stability stable
     */
    resetEnduserNote(): void;
    /**
     * @stability stable
     */
    get enduserNoteInput(): string | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    /**
     * @stability stable
     */
    get hideIos(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideIos(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideIos(): void;
    /**
     * @stability stable
     */
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    /**
     * @stability stable
     */
    get hideWeb(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideWeb(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideWeb(): void;
    /**
     * @stability stable
     */
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _logo?;
    /**
     * @stability stable
     */
    get logo(): string;
    /**
     * @stability stable
     */
    set logo(value: string);
    /**
     * @stability stable
     */
    resetLogo(): void;
    /**
     * @stability stable
     */
    get logoInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _preconfiguredApp?;
    /**
     * @stability stable
     */
    get preconfiguredApp(): string;
    /**
     * @stability stable
     */
    set preconfiguredApp(value: string);
    /**
     * @stability stable
     */
    resetPreconfiguredApp(): void;
    /**
     * @stability stable
     */
    get preconfiguredAppInput(): string | undefined;
    private _revealPassword?;
    /**
     * @stability stable
     */
    get revealPassword(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set revealPassword(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRevealPassword(): void;
    /**
     * @stability stable
     */
    get revealPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedPassword?;
    /**
     * @stability stable
     */
    get sharedPassword(): string;
    /**
     * @stability stable
     */
    set sharedPassword(value: string);
    /**
     * @stability stable
     */
    resetSharedPassword(): void;
    /**
     * @stability stable
     */
    get sharedPasswordInput(): string | undefined;
    private _sharedUsername?;
    /**
     * @stability stable
     */
    get sharedUsername(): string;
    /**
     * @stability stable
     */
    set sharedUsername(value: string);
    /**
     * @stability stable
     */
    resetSharedUsername(): void;
    /**
     * @stability stable
     */
    get sharedUsernameInput(): string | undefined;
    /**
     * @stability stable
     */
    get signOnMode(): string;
    private _signOnRedirectUrl?;
    /**
     * @stability stable
     */
    get signOnRedirectUrl(): string;
    /**
     * @stability stable
     */
    set signOnRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetSignOnRedirectUrl(): void;
    /**
     * @stability stable
     */
    get signOnRedirectUrlInput(): string | undefined;
    private _signOnUrl?;
    /**
     * @stability stable
     */
    get signOnUrl(): string;
    /**
     * @stability stable
     */
    set signOnUrl(value: string);
    /**
     * @stability stable
     */
    resetSignOnUrl(): void;
    /**
     * @stability stable
     */
    get signOnUrlInput(): string | undefined;
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _userNameTemplate?;
    /**
     * @stability stable
     */
    get userNameTemplate(): string;
    /**
     * @stability stable
     */
    set userNameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplate(): void;
    /**
     * @stability stable
     */
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatus(): string;
    /**
     * @stability stable
     */
    set userNameTemplatePushStatus(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplatePushStatus(): void;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    /**
     * @stability stable
     */
    get userNameTemplateSuffix(): string;
    /**
     * @stability stable
     */
    set userNameTemplateSuffix(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateSuffix(): void;
    /**
     * @stability stable
     */
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    /**
     * @stability stable
     */
    get userNameTemplateType(): string;
    /**
     * @stability stable
     */
    set userNameTemplateType(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateType(): void;
    /**
     * @stability stable
     */
    get userNameTemplateTypeInput(): string | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): AppAutoLoginUsers[];
    /**
     * @stability stable
     */
    set users(value: AppAutoLoginUsers[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): AppAutoLoginUsers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
