import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppGroupAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * App to associate group with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment.html#app_id AppGroupAssignment#app_id}
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Group associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment.html#group_id AppGroupAssignment#group_id}
     *
     * @stability stable
     */
    readonly groupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment.html#priority AppGroupAssignment#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment.html#profile AppGroupAssignment#profile}.
     *
     * @stability stable
     */
    readonly profile?: string;
    /**
     * Retain the group assignment on destroy.
     *
     * If set to true, the resource will be removed from state but not from the Okta app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment.html#retain_assignment AppGroupAssignment#retain_assignment}
     *
     * @stability stable
     */
    readonly retainAssignment?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment.html okta_app_group_assignment}.
 *
 * @stability stable
 */
export declare class AppGroupAssignment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment.html okta_app_group_assignment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppGroupAssignmentConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string;
    /**
     * @stability stable
     */
    set groupId(value: string);
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _profile?;
    /**
     * @stability stable
     */
    get profile(): string;
    /**
     * @stability stable
     */
    set profile(value: string);
    /**
     * @stability stable
     */
    resetProfile(): void;
    /**
     * @stability stable
     */
    get profileInput(): string | undefined;
    private _retainAssignment?;
    /**
     * @stability stable
     */
    get retainAssignment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set retainAssignment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRetainAssignment(): void;
    /**
     * @stability stable
     */
    get retainAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
