import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppGroupAssignmentsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments.html#app_id AppGroupAssignments#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments.html#group AppGroupAssignments#group}
     *
     * @stability stable
     */
    readonly group: AppGroupAssignmentsGroup[];
}
/**
 * @stability stable
 */
export interface AppGroupAssignmentsGroup {
    /**
     * A group to associate with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments.html#id AppGroupAssignments#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments.html#priority AppGroupAssignments#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments.html#profile AppGroupAssignments#profile}.
     *
     * @stability stable
     */
    readonly profile?: string;
}
export declare function appGroupAssignmentsGroupToTerraform(struct?: AppGroupAssignmentsGroup): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments.html okta_app_group_assignments}.
 *
 * @stability stable
 */
export declare class AppGroupAssignments extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments.html okta_app_group_assignments} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppGroupAssignmentsConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _group?;
    /**
     * @stability stable
     */
    get group(): AppGroupAssignmentsGroup[];
    /**
     * @stability stable
     */
    set group(value: AppGroupAssignmentsGroup[]);
    /**
     * @stability stable
     */
    get groupInput(): AppGroupAssignmentsGroup[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
