import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppOauthApiScopeConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_api_scope.html#app_id AppOauthApiScope#app_id}
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * The issuer of your Org Authorization Server, your Org URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_api_scope.html#issuer AppOauthApiScope#issuer}
     *
     * @stability stable
     */
    readonly issuer: string;
    /**
     * Scopes of the application for which consent is granted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_api_scope.html#scopes AppOauthApiScope#scopes}
     *
     * @stability stable
     */
    readonly scopes: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_api_scope.html okta_app_oauth_api_scope}.
 *
 * @stability stable
 */
export declare class AppOauthApiScope extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_api_scope.html okta_app_oauth_api_scope} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppOauthApiScopeConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
