import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppOauthConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom error page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#accessibility_error_redirect_url AppOauth#accessibility_error_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
     * Custom login page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#accessibility_login_redirect_url AppOauth#accessibility_login_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
     * Enable self service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#accessibility_self_service AppOauth#accessibility_self_service}
     *
     * @stability stable
     */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
     * Application notes for admins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#admin_note AppOauth#admin_note}
     *
     * @stability stable
     */
    readonly adminNote?: string;
    /**
     * Displays specific appLinks for the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#app_links_json AppOauth#app_links_json}
     *
     * @stability stable
     */
    readonly appLinksJson?: string;
    /**
     * Application settings in JSON format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#app_settings_json AppOauth#app_settings_json}
     *
     * @stability stable
     */
    readonly appSettingsJson?: string;
    /**
     * Requested key rotation mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#auto_key_rotation AppOauth#auto_key_rotation}
     *
     * @stability stable
     */
    readonly autoKeyRotation?: boolean | cdktf.IResolvable;
    /**
     * Display auto submit toolbar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#auto_submit_toolbar AppOauth#auto_submit_toolbar}
     *
     * @stability stable
     */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
     * OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#client_basic_secret AppOauth#client_basic_secret}
     *
     * @stability stable
     */
    readonly clientBasicSecret?: string;
    /**
     * OAuth client ID. If set during creation, app is created with this id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#client_id AppOauth#client_id}
     *
     * @stability stable
     */
    readonly clientId?: string;
    /**
     * URI to a web page providing information about the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#client_uri AppOauth#client_uri}
     *
     * @stability stable
     */
    readonly clientUri?: string;
    /**
     * *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED. Default value is TRUSTED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#consent_method AppOauth#consent_method}
     *
     * @stability stable
     */
    readonly consentMethod?: string;
    /**
     * **Deprecated** This property allows you to set your client_id during creation.
     *
     * NOTE: updating after creation will be a no-op, use client_id for that behavior instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#custom_client_id AppOauth#custom_client_id}
     *
     * @stability stable
     */
    readonly customClientId?: string;
    /**
     * Application notes for end users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#enduser_note AppOauth#enduser_note}
     *
     * @stability stable
     */
    readonly enduserNote?: string;
    /**
     * List of OAuth 2.0 grant types. Conditional validation params found here https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per app type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#grant_types AppOauth#grant_types}
     *
     * @stability stable
     */
    readonly grantTypes?: string[];
    /**
     * Groups associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#groups AppOauth#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * Do not display application icon on mobile app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#hide_ios AppOauth#hide_ios}
     *
     * @stability stable
     */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
     * Do not display application icon to users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#hide_web AppOauth#hide_web}
     *
     * @stability stable
     */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
     * *Early Access Property*. Enable Federation Broker Mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#implicit_assignment AppOauth#implicit_assignment}
     *
     * @stability stable
     */
    readonly implicitAssignment?: boolean | cdktf.IResolvable;
    /**
     * *Early Access Property*.
     *
     * Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a custom domain URL as the issuer of ID token for this client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#issuer_mode AppOauth#issuer_mode}
     *
     * @stability stable
     */
    readonly issuerMode?: string;
    /**
     * Pretty name of app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#label AppOauth#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * The type of Idp-Initiated login that the client supports, if any.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#login_mode AppOauth#login_mode}
     *
     * @stability stable
     */
    readonly loginMode?: string;
    /**
     * List of scopes to use for the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#login_scopes AppOauth#login_scopes}
     *
     * @stability stable
     */
    readonly loginScopes?: string[];
    /**
     * URI that initiates login.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#login_uri AppOauth#login_uri}
     *
     * @stability stable
     */
    readonly loginUri?: string;
    /**
     * Local path to logo of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#logo AppOauth#logo}
     *
     * @stability stable
     */
    readonly logo?: string;
    /**
     * URI that references a logo for the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#logo_uri AppOauth#logo_uri}
     *
     * @stability stable
     */
    readonly logoUri?: string;
    /**
     * This tells the provider not to persist the application's secret to state.
     *
     * If this is ever changes from true => false your app will be recreated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#omit_secret AppOauth#omit_secret}
     *
     * @stability stable
     */
    readonly omitSecret?: boolean | cdktf.IResolvable;
    /**
     * URI to web page providing client policy document.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#policy_uri AppOauth#policy_uri}
     *
     * @stability stable
     */
    readonly policyUri?: string;
    /**
     * List of URIs for redirection after logout.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#post_logout_redirect_uris AppOauth#post_logout_redirect_uris}
     *
     * @stability stable
     */
    readonly postLogoutRedirectUris?: string[];
    /**
     * Custom JSON that represents an OAuth application's profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#profile AppOauth#profile}
     *
     * @stability stable
     */
    readonly profile?: string;
    /**
     * List of URIs for use in the redirect-based flow.
     *
     * This is required for all application types except service. Note: see okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#redirect_uris AppOauth#redirect_uris}
     *
     * @stability stable
     */
    readonly redirectUris?: string[];
    /**
     * *Early Access Property* Grace period for token rotation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#refresh_token_leeway AppOauth#refresh_token_leeway}
     *
     * @stability stable
     */
    readonly refreshTokenLeeway?: number;
    /**
     * *Early Access Property* Refresh token rotation behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#refresh_token_rotation AppOauth#refresh_token_rotation}
     *
     * @stability stable
     */
    readonly refreshTokenRotation?: string;
    /**
     * List of OAuth 2.0 response type strings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#response_types AppOauth#response_types}
     *
     * @stability stable
     */
    readonly responseTypes?: string[];
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#skip_groups AppOauth#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#skip_users AppOauth#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
     * Status of application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#status AppOauth#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Requested authentication method for the token endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#token_endpoint_auth_method AppOauth#token_endpoint_auth_method}
     *
     * @stability stable
     */
    readonly tokenEndpointAuthMethod?: string;
    /**
     * URI to web page providing client tos (terms of service).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#tos_uri AppOauth#tos_uri}
     *
     * @stability stable
     */
    readonly tosUri?: string;
    /**
     * The type of client application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#type AppOauth#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Username template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#user_name_template AppOauth#user_name_template}
     *
     * @stability stable
     */
    readonly userNameTemplate?: string;
    /**
     * Push username on update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#user_name_template_push_status AppOauth#user_name_template_push_status}
     *
     * @stability stable
     */
    readonly userNameTemplatePushStatus?: string;
    /**
     * Username template suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#user_name_template_suffix AppOauth#user_name_template_suffix}
     *
     * @stability stable
     */
    readonly userNameTemplateSuffix?: string;
    /**
     * Username template type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#user_name_template_type AppOauth#user_name_template_type}
     *
     * @stability stable
     */
    readonly userNameTemplateType?: string;
    /**
     * *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#wildcard_redirect AppOauth#wildcard_redirect}
     *
     * @stability stable
     */
    readonly wildcardRedirect?: string;
    /**
     * groups_claim block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#groups_claim AppOauth#groups_claim}
     *
     * @stability stable
     */
    readonly groupsClaim?: AppOauthGroupsClaim;
    /**
     * jwks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#jwks AppOauth#jwks}
     *
     * @stability stable
     */
    readonly jwks?: AppOauthJwks[];
    /**
     * users block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#users AppOauth#users}
     *
     * @stability stable
     */
    readonly users?: AppOauthUsers[];
}
/**
 * @stability stable
 */
export interface AppOauthGroupsClaim {
    /**
     * Groups claim filter. Can only be set if type is FILTER.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#filter_type AppOauth#filter_type}
     *
     * @stability stable
     */
    readonly filterType?: string;
    /**
     * Name of the claim that will be used in the token.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#name AppOauth#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Groups claim type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#type AppOauth#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Value of the claim.
     *
     * Can be an Okta Expression Language statement that evaluates at the time the token is minted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#value AppOauth#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function appOauthGroupsClaimToTerraform(struct?: AppOauthGroupsClaimOutputReference | AppOauthGroupsClaim): any;
/**
 * @stability stable
 */
export declare class AppOauthGroupsClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppOauthGroupsClaim | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppOauthGroupsClaim | undefined);
    private _filterType?;
    /**
     * @stability stable
     */
    get filterType(): string;
    /**
     * @stability stable
     */
    set filterType(value: string);
    /**
     * @stability stable
     */
    resetFilterType(): void;
    /**
     * @stability stable
     */
    get filterTypeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppOauthJwks {
    /**
     * RSA Exponent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#e AppOauth#e}
     *
     * @stability stable
     */
    readonly e?: string;
    /**
     * Key ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#kid AppOauth#kid}
     *
     * @stability stable
     */
    readonly kid: string;
    /**
     * Key type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#kty AppOauth#kty}
     *
     * @stability stable
     */
    readonly kty: string;
    /**
     * RSA Modulus.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#n AppOauth#n}
     *
     * @stability stable
     */
    readonly n?: string;
}
export declare function appOauthJwksToTerraform(struct?: AppOauthJwks): any;
/**
 * @stability stable
 */
export interface AppOauthUsers {
    /**
     * User ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#id AppOauth#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Password for user application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#password AppOauth#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Username for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html#username AppOauth#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function appOauthUsersToTerraform(struct?: AppOauthUsers): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html okta_app_oauth}.
 *
 * @stability stable
 */
export declare class AppOauth extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_oauth.html okta_app_oauth} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppOauthConfig);
    private _accessibilityErrorRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityErrorRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityErrorRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityLoginRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityLoginRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    /**
     * @stability stable
     */
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessibilitySelfService(): void;
    /**
     * @stability stable
     */
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    /**
     * @stability stable
     */
    get adminNote(): string;
    /**
     * @stability stable
     */
    set adminNote(value: string);
    /**
     * @stability stable
     */
    resetAdminNote(): void;
    /**
     * @stability stable
     */
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    /**
     * @stability stable
     */
    get appLinksJson(): string;
    /**
     * @stability stable
     */
    set appLinksJson(value: string);
    /**
     * @stability stable
     */
    resetAppLinksJson(): void;
    /**
     * @stability stable
     */
    get appLinksJsonInput(): string | undefined;
    private _appSettingsJson?;
    /**
     * @stability stable
     */
    get appSettingsJson(): string;
    /**
     * @stability stable
     */
    set appSettingsJson(value: string);
    /**
     * @stability stable
     */
    resetAppSettingsJson(): void;
    /**
     * @stability stable
     */
    get appSettingsJsonInput(): string | undefined;
    private _autoKeyRotation?;
    /**
     * @stability stable
     */
    get autoKeyRotation(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoKeyRotation(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoKeyRotation(): void;
    /**
     * @stability stable
     */
    get autoKeyRotationInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSubmitToolbar?;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoSubmitToolbar(): void;
    /**
     * @stability stable
     */
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _clientBasicSecret?;
    /**
     * @stability stable
     */
    get clientBasicSecret(): string;
    /**
     * @stability stable
     */
    set clientBasicSecret(value: string);
    /**
     * @stability stable
     */
    resetClientBasicSecret(): void;
    /**
     * @stability stable
     */
    get clientBasicSecretInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    resetClientId(): void;
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    private _clientUri?;
    /**
     * @stability stable
     */
    get clientUri(): string;
    /**
     * @stability stable
     */
    set clientUri(value: string);
    /**
     * @stability stable
     */
    resetClientUri(): void;
    /**
     * @stability stable
     */
    get clientUriInput(): string | undefined;
    private _consentMethod?;
    /**
     * @stability stable
     */
    get consentMethod(): string;
    /**
     * @stability stable
     */
    set consentMethod(value: string);
    /**
     * @stability stable
     */
    resetConsentMethod(): void;
    /**
     * @stability stable
     */
    get consentMethodInput(): string | undefined;
    private _customClientId?;
    /**
     * @stability stable
     */
    get customClientId(): string;
    /**
     * @stability stable
     */
    set customClientId(value: string);
    /**
     * @stability stable
     */
    resetCustomClientId(): void;
    /**
     * @stability stable
     */
    get customClientIdInput(): string | undefined;
    private _enduserNote?;
    /**
     * @stability stable
     */
    get enduserNote(): string;
    /**
     * @stability stable
     */
    set enduserNote(value: string);
    /**
     * @stability stable
     */
    resetEnduserNote(): void;
    /**
     * @stability stable
     */
    get enduserNoteInput(): string | undefined;
    private _grantTypes?;
    /**
     * @stability stable
     */
    get grantTypes(): string[];
    /**
     * @stability stable
     */
    set grantTypes(value: string[]);
    /**
     * @stability stable
     */
    resetGrantTypes(): void;
    /**
     * @stability stable
     */
    get grantTypesInput(): string[] | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    /**
     * @stability stable
     */
    get hideIos(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideIos(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideIos(): void;
    /**
     * @stability stable
     */
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    /**
     * @stability stable
     */
    get hideWeb(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideWeb(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideWeb(): void;
    /**
     * @stability stable
     */
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _implicitAssignment?;
    /**
     * @stability stable
     */
    get implicitAssignment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set implicitAssignment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetImplicitAssignment(): void;
    /**
     * @stability stable
     */
    get implicitAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _issuerMode?;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    set issuerMode(value: string);
    /**
     * @stability stable
     */
    resetIssuerMode(): void;
    /**
     * @stability stable
     */
    get issuerModeInput(): string | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _loginMode?;
    /**
     * @stability stable
     */
    get loginMode(): string;
    /**
     * @stability stable
     */
    set loginMode(value: string);
    /**
     * @stability stable
     */
    resetLoginMode(): void;
    /**
     * @stability stable
     */
    get loginModeInput(): string | undefined;
    private _loginScopes?;
    /**
     * @stability stable
     */
    get loginScopes(): string[];
    /**
     * @stability stable
     */
    set loginScopes(value: string[]);
    /**
     * @stability stable
     */
    resetLoginScopes(): void;
    /**
     * @stability stable
     */
    get loginScopesInput(): string[] | undefined;
    private _loginUri?;
    /**
     * @stability stable
     */
    get loginUri(): string;
    /**
     * @stability stable
     */
    set loginUri(value: string);
    /**
     * @stability stable
     */
    resetLoginUri(): void;
    /**
     * @stability stable
     */
    get loginUriInput(): string | undefined;
    private _logo?;
    /**
     * @stability stable
     */
    get logo(): string;
    /**
     * @stability stable
     */
    set logo(value: string);
    /**
     * @stability stable
     */
    resetLogo(): void;
    /**
     * @stability stable
     */
    get logoInput(): string | undefined;
    private _logoUri?;
    /**
     * @stability stable
     */
    get logoUri(): string;
    /**
     * @stability stable
     */
    set logoUri(value: string);
    /**
     * @stability stable
     */
    resetLogoUri(): void;
    /**
     * @stability stable
     */
    get logoUriInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _omitSecret?;
    /**
     * @stability stable
     */
    get omitSecret(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set omitSecret(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOmitSecret(): void;
    /**
     * @stability stable
     */
    get omitSecretInput(): boolean | cdktf.IResolvable | undefined;
    private _policyUri?;
    /**
     * @stability stable
     */
    get policyUri(): string;
    /**
     * @stability stable
     */
    set policyUri(value: string);
    /**
     * @stability stable
     */
    resetPolicyUri(): void;
    /**
     * @stability stable
     */
    get policyUriInput(): string | undefined;
    private _postLogoutRedirectUris?;
    /**
     * @stability stable
     */
    get postLogoutRedirectUris(): string[];
    /**
     * @stability stable
     */
    set postLogoutRedirectUris(value: string[]);
    /**
     * @stability stable
     */
    resetPostLogoutRedirectUris(): void;
    /**
     * @stability stable
     */
    get postLogoutRedirectUrisInput(): string[] | undefined;
    private _profile?;
    /**
     * @stability stable
     */
    get profile(): string;
    /**
     * @stability stable
     */
    set profile(value: string);
    /**
     * @stability stable
     */
    resetProfile(): void;
    /**
     * @stability stable
     */
    get profileInput(): string | undefined;
    private _redirectUris?;
    /**
     * @stability stable
     */
    get redirectUris(): string[];
    /**
     * @stability stable
     */
    set redirectUris(value: string[]);
    /**
     * @stability stable
     */
    resetRedirectUris(): void;
    /**
     * @stability stable
     */
    get redirectUrisInput(): string[] | undefined;
    private _refreshTokenLeeway?;
    /**
     * @stability stable
     */
    get refreshTokenLeeway(): number;
    /**
     * @stability stable
     */
    set refreshTokenLeeway(value: number);
    /**
     * @stability stable
     */
    resetRefreshTokenLeeway(): void;
    /**
     * @stability stable
     */
    get refreshTokenLeewayInput(): number | undefined;
    private _refreshTokenRotation?;
    /**
     * @stability stable
     */
    get refreshTokenRotation(): string;
    /**
     * @stability stable
     */
    set refreshTokenRotation(value: string);
    /**
     * @stability stable
     */
    resetRefreshTokenRotation(): void;
    /**
     * @stability stable
     */
    get refreshTokenRotationInput(): string | undefined;
    private _responseTypes?;
    /**
     * @stability stable
     */
    get responseTypes(): string[];
    /**
     * @stability stable
     */
    set responseTypes(value: string[]);
    /**
     * @stability stable
     */
    resetResponseTypes(): void;
    /**
     * @stability stable
     */
    get responseTypesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get signOnMode(): string;
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _tokenEndpointAuthMethod?;
    /**
     * @stability stable
     */
    get tokenEndpointAuthMethod(): string;
    /**
     * @stability stable
     */
    set tokenEndpointAuthMethod(value: string);
    /**
     * @stability stable
     */
    resetTokenEndpointAuthMethod(): void;
    /**
     * @stability stable
     */
    get tokenEndpointAuthMethodInput(): string | undefined;
    private _tosUri?;
    /**
     * @stability stable
     */
    get tosUri(): string;
    /**
     * @stability stable
     */
    set tosUri(value: string);
    /**
     * @stability stable
     */
    resetTosUri(): void;
    /**
     * @stability stable
     */
    get tosUriInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userNameTemplate?;
    /**
     * @stability stable
     */
    get userNameTemplate(): string;
    /**
     * @stability stable
     */
    set userNameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplate(): void;
    /**
     * @stability stable
     */
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatus(): string;
    /**
     * @stability stable
     */
    set userNameTemplatePushStatus(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplatePushStatus(): void;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    /**
     * @stability stable
     */
    get userNameTemplateSuffix(): string;
    /**
     * @stability stable
     */
    set userNameTemplateSuffix(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateSuffix(): void;
    /**
     * @stability stable
     */
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    /**
     * @stability stable
     */
    get userNameTemplateType(): string;
    /**
     * @stability stable
     */
    set userNameTemplateType(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateType(): void;
    /**
     * @stability stable
     */
    get userNameTemplateTypeInput(): string | undefined;
    private _wildcardRedirect?;
    /**
     * @stability stable
     */
    get wildcardRedirect(): string;
    /**
     * @stability stable
     */
    set wildcardRedirect(value: string);
    /**
     * @stability stable
     */
    resetWildcardRedirect(): void;
    /**
     * @stability stable
     */
    get wildcardRedirectInput(): string | undefined;
    private _groupsClaim;
    /**
     * @stability stable
     */
    get groupsClaim(): AppOauthGroupsClaimOutputReference;
    /**
     * @stability stable
     */
    putGroupsClaim(value: AppOauthGroupsClaim): void;
    /**
     * @stability stable
     */
    resetGroupsClaim(): void;
    /**
     * @stability stable
     */
    get groupsClaimInput(): AppOauthGroupsClaim | undefined;
    private _jwks?;
    /**
     * @stability stable
     */
    get jwks(): AppOauthJwks[];
    /**
     * @stability stable
     */
    set jwks(value: AppOauthJwks[]);
    /**
     * @stability stable
     */
    resetJwks(): void;
    /**
     * @stability stable
     */
    get jwksInput(): AppOauthJwks[] | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): AppOauthUsers[];
    /**
     * @stability stable
     */
    set users(value: AppOauthUsers[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): AppOauthUsers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
